<!-- =========================================================================
 Copyright (c) 2017-2019 XMLmind Software. All rights reserved.
 
 Author: Hussein Shafie
 
 This file is part of the XMLmind W2X project.
 For conditions of distribution and use, see the accompanying legal.txt file.
========================================================================== -->

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:h="http://www.w3.org/1999/xhtml"
  xmlns="http://docbook.org/ns/docbook"
  exclude-result-prefixes="h">

<!-- =========================================================================
     Can be used for both DocBook 4 and DITA.
     
     For DocBook 5, simply insert 
     xmlns="http://docbook.org/ns/docbook"
     in the above stylesheet element.
     
     What follows is sufficient to process the HTML tables 
     generated by MS-Word (one colgroup per column, no span, no col, 
     single tbody, etc).
========================================================================== -->

<xsl:template name="processTableBorderAttribute">
  <xsl:if test="@border = '0'">
    <xsl:attribute name="frame">none</xsl:attribute>
    <xsl:attribute name="rowsep">0</xsl:attribute>
    <xsl:attribute name="colsep">0</xsl:attribute>
  </xsl:if>
</xsl:template>

<xsl:template name="processTgroup">
  <tgroup>
    <xsl:attribute name="cols">
      <xsl:choose>
        <xsl:when test="./h:colgroup">
          <xsl:value-of select="count(./h:colgroup)"/>
        </xsl:when>
        <xsl:otherwise>1</xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>

    <xsl:apply-templates select="./h:colgroup"/>
    <xsl:apply-templates select="./h:thead"/>
    <xsl:apply-templates select="./h:tfoot"/>
    <xsl:apply-templates select="./h:tbody"/>
  </tgroup>
</xsl:template>

<xsl:template match="h:colgroup">
  <colspec>
    <!-- DocBook 4 colspec does not have id and lang attributes.
         This is not the case of DITA and DocBook 5. -->
    <xsl:call-template name="processCommonAttributes"/>

    <xsl:attribute name="colname">
      <xsl:value-of
        select="concat('c', count(preceding-sibling::h:colgroup) + 1)"/>
    </xsl:attribute>

    <xsl:call-template name="processAlignAttribute"/>

    <xsl:if test="substring-before(@width, '%') != ''">
      <xsl:attribute name="colwidth">
        <xsl:value-of select="concat(substring-before(@width, '%'), '*')"/>
      </xsl:attribute>
    </xsl:if>
  </colspec>
</xsl:template>

<xsl:template name="processAlignAttribute">
  <xsl:if test="@align != ''">
    <xsl:attribute name="align">
      <xsl:choose>
        <xsl:when test="@align = 'center'">center</xsl:when>
        <xsl:when test="@align = 'right'">right</xsl:when>
        <xsl:otherwise>left</xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
  </xsl:if>
</xsl:template>

<xsl:template match="h:thead">
  <thead>
    <xsl:call-template name="processCommonAttributes"/>
    <xsl:call-template name="processValignAttribute"/>
    <xsl:apply-templates/>
  </thead>
</xsl:template>

<xsl:template match="h:tfoot">
  <tfoot>
    <xsl:call-template name="processCommonAttributes"/>
    <xsl:call-template name="processValignAttribute"/>
    <xsl:apply-templates/>
  </tfoot>
</xsl:template>

<xsl:template match="h:tbody">
  <tbody>
    <xsl:call-template name="processCommonAttributes"/>
    <xsl:call-template name="processValignAttribute"/>
    <xsl:apply-templates/>
  </tbody>
</xsl:template>

<xsl:template name="processValignAttribute">
  <xsl:if test="@valign != ''">
    <xsl:attribute name="valign">
      <xsl:choose>
        <xsl:when test="@valign = 'top' or @valign = 'baseline'">top</xsl:when>
        <xsl:when test="@valign = 'bottom'">bottom</xsl:when>
        <xsl:otherwise>middle</xsl:otherwise>
      </xsl:choose>
    </xsl:attribute>
  </xsl:if>
</xsl:template>

<xsl:template match="h:tr">
  <row>
    <xsl:call-template name="processCommonAttributes"/>

    <xsl:call-template name="processValignAttribute"/>
    <!-- a td has an implicit valign=middle. -->
    <xsl:if test="not(@valign) and not(../@valign)">
      <xsl:attribute name="valign">middle</xsl:attribute>
    </xsl:if>

    <xsl:apply-templates/>

    <xsl:if test="count(./h:th | ./h:td) = 0">
      <!-- In some rare cases, a row may be empty. -->
      <entry/>
    </xsl:if>
  </row>
</xsl:template>

<xsl:template match="h:th | h:td">
  <entry>
    <xsl:call-template name="processCommonAttributes"/>

    <xsl:if test="number(@colspan) > 1">
      <xsl:variable name="colnum">
        <xsl:call-template name="columnNumber">
          <xsl:with-param name="cell" select="."/>
        </xsl:call-template>
      </xsl:variable>

      <xsl:attribute name="namest">
        <xsl:value-of select="concat('c', $colnum)"/>
      </xsl:attribute>
      <xsl:attribute name="nameend">
        <xsl:value-of select="concat('c', $colnum + number(@colspan) - 1)"/>
      </xsl:attribute>
    </xsl:if>

    <xsl:if test="number(@rowspan) > 1">
      <xsl:attribute name="morerows">
        <xsl:value-of select="number(@rowspan) - 1"/>
      </xsl:attribute>
    </xsl:if>

    <!-- a th has an implicit align=center. -->
    <xsl:if test="self::h:th">
      <xsl:attribute name="align">center</xsl:attribute>
    </xsl:if>
    <xsl:call-template name="processAlignAttribute"/>

    <xsl:call-template name="processValignAttribute"/>

    <xsl:if test="$processCellRotate = 'yes' and
                  contains(@style, '-cell-rotate:')">
      <xsl:attribute name="rotate">1</xsl:attribute>
    </xsl:if>

    <xsl:apply-templates/>
  </entry>
</xsl:template>

<xsl:template name="columnNumber">
  <xsl:param name="cell" select="''"/>

  <xsl:variable name="colnum">
    <xsl:if test="$cell/processing-instruction('column-number')">
      <xsl:variable name="data"
        select="normalize-space($cell/processing-instruction('column-number'))"/>
      <xsl:if test="number($data) >= 1">
        <xsl:value-of select="number($data)"/>
      </xsl:if>
    </xsl:if>
  </xsl:variable>

  <xsl:choose>
    <xsl:when test="$colnum != ''">
      <xsl:value-of select="$colnum"/>
    </xsl:when>
    <xsl:otherwise>
      <xsl:call-template name="computeColumnNumber">
        <xsl:with-param name="cell" select="$cell"/>
        <xsl:with-param name="colnum" select="1"/>
      </xsl:call-template>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<xsl:template match="processing-instruction('column-number')"/>

<xsl:template name="computeColumnNumber">
  <!-- An approximation which does not support rowspan. -->
  <xsl:param name="cell" select="''"/>
  <xsl:param name="colnum" select="1"/>

  <xsl:variable name="previous"
    select="$cell/preceding-sibling::*[self::h:th or self::h:td][1]"/>
  <xsl:choose>
    <xsl:when test="$previous">
      <xsl:variable name="colnum2">
        <xsl:choose>
          <xsl:when test="number($previous/@colspan) > 1">
            <xsl:value-of select="number($previous/@colspan) + $colnum"/>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="1 + $colnum"/>
          </xsl:otherwise>
        </xsl:choose>
      </xsl:variable>

      <xsl:call-template name="computeColumnNumber">
        <xsl:with-param name="cell" select="$previous"/>
        <xsl:with-param name="colnum" select="$colnum2"/>
      </xsl:call-template>
    </xsl:when>

    <xsl:otherwise>
      <xsl:value-of select="$colnum"/>
    </xsl:otherwise>
  </xsl:choose>
</xsl:template>

<!-- Not translated ==========================================================
col
========================================================================== -->

</xsl:stylesheet>
