<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:h="http://www.w3.org/1999/xhtml"
  xmlns:du="java:com.xmlmind.misc.DateUtil"
  exclude-result-prefixes="h du">

<xsl:include href="w2x:xslt/common_params.xslt"/>
<xsl:include href="w2x:xslt/other_common.xslt"/>

<xsl:output method="xml" encoding="UTF-8" indent="no"/>

<xsl:param name="channel-title" select="'???'"/> 
<xsl:param name="channel-link" select="'???'"/> 
<xsl:param name="channel-description" select="'???'"/> 

<!-- html ================================================================ -->

<xsl:template match="h:html">
  <rss version="2.0">
    <channel>
      <title><xsl:value-of select="$channel-title"/></title>
      <link><xsl:value-of select="$channel-link"/></link>
      <description><xsl:value-of select="$channel-description"/></description>

      <xsl:if test="@lang != ''">
        <language><xsl:value-of select="@lang"/></language>
      </xsl:if>

      <xsl:apply-templates select="./h:head"/>
     </channel>
  </rss>
</xsl:template>

<xsl:template match="h:head">
  <item>
   <xsl:apply-templates select="./h:title"/>
   <xsl:apply-templates select="(./h:meta[@name = 'description'])[last()]"/>
   <xsl:apply-templates select="(./h:meta[@name = 'author'])[last()]"/>
   <xsl:apply-templates select="(./h:meta[@name = 'dcterms.created' or
                                         @name = 'dcterms.modified'])[last()]"/>
  </item>
</xsl:template>

<xsl:template match="h:title">
  <title><xsl:value-of select="."/></title>
</xsl:template>

<xsl:template match="h:meta[@name = 'description']">
  <description><xsl:value-of select="@content"/></description>
</xsl:template>

<xsl:template match="h:meta[@name = 'author']">
  <author><xsl:value-of select="@content"/></author>
</xsl:template>

<xsl:template match="h:meta[@name = 'dcterms.created' or
                            @name = 'dcterms.modified']">
  <pubDate><xsl:value-of select="du:format(string(@content))"/></pubDate>
</xsl:template>

<xsl:template match="*"/>

</xsl:stylesheet>
