function Snowball() {
BaseStemmer = function() {
this.setCurrent = function(value) {
this.current = value;
this.cursor = 0;
this.limit = this.current.length;
this.limit_backward = 0;
this.bra = this.cursor;
this.ket = this.limit;
};
this.getCurrent = function() {
return this.current;
};
this.copy_from = function(other) {
this.current = other.current;
this.cursor = other.cursor;
this.limit = other.limit;
this.limit_backward = other.limit_backward;
this.bra = other.bra;
this.ket = other.ket;
};
this.in_grouping = function(s, min, max) {
if (this.cursor >= this.limit) return false;
var ch = this.current.charCodeAt(this.cursor);
if (ch > max || ch < min) return false;
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
this.cursor++;
return true;
};
this.in_grouping_b = function(s, min, max) {
if (this.cursor <= this.limit_backward) return false;
var ch = this.current.charCodeAt(this.cursor - 1);
if (ch > max || ch < min) return false;
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
this.cursor--;
return true;
};
this.out_grouping = function(s, min, max) {
if (this.cursor >= this.limit) return false;
var ch = this.current.charCodeAt(this.cursor);
if (ch > max || ch < min) {
this.cursor++;
return true;
}
ch -= min;
if ((s[ch >>> 3] & (0X1 << (ch & 0x7))) == 0) {
this.cursor++;
return true;
}
return false;
};
this.out_grouping_b = function(s, min, max) {
if (this.cursor <= this.limit_backward) return false;
var ch = this.current.charCodeAt(this.cursor - 1);
if (ch > max || ch < min) {
this.cursor--;
return true;
}
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) {
this.cursor--;
return true;
}
return false;
};
this.eq_s = function(s)
{
if (this.limit - this.cursor < s.length) return false;
if (this.current.slice(this.cursor, this.cursor + s.length) != s)
{
return false;
}
this.cursor += s.length;
return true;
};
this.eq_s_b = function(s)
{
if (this.cursor - this.limit_backward < s.length) return false;
if (this.current.slice(this.cursor - s.length, this.cursor) != s)
{
return false;
}
this.cursor -= s.length;
return true;
};
 this.find_among = function(v)
{
var i = 0;
var j = v.length;
var c = this.cursor;
var l = this.limit;
var common_i = 0;
var common_j = 0;
var first_key_inspected = false;
while (true)
{
var k = i + ((j - i) >>> 1);
var diff = 0;
var common = common_i < common_j ? common_i : common_j; 
var w = v[k];
var i2;
for (i2 = common; i2 < w[0].length; i2++)
{
if (c + common == l)
{
diff = -1;
break;
}
diff = this.current.charCodeAt(c + common) - w[0].charCodeAt(i2);
if (diff != 0) break;
common++;
}
if (diff < 0)
{
j = k;
common_j = common;
}
else
{
i = k;
common_i = common;
}
if (j - i <= 1)
{
if (i > 0) break; 
if (j == i) break; 
if (first_key_inspected) break;
first_key_inspected = true;
}
}
do {
var w = v[i];
if (common_i >= w[0].length)
{
this.cursor = c + w[0].length;
if (w.length < 4) return w[2];
var res = w[3](this);
this.cursor = c + w[0].length;
if (res) return w[2];
}
i = w[1];
} while (i >= 0);
return 0;
};
this.find_among_b = function(v)
{
var i = 0;
var j = v.length
var c = this.cursor;
var lb = this.limit_backward;
var common_i = 0;
var common_j = 0;
var first_key_inspected = false;
while (true)
{
var k = i + ((j - i) >> 1);
var diff = 0;
var common = common_i < common_j ? common_i : common_j;
var w = v[k];
var i2;
for (i2 = w[0].length - 1 - common; i2 >= 0; i2--)
{
if (c - common == lb)
{
diff = -1;
break;
}
diff = this.current.charCodeAt(c - 1 - common) - w[0].charCodeAt(i2);
if (diff != 0) break;
common++;
}
if (diff < 0)
{
j = k;
common_j = common;
}
else
{
i = k;
common_i = common;
}
if (j - i <= 1)
{
if (i > 0) break;
if (j == i) break;
if (first_key_inspected) break;
first_key_inspected = true;
}
}
do {
var w = v[i];
if (common_i >= w[0].length)
{
this.cursor = c - w[0].length;
if (w.length < 4) return w[2];
var res = w[3](this);
this.cursor = c - w[0].length;
if (res) return w[2];
}
i = w[1];
} while (i >= 0);
return 0;
};
this.replace_s = function(c_bra, c_ket, s)
{
var adjustment = s.length - (c_ket - c_bra);
this.current = this.current.slice(0, c_bra) + s + this.current.slice(c_ket);
this.limit += adjustment;
if (this.cursor >= c_ket) this.cursor += adjustment;
else if (this.cursor > c_bra) this.cursor = c_bra;
return adjustment;
};
this.slice_check = function()
{
if (this.bra < 0 ||
this.bra > this.ket ||
this.ket > this.limit ||
this.limit > this.current.length)
{
return false;
}
return true;
};
this.slice_from = function(s)
{
var result = false;
if (this.slice_check())
{
this.replace_s(this.bra, this.ket, s);
result = true;
}
return result;
};
this.slice_del = function()
{
return this.slice_from("");
};
this.insert = function(c_bra, c_ket, s)
{
var adjustment = this.replace_s(c_bra, c_ket, s);
if (c_bra <= this.bra) this.bra += adjustment;
if (c_bra <= this.ket) this.ket += adjustment;
};
this.slice_to = function()
{
var result = '';
if (this.slice_check())
{
result = this.current.slice(this.bra, this.ket);
}
return result;
};
this.assign_to = function()
{
return this.current.slice(0, this.limit);
};
};
EnglishStemmer = function() {
var base = new BaseStemmer();
 var a_0 = [
["arsen", -1, -1],
["commun", -1, -1],
["gener", -1, -1]
];
 var a_1 = [
["'", -1, 1],
["'s'", 0, 1],
["'s", -1, 1]
];
 var a_2 = [
["ied", -1, 2],
["s", -1, 3],
["ies", 1, 2],
["sses", 1, 1],
["ss", 1, -1],
["us", 1, -1]
];
 var a_3 = [
["", -1, 3],
["bb", 0, 2],
["dd", 0, 2],
["ff", 0, 2],
["gg", 0, 2],
["bl", 0, 1],
["mm", 0, 2],
["nn", 0, 2],
["pp", 0, 2],
["rr", 0, 2],
["at", 0, 1],
["tt", 0, 2],
["iz", 0, 1]
];
 var a_4 = [
["ed", -1, 2],
["eed", 0, 1],
["ing", -1, 2],
["edly", -1, 2],
["eedly", 3, 1],
["ingly", -1, 2]
];
 var a_5 = [
["anci", -1, 3],
["enci", -1, 2],
["ogi", -1, 13],
["li", -1, 15],
["bli", 3, 12],
["abli", 4, 4],
["alli", 3, 8],
["fulli", 3, 9],
["lessli", 3, 14],
["ousli", 3, 10],
["entli", 3, 5],
["aliti", -1, 8],
["biliti", -1, 12],
["iviti", -1, 11],
["tional", -1, 1],
["ational", 14, 7],
["alism", -1, 8],
["ation", -1, 7],
["ization", 17, 6],
["izer", -1, 6],
["ator", -1, 7],
["iveness", -1, 11],
["fulness", -1, 9],
["ousness", -1, 10]
];
 var a_6 = [
["icate", -1, 4],
["ative", -1, 6],
["alize", -1, 3],
["iciti", -1, 4],
["ical", -1, 4],
["tional", -1, 1],
["ational", 5, 2],
["ful", -1, 5],
["ness", -1, 5]
];
 var a_7 = [
["ic", -1, 1],
["ance", -1, 1],
["ence", -1, 1],
["able", -1, 1],
["ible", -1, 1],
["ate", -1, 1],
["ive", -1, 1],
["ize", -1, 1],
["iti", -1, 1],
["al", -1, 1],
["ism", -1, 1],
["ion", -1, 2],
["er", -1, 1],
["ous", -1, 1],
["ant", -1, 1],
["ent", -1, 1],
["ment", 15, 1],
["ement", 16, 1]
];
 var a_8 = [
["e", -1, 1],
["l", -1, 2]
];
 var a_9 = [
["succeed", -1, -1],
["proceed", -1, -1],
["exceed", -1, -1],
["canning", -1, -1],
["inning", -1, -1],
["earring", -1, -1],
["herring", -1, -1],
["outing", -1, -1]
];
 var a_10 = [
["andes", -1, -1],
["atlas", -1, -1],
["bias", -1, -1],
["cosmos", -1, -1],
["dying", -1, 3],
["early", -1, 9],
["gently", -1, 7],
["howe", -1, -1],
["idly", -1, 6],
["lying", -1, 4],
["news", -1, -1],
["only", -1, 10],
["singly", -1, 11],
["skies", -1, 2],
["skis", -1, 1],
["sky", -1, -1],
["tying", -1, 5],
["ugly", -1, 8]
];
 var  g_v = [17, 65, 16, 1];
 var  g_v_WXY = [1, 17, 65, 208, 1];
 var  g_valid_LI = [55, 141, 2];
var  B_Y_found = false;
var  I_p2 = 0;
var  I_p1 = 0;
function r_prelude() {
B_Y_found = false;
var  v_1 = base.cursor;
lab0: {
base.bra = base.cursor;
if (!(base.eq_s("'")))
{
break lab0;
}
base.ket = base.cursor;
if (!base.slice_del())
{
return false;
}
}
base.cursor = v_1;
var  v_2 = base.cursor;
lab1: {
base.bra = base.cursor;
if (!(base.eq_s("y")))
{
break lab1;
}
base.ket = base.cursor;
if (!base.slice_from("Y"))
{
return false;
}
B_Y_found = true;
}
base.cursor = v_2;
var  v_3 = base.cursor;
lab2: {
while(true)
{
var  v_4 = base.cursor;
lab3: {
golab4: while(true)
{
var  v_5 = base.cursor;
lab5: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab5;
}
base.bra = base.cursor;
if (!(base.eq_s("y")))
{
break lab5;
}
base.ket = base.cursor;
base.cursor = v_5;
break golab4;
}
base.cursor = v_5;
if (base.cursor >= base.limit)
{
break lab3;
}
base.cursor++;
}
if (!base.slice_from("Y"))
{
return false;
}
B_Y_found = true;
continue;
}
base.cursor = v_4;
break;
}
}
base.cursor = v_3;
return true;
};
function r_mark_regions() {
I_p1 = base.limit;
I_p2 = base.limit;
var  v_1 = base.cursor;
lab0: {
lab1: {
var  v_2 = base.cursor;
lab2: {
if (base.find_among(a_0) == 0)
{
break lab2;
}
break lab1;
}
base.cursor = v_2;
golab3: while(true)
{
lab4: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab4;
}
break golab3;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
golab5: while(true)
{
lab6: {
if (!(base.out_grouping(g_v, 97, 121)))
{
break lab6;
}
break golab5;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
}
I_p1 = base.cursor;
golab7: while(true)
{
lab8: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab8;
}
break golab7;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
golab9: while(true)
{
lab10: {
if (!(base.out_grouping(g_v, 97, 121)))
{
break lab10;
}
break golab9;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
I_p2 = base.cursor;
}
base.cursor = v_1;
return true;
};
function r_shortv() {
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.out_grouping_b(g_v_WXY, 89, 121)))
{
break lab1;
}
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab1;
}
if (!(base.out_grouping_b(g_v, 97, 121)))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.out_grouping_b(g_v, 97, 121)))
{
return false;
}
if (!(base.in_grouping_b(g_v, 97, 121)))
{
return false;
}
if (base.cursor > base.limit_backward)
{
return false;
}
}
return true;
};
function r_R1() {
if (!(I_p1 <= base.cursor))
{
return false;
}
return true;
};
function r_R2() {
if (!(I_p2 <= base.cursor))
{
return false;
}
return true;
};
function r_Step_1a() {
var  among_var;
var  v_1 = base.limit - base.cursor;
lab0: {
base.ket = base.cursor;
if (base.find_among_b(a_1) == 0)
{
base.cursor = base.limit - v_1;
break lab0;
}
base.bra = base.cursor;
if (!base.slice_del())
{
return false;
}
}
base.ket = base.cursor;
among_var = base.find_among_b(a_2);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
if (!base.slice_from("ss"))
{
return false;
}
break;
case 2:
lab1: {
var  v_2 = base.limit - base.cursor;
lab2: {
{
var  c1 = base.cursor - 2;
if (c1 < base.limit_backward)
{
break lab2;
}
base.cursor = c1;
}
if (!base.slice_from("i"))
{
return false;
}
break lab1;
}
base.cursor = base.limit - v_2;
if (!base.slice_from("ie"))
{
return false;
}
}
break;
case 3:
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
golab3: while(true)
{
lab4: {
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab4;
}
break golab3;
}
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_1b() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_4);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
if (!r_R1())
{
return false;
}
if (!base.slice_from("ee"))
{
return false;
}
break;
case 2:
var  v_1 = base.limit - base.cursor;
golab0: while(true)
{
lab1: {
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab1;
}
break golab0;
}
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
}
base.cursor = base.limit - v_1;
if (!base.slice_del())
{
return false;
}
var  v_3 = base.limit - base.cursor;
among_var = base.find_among_b(a_3);
if (among_var == 0)
{
return false;
}
base.cursor = base.limit - v_3;
switch (among_var) {
case 1:
{
var  c1 = base.cursor;
base.insert(base.cursor, base.cursor, "e");
base.cursor = c1;
}
break;
case 2:
base.ket = base.cursor;
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
base.bra = base.cursor;
if (!base.slice_del())
{
return false;
}
break;
case 3:
if (base.cursor != I_p1)
{
return false;
}
var  v_4 = base.limit - base.cursor;
if (!r_shortv())
{
return false;
}
base.cursor = base.limit - v_4;
{
var  c2 = base.cursor;
base.insert(base.cursor, base.cursor, "e");
base.cursor = c2;
}
break;
}
break;
}
return true;
};
function r_Step_1c() {
base.ket = base.cursor;
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.eq_s_b("y")))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.eq_s_b("Y")))
{
return false;
}
}
base.bra = base.cursor;
if (!(base.out_grouping_b(g_v, 97, 121)))
{
return false;
}
lab2: {
if (base.cursor > base.limit_backward)
{
break lab2;
}
return false;
}
if (!base.slice_from("i"))
{
return false;
}
return true;
};
function r_Step_2() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_5);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R1())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("tion"))
{
return false;
}
break;
case 2:
if (!base.slice_from("ence"))
{
return false;
}
break;
case 3:
if (!base.slice_from("ance"))
{
return false;
}
break;
case 4:
if (!base.slice_from("able"))
{
return false;
}
break;
case 5:
if (!base.slice_from("ent"))
{
return false;
}
break;
case 6:
if (!base.slice_from("ize"))
{
return false;
}
break;
case 7:
if (!base.slice_from("ate"))
{
return false;
}
break;
case 8:
if (!base.slice_from("al"))
{
return false;
}
break;
case 9:
if (!base.slice_from("ful"))
{
return false;
}
break;
case 10:
if (!base.slice_from("ous"))
{
return false;
}
break;
case 11:
if (!base.slice_from("ive"))
{
return false;
}
break;
case 12:
if (!base.slice_from("ble"))
{
return false;
}
break;
case 13:
if (!(base.eq_s_b("l")))
{
return false;
}
if (!base.slice_from("og"))
{
return false;
}
break;
case 14:
if (!base.slice_from("less"))
{
return false;
}
break;
case 15:
if (!(base.in_grouping_b(g_valid_LI, 99, 116)))
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_3() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_6);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R1())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("tion"))
{
return false;
}
break;
case 2:
if (!base.slice_from("ate"))
{
return false;
}
break;
case 3:
if (!base.slice_from("al"))
{
return false;
}
break;
case 4:
if (!base.slice_from("ic"))
{
return false;
}
break;
case 5:
if (!base.slice_del())
{
return false;
}
break;
case 6:
if (!r_R2())
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_4() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_7);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R2())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_del())
{
return false;
}
break;
case 2:
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.eq_s_b("s")))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.eq_s_b("t")))
{
return false;
}
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_5() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_8);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!r_R2())
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!r_R1())
{
return false;
}
{
var  v_2 = base.limit - base.cursor;
lab2: {
if (!r_shortv())
{
break lab2;
}
return false;
}
base.cursor = base.limit - v_2;
}
}
if (!base.slice_del())
{
return false;
}
break;
case 2:
if (!r_R2())
{
return false;
}
if (!(base.eq_s_b("l")))
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_exception2() {
base.ket = base.cursor;
if (base.find_among_b(a_9) == 0)
{
return false;
}
base.bra = base.cursor;
if (base.cursor > base.limit_backward)
{
return false;
}
return true;
};
function r_exception1() {
var  among_var;
base.bra = base.cursor;
among_var = base.find_among(a_10);
if (among_var == 0)
{
return false;
}
base.ket = base.cursor;
if (base.cursor < base.limit)
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("ski"))
{
return false;
}
break;
case 2:
if (!base.slice_from("sky"))
{
return false;
}
break;
case 3:
if (!base.slice_from("die"))
{
return false;
}
break;
case 4:
if (!base.slice_from("lie"))
{
return false;
}
break;
case 5:
if (!base.slice_from("tie"))
{
return false;
}
break;
case 6:
if (!base.slice_from("idl"))
{
return false;
}
break;
case 7:
if (!base.slice_from("gentl"))
{
return false;
}
break;
case 8:
if (!base.slice_from("ugli"))
{
return false;
}
break;
case 9:
if (!base.slice_from("earli"))
{
return false;
}
break;
case 10:
if (!base.slice_from("onli"))
{
return false;
}
break;
case 11:
if (!base.slice_from("singl"))
{
return false;
}
break;
}
return true;
};
function r_postlude() {
if (!B_Y_found)
{
return false;
}
while(true)
{
var  v_1 = base.cursor;
lab0: {
golab1: while(true)
{
var  v_2 = base.cursor;
lab2: {
base.bra = base.cursor;
if (!(base.eq_s("Y")))
{
break lab2;
}
base.ket = base.cursor;
base.cursor = v_2;
break golab1;
}
base.cursor = v_2;
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
if (!base.slice_from("y"))
{
return false;
}
continue;
}
base.cursor = v_1;
break;
}
return true;
};
this.stem =  function() {
lab0: {
var  v_1 = base.cursor;
lab1: {
if (!r_exception1())
{
break lab1;
}
break lab0;
}
base.cursor = v_1;
lab2: {
{
var  v_2 = base.cursor;
lab3: {
{
var  c1 = base.cursor + 3;
if (c1 > base.limit)
{
break lab3;
}
base.cursor = c1;
}
break lab2;
}
base.cursor = v_2;
}
break lab0;
}
base.cursor = v_1;
r_prelude();
r_mark_regions();
base.limit_backward = base.cursor; base.cursor = base.limit;
var  v_5 = base.limit - base.cursor;
r_Step_1a();
base.cursor = base.limit - v_5;
lab4: {
var  v_6 = base.limit - base.cursor;
lab5: {
if (!r_exception2())
{
break lab5;
}
break lab4;
}
base.cursor = base.limit - v_6;
var  v_7 = base.limit - base.cursor;
r_Step_1b();
base.cursor = base.limit - v_7;
var  v_8 = base.limit - base.cursor;
r_Step_1c();
base.cursor = base.limit - v_8;
var  v_9 = base.limit - base.cursor;
r_Step_2();
base.cursor = base.limit - v_9;
var  v_10 = base.limit - base.cursor;
r_Step_3();
base.cursor = base.limit - v_10;
var  v_11 = base.limit - base.cursor;
r_Step_4();
base.cursor = base.limit - v_11;
var  v_12 = base.limit - base.cursor;
r_Step_5();
base.cursor = base.limit - v_12;
}
base.cursor = base.limit_backward;
var  v_13 = base.cursor;
r_postlude();
base.cursor = v_13;
}
return true;
};
this['stemWord'] = function(word) {
base.setCurrent(word);
this.stem();
return base.getCurrent();
};
};
return new EnglishStemmer();
}
wh.search_stemmer = Snowball();
wh.search_baseNameList = [
 "starting_w2x_app_native.html",
 "starting_w2x_app_zip.html",
 "starting_w2x_app.html",
 "converting_docx_to_xml.html",
 "options_wizard_format_screen.html",
 "options_wizard_options_screen.html",
 "style_mapping_editor.html",
 "options_wizard_style_mapping_screen.html",
 "options_wizard_other_parameters_screen.html",
 "options_wizard_save_file_screen.html",
 "options_wizard_review_screen.html",
 "options_wizard_saving_file_screen.html",
 "options_wizard_finish_screen.html",
 "options_wizard.html",
 "create_options_file.html",
 "edit_options_file.html",
 "hand_written_options_files.html",
 "custom_conversion.html",
 "command_line_usage.html",
 "change_user_pref.html",
 "user_pref_file.html",
 "user_pref_list.html",
 "user_preferences.html",
 "index.html"
];
wh.search_titleList = [
 "1.1. After installing the native distribution (setup.exe on Windows, .dmg on the Mac)",
 "1.2. After installing the .zip distribution",
 "1. Starting w2x-app",
 "2. Converting a DOCX file",
 "3.1.1. &#34;Output format&#34; screen",
 "3.1.2. &#34;Output format options&#34; screen",
 "3.1.3.1. Dialog box allowing to add or modify an entry of the MS-Word style to XML element map",
 "3.1.3. &#34;MS-Word style to XML element map&#34; screen",
 "3.1.4. &#34;Other parameters&#34; screen",
 "3.1.5. &#34;Save file&#34; screen",
 "3.1.6. &#34;Ready to save options&#34; screen",
 "3.1.7. &#34;Saving options&#34; screen",
 "3.1.8. &#34;Finish&#34; screen",
 "3.1. Using the setup assistant to create custom conversion specifications",
 "3.2.1. Creating a custom conversion specification",
 "3.2.2. Modifying an existing custom conversion specification",
 "3.2. Creating custom conversion specification without the help of the setup assistant",
 "3. Custom conversion specifications",
 "A. Command line options",
 "1. How to change a user preference",
 "2. Where user preferences are stored",
 "3. Supported user preferences",
 "B. User preferences",
 "w2x-app - Online Help"
];
wh.search_wordMap= {
"cancel": [3],
"parent": [6],
"been": [3,[6,12]],
"extens": [3,[9,21]],
"addit": [3],
"intellij": [1],
"your": [[1,13,14]],
"without": [16],
"these": [3],
"xml": [3,6,7,[0,8,13,17]],
"double-click": [0,1],
"strict": [3],
"abbr": [17],
"you": [1,[3,6],13,[14,15,20]],
"apply-templ": [17,9],
"happen": [3],
"ad": [6],
"appendix": [18],
"thus": [19],
"past": [14],
"advanced_opt": [18],
"automat": [3,6,[1,9]],
"percentag": [21],
"an": [3,6,15,[1,7,13,20,21]],
"cours": [3],
"click": [3,[6,7],14,[13,15]],
"version": [[9,17]],
"conserv": [6],
"finder": [3],
"uhd": [1],
"as": [3,1,6,14],
"befor": [3],
"predefin": [14,3,6],
"folder": [20,3],
"size": [[1,21]],
"util": [23],
"nativ": [21,0],
"left": [3],
"for-each": [17],
"p-remark": [6],
"descript": [[1,3]],
"much": [3],
"preserv": [6],
"chapter": [3],
"be": [3,[1,6,13],[8,21],[4,14,15]],
"depict": [9],
"icon": [0],
"delet": [17],
"turn": [20],
"manual": [17],
"manual_bookmap_top": [17],
"consecut": [6],
"result": [3],
"how": [19],
"see": [[1,18,20]],
"displaysc": [[1,19],21],
"same": [6],
"setup.ex": [0],
"by": [6,[3,9],1,[13,17,18,19],[4,5,8,11,12,21]],
"epub": [3,7],
"checkbox": [3],
"outputformat": [9],
"franc": [23],
"after": [1,[0,3,5,6,12]],
"transform.topic-typ": [9],
"behavior": [19],
"hand": [13,9],
"leblanc": [23],
"fli": [3],
"set": [[1,18],[19,21]],
"contain": [3,17,6,[15,23]],
"note_group_memb": [17],
"abl": [1],
"figur": [3],
"the": [3,6,1,9,21,[5,14],[0,8,13],18,[4,10,11,15,19,20],[7,12,16,17,23]],
"invok": [21],
"wizard": [13],
"standard": [[3,6]],
"dd": [17],
"preference_key": [19],
"featur": [3,13],
"iso": [20],
"dl": [17],
"extern": [3],
"forc": [6],
"do": [3,[1,6,8,9]],
"specif": [[3,17],[6,14],15,[13,16]],
"dt": [17],
"div": [17],
"outlin": [3],
"w2x_user_preferences_dir": [20],
"p-programlist": [17,6],
"implement": [6],
"finish": [12],
"lookandfeelclassnam": [1,21],
"which": [3,14,[8,9,13,21,23]],
"add": [[6,7],18],
"brows": [3],
"signific": [6],
"need": [1,[3,6,9,14,15]],
"flatlight": [1],
"equival": [14],
"check": [3],
"list": [3,6,23],
"els": [17],
"resolut": [1],
"referenc": [[3,17],9],
"v5.1": [3],
"altern": [1],
"v5.0": [3,14],
"topic.xslt": [[9,17]],
"final": [1],
"http": [17,9],
"excerpt": [9],
"frame": [3],
"child": [6],
"wordtoxml": [20,0],
"some": [[1,3,15]],
"delpref": [19,[1,18]],
"rather": [[1,6]],
"for": [3,1,[6,9],[5,8],[14,17,19,21]],
"h1": [3],
"h2": [3],
"h3": [3],
"h4": [3],
"h5": [3],
"content": [3,[5,14]],
"h6": [3],
"non-styl": [3],
"xsl": [17,9],
"random": [3],
"softwar": [23],
"combin": [6],
"end": [[3,6]],
"docbook": [3,17,[6,14]],
"just": [6],
"class": [17,[9,21]],
"modifi": [13,15,[6,7]],
"forcibl": [3],
"otherwis": [6],
"custom": [6,17,3,14,15,[4,5,9,13,16]],
"preference_valu": [19],
"perform": [3],
"shafi": [23],
"topic.w2x": [9],
"howev": [6,[1,3]],
"contrari": [3],
"home": [20],
"with": [3,[1,6,8]],
"v4.5": [3,17],
"role-not": [17],
"there": [6],
"xmlmind": [3,20,[0,17,23]],
"www.xmlmind.com": [23],
"setup": [13,9,[6,11,12,16]],
"syntax": [19],
"relat": [17],
"restor": [19],
"directori": [3,20,1],
"prompt": [1],
"dmg": [0],
"empti": [3],
"explain": [1],
"select": [[3,6],[5,7,14],4],
"bin": [1],
"properti": [20],
"convers": [3,14,17,15,[4,5,6,13,16]],
"convert": [6,3,17],
"ignor": [21],
"transform.hierarchy-nam": [14],
"clipboard": [14],
"assembl": [3],
"output": [3,5,[4,6],[7,8]],
"veri": [1,[3,11,20]],
"number": [17],
"edit.prune.preserv": [17],
"to1": [6],
"specifi": [3,8,[1,4,5,18],[6,9,15,20]],
"block": [3],
"custom_transform.xslt": [9],
"text": [[3,6],15,17,[9,14,20]],
"id": [17],
"per": [8],
"if": [3,[1,6],[4,5,13,14,15,17,20]],
"e.g": [6,3,[7,13],15],
"order": [3],
"creat": [3,[9,13],14,[1,16]],
"similar": [3],
"proceed": [[3,6]],
"in": [3,6,[1,9,15,17,20],[5,21]],
"made": [3],
"termin": [1],
"metal": [1],
"is": [3,6,1,[5,19],17,7,[9,11,13,21],[4,10,12,14,20,23]],
"integ": [3],
"it": [3,13,1,19,[6,11]],
"manag": [20],
"system": [1,[3,21],15],
"maco": [1],
"field": [3,6,15],
"singl": [3,[6,8]],
"invalid": [6],
"doc": [17],
"john": [20],
"doe": [[3,5]],
"w2x": [9,13,[1,3,6,17,20,23],[11,12,14,15]],
"paragraph": [6,[3,7,13]],
"charset": [3],
"other": [[6,8],[4,7,13,21]],
"valu": [3,21,[8,18],[1,6,20]],
"librari": [20],
"paramet": [3,8],
"save": [[9,11],[10,12]],
"com.formdev.flatlaf.themes.flatmacdarklaf": [1],
"articl": [3,14],
"mac": [1,0,[3,20,21]],
"interfac": [[1,21]],
"file": [3,9,[6,13,20],21,17,15,[11,12,14]],
"too": [3],
"assum": [6],
"hidpi": [1],
"have": [6,3,1,[5,7,13]],
"map": [6,7,3,[8,13]],
"avail": [1],
"may": [3,[6,13,21],[1,4,15]],
"break": [6],
"themselv": [3],
"c-filepath": [[6,9]],
"codesnippet": [6],
"uri": [17],
"urn": [17],
"charact": [6,[7,13,17]],
"surpris": [3],
"aka": [13],
"heurist": [6],
"exampl": [17,6,[1,19],[3,5,8,9,14,20]],
"cite": [6],
"topic-path": [17],
"instal": [[0,1]],
"mail": [23],
"use": [3,1,13,21,6,[4,5,9,17,19,20],[7,8,14,15,23]],
"pleas": [1,[6,9]],
"w2x_install_dir": [17,1],
"screen": [5,1,8,7,[4,9,10,11,12],13],
"feel": [1,21],
"namespac": [17,6],
"main": [3],
"while": [3,[11,14]],
"correspond": [3],
"laf": [21],
"that": [3,6,[1,9],[13,17]],
"high": [1],
"split": [3],
"conveni": [3],
"fine": [1],
"than": [3,[21,23]],
"limit": [13],
"outdat": [1],
"dita": [[3,6],[7,8,13,17]],
"all": [3,1,6,[10,13,19,21]],
"new": [3,[14,17]],
"entri": [3,7,6],
"level": [3],
"below": [[5,15]],
"utf": [3,[9,17]],
"revert": [1],
"choos": [6,3],
"rememb": [9],
"less": [3],
"programmat": [3],
"tool": [20],
"chosen": [[5,7,10]],
"alreadi": [3],
"transit": [3],
"remove-class": [17],
"true": [21],
"therefor": [[3,6]],
"bodi": [17],
"disabl": [[3,15]],
"no": [6,1],
"w2x-app.properti": [20],
"code": [[6,17]],
"box": [6,[3,13,20]],
"head": [3],
"dialog": [6,[3,13,20]],
"transform": [[9,17]],
"and": [6,3,1,21,[13,17,20],[7,8,9,19]],
"of": [3,6,21,1,[5,18],[4,7,8,13,14,16,17,23]],
"transform.root-topic-id": [17],
"command-lin": [19,[1,3,14,17,23]],
"possibl": [3,6,[7,8,13,17]],
"obsolet": [3],
"ok": [6],
"ani": [5,[1,3,4,7]],
"make": [3,13],
"on": [1,[0,3,20],[5,15,21]],
"bookmap_options.txt": [17],
"filesar": [9],
"custom_topic.xslt": [17],
"or": [[3,6],21,[8,9],[17,18,19]],
"abov": [[1,9]],
"chooser": [21],
"encod": [[9,17]],
"easier": [23],
"xslt": [9,[6,17]],
"multi-pag": [3,7],
"appdata": [20],
"reason": [1],
"css": [3],
"inform": [21,[1,3]],
"depend": [5],
"pu": [17,8],
"edit.blocks.convert": [17],
"outputclass": [[6,13]],
"shift": [3],
"about": [[3,6,9]],
"bookmap": [[3,17]],
"java": [21,20],
"url_or_file_parameter_valu": [8],
"let": [8,10],
"press": [1,3],
"section-depth": [17],
"onlin": [23],
"element": [6,3,7,[8,13]],
"edit": [3,9,7],
"frameset": [3],
"ms-word": [6,7,[3,8,13]],
"want": [3,6],
"com.formdev.flatlaf.flatdarculalaf": [1],
"then": [[1,3],[6,14]],
"each": [3,6],
"p-sidebar": [[6,7]],
"input": [6,3],
"meta": [3],
"codeblock": [[6,8]],
"must": [3,6,8],
"except": [3],
"fact": [17],
"document": [3,[8,23]],
"global": [[1,21]],
"recommend": [[3,9]],
"screenshot": [9],
"long": [3],
"seem": [3],
"into": [3,6,14],
"default": [21,3,1,[6,8,19]],
"current": [3,14],
"semant": [3],
"found": [3,6],
"are": [3,6,20,[8,9,14,17,21]],
"where": [6,[17,20]],
"free": [3],
"graphic": [23],
"key": [18,[1,3,20]],
"email": [23],
"get-class": [17],
"notes.x": [17],
"onc": [1,19],
"docbook5": [14],
"p-term": [17],
"one": [[6,8]],
"nest": [3],
"store": [20],
"delete-text": [17],
"docx": [3,6],
"call": [1,6],
"txt": [[3,9]],
"such": [3],
"plugin": [[3,4,5]],
"remov": [7,[18,19]],
"ask": [3],
"assist": [13,9,[6,11,12,16]],
"oper": [3],
"to": [3,6,1,7,[13,14,17],21,[4,9,10,15],[0,5,8,18,19,23]],
"tp": [6],
"open": [3,15],
"typic": [6],
"but": [[1,6]],
"tt": [17],
"com.formdev.flatlaf.themes.flatmaclightlaf": [1],
"treat": [3],
"rue": [23],
"p-keyboardinput": [[6,13]],
"run": [6,1],
"microsoft": [20],
"c-code": [17],
"set-attribut": [17],
"split-before-level": [3],
"view": [20],
"sever": [3],
"w2x-app": [1,[19,21,23],[2,3,9,18]],
"has": [[3,13],[6,12]],
"up": [6],
"topic_script": [9],
"evalu": [3],
"given": [6],
"doubl": [8],
"pre": [6,17,[8,13]],
"com.formdev.flatlaf.flatintellijlaf": [1],
"p-definit": [17],
"this": [3,[5,6,13],1,7,[4,8,9,10,12,15,20,21,23]],
"dure": [[3,10]],
"look": [1,21,3],
"alia": [21],
"repres": [6],
"opt": [1],
"name": [6,[3,17],[9,21]],
"low-level": [1],
"page": [3],
"support": [21,[6,8,20]],
"preview": [3],
"allow": [6],
"next": [13],
"vv": [18],
"string": [3],
"import": [[9,13,17]],
"hidden": [20],
"becaus": [[1,3,6,21]],
"concept": [3,9],
"book": [3,17],
"show": [[18,20]],
"detect": [1],
"com.formdev.flatlaf.flatlightlaf": [1],
"keyboard-input": [[6,13]],
"button": [3,15],
"comput": [1],
"not": [3,[5,6,8,17],[1,7,9,21]],
"xmlns": [[9,17]],
"common": [5],
"linux": [1,[3,15,20]],
"now": [[1,6]],
"factor": [1],
"precis": [6],
"parameter_nam": [8],
"p-note": [17],
"associ": [3],
"previous": [[5,10]],
"clariti": [8],
"org": [17,9],
"yes": [[14,17]],
"start": [3,1,[2,14]],
"distribut": [1,0],
"c-abbrev": [17],
"flatlaf": [1],
"way": [3,6],
"xhtml": [3,17,[5,6,9]],
"target": [6],
"equal": [3],
"exclude-result-prefix": [[9,17]],
"input_docx_fil": [18],
"edit.after.block": [17],
"chang": [[19,21],[1,13]],
"c-codesnippet": [6],
"step": [10],
"window": [1,[0,20],[3,21]],
"time": [3,13],
"combobox": [6,3,14],
"mark": [8],
"base": [1],
"intermedi": [3],
"sourc": [3],
"prefix": [6],
"compris": [[1,21]],
"type": [6,1,7],
"when": [[1,3,5,6,7,8,9,13,21]],
"xmlmind.com": [23],
"sidebar": [[6,7]],
"review": [10],
"lost": [13],
"rambouillet": [23],
"enter": [1],
"embed": [3],
"href": [[9,17]],
"roam": [20],
"between": [3,21],
"case": [[3,5,9]],
"zip": [1],
"profession": [3],
"stylesheet": [[9,17],[3,6]],
"applic": [3,[1,20,23]],
"item": [[1,21]],
"multipl": [3,6],
"work": [1],
"come": [6],
"exist": [15,3],
"transform.pre-element-nam": [8],
"light": [1],
"p-codesnippet": [6],
"phone": [23],
"call-templ": [17,9],
"style": [6,3,7,13,[5,8]],
"explor": [3],
"quot": [8],
"word": [3,[0,17]],
"care": [6],
"multi-platform": [21],
"tabl": [3,17],
"usenativefilechoos": [21],
"com.formdev.flatlaf.flatdarklaf": [1],
"hussein": [23],
"direct": [1],
"othertyp": [[6,7]],
"processcommonattribut": [17,9],
"transform2": [17],
"putpref": [1,19,18],
"copi": [14],
"unzip": [1],
"x-mlmind": [17],
"compil": [3],
"web": [3,[7,23]],
"dark": [1],
"w2x-app.ex": [1],
"theme": [1],
"packag": [3],
"editor": [15],
"loui": [23],
"more": [21,[1,3,6]],
"display": [5,[1,3,7,10,11,12,13]],
"suggest": [6],
"abstract": [23],
"filter": [21],
"help": [3,23,[7,16]],
"cannot": [[13,20]],
"advanc": [[17,18]],
"span": [[9,17]],
"quick": [13],
"prefer": [[1,18],[19,20,21],22],
"quotat": [8],
"whitespac": [6],
"www.w3": [17,9],
"section": [3,6],
"content-typ": [3,17],
"separ": [17],
"convert.set-column-numb": [[14,17]],
"simpli": [1,[3,17,20]],
"space": [17],
"draft-com": [6],
"filepath": [9,6],
"darcula": [1],
"plain": [9],
"simpl": [17],
"from": [[6,9],[1,3,18]],
"html": [3,17,[5,7]],
"replac": [[3,18]],
"group": [[6,17]],
"you\'ll": [[1,13]],
"like": [[3,6]],
"kind": [7],
"onli": [[1,3,6]],
"format": [5,4,[6,7,8,20]],
"templat": [17,9],
"done": [1],
"moreov": [3],
"fals": [21],
"both": [9],
"topic": [3,9],
"fallback": [1,21],
"option": [[9,13],5,3,[6,10,11,17,18,19],[1,8,12,14,15,20]],
"here": [6],
"note": [17,6,[3,7,9]],
"laf_class_nam": [1],
"procedur": [3],
"parameter_valu": [8],
"line": [6,[8,17,18]],
"part": [3],
"scale": [1],
"generat": [3,[8,17]],
"becom": [3],
"error": [1],
"novemb": [23],
"platform": [[1,3,15,21]],
"point": [3,14],
"cal": [3,17],
"can": [1],
"general": [6],
"transform.cals-t": [[14,17]],
"public": [23],
"retina": [1],
"briefli": [11],
"browser": [3],
"messag": [[1,18]],
"easi": [3,13],
"edit.inlines.convert": [17],
"debug": [18],
"will": [3,[6,13,14]],
"readi": [10],
"attribut": [6,[7,13]],
"match": [17,9],
"also": [[3,9,13]],
"follow": [1,6],
"categori": [4],
"instead": [6],
"command": [1,18],
"differ": [6],
"consol": [1],
"single-pag": [3,[5,7]],
"topicref": [3],
"mean": [3,21,[4,5]],
"w2x-app-c.bat": [1],
"intend": [1],
"user": [[18,19,20,21],8,[1,10,22]],
"w2x-support": [23]
};
