function Snowball() {
BaseStemmer = function() {
this.setCurrent = function(value) {
this.current = value;
this.cursor = 0;
this.limit = this.current.length;
this.limit_backward = 0;
this.bra = this.cursor;
this.ket = this.limit;
};
this.getCurrent = function() {
return this.current;
};
this.copy_from = function(other) {
this.current = other.current;
this.cursor = other.cursor;
this.limit = other.limit;
this.limit_backward = other.limit_backward;
this.bra = other.bra;
this.ket = other.ket;
};
this.in_grouping = function(s, min, max) {
if (this.cursor >= this.limit) return false;
var ch = this.current.charCodeAt(this.cursor);
if (ch > max || ch < min) return false;
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
this.cursor++;
return true;
};
this.in_grouping_b = function(s, min, max) {
if (this.cursor <= this.limit_backward) return false;
var ch = this.current.charCodeAt(this.cursor - 1);
if (ch > max || ch < min) return false;
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
this.cursor--;
return true;
};
this.out_grouping = function(s, min, max) {
if (this.cursor >= this.limit) return false;
var ch = this.current.charCodeAt(this.cursor);
if (ch > max || ch < min) {
this.cursor++;
return true;
}
ch -= min;
if ((s[ch >>> 3] & (0X1 << (ch & 0x7))) == 0) {
this.cursor++;
return true;
}
return false;
};
this.out_grouping_b = function(s, min, max) {
if (this.cursor <= this.limit_backward) return false;
var ch = this.current.charCodeAt(this.cursor - 1);
if (ch > max || ch < min) {
this.cursor--;
return true;
}
ch -= min;
if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) {
this.cursor--;
return true;
}
return false;
};
this.eq_s = function(s)
{
if (this.limit - this.cursor < s.length) return false;
if (this.current.slice(this.cursor, this.cursor + s.length) != s)
{
return false;
}
this.cursor += s.length;
return true;
};
this.eq_s_b = function(s)
{
if (this.cursor - this.limit_backward < s.length) return false;
if (this.current.slice(this.cursor - s.length, this.cursor) != s)
{
return false;
}
this.cursor -= s.length;
return true;
};
 this.find_among = function(v)
{
var i = 0;
var j = v.length;
var c = this.cursor;
var l = this.limit;
var common_i = 0;
var common_j = 0;
var first_key_inspected = false;
while (true)
{
var k = i + ((j - i) >>> 1);
var diff = 0;
var common = common_i < common_j ? common_i : common_j; 
var w = v[k];
var i2;
for (i2 = common; i2 < w[0].length; i2++)
{
if (c + common == l)
{
diff = -1;
break;
}
diff = this.current.charCodeAt(c + common) - w[0].charCodeAt(i2);
if (diff != 0) break;
common++;
}
if (diff < 0)
{
j = k;
common_j = common;
}
else
{
i = k;
common_i = common;
}
if (j - i <= 1)
{
if (i > 0) break; 
if (j == i) break; 
if (first_key_inspected) break;
first_key_inspected = true;
}
}
do {
var w = v[i];
if (common_i >= w[0].length)
{
this.cursor = c + w[0].length;
if (w.length < 4) return w[2];
var res = w[3](this);
this.cursor = c + w[0].length;
if (res) return w[2];
}
i = w[1];
} while (i >= 0);
return 0;
};
this.find_among_b = function(v)
{
var i = 0;
var j = v.length
var c = this.cursor;
var lb = this.limit_backward;
var common_i = 0;
var common_j = 0;
var first_key_inspected = false;
while (true)
{
var k = i + ((j - i) >> 1);
var diff = 0;
var common = common_i < common_j ? common_i : common_j;
var w = v[k];
var i2;
for (i2 = w[0].length - 1 - common; i2 >= 0; i2--)
{
if (c - common == lb)
{
diff = -1;
break;
}
diff = this.current.charCodeAt(c - 1 - common) - w[0].charCodeAt(i2);
if (diff != 0) break;
common++;
}
if (diff < 0)
{
j = k;
common_j = common;
}
else
{
i = k;
common_i = common;
}
if (j - i <= 1)
{
if (i > 0) break;
if (j == i) break;
if (first_key_inspected) break;
first_key_inspected = true;
}
}
do {
var w = v[i];
if (common_i >= w[0].length)
{
this.cursor = c - w[0].length;
if (w.length < 4) return w[2];
var res = w[3](this);
this.cursor = c - w[0].length;
if (res) return w[2];
}
i = w[1];
} while (i >= 0);
return 0;
};
this.replace_s = function(c_bra, c_ket, s)
{
var adjustment = s.length - (c_ket - c_bra);
this.current = this.current.slice(0, c_bra) + s + this.current.slice(c_ket);
this.limit += adjustment;
if (this.cursor >= c_ket) this.cursor += adjustment;
else if (this.cursor > c_bra) this.cursor = c_bra;
return adjustment;
};
this.slice_check = function()
{
if (this.bra < 0 ||
this.bra > this.ket ||
this.ket > this.limit ||
this.limit > this.current.length)
{
return false;
}
return true;
};
this.slice_from = function(s)
{
var result = false;
if (this.slice_check())
{
this.replace_s(this.bra, this.ket, s);
result = true;
}
return result;
};
this.slice_del = function()
{
return this.slice_from("");
};
this.insert = function(c_bra, c_ket, s)
{
var adjustment = this.replace_s(c_bra, c_ket, s);
if (c_bra <= this.bra) this.bra += adjustment;
if (c_bra <= this.ket) this.ket += adjustment;
};
this.slice_to = function()
{
var result = '';
if (this.slice_check())
{
result = this.current.slice(this.bra, this.ket);
}
return result;
};
this.assign_to = function()
{
return this.current.slice(0, this.limit);
};
};
EnglishStemmer = function() {
var base = new BaseStemmer();
 var a_0 = [
["arsen", -1, -1],
["commun", -1, -1],
["gener", -1, -1]
];
 var a_1 = [
["'", -1, 1],
["'s'", 0, 1],
["'s", -1, 1]
];
 var a_2 = [
["ied", -1, 2],
["s", -1, 3],
["ies", 1, 2],
["sses", 1, 1],
["ss", 1, -1],
["us", 1, -1]
];
 var a_3 = [
["", -1, 3],
["bb", 0, 2],
["dd", 0, 2],
["ff", 0, 2],
["gg", 0, 2],
["bl", 0, 1],
["mm", 0, 2],
["nn", 0, 2],
["pp", 0, 2],
["rr", 0, 2],
["at", 0, 1],
["tt", 0, 2],
["iz", 0, 1]
];
 var a_4 = [
["ed", -1, 2],
["eed", 0, 1],
["ing", -1, 2],
["edly", -1, 2],
["eedly", 3, 1],
["ingly", -1, 2]
];
 var a_5 = [
["anci", -1, 3],
["enci", -1, 2],
["ogi", -1, 13],
["li", -1, 15],
["bli", 3, 12],
["abli", 4, 4],
["alli", 3, 8],
["fulli", 3, 9],
["lessli", 3, 14],
["ousli", 3, 10],
["entli", 3, 5],
["aliti", -1, 8],
["biliti", -1, 12],
["iviti", -1, 11],
["tional", -1, 1],
["ational", 14, 7],
["alism", -1, 8],
["ation", -1, 7],
["ization", 17, 6],
["izer", -1, 6],
["ator", -1, 7],
["iveness", -1, 11],
["fulness", -1, 9],
["ousness", -1, 10]
];
 var a_6 = [
["icate", -1, 4],
["ative", -1, 6],
["alize", -1, 3],
["iciti", -1, 4],
["ical", -1, 4],
["tional", -1, 1],
["ational", 5, 2],
["ful", -1, 5],
["ness", -1, 5]
];
 var a_7 = [
["ic", -1, 1],
["ance", -1, 1],
["ence", -1, 1],
["able", -1, 1],
["ible", -1, 1],
["ate", -1, 1],
["ive", -1, 1],
["ize", -1, 1],
["iti", -1, 1],
["al", -1, 1],
["ism", -1, 1],
["ion", -1, 2],
["er", -1, 1],
["ous", -1, 1],
["ant", -1, 1],
["ent", -1, 1],
["ment", 15, 1],
["ement", 16, 1]
];
 var a_8 = [
["e", -1, 1],
["l", -1, 2]
];
 var a_9 = [
["succeed", -1, -1],
["proceed", -1, -1],
["exceed", -1, -1],
["canning", -1, -1],
["inning", -1, -1],
["earring", -1, -1],
["herring", -1, -1],
["outing", -1, -1]
];
 var a_10 = [
["andes", -1, -1],
["atlas", -1, -1],
["bias", -1, -1],
["cosmos", -1, -1],
["dying", -1, 3],
["early", -1, 9],
["gently", -1, 7],
["howe", -1, -1],
["idly", -1, 6],
["lying", -1, 4],
["news", -1, -1],
["only", -1, 10],
["singly", -1, 11],
["skies", -1, 2],
["skis", -1, 1],
["sky", -1, -1],
["tying", -1, 5],
["ugly", -1, 8]
];
 var  g_v = [17, 65, 16, 1];
 var  g_v_WXY = [1, 17, 65, 208, 1];
 var  g_valid_LI = [55, 141, 2];
var  B_Y_found = false;
var  I_p2 = 0;
var  I_p1 = 0;
function r_prelude() {
B_Y_found = false;
var  v_1 = base.cursor;
lab0: {
base.bra = base.cursor;
if (!(base.eq_s("'")))
{
break lab0;
}
base.ket = base.cursor;
if (!base.slice_del())
{
return false;
}
}
base.cursor = v_1;
var  v_2 = base.cursor;
lab1: {
base.bra = base.cursor;
if (!(base.eq_s("y")))
{
break lab1;
}
base.ket = base.cursor;
if (!base.slice_from("Y"))
{
return false;
}
B_Y_found = true;
}
base.cursor = v_2;
var  v_3 = base.cursor;
lab2: {
while(true)
{
var  v_4 = base.cursor;
lab3: {
golab4: while(true)
{
var  v_5 = base.cursor;
lab5: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab5;
}
base.bra = base.cursor;
if (!(base.eq_s("y")))
{
break lab5;
}
base.ket = base.cursor;
base.cursor = v_5;
break golab4;
}
base.cursor = v_5;
if (base.cursor >= base.limit)
{
break lab3;
}
base.cursor++;
}
if (!base.slice_from("Y"))
{
return false;
}
B_Y_found = true;
continue;
}
base.cursor = v_4;
break;
}
}
base.cursor = v_3;
return true;
};
function r_mark_regions() {
I_p1 = base.limit;
I_p2 = base.limit;
var  v_1 = base.cursor;
lab0: {
lab1: {
var  v_2 = base.cursor;
lab2: {
if (base.find_among(a_0) == 0)
{
break lab2;
}
break lab1;
}
base.cursor = v_2;
golab3: while(true)
{
lab4: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab4;
}
break golab3;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
golab5: while(true)
{
lab6: {
if (!(base.out_grouping(g_v, 97, 121)))
{
break lab6;
}
break golab5;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
}
I_p1 = base.cursor;
golab7: while(true)
{
lab8: {
if (!(base.in_grouping(g_v, 97, 121)))
{
break lab8;
}
break golab7;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
golab9: while(true)
{
lab10: {
if (!(base.out_grouping(g_v, 97, 121)))
{
break lab10;
}
break golab9;
}
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
I_p2 = base.cursor;
}
base.cursor = v_1;
return true;
};
function r_shortv() {
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.out_grouping_b(g_v_WXY, 89, 121)))
{
break lab1;
}
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab1;
}
if (!(base.out_grouping_b(g_v, 97, 121)))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.out_grouping_b(g_v, 97, 121)))
{
return false;
}
if (!(base.in_grouping_b(g_v, 97, 121)))
{
return false;
}
if (base.cursor > base.limit_backward)
{
return false;
}
}
return true;
};
function r_R1() {
if (!(I_p1 <= base.cursor))
{
return false;
}
return true;
};
function r_R2() {
if (!(I_p2 <= base.cursor))
{
return false;
}
return true;
};
function r_Step_1a() {
var  among_var;
var  v_1 = base.limit - base.cursor;
lab0: {
base.ket = base.cursor;
if (base.find_among_b(a_1) == 0)
{
base.cursor = base.limit - v_1;
break lab0;
}
base.bra = base.cursor;
if (!base.slice_del())
{
return false;
}
}
base.ket = base.cursor;
among_var = base.find_among_b(a_2);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
if (!base.slice_from("ss"))
{
return false;
}
break;
case 2:
lab1: {
var  v_2 = base.limit - base.cursor;
lab2: {
{
var  c1 = base.cursor - 2;
if (c1 < base.limit_backward)
{
break lab2;
}
base.cursor = c1;
}
if (!base.slice_from("i"))
{
return false;
}
break lab1;
}
base.cursor = base.limit - v_2;
if (!base.slice_from("ie"))
{
return false;
}
}
break;
case 3:
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
golab3: while(true)
{
lab4: {
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab4;
}
break golab3;
}
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_1b() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_4);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
if (!r_R1())
{
return false;
}
if (!base.slice_from("ee"))
{
return false;
}
break;
case 2:
var  v_1 = base.limit - base.cursor;
golab0: while(true)
{
lab1: {
if (!(base.in_grouping_b(g_v, 97, 121)))
{
break lab1;
}
break golab0;
}
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
}
base.cursor = base.limit - v_1;
if (!base.slice_del())
{
return false;
}
var  v_3 = base.limit - base.cursor;
among_var = base.find_among_b(a_3);
if (among_var == 0)
{
return false;
}
base.cursor = base.limit - v_3;
switch (among_var) {
case 1:
{
var  c1 = base.cursor;
base.insert(base.cursor, base.cursor, "e");
base.cursor = c1;
}
break;
case 2:
base.ket = base.cursor;
if (base.cursor <= base.limit_backward)
{
return false;
}
base.cursor--;
base.bra = base.cursor;
if (!base.slice_del())
{
return false;
}
break;
case 3:
if (base.cursor != I_p1)
{
return false;
}
var  v_4 = base.limit - base.cursor;
if (!r_shortv())
{
return false;
}
base.cursor = base.limit - v_4;
{
var  c2 = base.cursor;
base.insert(base.cursor, base.cursor, "e");
base.cursor = c2;
}
break;
}
break;
}
return true;
};
function r_Step_1c() {
base.ket = base.cursor;
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.eq_s_b("y")))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.eq_s_b("Y")))
{
return false;
}
}
base.bra = base.cursor;
if (!(base.out_grouping_b(g_v, 97, 121)))
{
return false;
}
lab2: {
if (base.cursor > base.limit_backward)
{
break lab2;
}
return false;
}
if (!base.slice_from("i"))
{
return false;
}
return true;
};
function r_Step_2() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_5);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R1())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("tion"))
{
return false;
}
break;
case 2:
if (!base.slice_from("ence"))
{
return false;
}
break;
case 3:
if (!base.slice_from("ance"))
{
return false;
}
break;
case 4:
if (!base.slice_from("able"))
{
return false;
}
break;
case 5:
if (!base.slice_from("ent"))
{
return false;
}
break;
case 6:
if (!base.slice_from("ize"))
{
return false;
}
break;
case 7:
if (!base.slice_from("ate"))
{
return false;
}
break;
case 8:
if (!base.slice_from("al"))
{
return false;
}
break;
case 9:
if (!base.slice_from("ful"))
{
return false;
}
break;
case 10:
if (!base.slice_from("ous"))
{
return false;
}
break;
case 11:
if (!base.slice_from("ive"))
{
return false;
}
break;
case 12:
if (!base.slice_from("ble"))
{
return false;
}
break;
case 13:
if (!(base.eq_s_b("l")))
{
return false;
}
if (!base.slice_from("og"))
{
return false;
}
break;
case 14:
if (!base.slice_from("less"))
{
return false;
}
break;
case 15:
if (!(base.in_grouping_b(g_valid_LI, 99, 116)))
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_3() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_6);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R1())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("tion"))
{
return false;
}
break;
case 2:
if (!base.slice_from("ate"))
{
return false;
}
break;
case 3:
if (!base.slice_from("al"))
{
return false;
}
break;
case 4:
if (!base.slice_from("ic"))
{
return false;
}
break;
case 5:
if (!base.slice_del())
{
return false;
}
break;
case 6:
if (!r_R2())
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_4() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_7);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
if (!r_R2())
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_del())
{
return false;
}
break;
case 2:
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!(base.eq_s_b("s")))
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!(base.eq_s_b("t")))
{
return false;
}
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_Step_5() {
var  among_var;
base.ket = base.cursor;
among_var = base.find_among_b(a_8);
if (among_var == 0)
{
return false;
}
base.bra = base.cursor;
switch (among_var) {
case 1:
lab0: {
var  v_1 = base.limit - base.cursor;
lab1: {
if (!r_R2())
{
break lab1;
}
break lab0;
}
base.cursor = base.limit - v_1;
if (!r_R1())
{
return false;
}
{
var  v_2 = base.limit - base.cursor;
lab2: {
if (!r_shortv())
{
break lab2;
}
return false;
}
base.cursor = base.limit - v_2;
}
}
if (!base.slice_del())
{
return false;
}
break;
case 2:
if (!r_R2())
{
return false;
}
if (!(base.eq_s_b("l")))
{
return false;
}
if (!base.slice_del())
{
return false;
}
break;
}
return true;
};
function r_exception2() {
base.ket = base.cursor;
if (base.find_among_b(a_9) == 0)
{
return false;
}
base.bra = base.cursor;
if (base.cursor > base.limit_backward)
{
return false;
}
return true;
};
function r_exception1() {
var  among_var;
base.bra = base.cursor;
among_var = base.find_among(a_10);
if (among_var == 0)
{
return false;
}
base.ket = base.cursor;
if (base.cursor < base.limit)
{
return false;
}
switch (among_var) {
case 1:
if (!base.slice_from("ski"))
{
return false;
}
break;
case 2:
if (!base.slice_from("sky"))
{
return false;
}
break;
case 3:
if (!base.slice_from("die"))
{
return false;
}
break;
case 4:
if (!base.slice_from("lie"))
{
return false;
}
break;
case 5:
if (!base.slice_from("tie"))
{
return false;
}
break;
case 6:
if (!base.slice_from("idl"))
{
return false;
}
break;
case 7:
if (!base.slice_from("gentl"))
{
return false;
}
break;
case 8:
if (!base.slice_from("ugli"))
{
return false;
}
break;
case 9:
if (!base.slice_from("earli"))
{
return false;
}
break;
case 10:
if (!base.slice_from("onli"))
{
return false;
}
break;
case 11:
if (!base.slice_from("singl"))
{
return false;
}
break;
}
return true;
};
function r_postlude() {
if (!B_Y_found)
{
return false;
}
while(true)
{
var  v_1 = base.cursor;
lab0: {
golab1: while(true)
{
var  v_2 = base.cursor;
lab2: {
base.bra = base.cursor;
if (!(base.eq_s("Y")))
{
break lab2;
}
base.ket = base.cursor;
base.cursor = v_2;
break golab1;
}
base.cursor = v_2;
if (base.cursor >= base.limit)
{
break lab0;
}
base.cursor++;
}
if (!base.slice_from("y"))
{
return false;
}
continue;
}
base.cursor = v_1;
break;
}
return true;
};
this.stem =  function() {
lab0: {
var  v_1 = base.cursor;
lab1: {
if (!r_exception1())
{
break lab1;
}
break lab0;
}
base.cursor = v_1;
lab2: {
{
var  v_2 = base.cursor;
lab3: {
{
var  c1 = base.cursor + 3;
if (c1 > base.limit)
{
break lab3;
}
base.cursor = c1;
}
break lab2;
}
base.cursor = v_2;
}
break lab0;
}
base.cursor = v_1;
r_prelude();
r_mark_regions();
base.limit_backward = base.cursor; base.cursor = base.limit;
var  v_5 = base.limit - base.cursor;
r_Step_1a();
base.cursor = base.limit - v_5;
lab4: {
var  v_6 = base.limit - base.cursor;
lab5: {
if (!r_exception2())
{
break lab5;
}
break lab4;
}
base.cursor = base.limit - v_6;
var  v_7 = base.limit - base.cursor;
r_Step_1b();
base.cursor = base.limit - v_7;
var  v_8 = base.limit - base.cursor;
r_Step_1c();
base.cursor = base.limit - v_8;
var  v_9 = base.limit - base.cursor;
r_Step_2();
base.cursor = base.limit - v_9;
var  v_10 = base.limit - base.cursor;
r_Step_3();
base.cursor = base.limit - v_10;
var  v_11 = base.limit - base.cursor;
r_Step_4();
base.cursor = base.limit - v_11;
var  v_12 = base.limit - base.cursor;
r_Step_5();
base.cursor = base.limit - v_12;
}
base.cursor = base.limit_backward;
var  v_13 = base.cursor;
r_postlude();
base.cursor = v_13;
}
return true;
};
this['stemWord'] = function(word) {
base.setCurrent(word);
this.stem();
return base.getCurrent();
};
};
return new EnglishStemmer();
}
wh.search_stemmer = Snowball();
wh.search_baseNameList = [
 "manual.html",
 "intro.html",
 "install.html",
 "distribution.html",
 "alternatives_to_command_line.html",
 "xxe_addon_alternative.html",
 "w2x_servlet.html",
 "getting_started.html",
 "check_outline_levels.html",
 "going_further.html",
 "stock_xed_scripts.html",
 "customize.html",
 "customizing_semantic_xml.html",
 "generating_custom_xml.html",
 "w2x_plugin.html",
 "w2x_command.html",
 "option_p_variables.html",
 "default_steps.html",
 "automatic_params.html",
 "step_reference.html",
 "delete_files_step.html",
 "edit_step.html",
 "epub_step.html",
 "load_step.html",
 "save_step.html",
 "split_step.html",
 "transform_step.html",
 "webhelp_step.html",
 "embed.html",
 "extension_points.html",
 "limitations.html",
 "about_tab_stops.html",
 "automatic_index.html"
];
wh.search_titleList = [
 "XMLmind Word To XML Manual",
 "1 Introduction",
 "2 Installing w2x",
 "2.1 Contents of the installation directory",
 "3 Alternatives to using the w2x command-line utility",
 "3.2 The “Word To XML” add-on for XMLmind XML Editor",
 "3.3 The “Word To XML” servlet",
 "4 Getting started with w2x",
 "4.1 How to generate useful multi-page HTML",
 "5 Going further with w2x",
 "5.1 Stock XED scripts",
 "6 Customizing the output of w2x",
 "6.2 Customizing the semantic XML files generated by w2x",
 "6.3 Generating XML conforming to a custom schema",
 "6.4 Packaging your customization as a w2x plugin",
 "7 The w2x command-line utility",
 "7.1 Variables substituted in the parameter values passed to the –p and –pu options",
 "7.2 Default conversion steps",
 "7.3 Automatic conversion step parameters",
 "8 Conversion step reference",
 "8.2 Delete files step",
 "8.3 Edit step",
 "8.4 EPUB step",
 "8.5 Load step",
 "8.6 Save step",
 "8.7 Split step",
 "8.8 Transform step",
 "8.9 Web Help step",
 "9 Embedding w2x in a Java™ application",
 "9.1 Extension points",
 "10 Limitations and implementation specificities",
 "10.1 About tab stops",
 "Index"
];
wh.search_wordMap= {
"german": [[19,30]],
"don\'t": [2,31],
"upload": [6],
"zipstep.java": [14],
"ready-to-deploy": [6],
"your": [2,[6,13],1,[0,8,14,15,29]],
"elimin": [12],
"without": [[10,14,15,16,19,29]],
"these": [21,10,6,[3,12,27],[9,11,13,14,19,22,25,30,31]],
"remove-styles.x": [21],
"image_convers": [29],
"would": [12,[19,30]],
"mathemat": [21],
"my.xml": [14],
"xml": [5,6,[0,3,21],15,26,[1,19],[7,12,14],[2,10,13,16,23,28,30],[9,17,24,25,29,31,32]],
"tei": [30],
"manual.dita": [7],
"i.e": [30],
"solid": [11],
"thus": [[20,25]],
"wordtoxml.app": [2,[3,14,15]],
"cdn": [21],
"click": [[5,6],2],
"befor": [10,11,19,[1,5,26,30]],
"single-top": [[26,32]],
"util": [3,[0,4,7,15,28],[6,14]],
"size": [[6,21,22]],
"sub-subsect": [7],
"left": [25,[7,11,30]],
"wh-layout": [27],
"much": [7,1,9],
"besid": [11],
"object": [19,30],
"chapter": [26,[7,9,12]],
"inlines.big-el": [21,32],
"role": [13],
"turn": [[7,19,21]],
"suffici": [6],
"edit.inlines.tt-el": [21],
"x-small": [21],
"result": [21,6,[9,11,17,19,20,22,23,24,25,26]],
"convert.resource-directori": [19],
"same": [25,[19,21],29,[14,15,24,26],[2,6,9,11,12,22,27]],
"checkbox": [5],
"jpeg": [29,19,[22,30]],
"after": [10,[11,12],[19,26]],
"quiet": [19],
"transform.topic-typ": [16,[7,15]],
"editstep": [28,29],
"rebuild": [6],
"verbos": [9,15],
"the": [21,26,12,6,19,11,9,25,2,14,[3,29],22,0,16,15,[7,30],5,[10,24],[17,27],[13,18],[1,8,28],20,31,[4,23]],
"title.x": [21],
"imag": [29,19,[0,22],[14,15]],
"wrap": [21,30],
"standard": [21,29,6,[0,30]],
"callout": [26],
"remove-pis.except": [[21,32]],
"correct": [30],
"good": [8],
"deploy": [6,1],
"pad": [11],
"exceed": [22],
"implement": [29,[14,30],1,[0,3,6,9,11,12,15]],
"tip": [[8,12,25]],
"webhelp.add-index": [32],
"options_url_or_fil": [15],
"export": [14],
"check": [[2,8]],
"list": [21,19,[0,1,2,7,9,12,15,25]],
"inlines.u-el": [21,32],
"v5.1": [26,[7,15,32]],
"resolut": [29],
"success": [6],
"topic.xslt": [12,26,[13,15]],
"inlines.generate-big-smal": [[21,32]],
"fr-fr": [30],
"captions.x": [21],
"child": [21],
"soffic": [29],
"fortun": [[12,21]],
"ensur": [21],
"minim": [30],
"padding-left": [30],
"jetti": [6],
"primari": [30],
"margin-left": [11],
"xsl": [12,26,13,30],
"determin": [19,30,[15,22]],
"lower-level": [28],
"root": [[22,26,27]],
"combin": [11,[0,16]],
"thread-saf": [29],
"discard-index-term": [[26,32]],
"cjk": [32],
"perform": [21,29],
"w2x.bat": [3],
"map.xslt": [26],
"better": [30,29],
"with": [21,19,[12,16],14,[0,3,29],[6,7,8,10,30],[1,5,9,13,18,23,25,26,27]],
"pdf": [[1,3]],
"certif": [2],
"there": [[12,21],[6,9]],
"well": [[6,12,14]],
"syntax": [[12,29],[6,10,21]],
"personnel": [6],
"edit.ids.generate-section-id": [21],
"empti": [21,19,26,[3,7,12,16,25]],
"cover-image-url-or-fil": [[22,32]],
"catalog": [[3,12,17,21]],
"w2x-app.jstart": [3],
"desir": [9,[6,11,12]],
"emul": [6,31,21,22],
"variabl": [21,[16,29],14,15,[0,6,30,32]],
"block": [11],
"per": [[12,21,28,29]],
"write": [12,1,13],
"convert-to": [29],
"flow": [21],
"order": [9,21,[2,6],[1,3,5,8,11,12,13,15,25,29]],
"e.g": [21,[19,25],[10,14],[1,8],[6,9,12,15,24]],
"proceed": [5],
"xvf": [6],
"integ": [21,[8,25]],
"intel": [2],
"fr-ca": [19,22],
"out_spec": [15,2],
"set-vari": [11],
"xed-url-or-fil": [[9,21,32]],
"regexp": [21],
"subtitl": [[22,27]],
"save": [24,25,[9,15,19,26],[0,11,18,28,32]],
"toc": [[22,26,27]],
"restrict": [21],
"matter": [26,27],
"articl": [[6,26]],
"manual.xml": [7,9],
"top": [7],
"too": [[12,21,25]],
"have": [21,12,30,2,[6,14],29,[7,8,10,11,13,18,19,25,26],[9,15,17,20,22,27]],
"role-xref": [13],
"printenv": [15,[2,32]],
"avail": [[3,5,29]],
"product": [[24,25]],
"programlist": [12,11],
"asian": [30,[19,32]],
"calibri": [11],
"charact": [21,12,[19,24,30],[6,29],[0,14,16,25]],
"instanc": [28,29,15],
"instal": [2,5,0,[1,3,6,14],15],
"almost": [[5,21]],
"pleas": [6,[5,21,26],[7,19,25,28]],
"index.x": [21],
"whether": [21,[11,25],[14,22,24,27,30]],
"w2x_all.jar": [3],
"function": [11,6],
"stock": [12,[13,21],[10,14,29],[0,6,15]],
"book-sect1": [26],
"thread-safeti": [[28,29]],
"deletefilesstep": [29],
"less": [[1,8,25]],
"absolut": [[26,29],21,15,16,[12,14,17,19,22]],
"translat": [30,[10,21,25]],
"uniqu": [[21,22]],
"were": [[7,14]],
"tertiari": [30],
"inlines.small-el": [21,32],
"basic": [7],
"w2x.war": [6],
"disabl": [[22,31]],
"manual_docbook5": [6],
"finish-styles.css-uri": [21,[10,32]],
"tiff": [29,30],
"footer": [30],
"saxon": [3],
"shorthand": [[9,14]],
"respons": [6],
"style_spec": [12,21],
"design": [1],
"transform.root-topic-id": [7],
"command-lin": [[3,9],[0,4,6,7,12,14,15],[13,16,28]],
"unpack": [6],
"lang": [19,30,26],
"lookup-length": [11],
"xhtml_to_foo.xsl": [13],
"multi-pag": [15,[6,8],[0,7,21,25]],
"omit-toc-root": [32,[22,27]],
"css": [11,21,0,[7,9],[10,15],[1,12,30],[22,26,31]],
"enhanc": [3],
"quoted_attribute_valu": [12,21],
"imageconverterfactories.regist": [29],
"let": [21,[6,12,13,14,16,25]],
"onlin": [[3,4]],
"element": [21,26,12,19,11,[13,30],[7,24,25,31]],
"frameset": [[7,25],8,32,[6,15,21]],
"want": [12,2,[21,31],[1,7,9,14,29]],
"png": [29,19,[22,30]],
"shortdesc": [26],
"edit.inlines.small-el": [21],
"end-of-sect": [30],
"processor": [28,9,[0,1,2]],
"each": [8,[19,25],21],
"javascript": [[21,22,31]],
"role-field": [30],
"pno": [15,16],
"input": [26,15,6,[19,29],21,[9,16,20,22,25],[0,13,14,17,23,24,27,28,30]],
"init-styl": [10],
"com.xmlmind.w2x.processor.processor": [29],
"file.separ": [16],
"must": [6,22,[9,13,16,21,29,30]],
"pnx": [16],
"suppli": [6],
"myborders.x": [10],
"document": [19,[9,21],26,15,30,11,1,[22,27],[3,6,8,23,25],10,[7,18,24]],
"zip.out-fil": [14],
"two": [21,[3,10,12,19,28,30]],
"user-defin": [21],
"anyway": [21],
"semant": [21,12,[0,1,9,13],[3,7,10,14,31],[6,8,15,22,25,27]],
"found": [29,[7,11,21],3,9,[0,2,4,5,6,8,10,14,15,25,28]],
"get-styl": [11],
"anoth": [[6,16,21]],
"graphic": [29,3,4,[0,5]],
"resourc": [19,[2,3,14,15]],
"latest": [[5,6]],
"think": [30],
"docbook5": [9,15,[6,7,26],12],
"role-footnote-ref": [13],
"high-level": [28],
"docx": [6,[15,19,30],[5,9],[1,8,16],[0,14,21,29],[3,7,13,17]],
"break-column": [30],
"blocks.x": [21,12],
"quit": [12],
"polish": [[9,10,21]],
"chart": [30],
"definit": [29,12],
"lib": [6,3],
"lists.x": [21],
"tiff.png": [29],
"prepar": [[10,21]],
"align": [[21,31]],
"frameset_strict": [15],
"set-attribut": [12],
"split-before-level": [25,8,32],
"structur": [26,1],
"index.html": [27,3],
"has": [[2,11],[6,12],[1,3,5,14,15,19,22,25,27,29]],
"keyword": [12],
"converted.zip": [6],
"actual": [[2,30]],
"given": [21,30,25,[10,12,19]],
"pre": [12,21,26,11],
"last": [[14,18]],
"web.xml": [6],
"batch": [15,[2,32]],
"develop": [15,[6,12]],
"xmlresolver.jar": [3],
"bookmark": [[19,25]],
"warn": [30],
"easiest": [21],
"inlin": [21,11],
"low-level": [28,3],
"page": [25,[22,30],27,[6,7,8]],
"doctyp": [19,[23,26]],
"full": [16,[6,10]],
"becaus": [[1,11,12],21,[6,9,15,19,22,29,30,31]],
"concept": [[16,26]],
"column-numb": [19],
"white-spac": [11],
"init-styles.x": [11,[10,21]],
"edit.do.bord": [10],
"xmlns": [12],
"precis": [1],
"snowbal": [3],
"w2x.jar": [3],
"begin-sdt": [30],
"clariti": [[19,20,21,22,24,25,26,27]],
"yes": [26,21,27,19,[14,25],[7,22],[15,24,28,31]],
"center": [26],
"start": [[19,21],[2,3,8,12,25,30],[0,5,7,13,14,16,18,23,26,27]],
"equal": [21,[7,8,20,25]],
"headless": [29],
"intenserefer": [21],
"chang": [30,[1,6]],
"anywher": [14,2],
"short": [10,[0,1,2,3,6,14,21,26]],
"lower-case-resource-nam": [[19,32]],
"time": [2,[8,9,15,25]],
"combobox": [30,[6,14]],
"pub": [15],
"compris": [[14,22]],
"program": [[12,21,29]],
"c-placeholdertext": [30],
"three": [6],
"caucho": [6],
"unsolv": [12],
"borderless": [21,31],
"metafil": [29],
"conv_manual.bat": [3],
"applic": [[2,6],[0,3,4],[1,28],[5,14,19]],
"patch_manual_restyled.x": [11],
"preced": [16],
"role-section2": [[13,21]],
"quot": [29,21],
"role-section1": [13],
"engin": [3,21],
"tabl": [26,21,8,[7,25,31],19,[5,30]],
"processcommonattribut": [[12,26]],
"unzip": [2],
"x-mlmind": [[6,12,21]],
"smart": [30],
"openjdk": [2],
"manual.css": [11,10],
"editor": [5,[0,3,32]],
"manual.epub": [7,[6,8]],
"zip.w2x_plugin": [14],
"mmmm": [30],
"char": [21],
"margin-bottom": [11],
"clip": [30],
"personnam": [30],
"small": [21],
"www.w3": [12],
"remove-pi": [10],
"convert.set-column-numb": [[7,15]],
"uuid": [22],
"major": [6],
"titl": [21,12,[22,27]],
"inspir": [15],
"group": [12,21,14],
"external_image_convers": [29],
"suppos": [[6,12,14,16,25]],
"eastasia": [[19,30]],
"format": [32,29,3,15,[6,9,21,26],[12,14,19],[0,1,7,8,22,30,31]],
"done": [12,[13,28]],
"w2x_plugin": [14,32],
"webapps-javae": [6],
"abbrev": [12],
"launcher": [3],
"param-nam": [6],
"request": [6,0],
"media-alt": [[26,32]],
"procedur": [6],
"finish-styles.mathjax": [[21,32]],
"part": [[8,14],[5,21,26]],
"processstep.process": [29],
"generat": [[21,26],19,7,25,[11,12],22,[0,30],[3,6,8,27],[1,9,13,31],[5,10,14,18,20,28]],
"their": [[1,9,14,21,29]],
"point": [[21,29],[0,6,9,19,22,23,26,27]],
"general": [12,2,[6,21],[0,19,26,29,31]],
"east": [[19,30,32]],
"transform.cals-t": [[7,26]],
"style_pattern": [12,21],
"browser": [[6,21,29],[7,18,19,22,31]],
"title.subtitle-style-nam": [21,32],
"easi": [[7,11,25]],
"facil": [21],
"process": [21,28,[6,9,10,13,14,31]],
"temp": [25,29,14],
"debug": [9],
"wbmp.png": [15],
"attribut": [21,12,19,[26,30],11,13],
"clear": [[11,12]],
"clean": [[1,7],[12,17]],
"fully_qualified_java_class_nam": [29],
"chive": [6],
"single-pag": [15,21],
"build": [[2,28],14],
"mean": [29,12,[21,30],[2,8,9,14,15,16,19,25]],
"ms-cp-lastmodifiedbi": [30],
"topic-typ": [26,[15,32]],
"further": [[0,9,12]],
"semi-colon": [14],
"account": [6],
"number-footnot": [10,26,32],
"processor.parametermap.put": [28],
"been": [[2,12,18],[1,3,11,14,15,17,25]],
"taho": [2],
"part-sect1": [26],
"servlet": [6,0,32],
"ident": [[5,9,10,21,28]],
"japanes": [19,30],
"addit": [12,[21,30]],
"subdirectori": [3,[14,26],[6,12,17,21]],
"path": [19,26,[2,16,20,22,24,25,29],[14,15,21],6],
"strict": [15,[1,7,10,19,26,32]],
"abbr": [12],
"you": [2,21,12,6,[1,9,30],[7,14,29,31],[3,8,13,19,25,26]],
"happen": [[7,30]],
"transform.xslt-url-or-fil": [9,15],
"d0e35": [21],
"sequoia": [2],
"pass": [[9,16],13,[10,12,21,26,31],[0,19,25,27,28]],
"add-rul": [11],
"xhtml_strict.xslt": [26],
"bill": [30],
"especi": [21],
"cours": [18,[1,7,11,30]],
"configur": [[6,28],[0,21]],
"nativ": [21],
"for-each": [[11,12]],
"mathjax": [21,32],
"descript": [26,21,14,[16,19],[20,22,24,25,27]],
"organ": [10],
"depict": [9],
"zip_step.jar": [[3,14]],
"jpeg.png.jpg.png.png.jpg.png.jpeg.tif.jpg.tif.jpeg": [15],
"consecut": [21,12,[9,10,31]],
"how": [0,1,[13,15],[4,8,21,29]],
"snowball.jar": [3],
"index.index-term-separ": [[21,32]],
"setup.ex": [2],
"com.xmlmind.w2x.processor.transformstep": [15],
"term": [26,[12,21]],
"server-sid": [6,1],
"leblanc": [0],
"convert.default-lang": [19,30],
"counter-incr": [11],
"right": [[2,30]],
"quotechar": [21],
"end-sdt": [30],
"insid": [[14,24,25,26]],
"answer": [11],
"tif.png.tiff.jpg.tiff.jpeg.tiff.png.wbmp.jpg.wbmp.jpeg": [15],
"maximum": [21],
"wizard": [26],
"inch": [29],
"manual.ditamap": [7],
"dir": [2],
"div": [13,[12,26],21],
"habit": [1],
"plugin.multifileoutput": [14],
"legal": [3,2],
"before-save.x": [[9,21]],
"signal": [30],
"info": [30],
"brows": [[7,25]],
"hyperlink": [26],
"test": [10,[15,23]],
"p-subtitl": [21],
"remove-rul": [11],
"out.xhtml": [23],
"take": [6],
"schemas-microsoft-com": [30],
"final": [9],
"system.exit": [28],
"excerpt": [[10,11]],
"some": [[11,21,26],[6,14,15,22,31]],
"blank": [30],
"rather": [21,11,0],
"back": [26],
"root-topic-id": [[26,32]],
"miss": [[21,25]],
"solv": [12],
"load": [23,[9,15],21,[0,14,26,32]],
"p-head": [11],
"selector": [11],
"just": [14,[19,25,29,30]],
"pixel": [22],
"asid": [[14,21]],
"htm": [18],
"metas.keep": [21,32],
"dll": [6],
"custom": [11,12,0,[10,13,21],29,14,[1,3,9],15],
"length": [21],
"font-famili": [11,30],
"monitor": [28],
"home": [14],
"print": [15,[1,2]],
"wmf_converter.jar": [3],
"role-not": [12],
"interpret": [30],
"www.xmlmind.com": [0],
"out-fil": [25,[9,15,18,22,24,26,32]],
"build.xml": [[6,28],14],
"relat": [26,21,30,[15,22],14,[19,20,24,25]],
"append": [11,[0,6,19,21,25]],
"dmg": [2,[3,14,15]],
"explain": [12,[0,1,4,7]],
"smarttag": [30],
"convers": [21,9,6,[12,29],[0,14,15],18,[13,17,28],[3,19,30]],
"visibl": [21,9],
"cambria": [30],
"convert": [21,29,12,26,19,[7,9],6,[0,15,30],13,1,[3,11,14],[10,28,31],[8,17,18,25,32]],
"ignor": [[21,26],2,20],
"attempt": [19,[6,23]],
"assembl": [26,[7,15],32],
"text": [21,30,12,19,[6,11],[3,7,14,15,26,31]],
"creat": [21,[8,25],12,[11,14,26,28],19,[6,7,10,13],[1,5,17,20,23,24,27,29]],
"made": [19,[7,9,25]],
"web-inf": [6],
"maco": [[2,14]],
"field": [30,6,14],
"singl": [29,[14,21,22,27],[1,6,12]],
"invalid": [[19,26,30]],
"doc": [28,3,[9,12,16],11,7,2],
"doe": [[1,12,26,30],[6,7,27]],
"xslt-url-or-fil": [[9,15,26,32]],
"w2x": [21,9,[2,7],3,0,14,15,12,11,[1,6,30],[17,19,26],28,13,8,[4,16,18,29,31],[10,23,25]],
"infil": [28],
"java_image_convers": [29],
"java_class_nam": [15],
"server": [2],
"xhtml_loos": [[6,7,15,26]],
"don": [30],
"simple_spec": [21],
"logo.wmf": [29],
"paramet": [32,21,[19,26],27,[9,15,25],[6,12,22,29],[10,16,18],[11,30],[0,8,20,24],[7,14,23,28]],
"glob": [20],
"dot": [29],
"skip": [26],
"unfortun": [30],
"overrid": [[12,29]],
"savestep": [28,29],
"mac": [2,[3,14,15,29]],
"deriv": [[9,15,29]],
"style-count": [11],
"file": [[19,26],15,14,6,29,21,[9,25],16,[0,11],28,20,[7,24,30],[3,22],[1,12],[2,5,27,32],[13,17,23,31],10],
"anatomi": [[0,9,14]],
"pnxi": [16],
"dpi": [29],
"legal.txt": [3],
"map": [26,[7,21],[6,12,15,16,20,32]],
"may": [21,[14,29],11,[6,10,15],[9,16,19,24,25,26,30]],
"webhelp.wh-collapse-toc": [27],
"bookmap.xslt": [26,15],
"menu": [5],
"uri": [26,21],
"url": [21,16,[6,12,15,17,22],[19,26,29]],
"urn": [30,[6,12,21,22]],
"widest": [1],
"a-za-z": [19],
"probabl": [5],
"topic-path": [26,32],
"transformstep": [29],
"mail": [[0,30]],
"docbook.xslt": [26,[12,13]],
"use": [21,26,3,29,15,[2,19],[6,12,30],11,[0,7,14],9,1,[4,8,10,25],[20,22,28,31],[5,13,17,23,27]],
"main": [19,[1,10,21],[15,22,23]],
"subtlerefer": [21],
"w2x_plugin_path": [14,32],
"title.subtitle-contain": [21,32],
"convent": [10],
"home-mad": [3],
"strip": [12],
"conveni": [[7,25]],
"fine": [[6,12]],
"find": [[12,14]],
"host": [6,1],
"logo": [29],
"utf": [[7,15,19],[6,24],[3,14,18,21,27,29]],
"end-smarttag": [30],
"sort": [30],
"manual.docx": [7,11,[8,9],6],
"trash": [2],
"guarante": [21],
"servic": [6],
"forget": [[12,19,21,25,26]],
"task": [26,7,29],
"null": [28],
"cleanup": [[14,15,20]],
"transit": [21,19,[9,10,13,15],[7,14,26,32]],
"true": [25,19,24,14],
"com.xmlmind.w2x_ext.emf2png.emf2png": [29,15],
"header": [30],
"add-on": [5,0,32],
"style-with-class": [[26,32]],
"xhtml_loose.xslt": [26],
"xxe.jstart": [3],
"best": [[6,8]],
"phonet": [30],
"transform": [[9,26],15,[12,13],21,[0,14,18,20,32]],
"execut": [9,13,[2,10,28,29],[11,12,15,16]],
"dtd": [[23,26],19],
"ids.section-id-max-length": [[21,32]],
"make": [21,6,[2,7,11,16,25,26]],
"set-lang": [19,32],
"abov": [12,[9,11],21,[7,14,29],[0,6,10,15,16,17,26,28]],
"thread": [28],
"outfil": [28],
"manual_restyled.html": [11],
"due": [19],
"conform": [13,[0,22]],
"expand-tab": [10],
"underlin": [11],
"wordart": [30],
"merg": [12],
"migrat": [6],
"curl": [6,32],
"inform": [[3,11,14,21,22,30]],
"depend": [[6,9,26,28]],
"form-data": [[6,32]],
"about": [[2,3,6,19,29,32],[0,7,9,11,12,14,21,22,28,30,31]],
"bookmap": [26,15,7,[6,12,20,21,32]],
"yyyi": [30],
"xslt_url_or_fil": [15,13],
"cover": [22,30],
"param_nam": [15],
"unoconv": [29],
"meaning": [21],
"section-depth": [26,[7,32]],
"text-align": [26],
"august": [30],
"edit.do.expand-tab": [31],
"shortdesc-class-nam": [[26,32]],
"add-index": [26,[27,32]],
"wmf2svg.jar": [3],
"in_docx_filen": [15,2],
"meta": [21,19,30,7],
"declar": [19,[7,29]],
"except": [30,[12,15,25]],
"us-id-as-filenam": [32],
"programm": [9],
"libreoffic": [29],
"fact": [9,[12,29]],
"split.split-before-level": [[8,25]],
"global": [21,22],
"long": [[6,19]],
"bmp.jpg.bmp.jpeg.bmp.png.gif.jpg.gif.jpeg.gif.png": [15],
"bewar": [6],
"into": [21,12,[25,27],[7,8,9,10,22]],
"com.xmlmind.w2x_ext.wmf_converter.wmfconverterfactori": [29,15],
"unless": [18,[12,21,25]],
"pre-element-nam": [26,32],
"defin": [21,10,6,[12,16,17]],
"free": [27],
"mix": [[2,30]],
"convert-tabs.unwrap-paragraph": [[21,32]],
"redirect": [21],
"plug-in": [[3,14]],
"notes.x": [12],
"though": [[6,9,21]],
"appendix-sect1": [26],
"script_nam": [10],
"non-mod": [5],
"progress": [28],
"oper": [[6,11,30]],
"open": [2,30,[1,5,6,12,27]],
"converted-image-extens": [19,32],
"treat": [7],
"com.xmlmind.w2x.processor.editstep": [15],
"prepend": [19],
"project": [30],
"whatev": [[9,30]],
"webhelp.wh-layout": [14],
"sever": [[6,12,19,25],[22,27]],
"loos": [19],
"c-footnoterefer": [11],
"evalu": [7,5],
"enclos": [30],
"invers": [[11,21]],
"expand-tabs.j": [[22,31]],
"look": [7,[1,9,13]],
"repres": [[2,21]],
"omml2mml.xsl": [30],
"expand-tabs.x": [10],
"loadstep": [29],
"internet": [2],
"allow": [11,21,1,[3,8,12,18,19,22,25,26,31]],
"processing-instruct": [21,19],
"control_id": [30],
"binari": [6],
"edit.after.bord": [10],
"proper": [[1,2,9]],
"rule": [11],
"detect": [30,19],
"everi": [9],
"mml": [19],
"w2x_rt.jar": [3],
"common": [21,12],
"appli": [9,[10,21,29]],
"edit2": [15],
"linux": [2,[14,19,29]],
"parameter_nam": [[10,29]],
"p-note": [12],
"emf.png.wmf.png": [29,15],
"xhtml_element_qnam": [21],
"writabl": [6],
"layout": [30],
"registri": [32],
"edit.after.block": [12],
"manual-n.xhtml": [8],
"processor.steplist.add": [28],
"step": [15,9,21,0,18,[13,14,32],[12,25],[20,26],[17,19,23],[10,11,22,27,29],[24,30],[3,28]],
"comment": [[14,30]],
"p-placehold": [21],
"mark": [21],
"base": [[3,19,21]],
"stem": [3],
"intermedi": [21,20],
"plugin.nam": [14],
"prefix": [21,19,12,[25,26],[9,10,11,17,20,22,24,27,30]],
"role-index-term": [26,13],
"find-rul": [11],
"whole": [21],
"xmlmind.com": [0],
"add-class": [11],
"consist": [17],
"grammar": [30],
"rambouillet": [0],
"convert.xhtml-fil": [9,14],
"processor.parametermap": [28],
"my.zip": [14],
"zip": [14,6,3,2],
"profession": [7],
"val": [[19,30]],
"still": [[2,9]],
"text-ind": [11],
"work": [26,[21,22],12,[6,8,14,15,20,24,25]],
"webhelp_loos": [15],
"fail": [30],
"itself": [2],
"math": [19,30,15],
"word": [6,5,[0,1],3,14,[2,7],[8,10,15,21,28,29]],
"introduction.dita": [21],
"biblio.style-nam": [[21,32]],
"requir": [[12,26],2,[1,6],[8,9,10,20,21,22,24,25]],
"report.xml": [16],
"eas": [21],
"finish-styles.x": [21,[10,11]],
"simplest": [[9,13,30]],
"p-code2": [21],
"emf.svg.wmf.svg": [29],
"loui": [0],
"abstract": [[1,9,29]],
"p-code1": [21],
"rss.xslt": [14],
"sample_plugin": [14,3],
"epub3": [6],
"cannot": [22,[1,2,19,28]],
"epub2": [6],
"epub1": [15],
"first": [[2,9],19,[6,12,15,16,18,20,21,30]],
"role-document-titl": [21],
"allow-lonely-head": [[25,32]],
"span": [30,21,12,31,19,[22,26],13],
"prefer": [2,[7,14]],
"float": [11],
"space": [21,[19,24,25]],
"spec": [21],
"simpl": [21,12,14,[6,7,24,25,28,30]],
"webhelp.wh": [32],
"webhelp2": [6],
"webhelp1": [15],
"html": [25,7,[6,19,26],[15,21],[8,11,14],[12,22],[0,18,27,31]],
"from": [[2,21],[15,30],[1,3,9,10,11,12,22,27]],
"webhelp3": [6],
"custom.css": [11],
"spell": [30],
"you\'ll": [2,[14,21]],
"bottom": [11],
"templat": [12,26,1],
"moreov": [2,[7,9,11,25]],
"fals": [25,19,[14,24]],
"p-abstract": [26],
"impli": [29],
"img": [26],
"interact": [[0,6]],
"error": [3],
"number-footnotes.x": [10],
"platform": [[2,16,19]],
"plugin.outputdescript": [14],
"webhelp.out-fil": [14],
"public": [2,0],
"array": [28],
"parameter": [[3,15]],
"input_file_extens": [29],
"track": [30],
"padding-top": [30],
"webhelp5": [14,[8,15]],
"in_docx_file1": [15,2],
"instead": [21],
"p-shortdesc": [26],
"command": [11,21,12,[2,7],[6,9,28,29]],
"set-column-numb": [[19,26,32]],
"int": [28],
"unlik": [[26,29,30]],
"stricttask": [26],
"serif": [11],
"biblio.x": [21],
"perman": [22],
"negat": [29],
"break-pag": [30],
"before-save.allow-flow": [[21,32]],
"w2x_servet": [6],
"wmfconverterfactori": [29],
"epubcheck": [19],
"sorta": [30],
"temporari": [[6,19]],
"describ": [28],
"poor": [21],
"xhtml_css": [15,[6,17]],
"double-click": [2],
"absent": [23],
"c-strong": [21],
"instruct": [5,[2,9]],
"appendix": [26],
"liststep": [15,9,[2,32]],
"concat": [11],
"url_or_fil": [15],
"version": [2,19,26,6,[7,15],[5,32],12],
"report.docx": [16],
"plugin.outputextens": [14],
"folder": [2,6,19],
"stop": [31,21,[22,30],[0,32]],
"detail": [9],
"convert-tabs.to-t": [[21,32]],
"least": [6],
"manual": [28,7,3,[9,12],11,[8,21],[0,2,6,30]],
"title.title-contain": [21,32],
"wlang": [[19,30]],
"machin": [1],
"behavior": [[21,25]],
"webhelp": [7,[6,8,15,27]],
"learn": [[6,9,13,15]],
"abl": [3],
"invok": [21,[10,11,12,14,28]],
"doc_fil": [29,19],
"role-sect": [26,21],
"chapter-sect1": [26],
"basenam": [25,[14,29],[10,15,19,21]],
"possibly_quoted_parameter_valu": [29],
"specif": [21,29,[1,12],30,[0,14,22,27]],
"act": [26,7],
"use-id-as-filenam": [25],
"post": [[6,32]],
"p-programlist": [12,11,[10,21]],
"rel": [11],
"sampl": [21,[3,28]],
"http-equiv": [[7,19]],
"add": [26,15,19,[11,21],[5,17,24,25]],
"need": [3,[2,6],[7,25],[5,8,9,11,15,19,21]],
"pose": [29],
"often": [[12,21,25]],
"equival": [21,29,30,[14,15,16,17]],
"els": [12,[25,28]],
"article-sect1": [26],
"respect": [21],
"rfc": [22],
"manual-toc.xhtml": [7],
"referenc": [[2,6,14,19,21]],
"port": [6,1],
"altern": [[0,4,14,21]],
"http": [[6,12]],
"tomcat_install_dir": [6],
"emb": [28,19,[0,1]],
"title-styled.x": [10],
"emf": [29,30],
"prevent": [[22,27]],
"softwar": [6,[0,1],[5,28]],
"end": [[12,26,30],[11,19,21]],
"docbook": [26,12,7,21,32,15,[1,6,9,10,19,30,31]],
"footnot": [26],
"modifi": [[11,16],29,[0,9,21]],
"transform.out-fil": [[9,15],14],
"otherwis": [[19,21],[11,15]],
"get-rul": [11],
"shafi": [[0,30]],
"label": [26,12],
"howev": [25,[1,2,5,6,12,14,19,21,22,26,29,30,31]],
"foo-toc.html": [25],
"special": [14],
"numer": [26],
"edit.xed-url-or-fil": [9,[15,17,28]],
"directori": [26,14,6,[19,25],[2,7,15,20,21],[3,22],[0,12,16,17,24,29]],
"emf2png": [29],
"smaller": [[11,21]],
"role-footnot": [13],
"tomcat": [6],
"captions.style-nam": [[21,32]],
"properti": [[11,30],[14,15,16,29]],
"number": [21,[9,26,29],11,[1,2,6,10,13,14,15,19,25,30]],
"identifi": [22,32],
"specifi": [21,26,19,25,15,[24,29],[6,11,12,20],[17,18,22,28,30],[0,8,9,27]],
"leverag": [[10,21,29]],
"jane": [15],
"invis": [21],
"similar": [[12,21]],
"shape": [30],
"in_docx_fil": [[2,15,16]],
"dcterm": [21],
"script": [10,21,[11,12],[3,9],15,[0,13],[14,22,23,30,31]],
"edit.before.finish-styl": [11,10],
"exit": [15,2],
"system": [3,[6,14,15,16,30]],
"openxml": [30,19],
"issu": [[2,26,30]],
"partial": [30],
"padding-right": [30],
"other": [21,[16,26],[7,30],[3,6,8,9,14,15,19,27,31]],
"aim": [1],
"cell": [19,21],
"local": [26],
"date_util.jar": [3],
"crude": [30],
"valid": [19,[1,9],7,[17,24,26]],
"pictur": [30,3],
"interfac": [29],
"locat": [21,[11,12,17]],
"counter-reset": [11],
"sections.x": [21],
"share": [[19,28]],
"givennam": [30],
"output-path": [26,[15,32]],
"template_topic.xslt": [12],
"output_file_basenam": [19],
"tc-tablegrid": [30],
"notic": [12,[5,21]],
"args.length": [28],
"inlines.s-el": [21,32],
"exampl": [21,[12,26,30],[14,29],[11,16,19],15,6,[8,13],[9,10,25,28],[1,2,3,20,22,23,27]],
"cite": [21],
"w2x_install_dir": [12,[11,14,28],9,10,[2,7,13],[4,22,31]],
"namespac": [12,21],
"screen": [14],
"correspond": [[11,25,30]],
"mergeformat": [30],
"mode": [[2,5]],
"jre64": [2],
"in-memori": [15],
"etc": [21,[1,27,29],[2,13,15,19,22,31]],
"resource-prefix": [[19,32]],
"all": [21,30,[3,26],[11,29],[14,15],12,[6,9,25,27,31],[0,5,7,10,13,16,22]],
"border": [10,[9,11,21]],
"new": [28,8,25],
"escap": [29],
"read": [9],
"below": [21,29,[5,9,12,14,26]],
"alt": [26],
"choos": [[6,30]],
"rememb": [26],
"real": [29],
"com.xmlmind.w2x.docx.image.imageconverterfactoryimpl": [29,15],
"programmat": [[7,25]],
"tool": [[1,3,6,13]],
"non-nest": [26],
"role-tab": [31,[22,30]],
"alreadi": [[2,12,18,19],[7,25,27]],
"vvv": [15,[2,32]],
"remove-class": [11,12],
"docbook-vers": [[26,32]],
"therefor": [[2,9],[5,11]],
"bodi": [11,26,12],
"unix": [3],
"indent": [[24,25],[17,32]],
"simpler": [10],
"p-bibliographi": [21],
"resolv": [3],
"unparsed-styl": [[11,21]],
"borders.x": [10],
"and": [21,12,6,30,[9,14],19,[2,16],26,[3,25],[0,7,11,15],[1,10,28],[8,22,29,31],[5,17,18,27]],
"xhtml-file": [19,[9,18,21,32]],
"row": [5],
"obsolet": [[7,25]],
"ani": [21,26,[2,12,19,29],[3,10,15,16],[1,6,7,8,22,25,31]],
"render": [21],
"custom_topic.xslt": [12],
"ant": [28,[6,14]],
"p-normal": [30],
"c3%": [29],
"xslt": [[12,26],9,13,[3,15],[14,21,30],17],
"reason": [1],
"font-weight": [21],
"ship": [29],
"compon": [6,[1,3]],
"java": [2,29,28,6,[3,15],[1,14],0,[9,16,30]],
"exe": [3],
"english": [30],
"jar": [[3,6,14]],
"mistak": [21],
"api": [[3,28]],
"app": [2],
"set-styl": [11],
"zipstep": [14],
"code2": [21],
"code1": [21],
"appl": [2],
"frameset_loos": [15],
"recommend": [19,[14,21,28]],
"default": [21,26,19,25,22,29,27,24,[0,6,7,8,11,14,15,17,20,28,31]],
"rss": [14,3],
"processor.steplist": [28],
"are": [21,30,26,[6,9,29],[1,3,15,19,25],[11,18,27,31],[0,5,8,10,14,16,20,24]],
"arg": [28],
"where": [11,[1,3,6,19,24,25,29]],
"popular": [1],
"arm": [2],
"get-class": [11,12],
"art": [30],
"p-term": [[12,21]],
"webhelp.use-id-as-filenam": [14],
"suppress": [[1,21]],
"nest": [[7,21,26]],
"processor.configur": [28],
"acut": [29],
"jdk": [6],
"call": [[9,13],[14,21],15,[11,28,29,30]],
"such": [21,[6,30],[12,13,22,27,29]],
"plugin": [14,[0,3],[15,32]],
"frameset3": [6],
"frameset2": [6],
"frameset1": [15],
"ask": [[2,6]],
"principl": [2],
"rue": [0],
"enref": [19],
"run": [6,3,2,[21,28],[5,31]],
"microsoft": [1],
"worri": [2],
"webhelp.omit-toc-root": [14],
"either": [11],
"yourself": [21],
"discov": [14],
"those": [21,[19,28]],
"examin": [19,[22,30]],
"dure": [[6,14,21]],
"bold": [[12,21]],
"effici": [11],
"privat": [2],
"name": [21,26,15,[14,19],6,[9,12],[10,11,20,22,24,25,27,30],16],
"non-system": [3],
"next": [6],
"import": [5,[9,12],[8,25]],
"string": [21,19,[5,7,16,22,26,27,28]],
"color": [[11,30]],
"submit": [30],
"parse-styl": [[11,21]],
"xhtml5": [7,26,[6,15]],
"book": [22,26,7],
"non": [[0,6]],
"button": [8],
"comput": [2,21,[6,22,31]],
"not": [19,26,[21,30],12,6,[11,25,29],[1,2,7,16],[5,8,9,10,14,15,17,18,22,23,24,27,28,31]],
"finish-styles.mathjax-url": [[21,32]],
"introduct": [[0,1]],
"now": [5],
"xhtml1": [26,[6,15]],
"webhelp_strict": [15],
"emphasi": [21],
"was": [[19,23]],
"title.keep-titl": [21,32],
"war": [6],
"greet": [30],
"com.xmlmind.w2x.docx.image.imageconverterfactori": [29],
"way": [21,[19,25],[7,8,24,30]],
"xhtml": [21,12,15,7,19,[9,11],26,32,13,[0,1,8,10,14,22],[25,31],[3,17,18,24,27,28,30]],
"target": [[12,21]],
"what": [12,21],
"refer": [[26,29],[0,3,6,8,9,19,28]],
"colon": [29],
"window": [2,29,3,[4,6,14,16,19,24,30]],
"edit.blocks.convert-to-pr": [21],
"discard": [[12,26]],
"siames": [21],
"cals-tabl": [26,32],
"edit.inlines.b-el": [21],
"when": [21,19,[25,26,30],[12,15,16,22,31],[2,3,5,9,11,20]],
"assembly.xslt": [26],
"sequenc": [9,21,[10,29]],
"role-figcapt": [13],
"embed": [[0,11],28,1],
"zip.include-top-dir": [14],
"greater": [21,29],
"case": [12,26,[0,1,9,21,22,28,29,30,31]],
"transform.single-top": [15],
"give": [21,[9,11,14,19,22,31]],
"item": [5,21,30],
"multipl": [7,14],
"main-styled.x": [21,[10,17],[9,28]],
"p-titl": [21],
"modul": [26],
"index-sort-a": [30],
"patch_manual.x": [10,11],
"consid": [21,19,[18,29,30]],
"w2x_image_convers": [29,15],
"ids.x": [21],
"phone": [0],
"call-templ": [[12,26]],
"title.title-style-nam": [21,32],
"everyth": [3],
"style": [21,11,12,25,0,[6,15,26],[9,10,22],[1,8],[7,30],[3,13,17,19,27,31]],
"inlines.sub-el": [[21,32]],
"output_file_extens": [29],
"implicit": [12],
"hussein": [[0,30]],
"role-figur": [13],
"direct": [21,[2,11,26,28]],
"pattern": [12,[19,20],21,11],
"transform2": [15,[7,26]],
"compil": [27,[3,28],[14,32]],
"caus": [[19,21,30],[6,12,26]],
"modern": [[22,31]],
"web": [27,15,[0,3,7,8,14,18,21,29,32],[6,19,22,25,31]],
"w2x-app.ex": [3],
"older": [[6,26]],
"protect": [30],
"footnote-number-format": [[26,32]],
"more": [21,15,29,[1,11,12,16,22]],
"display": [11,5,[6,21]],
"interchang": [1],
"great": [[8,19,21,29]],
"command_lin": [29],
"usag": [[2,15]],
"width": [11,[22,31]],
"add-xml-lang": [[26,32]],
"saxon.jar": [3],
"certain": [21],
"default-lang": [[19,22,32]],
"en-us": [30],
"wh5": [14,3],
"whitespac": [[21,24,25]],
"section": [26,21,[12,30],7],
"frameset5": [15],
"simpli": [[2,7,9,11,14,21]],
"few": [[14,21]],
"codeph": [12],
"transform.shortdesc-class-nam": [26],
"kind": [21,[10,29]],
"usabl": [21],
"both": [[12,21],[10,11,14,17,30]],
"most": [2,[1,6,9,10,30]],
"resin": [6],
"transfer": [6],
"effect": [12],
"keep": [21,26,19],
"specification_list": [29],
"topic": [26,7,12,[6,15,20,21,32]],
"xhtml_strict": [[6,7,15,26]],
"whi": [[11,19,30]],
"non-empti": [19],
"c-booktitl": [21],
"shtm": [18],
"omit": [26,[19,20,21,22,24,25,27]],
"fallback": [25],
"option": [32,15,9,12,7,[6,16],21,[2,11,17,31],[0,5,10,13,28]],
"self-contain": [3],
"goback": [19],
"launchpad": [2],
"init-param": [6],
"insert": [19,[7,10,29]],
"indexterm": [30],
"toc123": [19],
"reject": [30],
"whc.jar": [3],
"messag": [3],
"convert-tabs.x": [21],
"edit.inlines.convert": [12,10],
"font-siz": [11,21],
"move": [2],
"nxo": [16],
"padding-bottom": [30],
"also": [14,[6,12,25],[1,3,5,10,11,15,21,29]],
"differ": [[2,26],[21,28]],
"consol": [3],
"wh-local-jqueri": [27],
"favor": [19,30],
"various": [30],
"archiv": [[6,14]],
"a9": [29],
"front": [26],
"w2x-support": [0],
"user": [21,[10,13,14,15,18,30],3],
"extent": [30],
"parent": [21,12,15,[16,17,29,30]],
"title-styl": [10],
"extens": [29,[11,19],[14,16],[0,7,10,15,18,32]],
"custom-styles-url-or-fil": [21,11],
"complet": [1],
"step_nam": [15,18,10],
"blocks.convert": [12,21,32],
"fix": [26],
"complex": [30],
"jre": [2],
"mkdir": [7],
"apply-templ": [[12,26]],
"w2x_math_converter_xslt": [30],
"posit": [29],
"sure": [[2,6]],
"ad": [[18,19,31],[11,22,28]],
"parametr": [15],
"reus": [28],
"inlines.convert": [[12,21],32],
"create-mathml-object": [[19,32]],
"automat": [21,19,[7,8,11],[12,18],[17,25],[0,1,2,3,5,14,15,26,27,30]],
"an": [26,21,11,[15,19,29],[12,22,25,28],[3,5,6,8,30],[0,1,2,7,9,13,17,27],[14,23]],
"subsect": [26,7],
"finder": [2],
"ar": [6],
"automatic-id": [[19,32]],
"as": [25,[19,21,26],14,[5,6,7],[22,29],[9,11,24,27,28],[0,1,2,3,10,12,13,15,18,23,30,31]],
"at": [29,26,[2,6,7,12,21,25]],
"edit.do.title-styl": [10],
"schema": [30,13,[0,1]],
"bb": [30],
"strong": [21,[14,19,28]],
"be": [21,26,29,6,[2,11,19],[3,9,12,14,22],[10,15,24,25],[1,4,8,13,16,18,20,28,30,31]],
"icon": [2],
"remove-styles.preserved-class": [21,32],
"delet": [[12,20],2,[0,11,21,32]],
"javadoc": [[3,28]],
"wmf": [29,[3,30],19],
"see": [21,29,26,32,[3,7,9,12,14,16,25,30]],
"by": [21,12,[14,19],11,[2,16],[3,28,29],[6,26],[10,15,18,30],[7,22],[0,9,13,17,25],[1,5,20,23,27,31]],
"epub": [22,6,[8,15],[7,21],[0,18,25,32]],
"franc": [0],
"cd": [[2,7]],
"blocks.convert-to-pr": [[21,32]],
"fli": [25],
"contain": [6,[21,26],[3,7],[12,15],[11,14],19,25,30,[5,22],[2,8,9,16,27,29,31]],
"set": [19,21,30,[11,14],[15,22,27,29]],
"incorrect": [[6,19,30]],
"column": [19,30],
"note_group_memb": [12],
"attribute_spec": [21],
"e2": [[15,17,32]],
"figur": [9,[4,6]],
"user-specifi": [19],
"my_script.x": [23],
"apach": [6,28],
"foo.html": [25],
"font": [21],
"dc": [21],
"dd": [12,21],
"de": [22],
"featur": [30,[7,25]],
"offic": [30],
"dl": [12,21],
"extern": [29,[0,11],[19,21]],
"forc": [2],
"do": [10,26,12,[6,21],[19,25],[1,7,13,16,24,27]],
"itlechar": [21],
"dt": [12,21],
"outlin": [[8,25],[21,32]],
"startup": [14],
"contact": [30],
"useless": [12,7],
"eb": [6],
"digit": [2],
"which": [26,21,19,12,7,[11,14],[6,9,17,29,30],[2,3,8,10,20,22,25]],
"set-rul": [11],
"signific": [[9,15,21,24,25]],
"ei": [29],
"em": [21],
"en": [19,22],
"she": [30],
"never": [30],
"multipart": [[6,32]],
"compat": [5],
"role-document-subtitl": [21],
"frame": [25,7],
"compar": [30],
"foo": [25,13,[12,16]],
"for": [12,[21,26,30],19,29,[14,22],[1,2,8],[0,5,6,7,9,20,25,27],[3,11,15,16,24,28]],
"h1": [21],
"h2": [21],
"h3": [21],
"h4": [21],
"sect2": [26],
"h5": [21],
"sect1": [26],
"content": [11,8,[0,19,25],[1,3,6,7,21],[2,14,15,30]],
"h6": [21],
"random": [[5,7]],
"sect5": [26],
"sect4": [26],
"desktop": [[2,6],[1,14]],
"sect3": [26],
"class": [26,[11,13],21,30,[12,29],[3,10,31],[9,15,22,28]],
"over": [19,30],
"someth": [[12,17,21,30]],
"go": [[0,9,12]],
"counter": [11],
"kept": [21],
"border-bottom": [11],
"form": [6,1],
"removes-styles.x": [21],
"publish": [1],
"xmlmind": [5,3,0,[2,27],[1,7,32],[10,14,15,21,28,29]],
"hierarchy-nam": [[26,32]],
"setup": [14],
"headings.x": [21],
"dc.subject": [21],
"gate": [30],
"tp-tablegrid": [30],
"p-caption": [21],
"prompt": [2],
"he": [30],
"hh": [29],
"big": [21],
"select": [6,5],
"bin": [7,2,[3,8],9,[4,15]],
"custom.c": [11],
"easili": [1,[6,12]],
"bit": [2],
"output": [32,15,14,7,[0,3,5,6,9,12,16,21,22,25,29,31],[1,11,13,17,28]],
"veri": [7,[2,9,12],[1,21,24,25,30]],
"edit.prune.preserv": [[10,12]],
"autom": [[1,28]],
"css-uri": [11],
"drag": [2],
"id": [21,12,[25,26],7],
"join": [21],
"blockquot": [21],
"literallayout": [26],
"if": [26,19,21,[7,12,29],[2,6],[18,25],[11,15,23,27,31],[3,8,9,14,17,28,30]],
"xedscript": [3],
"non-ascii": [6],
"save.out-fil": [15],
"in": [21,12,6,[9,11],[2,14,19,29],3,28,25,[0,7,30],5,[1,15,22,26],[8,16],[4,13,17,31],[10,24,27]],
"manual.xhtml": [7,9,8],
"termin": [2],
"index": [26,30,21,[0,32]],
"is": [21,19,[26,29],12,25,[15,16],30,14,[6,7,22],[2,11],[3,8,9],[1,20,28],5,[13,17,24,27,31],[4,10,18,23]],
"mathml": [19,21,30,32],
"it": [1,[14,19],6,[11,21],[9,29],[7,25,28,30],[5,12,15,20,31],[2,4,10,16,22,26]],
"workdir": [6],
"ja": [19,30],
"john": [14,[10,13],30],
"com.xmlmind.w2x.docx.imag": [29],
"paragraph": [21,12,[9,10,11],[0,1,8,25,31]],
"charset": [19,[7,18],32],
"valu": [21,[12,26,29],16,[15,19],[14,22,25,27],[0,6,8,11,20,24]],
"librari": [[3,6]],
"inlines.i-el": [21,32],
"amaz": [1],
"bm3": [19],
"attribute_nam": [12],
"ms-outlinelvl": [30],
"ko": [19,30],
"add-toc": [[26,32]],
"break": [30,[6,21]],
"themselv": [26],
"raster": [29],
"metas.x": [21],
"case-sensit": [19],
"off": [25,19,[14,21,24]],
"report": [16],
"li": [21,10],
"wmf.svg": [29,15],
"ll": [[12,21],[7,19,25,26,29]],
"expans": [22],
"lookup-styl": [11],
"auto": [[19,21]],
"lists.alternate-ordered-list-group": [[21,32]],
"bmp": [30],
"sign": [2],
"in.xhtml": [23],
"while": [[1,7,11,25]],
"suffix": [14],
"convertstep": [28],
"second": [[6,12]],
"resource-directori": [19,32],
"that": [21,[12,29],2,[19,30],16,[5,6,8,15],[1,7,14,25,26],[3,22,23,28,31]],
"download": [2,[5,6]],
"out_fil": [18,[2,15,16]],
"split": [6,25,[22,27],[0,8,18]],
"than": [21,[3,30],[11,29],[0,1,4,7,8,16,25,26]],
"limit": [[19,30],[0,11]],
"dita": [26,12,21,[7,32],15,[1,10,19,20,28,30,31]],
"entri": [30,[9,21]],
"level": [[8,21,25],32],
"author": [[1,21,22,27]],
"ms": [30],
"w2x_trace": [15],
"restyl": [1],
"my": [16,30],
"plus": [[22,27]],
"disk": [[9,15,19,24,25]],
"border-bottom-width": [11],
"ni": [[16,29]],
"edit.finish-styles.css-uri": [11,10],
"no": [26,21,14,19,[1,22,27],25,29,[15,24,30],[7,9,20,23]],
"code": [12,21,19,[3,22,31],[6,14,30],[10,28]],
"seal": [21],
"box": [5,30],
"nx": [16],
"vnd.openxmlformats-officedocument.wordprocessingml.docu": [6],
"decent": [[22,31]],
"head": [25,6,[8,21],11,[7,19]],
"dialog": [5],
"dw2x_plugin_path": [14],
"of": [21,26,19,29,6,12,11,[14,25],[9,16],30,28,[2,10],[3,15,22],[7,8],0,[1,5,17],24,[18,20],[13,23,27]],
"bundl": [2],
"possibl": [26,21,[12,31],[6,7,9,10,11,15]],
"inlines.x": [21],
"attribute_qnam": [21],
"ok": [[5,8]],
"dynam": [[6,22]],
"ol": [[10,21]],
"on": [2,6,3,29,25,[19,21],[11,14,16],[1,7,9,15,24,26,30,31]],
"macro": [[1,30]],
"suffic": [12,[11,29]],
"purpos": [[7,21]],
"technic": [29],
"or": [21,15,26,30,19,20,[14,16],[1,11],[2,6,10,12,22,29],[8,18,25,28],[13,27]],
"src": [6,[3,14]],
"control": [[29,30],0],
"title_of_this_sect": [21],
"encod": [[6,24],19,[3,7,14,21,27,32]],
"mytask": [7],
"offici": [2],
"easier": [3,4],
"pi": [[16,29]],
"mailto": [0],
"pn": [16],
"po": [14,[15,29]],
"metadata": [1],
"inlines.sup-el": [21,32],
"pu": [11,[10,16],[15,18,32],[0,9,12]],
"edit.blocks.convert": [12,[21,26]],
"finish.x": [12],
"main.x": [9,21,[13,14],[10,15]],
"environ": [14,[2,6,15,29,30,32]],
"factori": [29],
"style_nam": [12,21],
"conv_manual.sh": [3],
"manual.html": [[7,11],8],
"recent": [2],
"generaltask": [26],
"they": [18,[10,15,21]],
"edit.convert-tabs.to-t": [31],
"secondari": [30],
"webhelp.split-before-level": [[8,14]],
"after-translate.x": [9],
"edit": [21,9,[7,12,13,15],11,[0,5,10,14,28,32]],
"ms-word": [[21,30],19,8,1,25],
"them": [9,26],
"then": [[12,29],[6,9,19],[2,30],[13,23,26]],
"cleanup.fil": [14,15],
"out_file_with_an_xhtml_extens": [18],
"third-parti": [3],
"accept": [30],
"node": [11],
"includ": [2,[5,14,29]],
"ri": [29],
"ole_link": [19],
"t2": [[15,17,32]],
"minut": [6],
"sub": [21],
"access": [[11,30]],
"end-us": [6],
"languag": [19,30,22,32,3],
"sup": [21],
"workaround": [30],
"xpath": [11],
"current": [26,21,[15,22],[14,20,24,25]],
"vector": [29],
"conjunct": [19],
"sn": [30],
"email": [[0,1]],
"silent": [26],
"intern": [21,11],
"onc": [[1,14]],
"svg": [29,19,[3,30]],
"one": [21,[11,19],[12,29],[6,8,14,15,16,28,30]],
"ids.generate-section-id": [21,32],
"launch": [2],
"store": [21,[2,6,19]],
"delete-text": [12],
"stori": [6],
"outdir": [29],
"confirm": [2],
"td": [30],
"remov": [21,10,[7,11,12]],
"assist": [14],
"my.docx": [14],
"to": [21,26,6,19,12,[29,30],3,2,9,15,[7,11],0,1,[13,25],31,14,[5,8],[22,28],10,16,[20,27],[4,23],24,[17,18]],
"vast": [[19,30]],
"typic": [22],
"v4": [26],
"v5": [[9,26]],
"but": [21,[19,29],[7,11],[3,6,8,9,15]],
"webapp": [6],
"p-heading6": [11],
"tt": [21],
"p-heading5": [11],
"loader": [23,26],
"express": [19,[21,29]],
"c-code": [12,[10,21]],
"com.xmlmind.w2x.processor.convertstep": [[15,29]],
"remove-pis.x": [[10,21]],
"drawback": [1],
"w2x-app": [3,[4,14],2,5,[0,6,26,32]],
"w2": [[6,10]],
"up": [[9,10,11,12,21]],
"written": [30,19],
"p-heading2": [11],
"p-heading1": [11],
"p-heading4": [11],
"us": [12],
"p-heading3": [[11,30]],
"sections.max-level": [[21,32]],
"p-definit": [[12,21]],
"unstyl": [[1,7,9]],
"this": [21,19,25,12,[15,29],[14,22],[6,26],11,[7,9],30,[2,5,23,27,28,31],[1,3,20,24],[8,10,13],4],
"verif": [2],
"processor.process": [28],
"com.xmlmind.w2x.docx.image.externalimageconvert": [29],
"substitut": [16,0],
"opt": [15],
"extract": [1],
"vm": [2],
"hint": [[19,30]],
"support": [3,30,[12,29],[6,14,15,26],[2,17,21]],
"vs": [15],
"drop": [[2,30]],
"vv": [[9,15],[2,32]],
"edit.metas.keep": [21],
"w2x_app_help": [3],
"extractor": [6],
"we": [12,[9,30],[7,8,25]],
"wh": [27],
"prune.x": [21,12],
"param": [6],
"kit": [6],
"rss.w2x_plugin": [14],
"normal": [7],
"xed_url_or_fil": [15,13],
"org": [12],
"distribut": [2,6,[0,3,5,14,15]],
"c-abbrev": [12],
"xe": [30],
"behav": [23],
"exclude-result-prefix": [12],
"xi": [16],
"convert.create-mathml-object": [15],
"param-valu": [6],
"succeed": [6],
"redund": [12],
"embed2": [28],
"embed1": [28],
"runtim": [2,3],
"sourc": [[3,6,8],[1,30],[25,27]],
"yomi": [30],
"none": [[17,19,22]],
"type": [6,26,11,[19,21]],
"convert.set-lang": [19,30],
"problem": [12,29],
"children": [30],
"xed": [21,[11,12],9,10,[3,13,15],[14,17],[0,31],[22,23,28]],
"cross-refer": [26],
"filenam": [21,[6,22],[15,19]],
"epub.split-before-level": [[6,8]],
"conv": [6],
"href": [[11,12]],
"xhtml_element_nam": [12],
"processor.executestep": [28],
"between": [[25,30],[6,8,26]],
"stylesheet": [12,26,13,[14,30],[3,9,15],[11,21]],
"phase": [14],
"method": [28,[11,29],0],
"come": [6,[2,3,10,21,30]],
"gdi": [29],
"zh": [19,30],
"exist": [19,[1,6,7,15,21,25,26,27]],
"tembed1": [28],
"tembed2": [28],
"imageconverterfactori": [29],
"regist": [14,[0,3,29]],
"henc": [19,[10,29]],
"copi": [6,[2,3,12,14,19]],
"out": [7,9,8,11,16,[1,3]],
"inlines.tt-el": [21,32],
"get": [[0,7,15,18,19,21]],
"manual_restyled_css": [11],
"inkscap": [29],
"packag": [[0,14,22,29]],
"place": [15,[9,21]],
"semi": [29],
"leav": [12],
"regular": [19,21],
"wh-collapse-toc": [27],
"restart": [[5,6]],
"role-inline-wrapp": [21],
"bigger": [21],
"tmp.xhtml": [14],
"alway": [[12,27],[22,25,26,30]],
"readabl": [6],
"help": [27,15,3,[8,14,32],[0,4,7,18,19,21,25]],
"expect": [[19,21]],
"begin-smarttag": [30],
"c-endnoterefer": [11],
"revis": [30],
"date": [30],
"com.xmlmind.w2x.processor.processstep": [29,[9,15]],
"argument": [[16,30],14],
"whatsoev": [[9,29]],
"data": [[1,6,19]],
"own": [29,[6,9,14,15,30]],
"firefox": [21],
"separ": [21,19,[1,14,29]],
"content-typ": [12,[7,19]],
"save.ind": [28],
"tab": [31,[21,22],30,[0,5,32]],
"plain": [26,[3,14,15]],
"should": [21,8,[4,24,25,26]],
"indexlist": [26],
"tag": [30,[0,12],[1,3,9,10,21]],
"replac": [15,16,10,[5,7,12,21]],
"ja-jp": [[19,30]],
"localhost": [6],
"sens": [[1,16]],
"like": [7,11,[1,9,12,14,17,21,29]],
"onli": [21,26,19,[29,30],[2,3,11,22]],
"generate-xref-text": [[26,32]],
"sans-serif": [11],
"person": [5],
"finish-styl": [10,21],
"convert.charset": [15,7],
"ugli": [11],
"openoffic": [29],
"send": [[1,6]],
"emf.svg": [29],
"here": [[14,19,20,21,22,24,25,26,27]],
"note": [12,21,19,[7,29],[1,2,5,6,8,14,16,17,23,24,25,26,30]],
"com.xmlmind.w2x.processor.deletefilesstep": [[14,15]],
"gif": [30],
"line": [[12,21,29],[6,11,14,28]],
"noth": [12,[25,29]],
"link": [11],
"becom": [[11,19]],
"smartart": [30],
"cal": [26,[7,19]],
"can": [[1,2,8,9,21,30]],
"headings.convert": [[21,32]],
"cap": [30],
"edit.finish-styles.custom-styles-url-or-fil": [11],
"cat": [21],
"provid": [[14,21]],
"inlines.b-el": [[21,32]],
"realli": [31],
"will": [[6,21],[2,12,30],[19,23],26],
"match": [[11,12,20,21,26]],
"w2x_servlet_deployment_dir": [6],
"follow": [[11,12,21],9,[5,6,7,16,18,19,26,29,30],[2,3,10,13,15,17,22,25,27,31]],
"accent": [[6,29]],
"epub.identifi": [6],
"boolean": [25,19,[14,24]],
"topicref": [26,7],
"prune.preserv": [21,32],
"w2x-app-c.bat": [3],
"disciplin": [1],
"intend": [2]
};
