<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns:h="http://www.w3.org/1999/xhtml"
  xmlns="http://docbook.org/ns/docbook"
  exclude-result-prefixes="h">

<xsl:import href="w2x:xslt/docbook5.xslt"/>

<xsl:template match="h:div[@class = 'role-note']">
  <note>
    <xsl:call-template name="processCommonAttributes"/>
    <xsl:apply-templates/>
  </note>
</xsl:template>

<xsl:template match="h:code">
  <literal>
    <xsl:call-template name="processCommonAttributes"/>
    <xsl:choose>
      <xsl:when test="count(./h:i) = count(./*)">
        <!-- We want to support h:code/h:i. -->
        <xsl:apply-templates/>
      </xsl:when>
      <xsl:otherwise>
        <xsl:call-template name="simpleInlineContent2"/>
      </xsl:otherwise>
    </xsl:choose>
  </literal>
</xsl:template>

<xsl:template match="h:code/h:i">
  <replaceable>
    <xsl:call-template name="processCommonAttributes"/>
    <xsl:apply-templates/>
  </replaceable>
</xsl:template>

</xsl:stylesheet>
