function Snowball() {

/**@constructor*/
BaseStemmer = function() {
    this.setCurrent = function(value) {
        this.current = value;
        this.cursor = 0;
        this.limit = this.current.length;
        this.limit_backward = 0;
        this.bra = this.cursor;
        this.ket = this.limit;
    };

    this.getCurrent = function() {
        return this.current;
    };

    this.copy_from = function(other) {
        this.current          = other.current;
        this.cursor           = other.cursor;
        this.limit            = other.limit;
        this.limit_backward   = other.limit_backward;
        this.bra              = other.bra;
        this.ket              = other.ket;
    };

    this.in_grouping = function(s, min, max) {
        if (this.cursor >= this.limit) return false;
        var ch = this.current.charCodeAt(this.cursor);
        if (ch > max || ch < min) return false;
        ch -= min;
        if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
        this.cursor++;
        return true;
    };

    this.in_grouping_b = function(s, min, max) {
        if (this.cursor <= this.limit_backward) return false;
        var ch = this.current.charCodeAt(this.cursor - 1);
        if (ch > max || ch < min) return false;
        ch -= min;
        if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) return false;
        this.cursor--;
        return true;
    };

    this.out_grouping = function(s, min, max) {
        if (this.cursor >= this.limit) return false;
        var ch = this.current.charCodeAt(this.cursor);
        if (ch > max || ch < min) {
            this.cursor++;
            return true;
        }
        ch -= min;
        if ((s[ch >>> 3] & (0X1 << (ch & 0x7))) == 0) {
            this.cursor++;
            return true;
        }
        return false;
    };

    this.out_grouping_b = function(s, min, max) {
        if (this.cursor <= this.limit_backward) return false;
        var ch = this.current.charCodeAt(this.cursor - 1);
        if (ch > max || ch < min) {
            this.cursor--;
            return true;
        }
        ch -= min;
        if ((s[ch >>> 3] & (0x1 << (ch & 0x7))) == 0) {
            this.cursor--;
            return true;
        }
        return false;
    };

    this.eq_s = function(s)
    {
        if (this.limit - this.cursor < s.length) return false;
        if (this.current.slice(this.cursor, this.cursor + s.length) != s)
        {
            return false;
        }
        this.cursor += s.length;
        return true;
    };

    this.eq_s_b = function(s)
    {
        if (this.cursor - this.limit_backward < s.length) return false;
        if (this.current.slice(this.cursor - s.length, this.cursor) != s)
        {
            return false;
        }
        this.cursor -= s.length;
        return true;
    };

    /** @return {number} */ this.find_among = function(v)
    {
        var i = 0;
        var j = v.length;

        var c = this.cursor;
        var l = this.limit;

        var common_i = 0;
        var common_j = 0;

        var first_key_inspected = false;

        while (true)
        {
            var k = i + ((j - i) >>> 1);
            var diff = 0;
            var common = common_i < common_j ? common_i : common_j; // smaller
            // w[0]: string, w[1]: substring_i, w[2]: result, w[3]: function (optional)
            var w = v[k];
            var i2;
            for (i2 = common; i2 < w[0].length; i2++)
            {
                if (c + common == l)
                {
                    diff = -1;
                    break;
                }
                diff = this.current.charCodeAt(c + common) - w[0].charCodeAt(i2);
                if (diff != 0) break;
                common++;
            }
            if (diff < 0)
            {
                j = k;
                common_j = common;
            }
            else
            {
                i = k;
                common_i = common;
            }
            if (j - i <= 1)
            {
                if (i > 0) break; // v->s has been inspected
                if (j == i) break; // only one item in v

                // - but now we need to go round once more to get
                // v->s inspected. This looks messy, but is actually
                // the optimal approach.

                if (first_key_inspected) break;
                first_key_inspected = true;
            }
        }
        do {
            var w = v[i];
            if (common_i >= w[0].length)
            {
                this.cursor = c + w[0].length;
                if (w.length < 4) return w[2];
                var res = w[3](this);
                this.cursor = c + w[0].length;
                if (res) return w[2];
            }
            i = w[1];
        } while (i >= 0);
        return 0;
    };

    // find_among_b is for backwards processing. Same comments apply
    this.find_among_b = function(v)
    {
        var i = 0;
        var j = v.length

        var c = this.cursor;
        var lb = this.limit_backward;

        var common_i = 0;
        var common_j = 0;

        var first_key_inspected = false;

        while (true)
        {
            var k = i + ((j - i) >> 1);
            var diff = 0;
            var common = common_i < common_j ? common_i : common_j;
            var w = v[k];
            var i2;
            for (i2 = w[0].length - 1 - common; i2 >= 0; i2--)
            {
                if (c - common == lb)
                {
                    diff = -1;
                    break;
                }
                diff = this.current.charCodeAt(c - 1 - common) - w[0].charCodeAt(i2);
                if (diff != 0) break;
                common++;
            }
            if (diff < 0)
            {
                j = k;
                common_j = common;
            }
            else
            {
                i = k;
                common_i = common;
            }
            if (j - i <= 1)
            {
                if (i > 0) break;
                if (j == i) break;
                if (first_key_inspected) break;
                first_key_inspected = true;
            }
        }
        do {
            var w = v[i];
            if (common_i >= w[0].length)
            {
                this.cursor = c - w[0].length;
                if (w.length < 4) return w[2];
                var res = w[3](this);
                this.cursor = c - w[0].length;
                if (res) return w[2];
            }
            i = w[1];
        } while (i >= 0);
        return 0;
    };

    /* to replace chars between c_bra and c_ket in this.current by the
     * chars in s.
     */
    this.replace_s = function(c_bra, c_ket, s)
    {
        var adjustment = s.length - (c_ket - c_bra);
        this.current = this.current.slice(0, c_bra) + s + this.current.slice(c_ket);
        this.limit += adjustment;
        if (this.cursor >= c_ket) this.cursor += adjustment;
        else if (this.cursor > c_bra) this.cursor = c_bra;
        return adjustment;
    };

    this.slice_check = function()
    {
        if (this.bra < 0 ||
            this.bra > this.ket ||
            this.ket > this.limit ||
            this.limit > this.current.length)
        {
            return false;
        }
        return true;
    };

    this.slice_from = function(s)
    {
        var result = false;
        if (this.slice_check())
        {
            this.replace_s(this.bra, this.ket, s);
            result = true;
        }
        return result;
    };

    this.slice_del = function()
    {
        return this.slice_from("");
    };

    this.insert = function(c_bra, c_ket, s)
    {
        var adjustment = this.replace_s(c_bra, c_ket, s);
        if (c_bra <= this.bra) this.bra += adjustment;
        if (c_bra <= this.ket) this.ket += adjustment;
    };

    this.slice_to = function()
    {
        var result = '';
        if (this.slice_check())
        {
            result = this.current.slice(this.bra, this.ket);
        }
        return result;
    };

    this.assign_to = function()
    {
        return this.current.slice(0, this.limit);
    };
};


/*==============================================*/

// Generated by Snowball 2.2.0 - https://snowballstem.org/

/**@constructor*/
YiddishStemmer = function() {
    var base = new BaseStemmer();
    /** @const */ var a_0 = [
        ["\u05D5\u05D5", -1, 1],
        ["\u05D5\u05D9", -1, 2],
        ["\u05D9\u05D9", -1, 3],
        ["\u05DA", -1, 4],
        ["\u05DD", -1, 5],
        ["\u05DF", -1, 6],
        ["\u05E3", -1, 7],
        ["\u05E5", -1, 8]
    ];

    /** @const */ var a_1 = [
        ["\u05D0\u05D3\u05D5\u05E8\u05DB", -1, 1],
        ["\u05D0\u05D4\u05D9\u05E0", -1, 1],
        ["\u05D0\u05D4\u05E2\u05E8", -1, 1],
        ["\u05D0\u05D4\u05F2\u05DE", -1, 1],
        ["\u05D0\u05D5\u05DE", -1, 1],
        ["\u05D0\u05D5\u05E0\u05D8\u05E2\u05E8", -1, 1],
        ["\u05D0\u05D9\u05D1\u05E2\u05E8", -1, 1],
        ["\u05D0\u05E0", -1, 1],
        ["\u05D0\u05E0\u05D8", 7, 1],
        ["\u05D0\u05E0\u05D8\u05E7\u05E2\u05D2\u05E0", 8, 1],
        ["\u05D0\u05E0\u05D9\u05D3\u05E2\u05E8", 7, 1],
        ["\u05D0\u05E4", -1, 1],
        ["\u05D0\u05E4\u05D9\u05E8", 11, 1],
        ["\u05D0\u05E7\u05E2\u05D2\u05E0", -1, 1],
        ["\u05D0\u05E8\u05D0\u05E4", -1, 1],
        ["\u05D0\u05E8\u05D5\u05DE", -1, 1],
        ["\u05D0\u05E8\u05D5\u05E0\u05D8\u05E2\u05E8", -1, 1],
        ["\u05D0\u05E8\u05D9\u05D1\u05E2\u05E8", -1, 1],
        ["\u05D0\u05E8\u05F1\u05E1", -1, 1],
        ["\u05D0\u05E8\u05F1\u05E4", -1, 1],
        ["\u05D0\u05E8\u05F2\u05E0", -1, 1],
        ["\u05D0\u05F0\u05E2\u05E7", -1, 1],
        ["\u05D0\u05F1\u05E1", -1, 1],
        ["\u05D0\u05F1\u05E4", -1, 1],
        ["\u05D0\u05F2\u05E0", -1, 1],
        ["\u05D1\u05D0", -1, 1],
        ["\u05D1\u05F2", -1, 1],
        ["\u05D3\u05D5\u05E8\u05DB", -1, 1],
        ["\u05D3\u05E2\u05E8", -1, 1],
        ["\u05DE\u05D9\u05D8", -1, 1],
        ["\u05E0\u05D0\u05DB", -1, 1],
        ["\u05E4\u05D0\u05E8", -1, 1],
        ["\u05E4\u05D0\u05E8\u05D1\u05F2", 31, 1],
        ["\u05E4\u05D0\u05E8\u05F1\u05E1", 31, 1],
        ["\u05E4\u05D5\u05E0\u05D0\u05E0\u05D3\u05E2\u05E8", -1, 1],
        ["\u05E6\u05D5", -1, 1],
        ["\u05E6\u05D5\u05D6\u05D0\u05DE\u05E2\u05E0", 35, 1],
        ["\u05E6\u05D5\u05E0\u05F1\u05E4", 35, 1],
        ["\u05E6\u05D5\u05E8\u05D9\u05E7", 35, 1],
        ["\u05E6\u05E2", -1, 1]
    ];

    /** @const */ var a_2 = [
        ["\u05D3\u05D6\u05E9", -1, -1],
        ["\u05E9\u05D8\u05E8", -1, -1],
        ["\u05E9\u05D8\u05E9", -1, -1],
        ["\u05E9\u05E4\u05E8", -1, -1]
    ];

    /** @const */ var a_3 = [
        ["\u05E7\u05DC\u05D9\u05D1", -1, 9],
        ["\u05E8\u05D9\u05D1", -1, 10],
        ["\u05D8\u05E8\u05D9\u05D1", 1, 7],
        ["\u05E9\u05E8\u05D9\u05D1", 1, 15],
        ["\u05D4\u05F1\u05D1", -1, 23],
        ["\u05E9\u05F0\u05D9\u05D2", -1, 12],
        ["\u05D2\u05D0\u05E0\u05D2", -1, 1],
        ["\u05D6\u05D5\u05E0\u05D2", -1, 18],
        ["\u05E9\u05DC\u05D5\u05E0\u05D2", -1, 21],
        ["\u05E6\u05F0\u05D5\u05E0\u05D2", -1, 20],
        ["\u05D1\u05F1\u05D2", -1, 22],
        ["\u05D1\u05D5\u05E0\u05D3", -1, 16],
        ["\u05F0\u05D9\u05D6", -1, 6],
        ["\u05D1\u05D9\u05D8", -1, 4],
        ["\u05DC\u05D9\u05D8", -1, 8],
        ["\u05DE\u05D9\u05D8", -1, 3],
        ["\u05E9\u05E0\u05D9\u05D8", -1, 14],
        ["\u05E0\u05D5\u05DE", -1, 2],
        ["\u05E9\u05D8\u05D0\u05E0", -1, 25],
        ["\u05D1\u05D9\u05E1", -1, 5],
        ["\u05E9\u05DE\u05D9\u05E1", -1, 13],
        ["\u05E8\u05D9\u05E1", -1, 11],
        ["\u05D8\u05E8\u05D5\u05E0\u05E7", -1, 19],
        ["\u05E4\u05D0\u05E8\u05DC\u05F1\u05E8", -1, 24],
        ["\u05E9\u05F0\u05F1\u05E8", -1, 26],
        ["\u05F0\u05D5\u05D8\u05E9", -1, 17]
    ];

    /** @const */ var a_4 = [
        ["\u05D5\u05E0\u05D2", -1, 1],
        ["\u05E1\u05D8\u05D5", -1, 1],
        ["\u05D8", -1, 1],
        ["\u05D1\u05E8\u05D0\u05DB\u05D8", 2, 31],
        ["\u05E1\u05D8", 2, 1],
        ["\u05D9\u05E1\u05D8", 4, 33],
        ["\u05E2\u05D8", 2, 1],
        ["\u05E9\u05D0\u05E4\u05D8", 2, 1],
        ["\u05D4\u05F2\u05D8", 2, 1],
        ["\u05E7\u05F2\u05D8", 2, 1],
        ["\u05D9\u05E7\u05F2\u05D8", 9, 1],
        ["\u05DC\u05E2\u05DB", -1, 1],
        ["\u05E2\u05DC\u05E2\u05DB", 11, 1],
        ["\u05D9\u05D6\u05DE", -1, 1],
        ["\u05D9\u05DE", -1, 1],
        ["\u05E2\u05DE", -1, 1],
        ["\u05E2\u05E0\u05E2\u05DE", 15, 3],
        ["\u05D8\u05E2\u05E0\u05E2\u05DE", 16, 4],
        ["\u05E0", -1, 1],
        ["\u05E7\u05DC\u05D9\u05D1\u05E0", 18, 14],
        ["\u05E8\u05D9\u05D1\u05E0", 18, 15],
        ["\u05D8\u05E8\u05D9\u05D1\u05E0", 20, 12],
        ["\u05E9\u05E8\u05D9\u05D1\u05E0", 20, 7],
        ["\u05D4\u05F1\u05D1\u05E0", 18, 27],
        ["\u05E9\u05F0\u05D9\u05D2\u05E0", 18, 17],
        ["\u05D6\u05D5\u05E0\u05D2\u05E0", 18, 22],
        ["\u05E9\u05DC\u05D5\u05E0\u05D2\u05E0", 18, 25],
        ["\u05E6\u05F0\u05D5\u05E0\u05D2\u05E0", 18, 24],
        ["\u05D1\u05F1\u05D2\u05E0", 18, 26],
        ["\u05D1\u05D5\u05E0\u05D3\u05E0", 18, 20],
        ["\u05F0\u05D9\u05D6\u05E0", 18, 11],
        ["\u05D8\u05E0", 18, 4],
        ["GE\u05D1\u05D9\u05D8\u05E0", 31, 9],
        ["GE\u05DC\u05D9\u05D8\u05E0", 31, 13],
        ["GE\u05DE\u05D9\u05D8\u05E0", 31, 8],
        ["\u05E9\u05E0\u05D9\u05D8\u05E0", 31, 19],
        ["\u05E1\u05D8\u05E0", 31, 1],
        ["\u05D9\u05E1\u05D8\u05E0", 36, 1],
        ["\u05E2\u05D8\u05E0", 31, 1],
        ["GE\u05D1\u05D9\u05E1\u05E0", 18, 10],
        ["\u05E9\u05DE\u05D9\u05E1\u05E0", 18, 18],
        ["GE\u05E8\u05D9\u05E1\u05E0", 18, 16],
        ["\u05E2\u05E0", 18, 1],
        ["\u05D2\u05D0\u05E0\u05D2\u05E2\u05E0", 42, 5],
        ["\u05E2\u05DC\u05E2\u05E0", 42, 1],
        ["\u05E0\u05D5\u05DE\u05E2\u05E0", 42, 6],
        ["\u05D9\u05D6\u05DE\u05E2\u05E0", 42, 1],
        ["\u05E9\u05D8\u05D0\u05E0\u05E2\u05E0", 42, 29],
        ["\u05D8\u05E8\u05D5\u05E0\u05E7\u05E0", 18, 23],
        ["\u05E4\u05D0\u05E8\u05DC\u05F1\u05E8\u05E0", 18, 28],
        ["\u05E9\u05F0\u05F1\u05E8\u05E0", 18, 30],
        ["\u05F0\u05D5\u05D8\u05E9\u05E0", 18, 21],
        ["\u05D2\u05F2\u05E0", 18, 5],
        ["\u05E1", -1, 1],
        ["\u05D8\u05E1", 53, 4],
        ["\u05E2\u05D8\u05E1", 54, 1],
        ["\u05E0\u05E1", 53, 1],
        ["\u05D8\u05E0\u05E1", 56, 4],
        ["\u05E2\u05E0\u05E1", 56, 3],
        ["\u05E2\u05E1", 53, 1],
        ["\u05D9\u05E2\u05E1", 59, 2],
        ["\u05E2\u05DC\u05E2\u05E1", 59, 1],
        ["\u05E2\u05E8\u05E1", 53, 1],
        ["\u05E2\u05E0\u05E2\u05E8\u05E1", 62, 1],
        ["\u05E2", -1, 1],
        ["\u05D8\u05E2", 64, 4],
        ["\u05E1\u05D8\u05E2", 65, 1],
        ["\u05E2\u05D8\u05E2", 65, 1],
        ["\u05D9\u05E2", 64, -1],
        ["\u05E2\u05DC\u05E2", 64, 1],
        ["\u05E2\u05E0\u05E2", 64, 3],
        ["\u05D8\u05E2\u05E0\u05E2", 70, 4],
        ["\u05E2\u05E8", -1, 1],
        ["\u05D8\u05E2\u05E8", 72, 4],
        ["\u05E1\u05D8\u05E2\u05E8", 73, 1],
        ["\u05E2\u05D8\u05E2\u05E8", 73, 1],
        ["\u05E2\u05E0\u05E2\u05E8", 72, 3],
        ["\u05D8\u05E2\u05E0\u05E2\u05E8", 76, 4],
        ["\u05D5\u05EA", -1, 32]
    ];

    /** @const */ var a_5 = [
        ["\u05D5\u05E0\u05D2", -1, 1],
        ["\u05E9\u05D0\u05E4\u05D8", -1, 1],
        ["\u05D4\u05F2\u05D8", -1, 1],
        ["\u05E7\u05F2\u05D8", -1, 1],
        ["\u05D9\u05E7\u05F2\u05D8", 3, 1],
        ["\u05DC", -1, 2]
    ];

    /** @const */ var a_6 = [
        ["\u05D9\u05D2", -1, 1],
        ["\u05D9\u05E7", -1, 1],
        ["\u05D3\u05D9\u05E7", 1, 1],
        ["\u05E0\u05D3\u05D9\u05E7", 2, 1],
        ["\u05E2\u05E0\u05D3\u05D9\u05E7", 3, 1],
        ["\u05D1\u05DC\u05D9\u05E7", 1, -1],
        ["\u05D2\u05DC\u05D9\u05E7", 1, -1],
        ["\u05E0\u05D9\u05E7", 1, 1],
        ["\u05D9\u05E9", -1, 1]
    ];

    /** @const */ var /** Array<int> */ g_niked = [255, 155, 6];

    /** @const */ var /** Array<int> */ g_vowel = [33, 2, 4, 0, 6];

    /** @const */ var /** Array<int> */ g_consonant = [239, 254, 253, 131];

    var /** number */ I_x = 0;
    var /** number */ I_p1 = 0;


    /** @return {boolean} */
    function r_prelude() {
        var /** number */ among_var;
        var /** number */ v_1 = base.cursor;
        lab0: {
            while(true)
            {
                var /** number */ v_2 = base.cursor;
                lab1: {
                    golab2: while(true)
                    {
                        var /** number */ v_3 = base.cursor;
                        lab3: {
                            base.bra = base.cursor;
                            among_var = base.find_among(a_0);
                            if (among_var == 0)
                            {
                                break lab3;
                            }
                            base.ket = base.cursor;
                            switch (among_var) {
                                case 1:
                                    {
                                        var /** number */ v_4 = base.cursor;
                                        lab4: {
                                            if (!(base.eq_s("\u05BC")))
                                            {
                                                break lab4;
                                            }
                                            break lab3;
                                        }
                                        base.cursor = v_4;
                                    }
                                    if (!base.slice_from("\u05F0"))
                                    {
                                        return false;
                                    }
                                    break;
                                case 2:
                                    {
                                        var /** number */ v_5 = base.cursor;
                                        lab5: {
                                            if (!(base.eq_s("\u05B4")))
                                            {
                                                break lab5;
                                            }
                                            break lab3;
                                        }
                                        base.cursor = v_5;
                                    }
                                    if (!base.slice_from("\u05F1"))
                                    {
                                        return false;
                                    }
                                    break;
                                case 3:
                                    {
                                        var /** number */ v_6 = base.cursor;
                                        lab6: {
                                            if (!(base.eq_s("\u05B4")))
                                            {
                                                break lab6;
                                            }
                                            break lab3;
                                        }
                                        base.cursor = v_6;
                                    }
                                    if (!base.slice_from("\u05F2"))
                                    {
                                        return false;
                                    }
                                    break;
                                case 4:
                                    if (!base.slice_from("\u05DB"))
                                    {
                                        return false;
                                    }
                                    break;
                                case 5:
                                    if (!base.slice_from("\u05DE"))
                                    {
                                        return false;
                                    }
                                    break;
                                case 6:
                                    if (!base.slice_from("\u05E0"))
                                    {
                                        return false;
                                    }
                                    break;
                                case 7:
                                    if (!base.slice_from("\u05E4"))
                                    {
                                        return false;
                                    }
                                    break;
                                case 8:
                                    if (!base.slice_from("\u05E6"))
                                    {
                                        return false;
                                    }
                                    break;
                            }
                            base.cursor = v_3;
                            break golab2;
                        }
                        base.cursor = v_3;
                        if (base.cursor >= base.limit)
                        {
                            break lab1;
                        }
                        base.cursor++;
                    }
                    continue;
                }
                base.cursor = v_2;
                break;
            }
        }
        base.cursor = v_1;
        var /** number */ v_7 = base.cursor;
        lab7: {
            while(true)
            {
                var /** number */ v_8 = base.cursor;
                lab8: {
                    golab9: while(true)
                    {
                        var /** number */ v_9 = base.cursor;
                        lab10: {
                            base.bra = base.cursor;
                            if (!(base.in_grouping(g_niked, 1456, 1474)))
                            {
                                break lab10;
                            }
                            base.ket = base.cursor;
                            if (!base.slice_del())
                            {
                                return false;
                            }
                            base.cursor = v_9;
                            break golab9;
                        }
                        base.cursor = v_9;
                        if (base.cursor >= base.limit)
                        {
                            break lab8;
                        }
                        base.cursor++;
                    }
                    continue;
                }
                base.cursor = v_8;
                break;
            }
        }
        base.cursor = v_7;
        return true;
    };

    /** @return {boolean} */
    function r_mark_regions() {
        I_p1 = base.limit;
        var /** number */ v_1 = base.cursor;
        lab0: {
            base.bra = base.cursor;
            if (!(base.eq_s("\u05D2\u05E2")))
            {
                base.cursor = v_1;
                break lab0;
            }
            base.ket = base.cursor;
            {
                var /** number */ v_2 = base.cursor;
                lab1: {
                    lab2: {
                        var /** number */ v_3 = base.cursor;
                        lab3: {
                            if (!(base.eq_s("\u05DC\u05D8")))
                            {
                                break lab3;
                            }
                            break lab2;
                        }
                        base.cursor = v_3;
                        if (!(base.eq_s("\u05D1\u05E0")))
                        {
                            break lab1;
                        }
                    }
                    base.cursor = v_1;
                    break lab0;
                }
                base.cursor = v_2;
            }
            if (!base.slice_from("GE"))
            {
                return false;
            }
        }
        var /** number */ v_4 = base.cursor;
        lab4: {
            if (base.find_among(a_1) == 0)
            {
                base.cursor = v_4;
                break lab4;
            }
            lab5: {
                var /** number */ v_5 = base.cursor;
                lab6: {
                    var /** number */ v_6 = base.cursor;
                    lab7: {
                        var /** number */ v_7 = base.cursor;
                        lab8: {
                            if (!(base.eq_s("\u05E6\u05D5\u05D2\u05E0")))
                            {
                                break lab8;
                            }
                            break lab7;
                        }
                        base.cursor = v_7;
                        lab9: {
                            if (!(base.eq_s("\u05E6\u05D5\u05E7\u05D8")))
                            {
                                break lab9;
                            }
                            break lab7;
                        }
                        base.cursor = v_7;
                        if (!(base.eq_s("\u05E6\u05D5\u05E7\u05E0")))
                        {
                            break lab6;
                        }
                    }
                    if (base.cursor < base.limit)
                    {
                        break lab6;
                    }
                    base.cursor = v_6;
                    break lab5;
                }
                base.cursor = v_5;
                lab10: {
                    var /** number */ v_8 = base.cursor;
                    if (!(base.eq_s("\u05D2\u05E2\u05D1\u05E0")))
                    {
                        break lab10;
                    }
                    base.cursor = v_8;
                    break lab5;
                }
                base.cursor = v_5;
                lab11: {
                    base.bra = base.cursor;
                    if (!(base.eq_s("\u05D2\u05E2")))
                    {
                        break lab11;
                    }
                    base.ket = base.cursor;
                    if (!base.slice_from("GE"))
                    {
                        return false;
                    }
                    break lab5;
                }
                base.cursor = v_5;
                base.bra = base.cursor;
                if (!(base.eq_s("\u05E6\u05D5")))
                {
                    base.cursor = v_4;
                    break lab4;
                }
                base.ket = base.cursor;
                if (!base.slice_from("TSU"))
                {
                    return false;
                }
            }
        }
        var /** number */ v_9 = base.cursor;
        {
            var /** number */ c1 = base.cursor + 3;
            if (c1 > base.limit)
            {
                return false;
            }
            base.cursor = c1;
        }
        I_x = base.cursor;
        base.cursor = v_9;
        var /** number */ v_10 = base.cursor;
        lab12: {
            if (base.find_among(a_2) == 0)
            {
                base.cursor = v_10;
                break lab12;
            }
        }
        {
            var /** number */ v_11 = base.cursor;
            lab13: {
                if (!(base.in_grouping(g_consonant, 1489, 1520)))
                {
                    break lab13;
                }
                if (!(base.in_grouping(g_consonant, 1489, 1520)))
                {
                    break lab13;
                }
                if (!(base.in_grouping(g_consonant, 1489, 1520)))
                {
                    break lab13;
                }
                I_p1 = base.cursor;
                return false;
            }
            base.cursor = v_11;
        }
        golab14: while(true)
        {
            var /** number */ v_12 = base.cursor;
            lab15: {
                if (!(base.in_grouping(g_vowel, 1488, 1522)))
                {
                    break lab15;
                }
                base.cursor = v_12;
                break golab14;
            }
            base.cursor = v_12;
            if (base.cursor >= base.limit)
            {
                return false;
            }
            base.cursor++;
        }
        while(true)
        {
            lab16: {
                if (!(base.in_grouping(g_vowel, 1488, 1522)))
                {
                    break lab16;
                }
                continue;
            }
            break;
        }
        I_p1 = base.cursor;
        lab17: {
            if (!(I_p1 < I_x))
            {
                break lab17;
            }
            I_p1 = I_x;
        }
        return true;
    };

    /** @return {boolean} */
    function r_R1() {
        if (!(I_p1 <= base.cursor))
        {
            return false;
        }
        return true;
    };

    /** @return {boolean} */
    function r_R1plus3() {
        if (!(I_p1 <= (base.cursor + 3)))
        {
            return false;
        }
        return true;
    };

    /** @return {boolean} */
    function r_standard_suffix() {
        var /** number */ among_var;
        var /** number */ v_1 = base.limit - base.cursor;
        lab0: {
            base.ket = base.cursor;
            among_var = base.find_among_b(a_4);
            if (among_var == 0)
            {
                break lab0;
            }
            base.bra = base.cursor;
            switch (among_var) {
                case 1:
                    if (!r_R1())
                    {
                        break lab0;
                    }
                    if (!base.slice_del())
                    {
                        return false;
                    }
                    break;
                case 2:
                    if (!r_R1())
                    {
                        break lab0;
                    }
                    if (!base.slice_from("\u05D9\u05E2"))
                    {
                        return false;
                    }
                    break;
                case 3:
                    if (!r_R1())
                    {
                        break lab0;
                    }
                    if (!base.slice_del())
                    {
                        return false;
                    }
                    base.ket = base.cursor;
                    among_var = base.find_among_b(a_3);
                    if (among_var == 0)
                    {
                        break lab0;
                    }
                    base.bra = base.cursor;
                    switch (among_var) {
                        case 1:
                            if (!base.slice_from("\u05D2\u05F2"))
                            {
                                return false;
                            }
                            break;
                        case 2:
                            if (!base.slice_from("\u05E0\u05E2\u05DE"))
                            {
                                return false;
                            }
                            break;
                        case 3:
                            if (!base.slice_from("\u05DE\u05F2\u05D3"))
                            {
                                return false;
                            }
                            break;
                        case 4:
                            if (!base.slice_from("\u05D1\u05F2\u05D8"))
                            {
                                return false;
                            }
                            break;
                        case 5:
                            if (!base.slice_from("\u05D1\u05F2\u05E1"))
                            {
                                return false;
                            }
                            break;
                        case 6:
                            if (!base.slice_from("\u05F0\u05F2\u05D6"))
                            {
                                return false;
                            }
                            break;
                        case 7:
                            if (!base.slice_from("\u05D8\u05E8\u05F2\u05D1"))
                            {
                                return false;
                            }
                            break;
                        case 8:
                            if (!base.slice_from("\u05DC\u05F2\u05D8"))
                            {
                                return false;
                            }
                            break;
                        case 9:
                            if (!base.slice_from("\u05E7\u05DC\u05F2\u05D1"))
                            {
                                return false;
                            }
                            break;
                        case 10:
                            if (!base.slice_from("\u05E8\u05F2\u05D1"))
                            {
                                return false;
                            }
                            break;
                        case 11:
                            if (!base.slice_from("\u05E8\u05F2\u05E1"))
                            {
                                return false;
                            }
                            break;
                        case 12:
                            if (!base.slice_from("\u05E9\u05F0\u05F2\u05D2"))
                            {
                                return false;
                            }
                            break;
                        case 13:
                            if (!base.slice_from("\u05E9\u05DE\u05F2\u05E1"))
                            {
                                return false;
                            }
                            break;
                        case 14:
                            if (!base.slice_from("\u05E9\u05E0\u05F2\u05D3"))
                            {
                                return false;
                            }
                            break;
                        case 15:
                            if (!base.slice_from("\u05E9\u05E8\u05F2\u05D1"))
                            {
                                return false;
                            }
                            break;
                        case 16:
                            if (!base.slice_from("\u05D1\u05D9\u05E0\u05D3"))
                            {
                                return false;
                            }
                            break;
                        case 17:
                            if (!base.slice_from("\u05F0\u05D9\u05D8\u05E9"))
                            {
                                return false;
                            }
                            break;
                        case 18:
                            if (!base.slice_from("\u05D6\u05D9\u05E0\u05D2"))
                            {
                                return false;
                            }
                            break;
                        case 19:
                            if (!base.slice_from("\u05D8\u05E8\u05D9\u05E0\u05E7"))
                            {
                                return false;
                            }
                            break;
                        case 20:
                            if (!base.slice_from("\u05E6\u05F0\u05D9\u05E0\u05D2"))
                            {
                                return false;
                            }
                            break;
                        case 21:
                            if (!base.slice_from("\u05E9\u05DC\u05D9\u05E0\u05D2"))
                            {
                                return false;
                            }
                            break;
                        case 22:
                            if (!base.slice_from("\u05D1\u05F2\u05D2"))
                            {
                                return false;
                            }
                            break;
                        case 23:
                            if (!base.slice_from("\u05D4\u05F2\u05D1"))
                            {
                                return false;
                            }
                            break;
                        case 24:
                            if (!base.slice_from("\u05E4\u05D0\u05E8\u05DC\u05D9\u05E8"))
                            {
                                return false;
                            }
                            break;
                        case 25:
                            if (!base.slice_from("\u05E9\u05D8\u05F2"))
                            {
                                return false;
                            }
                            break;
                        case 26:
                            if (!base.slice_from("\u05E9\u05F0\u05E2\u05E8"))
                            {
                                return false;
                            }
                            break;
                    }
                    break;
                case 4:
                    lab1: {
                        var /** number */ v_2 = base.limit - base.cursor;
                        lab2: {
                            if (!r_R1())
                            {
                                break lab2;
                            }
                            if (!base.slice_del())
                            {
                                return false;
                            }
                            break lab1;
                        }
                        base.cursor = base.limit - v_2;
                        if (!base.slice_from("\u05D8"))
                        {
                            return false;
                        }
                    }
                    base.ket = base.cursor;
                    if (!(base.eq_s_b("\u05D1\u05E8\u05D0\u05DB")))
                    {
                        break lab0;
                    }
                    var /** number */ v_3 = base.limit - base.cursor;
                    lab3: {
                        if (!(base.eq_s_b("\u05D2\u05E2")))
                        {
                            base.cursor = base.limit - v_3;
                            break lab3;
                        }
                    }
                    base.bra = base.cursor;
                    if (!base.slice_from("\u05D1\u05E8\u05E2\u05E0\u05D2"))
                    {
                        return false;
                    }
                    break;
                case 5:
                    if (!base.slice_from("\u05D2\u05F2"))
                    {
                        return false;
                    }
                    break;
                case 6:
                    if (!base.slice_from("\u05E0\u05E2\u05DE"))
                    {
                        return false;
                    }
                    break;
                case 7:
                    if (!base.slice_from("\u05E9\u05E8\u05F2\u05D1"))
                    {
                        return false;
                    }
                    break;
                case 8:
                    if (!base.slice_from("\u05DE\u05F2\u05D3"))
                    {
                        return false;
                    }
                    break;
                case 9:
                    if (!base.slice_from("\u05D1\u05F2\u05D8"))
                    {
                        return false;
                    }
                    break;
                case 10:
                    if (!base.slice_from("\u05D1\u05F2\u05E1"))
                    {
                        return false;
                    }
                    break;
                case 11:
                    if (!base.slice_from("\u05F0\u05F2\u05D6"))
                    {
                        return false;
                    }
                    break;
                case 12:
                    if (!base.slice_from("\u05D8\u05E8\u05F2\u05D1"))
                    {
                        return false;
                    }
                    break;
                case 13:
                    if (!base.slice_from("\u05DC\u05F2\u05D8"))
                    {
                        return false;
                    }
                    break;
                case 14:
                    if (!base.slice_from("\u05E7\u05DC\u05F2\u05D1"))
                    {
                        return false;
                    }
                    break;
                case 15:
                    if (!base.slice_from("\u05E8\u05F2\u05D1"))
                    {
                        return false;
                    }
                    break;
                case 16:
                    if (!base.slice_from("\u05E8\u05F2\u05E1"))
                    {
                        return false;
                    }
                    break;
                case 17:
                    if (!base.slice_from("\u05E9\u05F0\u05F2\u05D2"))
                    {
                        return false;
                    }
                    break;
                case 18:
                    if (!base.slice_from("\u05E9\u05DE\u05F2\u05E1"))
                    {
                        return false;
                    }
                    break;
                case 19:
                    if (!base.slice_from("\u05E9\u05E0\u05F2\u05D3"))
                    {
                        return false;
                    }
                    break;
                case 20:
                    if (!base.slice_from("\u05D1\u05D9\u05E0\u05D3"))
                    {
                        return false;
                    }
                    break;
                case 21:
                    if (!base.slice_from("\u05F0\u05D9\u05D8\u05E9"))
                    {
                        return false;
                    }
                    break;
                case 22:
                    if (!base.slice_from("\u05D6\u05D9\u05E0\u05D2"))
                    {
                        return false;
                    }
                    break;
                case 23:
                    if (!base.slice_from("\u05D8\u05E8\u05D9\u05E0\u05E7"))
                    {
                        return false;
                    }
                    break;
                case 24:
                    if (!base.slice_from("\u05E6\u05F0\u05D9\u05E0\u05D2"))
                    {
                        return false;
                    }
                    break;
                case 25:
                    if (!base.slice_from("\u05E9\u05DC\u05D9\u05E0\u05D2"))
                    {
                        return false;
                    }
                    break;
                case 26:
                    if (!base.slice_from("\u05D1\u05F2\u05D2"))
                    {
                        return false;
                    }
                    break;
                case 27:
                    if (!base.slice_from("\u05D4\u05F2\u05D1"))
                    {
                        return false;
                    }
                    break;
                case 28:
                    if (!base.slice_from("\u05E4\u05D0\u05E8\u05DC\u05D9\u05E8"))
                    {
                        return false;
                    }
                    break;
                case 29:
                    if (!base.slice_from("\u05E9\u05D8\u05F2"))
                    {
                        return false;
                    }
                    break;
                case 30:
                    if (!base.slice_from("\u05E9\u05F0\u05E2\u05E8"))
                    {
                        return false;
                    }
                    break;
                case 31:
                    if (!base.slice_from("\u05D1\u05E8\u05E2\u05E0\u05D2"))
                    {
                        return false;
                    }
                    break;
                case 32:
                    if (!r_R1())
                    {
                        break lab0;
                    }
                    if (!base.slice_from("\u05D4"))
                    {
                        return false;
                    }
                    break;
                case 33:
                    lab4: {
                        var /** number */ v_4 = base.limit - base.cursor;
                        lab5: {
                            lab6: {
                                var /** number */ v_5 = base.limit - base.cursor;
                                lab7: {
                                    if (!(base.eq_s_b("\u05D2")))
                                    {
                                        break lab7;
                                    }
                                    break lab6;
                                }
                                base.cursor = base.limit - v_5;
                                if (!(base.eq_s_b("\u05E9")))
                                {
                                    break lab5;
                                }
                            }
                            var /** number */ v_6 = base.limit - base.cursor;
                            lab8: {
                                if (!r_R1plus3())
                                {
                                    base.cursor = base.limit - v_6;
                                    break lab8;
                                }
                                if (!base.slice_from("\u05D9\u05E1"))
                                {
                                    return false;
                                }
                            }
                            break lab4;
                        }
                        base.cursor = base.limit - v_4;
                        if (!r_R1())
                        {
                            break lab0;
                        }
                        if (!base.slice_del())
                        {
                            return false;
                        }
                    }
                    break;
            }
        }
        base.cursor = base.limit - v_1;
        var /** number */ v_7 = base.limit - base.cursor;
        lab9: {
            base.ket = base.cursor;
            among_var = base.find_among_b(a_5);
            if (among_var == 0)
            {
                break lab9;
            }
            base.bra = base.cursor;
            switch (among_var) {
                case 1:
                    if (!r_R1())
                    {
                        break lab9;
                    }
                    if (!base.slice_del())
                    {
                        return false;
                    }
                    break;
                case 2:
                    if (!r_R1())
                    {
                        break lab9;
                    }
                    if (!(base.in_grouping_b(g_consonant, 1489, 1520)))
                    {
                        break lab9;
                    }
                    if (!base.slice_del())
                    {
                        return false;
                    }
                    break;
            }
        }
        base.cursor = base.limit - v_7;
        var /** number */ v_8 = base.limit - base.cursor;
        lab10: {
            base.ket = base.cursor;
            among_var = base.find_among_b(a_6);
            if (among_var == 0)
            {
                break lab10;
            }
            base.bra = base.cursor;
            switch (among_var) {
                case 1:
                    if (!r_R1())
                    {
                        break lab10;
                    }
                    if (!base.slice_del())
                    {
                        return false;
                    }
                    break;
            }
        }
        base.cursor = base.limit - v_8;
        var /** number */ v_9 = base.limit - base.cursor;
        lab11: {
            while(true)
            {
                var /** number */ v_10 = base.limit - base.cursor;
                lab12: {
                    golab13: while(true)
                    {
                        var /** number */ v_11 = base.limit - base.cursor;
                        lab14: {
                            base.ket = base.cursor;
                            lab15: {
                                var /** number */ v_12 = base.limit - base.cursor;
                                lab16: {
                                    if (!(base.eq_s_b("GE")))
                                    {
                                        break lab16;
                                    }
                                    break lab15;
                                }
                                base.cursor = base.limit - v_12;
                                if (!(base.eq_s_b("TSU")))
                                {
                                    break lab14;
                                }
                            }
                            base.bra = base.cursor;
                            if (!base.slice_del())
                            {
                                return false;
                            }
                            base.cursor = base.limit - v_11;
                            break golab13;
                        }
                        base.cursor = base.limit - v_11;
                        if (base.cursor <= base.limit_backward)
                        {
                            break lab12;
                        }
                        base.cursor--;
                    }
                    continue;
                }
                base.cursor = base.limit - v_10;
                break;
            }
        }
        base.cursor = base.limit - v_9;
        return true;
    };

    this.stem = /** @return {boolean} */ function() {
        r_prelude();
        var /** number */ v_2 = base.cursor;
        r_mark_regions();
        base.cursor = v_2;
        base.limit_backward = base.cursor; base.cursor = base.limit;
        r_standard_suffix();
        base.cursor = base.limit_backward;
        return true;
    };

    /**@return{string}*/
    this['stemWord'] = function(/**string*/word) {
        base.setCurrent(word);
        this.stem();
        return base.getCurrent();
    };
};


return new YiddishStemmer();
}