/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.xpath.BooleanVariant;
import com.xmlmind.xml.xpath.Converter;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.NodeIterator;
import com.xmlmind.xml.xpath.NodeSetVariant;
import com.xmlmind.xml.xpath.NumberVariant;
import com.xmlmind.xml.xpath.ObjectVariant;
import com.xmlmind.xml.xpath.SingleNodeIterator;
import com.xmlmind.xml.xpath.StringVariant;
import com.xmlmind.xml.xpath.Variant;

public abstract class VariantBase
implements Variant {
    @Override
    public Variant makePermanent() throws EvalException {
        return this;
    }

    @Override
    public NodeIterator convertToNodeSet() throws EvalException {
        throw new EvalException("cannot convert to node-set");
    }

    @Override
    public double convertToNumber() throws EvalException {
        return Converter.toNumber(this.convertToString());
    }

    @Override
    public boolean convertToPredicate(ExprContext exprContext) throws EvalException {
        return this.convertToBoolean();
    }

    @Override
    public boolean isBoolean() {
        return false;
    }

    @Override
    public boolean isNumber() {
        return false;
    }

    @Override
    public boolean isString() {
        return false;
    }

    @Override
    public boolean isNodeSet() {
        return false;
    }

    public static Variant create(Object object) {
        if (object instanceof String) {
            return new StringVariant((String)object);
        }
        if (object instanceof Number) {
            return new NumberVariant(((Number)object).doubleValue());
        }
        if (object instanceof Boolean) {
            return new BooleanVariant((Boolean)object);
        }
        if (object instanceof NodeIterator) {
            return new NodeSetVariant((NodeIterator)object);
        }
        if (object instanceof XNode) {
            return new NodeSetVariant(new SingleNodeIterator((XNode)object));
        }
        if (object instanceof Variant) {
            return (Variant)object;
        }
        return new ObjectVariant(object);
    }
}

