/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.xpath.ConvertibleExpr;
import com.xmlmind.xml.xpath.ConvertibleStringExpr;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.Function1;
import com.xmlmind.xml.xpath.ParseException;
import java.net.URL;

class URIOrFileNameFunction
extends Function1 {
    URIOrFileNameFunction() {
    }

    @Override
    ConvertibleExpr makeCallExpr(ConvertibleExpr convertibleExpr) throws ParseException {
        final ConvertibleStringExpr convertibleStringExpr = convertibleExpr.makeStringExpr();
        return new ConvertibleStringExpr(){

            @Override
            public String eval(XNode xNode, ExprContext exprContext) throws EvalException {
                String string = convertibleStringExpr.eval(xNode, exprContext);
                URL uRL = URLUtil.urlOrFile(string, false, true);
                if (uRL == null) {
                    throw new EvalException("invalid argument to uri-or-file-name: '" + string + "' not an URL and not the name of an existing file or directory");
                }
                return uRL.toExternalForm();
            }
        };
    }
}

