/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.NodeIterator;

class MergeNodeIterator
implements NodeIterator {
    private NodeIterator[] iters;
    private XNode[] nodes;
    private int length;

    MergeNodeIterator(NodeIterator[] nodeIteratorArray, int n) throws EvalException {
        this.length = n;
        this.iters = nodeIteratorArray;
        this.nodes = new XNode[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            XNode xNode;
            if (i != n2) {
                nodeIteratorArray[n2] = nodeIteratorArray[i];
            }
            if ((xNode = nodeIteratorArray[n2].next()) == null) continue;
            this.nodes[n2++] = xNode;
        }
        this.length = n2;
        this.buildHeap();
    }

    private final void heapify(int n) {
        while (true) {
            int n2;
            int n3;
            if ((n3 = (n2 = n << 1 | 1) + 1) < this.length) {
                if (this.compare(n2, n3) <= 0) {
                    if (this.compare(n2, n) > 0) break;
                    this.exchange(n2, n);
                    n = n2;
                    continue;
                }
                if (this.compare(n3, n) > 0) break;
                this.exchange(n3, n);
                n = n3;
                continue;
            }
            if (n2 >= this.length || this.compare(n2, n) > 0) break;
            this.exchange(n2, n);
            n = n2;
        }
    }

    private final void exchange(int n, int n2) {
        Object object = this.nodes[n];
        this.nodes[n] = this.nodes[n2];
        this.nodes[n2] = object;
        object = this.iters[n];
        this.iters[n] = this.iters[n2];
        this.iters[n2] = object;
    }

    private final int compare(int n, int n2) {
        return this.nodes[n].compareTo(this.nodes[n2]);
    }

    private void buildHeap() {
        for (int i = this.length / 2 - 1; i >= 0; --i) {
            this.heapify(i);
        }
    }

    @Override
    public XNode next() throws EvalException {
        if (this.length == 0) {
            return null;
        }
        XNode xNode = this.nodes[0];
        do {
            XNode xNode2;
            if ((xNode2 = this.iters[0].next()) == null) {
                if (--this.length == 0) break;
                this.nodes[0] = this.nodes[this.length];
                this.iters[0] = this.iters[this.length];
            } else {
                this.nodes[0] = xNode2;
            }
            this.heapify(0);
        } while (xNode.equals(this.nodes[0]));
        return xNode;
    }
}

