/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.xpath.ConvertibleBooleanExpr;
import com.xmlmind.xml.xpath.ConvertibleExpr;
import com.xmlmind.xml.xpath.ConvertibleStringExpr;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.Function1;
import com.xmlmind.xml.xpath.ParseException;

class LangFunction
extends Function1 {
    LangFunction() {
    }

    @Override
    ConvertibleExpr makeCallExpr(ConvertibleExpr convertibleExpr) throws ParseException {
        final ConvertibleStringExpr convertibleStringExpr = convertibleExpr.makeStringExpr();
        return new ConvertibleBooleanExpr(){

            @Override
            public boolean eval(XNode xNode, ExprContext exprContext) throws EvalException {
                return LangFunction.lang(xNode, convertibleStringExpr.eval(xNode, exprContext));
            }
        };
    }

    private static final boolean lang(XNode xNode, String string) {
        while (xNode != null) {
            String string2 = xNode.attributeValue(Name.XML_LANG);
            if (string2 != null) {
                return LangFunction.isSubLanguage(string, string2);
            }
            xNode = xNode.parent();
        }
        return false;
    }

    private static final boolean isSubLanguage(String string, String string2) {
        int n;
        int n2 = string.length();
        if (n2 > (n = string2.length())) {
            return false;
        }
        if (n2 < n && string2.charAt(n2) != '-') {
            return false;
        }
        block3: for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            char c2 = string2.charAt(i);
            switch (c - c2) {
                case -32: 
                case 0: 
                case 32: {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }
}

