/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.xpath.ConvertibleExpr;
import com.xmlmind.xml.xpath.ConvertibleNodeSetExpr;
import com.xmlmind.xml.xpath.ConvertibleStringExpr;
import com.xmlmind.xml.xpath.DocumentOrderComparator;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.Function;
import com.xmlmind.xml.xpath.KeyedNodeIterator;
import com.xmlmind.xml.xpath.NodeIterator;
import com.xmlmind.xml.xpath.NodeListSorter;
import com.xmlmind.xml.xpath.NodeSetExpr;
import com.xmlmind.xml.xpath.ParseException;
import com.xmlmind.xml.xpath.UniqueNodeIterator;
import com.xmlmind.xml.xpath.Variant;
import com.xmlmind.xml.xpath.VariantExpr;

class KeyFunction
implements Function {
    KeyFunction() {
    }

    @Override
    public ConvertibleExpr makeCallExpr(ConvertibleExpr[] convertibleExprArray, final PrefixToNamespace prefixToNamespace) throws ParseException {
        if (convertibleExprArray.length != 2) {
            throw new ParseException("expected two arguments");
        }
        ConvertibleExpr convertibleExpr = convertibleExprArray[0];
        ConvertibleExpr convertibleExpr2 = convertibleExprArray[1];
        final ConvertibleStringExpr convertibleStringExpr = convertibleExpr.makeStringExpr();
        if (convertibleExpr2 instanceof NodeSetExpr) {
            final NodeSetExpr nodeSetExpr = (NodeSetExpr)((Object)convertibleExpr2);
            return new ConvertibleNodeSetExpr(){

                @Override
                public NodeIterator eval(XNode xNode, ExprContext exprContext) throws EvalException {
                    return KeyFunction.key(convertibleStringExpr.eval(xNode, exprContext), prefixToNamespace, nodeSetExpr.eval(xNode, exprContext), xNode, exprContext);
                }
            };
        }
        if (convertibleExpr2 instanceof VariantExpr) {
            final VariantExpr variantExpr = (VariantExpr)((Object)convertibleExpr2);
            return new ConvertibleNodeSetExpr(){

                @Override
                public NodeIterator eval(XNode xNode, ExprContext exprContext) throws EvalException {
                    Variant variant = variantExpr.eval(xNode, exprContext);
                    if (variant.isNodeSet()) {
                        return KeyFunction.key(convertibleStringExpr.eval(xNode, exprContext), prefixToNamespace, variant.convertToNodeSet(), xNode, exprContext);
                    }
                    return KeyFunction.key(convertibleStringExpr.eval(xNode, exprContext), prefixToNamespace, variant.convertToString(), xNode, exprContext);
                }
            };
        }
        final ConvertibleStringExpr convertibleStringExpr2 = convertibleExpr2.makeStringExpr();
        return new ConvertibleNodeSetExpr(){

            @Override
            public NodeIterator eval(XNode xNode, ExprContext exprContext) throws EvalException {
                return KeyFunction.key(convertibleStringExpr.eval(xNode, exprContext), prefixToNamespace, convertibleStringExpr2.eval(xNode, exprContext), xNode, exprContext);
            }
        };
    }

    private static final NodeIterator key(String string, PrefixToNamespace prefixToNamespace, NodeIterator nodeIterator, XNode xNode, ExprContext exprContext) throws EvalException {
        Name name = KeyFunction.parseName(string, prefixToNamespace);
        return new UniqueNodeIterator(NodeListSorter.sort(new KeyedNodeIterator(name, nodeIterator, xNode, exprContext), new DocumentOrderComparator()));
    }

    private static final NodeIterator key(String string, PrefixToNamespace prefixToNamespace, String string2, XNode xNode, ExprContext exprContext) throws EvalException {
        Name name = KeyFunction.parseName(string, prefixToNamespace);
        return NodeListSorter.sort(exprContext.getKeyedNodes(name, string2, xNode), new DocumentOrderComparator());
    }

    static final Name parseName(String string, PrefixToNamespace prefixToNamespace) throws EvalException {
        Name name = Name.parse(string, true, prefixToNamespace);
        if (name == null) {
            throw new EvalException("'" + string + "', malformed name or undefined prefix");
        }
        return name;
    }
}

