/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.xpath.BooleanExpr;
import com.xmlmind.xml.xpath.DelegateExprContext;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.NodeUtil;
import com.xmlmind.xml.xpath.PathPatternBase;
import com.xmlmind.xml.xpath.SafeNodeIterator;

class FilterPattern
extends PathPatternBase {
    private PathPatternBase pattern;
    private BooleanExpr predicate;

    FilterPattern(PathPatternBase pathPatternBase, BooleanExpr booleanExpr) {
        this.pattern = pathPatternBase;
        this.predicate = booleanExpr;
    }

    @Override
    public boolean matches(XNode xNode, ExprContext exprContext) throws EvalException {
        if (!this.pattern.matches(xNode, exprContext)) {
            return false;
        }
        return this.predicate.eval(xNode, new Context(xNode, exprContext));
    }

    class Context
    extends DelegateExprContext {
        XNode node;
        int position;
        int lastPosition;

        Context(XNode xNode, ExprContext exprContext) {
            super(exprContext);
            this.position = 0;
            this.lastPosition = 0;
            this.node = xNode;
        }

        @Override
        public int getPosition() throws EvalException {
            XNode xNode;
            SafeNodeIterator safeNodeIterator;
            if (this.position != 0) {
                return this.position;
            }
            switch (this.node.type()) {
                case DOCUMENT: {
                    this.position = 1;
                    return 1;
                }
                case ATTRIBUTE: {
                    safeNodeIterator = NodeUtil.getAttributes(this.node.parent());
                    break;
                }
                default: {
                    safeNodeIterator = NodeUtil.getChildren(this.node.parent());
                }
            }
            this.position = 1;
            while (!(xNode = safeNodeIterator.next()).equals(this.node)) {
                if (!FilterPattern.this.pattern.matches(xNode, this.origContext)) continue;
                ++this.position;
            }
            return this.position;
        }

        @Override
        public int getLastPosition() throws EvalException {
            XNode xNode;
            SafeNodeIterator safeNodeIterator;
            if (this.lastPosition != 0) {
                return this.lastPosition;
            }
            switch (this.node.type()) {
                case DOCUMENT: {
                    this.lastPosition = 1;
                    return 1;
                }
                case ATTRIBUTE: {
                    safeNodeIterator = NodeUtil.getAttributes(this.node.parent());
                    this.lastPosition = 0;
                    break;
                }
                default: {
                    safeNodeIterator = NodeUtil.getFollowingSiblings(this.node);
                    this.lastPosition = this.getPosition();
                }
            }
            while ((xNode = safeNodeIterator.next()) != null) {
                if (!FilterPattern.this.pattern.matches(xNode, this.origContext)) continue;
                ++this.lastPosition;
            }
            return this.lastPosition;
        }
    }
}

