/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.xpath.BooleanExpr;
import com.xmlmind.xml.xpath.CloneableNodeIterator;
import com.xmlmind.xml.xpath.CloneableNodeIteratorImpl;
import com.xmlmind.xml.xpath.DelegateExprContext;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.NodeIterator;

class FilterNodeIterator
extends DelegateExprContext
implements NodeIterator {
    private int pos = 0;
    private int lastPos = 0;
    private NodeIterator iter;
    private BooleanExpr predicate;

    FilterNodeIterator(NodeIterator nodeIterator, ExprContext exprContext, BooleanExpr booleanExpr) {
        super(exprContext);
        this.iter = nodeIterator;
        this.predicate = booleanExpr;
    }

    @Override
    public XNode next() throws EvalException {
        XNode xNode;
        while ((xNode = this.iter.next()) != null) {
            ++this.pos;
            if (!this.predicate.eval(xNode, this)) continue;
            return xNode;
        }
        return null;
    }

    @Override
    public int getPosition() {
        return this.pos;
    }

    @Override
    public int getLastPosition() throws EvalException {
        if (this.lastPos == 0) {
            CloneableNodeIterator cloneableNodeIterator = this.iter instanceof CloneableNodeIterator ? (CloneableNodeIterator)this.iter : new CloneableNodeIteratorImpl(this.iter);
            this.iter = (NodeIterator)cloneableNodeIterator.clone();
            int n = this.pos;
            try {
                while (this.next() != null) {
                }
                this.lastPos = this.pos;
            }
            finally {
                this.pos = n;
                this.iter = cloneableNodeIterator;
            }
        }
        return this.lastPos;
    }
}

