/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xpath;

import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.xpath.CloneableNodeIterator;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.NodeIterator;

class CloneableNodeIteratorImpl
implements CloneableNodeIterator {
    private NodeList list;
    private int i;

    @Override
    public Object clone() {
        return new CloneableNodeIteratorImpl(this.list, this.i);
    }

    public CloneableNodeIteratorImpl(NodeIterator nodeIterator) {
        this.list = new NodeList(nodeIterator);
        this.i = 0;
    }

    private CloneableNodeIteratorImpl(NodeList nodeList, int n) {
        this.list = nodeList;
        this.i = n;
    }

    @Override
    public XNode next() throws EvalException {
        XNode xNode = this.list.nodeAt(this.i);
        if (xNode != null) {
            ++this.i;
        }
        return xNode;
    }

    @Override
    public void bind() throws EvalException {
        int n = 0;
        while (this.list.nodeAt(n) != null) {
            ++n;
        }
    }

    static class NodeList {
        NodeIterator iter;
        XNode[] nodes = null;
        int len = 0;

        NodeList(NodeIterator nodeIterator) {
            this.iter = nodeIterator;
        }

        XNode nodeAt(int n) throws EvalException {
            if (n >= this.len) {
                if (this.nodes == null) {
                    this.nodes = new XNode[n + 4];
                } else if (n >= this.nodes.length) {
                    XNode[] xNodeArray = this.nodes;
                    this.nodes = new XNode[xNodeArray.length * 2];
                    System.arraycopy(xNodeArray, 0, this.nodes, 0, xNodeArray.length);
                }
                while (this.len <= n) {
                    this.nodes[this.len] = this.iter.next();
                    if (this.nodes[this.len] == null) {
                        return null;
                    }
                    ++this.len;
                }
            }
            return this.nodes[n];
        }
    }
}

