/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xed;

import com.xmlmind.util.Console;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.xed.Command;
import com.xmlmind.xml.xed.Constants;
import com.xmlmind.xml.xed.Msg;
import com.xmlmind.xml.xed.Script;
import com.xmlmind.xml.xed.ScriptingSupport;
import com.xmlmind.xml.xpath.ExprContext;
import java.util.Stack;

final class GroupCmd
extends Command {
    private static final String[] ARG_SPEC = new String[]{"tree", "Node", "(context node)"};
    private static final Name CONTAINER_ATTR = Name.get(Constants.GROUP_NAMESPACE, "container");
    private static final Name ID_ATTR = Name.get(Constants.GROUP_NAMESPACE, "id");
    private static final Name NESTING_ATTR = Name.get(Constants.GROUP_NAMESPACE, "nesting");

    GroupCmd() {
    }

    @Override
    public void executeCommand(Object[] objectArray, XNode xNode, ExprContext exprContext, Script script, Console console) throws IllegalArgumentException, RuntimeException {
        objectArray = GroupCmd.parseArguments(objectArray, ARG_SPEC, "group", xNode, exprContext, script);
        Element element = null;
        Node node = (Node)objectArray[0];
        switch (node.getType()) {
            case DOCUMENT: {
                element = ((Document)node).getRootElement();
                break;
            }
            case ELEMENT: {
                element = (Element)node;
            }
        }
        if (element == null) {
            throw new IllegalArgumentException(Msg.msg("cannotEvaluateArgAs", "group", "tree", "Element"));
        }
        Stack<Group> stack = new Stack<Group>();
        this.processSections(element, stack, exprContext, script);
        GroupCmd.removeGroupAttributes(element);
    }

    private void processSections(Element element, Stack<Group> stack, ExprContext exprContext, Script script) throws RuntimeException {
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getType() == Node.Type.ELEMENT) {
                this.processSections((Element)node, stack, exprContext, script);
            }
            node = node2;
        }
        if (GroupCmd.isSection(element)) {
            this.processSection(element, stack, exprContext, script);
        }
    }

    private static boolean isSection(Element element) {
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT || !((Element)node).hasAttribute(CONTAINER_ATTR)) continue;
            return true;
        }
        return false;
    }

    private void processSection(Element element, Stack<Group> stack, ExprContext exprContext, Script script) throws RuntimeException {
        stack.removeAllElements();
        Node node = element.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (node.getType() == Node.Type.ELEMENT) {
                this.processElement((Element)node, stack, exprContext, script);
            } else {
                this.processNode(node, stack, exprContext, script);
            }
            node = node2;
        }
    }

    private void processNode(Node node, Stack<Group> stack, ExprContext exprContext, Script script) {
        Group group = GroupCmd.currentGroup(stack);
        if (group != null) {
            GroupCmd.addMember(group, node, exprContext);
        }
    }

    private void processElement(Element element, Stack<Group> stack, ExprContext exprContext, Script script) throws RuntimeException {
        String string = element.getAttribute(ID_ATTR);
        double d = element.getDoubleAttribute(NESTING_ATTR, 0.0);
        Group group = GroupCmd.currentGroup(stack);
        if (group == null) {
            if (string != null) {
                GroupCmd.pushGroup(null, element, string, d, stack, exprContext, script);
            }
        } else if (string != null) {
            if (string.equals(group.id)) {
                GroupCmd.addMember(group, element, exprContext);
            } else if (d <= group.nesting) {
                group = null;
                while (!stack.empty()) {
                    Group group2 = stack.peek();
                    if (group2.id.equals(string) || group2.nesting < d) {
                        group = group2;
                        break;
                    }
                    stack.pop();
                }
                if (group != null && group.id.equals(string)) {
                    GroupCmd.addMember(group, element, exprContext);
                } else {
                    GroupCmd.pushGroup(group, element, string, d, stack, exprContext, script);
                }
            } else {
                GroupCmd.pushGroup(group, element, string, d, stack, exprContext, script);
            }
        } else {
            if (d <= group.nesting) {
                group = null;
                while (!stack.empty()) {
                    Group group3 = stack.peek();
                    if (group3.nesting < d) {
                        group = group3;
                        break;
                    }
                    stack.pop();
                }
            }
            GroupCmd.addMember(group, element, exprContext);
        }
    }

    private static Group currentGroup(Stack<Group> stack) {
        return stack.empty() ? null : stack.peek();
    }

    private static Element parseContainer(Element element, Script script, int n) throws RuntimeException {
        Element element2 = null;
        String string = element.getAttribute(CONTAINER_ATTR);
        if (string != null) {
            element2 = GroupCmd.createContainer(string, script, n);
        }
        if (element2 == null) {
            String string2 = string == null || string.length() == 0 ? Msg.msg("missingAttribute", CONTAINER_ATTR.format(true, script), element.getXPath()) : Msg.msg("invalidAttribute", string, CONTAINER_ATTR.format(true, script), element.getXPath());
            throw new RuntimeException(string2);
        }
        return element2;
    }

    private static Element createContainer(String string, Script script, int n) {
        String string2;
        String string3;
        int n2;
        string = string.trim();
        if (n >= 0 && string.indexOf("{$nesting}") >= 0) {
            string = StringUtil.replaceAll(string, "{$nesting}", Integer.toString(n));
        }
        if ((n2 = string.indexOf(32)) < 0) {
            string3 = string;
            string2 = null;
        } else {
            string3 = string.substring(0, n2);
            string2 = string.substring(n2 + 1);
        }
        Element element = null;
        Name name = Name.parse(string3, false, script);
        if (name != null) {
            int n3;
            String[] stringArray;
            element = new Element(name);
            if (string2 != null && (stringArray = ProcessingInstruction.parsePseudoAttributes(string2)) != null && (n3 = stringArray.length) > 0) {
                for (int i = 0; i < n3; i += 2) {
                    name = Name.parse(stringArray[i], true, script);
                    if (name == null) {
                        element = null;
                        break;
                    }
                    element.putAttribute(name, XMLText.unescapeXML(stringArray[i + 1]));
                }
            }
        }
        return element;
    }

    private static void pushGroup(Group group, Element element, String string, double d, Stack<Group> stack, ExprContext exprContext, Script script) throws RuntimeException {
        Element element2 = GroupCmd.parseContainer(element, script, stack.size() + 1);
        if (group == null) {
            element.getParent().replaceChild(element, element2);
            element2.appendChild(element);
        } else {
            element.getParent().removeChild(element);
            element2.appendChild(element);
            GroupCmd.doAddMember(group, element2, exprContext);
        }
        Group group2 = new Group(element2, string, d);
        stack.push(group2);
    }

    private static void addMember(Group group, Node node, ExprContext exprContext) {
        if (group != null) {
            node.getParent().removeChild(node);
            GroupCmd.doAddMember(group, node, exprContext);
        }
    }

    private static void doAddMember(Group group, Node node, ExprContext exprContext) {
        Element element = null;
        ScriptingSupport scriptingSupport = (ScriptingSupport)((Object)exprContext);
        block0 : switch (node.getType()) {
            case ELEMENT: {
                Element element2;
                Name name = ((Element)node).getName();
                for (element2 = group.container; element2 != null; element2 = element2.getLastChildElement()) {
                    if (!scriptingSupport.isChildElement(element2.getName(), name)) continue;
                    element = element2;
                    break block0;
                }
                break;
            }
            case TEXT: {
                Element element2;
                while (element2 != null) {
                    if (scriptingSupport.mayContainText(element2.getName())) {
                        element = element2;
                        break block0;
                    }
                    element2 = element2.getLastChildElement();
                }
                break;
            }
        }
        if (element == null) {
            element = group.container;
        }
        element.appendChild(node);
    }

    private static void removeGroupAttributes(Element element) {
        element.removeAttribute(CONTAINER_ATTR);
        element.removeAttribute(ID_ATTR);
        element.removeAttribute(NESTING_ATTR);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            GroupCmd.removeGroupAttributes((Element)node);
        }
    }

    private static final class Group {
        public final Element container;
        public final String id;
        public final double nesting;

        public Group(Element element, String string, double d) {
            this.container = element;
            this.id = string;
            this.nesting = d;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Group[container=");
            stringBuilder.append(this.container.getLocalName());
            stringBuilder.append(", id=");
            stringBuilder.append(this.id);
            stringBuilder.append(", nesting=");
            stringBuilder.append(this.nesting);
            stringBuilder.append(']');
            return stringBuilder.toString();
        }
    }
}

