/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.xed;

import com.xmlmind.util.Console;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.xed.Msg;
import com.xmlmind.xml.xed.Script;
import com.xmlmind.xml.xed.XMLTemplate;
import com.xmlmind.xml.xed.XPathExpr;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.ExprContext;
import com.xmlmind.xml.xpath.NodeIterator;
import com.xmlmind.xml.xpath.Variant;
import com.xmlmind.xml.xpath.VariantExpr;
import java.util.ArrayList;

public abstract class Command {
    protected static final String VAR_ARGS = "...";
    protected static final String NULL_VALUE = "(null value)";
    protected static final String CONTEXT_NODE = "(context node)";
    private static final Element[] NO_ELEMENTS = new Element[0];
    private static final Node[] NO_NODES = new Node[0];
    private static final XNode[] NO_XNODES = new XNode[0];

    protected Command() {
    }

    public abstract void executeCommand(Object[] var1, XNode var2, ExprContext var3, Script var4, Console var5) throws Exception;

    protected static Object[] parseArguments(Object[] objectArray, String[] stringArray, String string, XNode xNode, ExprContext exprContext, Script script) throws IllegalArgumentException {
        Object object;
        String string2;
        int n;
        int n2 = stringArray.length / 3;
        int n3 = objectArray.length;
        Object[] objectArray2 = new Object[Math.max(n2, n3)];
        int n4 = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < n3; ++n) {
            boolean bl3 = n >= n2;
            int n5 = bl3 ? n2 - 1 : n;
            string2 = stringArray[3 * n5];
            object = stringArray[3 * n5 + 1];
            String string3 = stringArray[3 * n5 + 2];
            if (bl3) {
                if (!bl2) {
                    throw new IllegalArgumentException(Msg.msg("tooManyArguments", string));
                }
            } else if (string3 == VAR_ARGS) {
                if (!bl2) {
                    bl2 = true;
                    if (bl) {
                        Command.invalidArgSpec(stringArray, string);
                    }
                } else {
                    Command.invalidArgSpec(stringArray, string);
                }
            } else if (string3 != null) {
                if (!bl) {
                    bl = true;
                    if (bl2) {
                        Command.invalidArgSpec(stringArray, string);
                    }
                }
            } else if (bl2 || bl) {
                Command.invalidArgSpec(stringArray, string);
            }
            Object object2 = objectArray[n];
            Object object3 = null;
            String string4 = null;
            if (object == null) {
                object3 = object2;
            } else {
                try {
                    object3 = object2 instanceof XPathExpr ? Command.parseArgument(string2, (String)object, ((XPathExpr)object2).expr, xNode, exprContext, script) : Command.parseArgument(string2, (String)object, (XMLTemplate)object2, xNode, exprContext, script);
                }
                catch (EvalException evalException) {
                    string4 = ThrowableUtil.reason(evalException);
                }
                if (object3 == null) {
                    Object object4 = Msg.msg("cannotEvaluateArgAs", string, string2, object);
                    if (string4 != null) {
                        object4 = (String)object4 + ": " + string4;
                    }
                    throw new IllegalArgumentException((String)object4);
                }
                if (object3 == NULL_VALUE) {
                    object3 = null;
                }
            }
            objectArray2[n4++] = object3;
        }
        while (n < n2) {
            String string5 = stringArray[3 * n];
            String string6 = stringArray[3 * n + 1];
            string2 = stringArray[3 * n + 2];
            if (string2 == null || string2 == VAR_ARGS) {
                throw new IllegalArgumentException(Msg.msg("tooFewArguments", string));
            }
            object = null;
            if (string2 != NULL_VALUE) {
                if (string6 != null) {
                    object = Command.parseArgument(string5, string6, string2, xNode, script);
                }
                if (object == null) {
                    Command.invalidArgSpec(stringArray, string);
                }
            }
            objectArray2[n4++] = object;
            ++n;
        }
        return objectArray2;
    }

    private static void invalidArgSpec(String[] stringArray, String string) throws IllegalArgumentException {
        throw new IllegalArgumentException(Msg.msg("invalidArgSpec", Command.argSpecToString(stringArray), string));
    }

    private static String argSpecToString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; i += 3) {
            String string = stringArray[i];
            String string2 = stringArray[i + 1];
            String string3 = stringArray[i + 2];
            if (i > 0) {
                stringBuilder.append("; ");
            }
            stringBuilder.append(string);
            stringBuilder.append(" : ");
            stringBuilder.append(string2 == null ? "-" : string2);
            if (string3 == VAR_ARGS) {
                stringBuilder.append(' ');
                stringBuilder.append(VAR_ARGS);
                continue;
            }
            stringBuilder.append(" : ");
            if (string3 == CONTEXT_NODE) {
                stringBuilder.append(CONTEXT_NODE);
                continue;
            }
            if (string3 != null) {
                char c = string3.indexOf(34) >= 0 ? (char)'\'' : '\"';
                stringBuilder.append(c);
                stringBuilder.append(string3);
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append('-');
        }
        return stringBuilder.toString();
    }

    private static Object parseArgument(String string, String string2, VariantExpr variantExpr, XNode xNode, ExprContext exprContext, Script script) throws EvalException {
        Variant variant = variantExpr.eval(xNode, exprContext);
        Object object = null;
        if ("String".equals(string2)) {
            object = variant.convertToString();
        } else if (string2.endsWith("Name")) {
            boolean bl = "Name".equals(string2);
            object = Name.parse(variant.convertToString(), bl, script);
        } else if ("Boolean".equals(string2)) {
            object = variant.convertToBoolean() ? Boolean.TRUE : Boolean.FALSE;
        } else if ("Double".equals(string2) || string2.endsWith("Integer")) {
            double d = variant.convertToNumber();
            if ("Double".equals(string2)) {
                object = d;
            } else {
                int n = (int)Math.rint(d);
                Integer n2 = n;
                if ("PositiveInteger".equals(string2)) {
                    if (n < 1) {
                        n2 = null;
                    }
                } else if ("NonNegativeInteger".equals(string2)) {
                    if (n < 0) {
                        n2 = null;
                    }
                } else if ("NonPositiveInteger".equals(string2)) {
                    if (n > 0) {
                        n2 = null;
                    }
                } else if ("NegativeInteger".equals(string2) && n > -1) {
                    n2 = null;
                }
                object = n2;
            }
        } else if ("Object".equals(string2)) {
            object = variant.convertToObject();
        } else if (string2.startsWith("Element") || string2.startsWith("Node") || string2.startsWith("XNode")) {
            XNode xNode2;
            boolean bl = string2.startsWith("Element");
            boolean bl2 = string2.startsWith("Node");
            boolean bl3 = !string2.endsWith("*") && !string2.endsWith("+");
            XNode xNode3 = null;
            ArrayList<XNode> arrayList = null;
            Node node = null;
            ArrayList<Node> arrayList2 = null;
            Element element = null;
            ArrayList<Element> arrayList3 = null;
            NodeIterator nodeIterator = variant.convertToNodeSet();
            while ((xNode2 = nodeIterator.next()) != null) {
                switch (xNode2.type()) {
                    case ATTRIBUTE: {
                        if (bl2) {
                            return null;
                        }
                    }
                    case TEXT: 
                    case COMMENT: 
                    case PROCESSING_INSTRUCTION: 
                    case DOCUMENT_TYPE_DECLARATION: 
                    case DOCUMENT: {
                        if (bl) {
                            return null;
                        }
                    }
                    case ELEMENT: {
                        if (bl) {
                            if (element == null) {
                                element = (Element)xNode2;
                                break;
                            }
                            if (arrayList3 == null) {
                                arrayList3 = new ArrayList<Element>();
                                arrayList3.add(element);
                            }
                            arrayList3.add((Element)xNode2);
                            break;
                        }
                        if (bl2) {
                            if (node == null) {
                                node = (Node)xNode2;
                                break;
                            }
                            if (arrayList2 == null) {
                                arrayList2 = new ArrayList<Node>();
                                arrayList2.add(node);
                            }
                            arrayList2.add((Node)xNode2);
                            break;
                        }
                        if (xNode3 == null) {
                            xNode3 = xNode2;
                            break;
                        }
                        if (arrayList == null) {
                            arrayList = new ArrayList<XNode>();
                            arrayList.add(xNode3);
                        }
                        arrayList.add(xNode2);
                    }
                }
                if (!bl3) continue;
                break;
            }
            if (bl) {
                if (!bl3) {
                    if (arrayList3 != null) {
                        return arrayList3.toArray(NO_ELEMENTS);
                    }
                    if (element != null) {
                        return new Element[]{element};
                    }
                    return string2.endsWith("*") ? NO_ELEMENTS : null;
                }
                if (arrayList3 != null) {
                    return arrayList3.get(0);
                }
                if (element != null) {
                    return element;
                }
                return string2.endsWith("?") ? NULL_VALUE : null;
            }
            if (bl2) {
                if (!bl3) {
                    if (arrayList2 != null) {
                        return arrayList2.toArray(NO_NODES);
                    }
                    if (node != null) {
                        return new Node[]{node};
                    }
                    return string2.endsWith("*") ? NO_NODES : null;
                }
                if (arrayList2 != null) {
                    return arrayList2.get(0);
                }
                if (node != null) {
                    return node;
                }
                return string2.endsWith("?") ? NULL_VALUE : null;
            }
            if (!bl3) {
                if (arrayList != null) {
                    return arrayList.toArray(NO_XNODES);
                }
                if (xNode3 != null) {
                    return new XNode[]{xNode3};
                }
                return string2.endsWith("*") ? NO_XNODES : null;
            }
            if (arrayList != null) {
                return arrayList.get(0);
            }
            if (xNode3 != null) {
                return xNode3;
            }
            return string2.endsWith("?") ? NULL_VALUE : null;
        }
        return object;
    }

    private static Object parseArgument(String string, String string2, XMLTemplate xMLTemplate, XNode xNode, ExprContext exprContext, Script script) throws EvalException {
        Object object = null;
        if ("String".equals(string2)) {
            PrefixEntry[] prefixEntryArray = script.getNamespacePrefixes();
            object = xMLTemplate.format(true, prefixEntryArray);
        } else if (string2.startsWith("Element")) {
            Element element = xMLTemplate.expand(xNode, exprContext);
            object = string2.endsWith("*") || string2.endsWith("+") ? new Element[]{element} : element;
        } else if (string2.startsWith("Node")) {
            Element element = xMLTemplate.expand(xNode, exprContext);
            object = string2.endsWith("*") || string2.endsWith("+") ? new Node[]{element} : element;
        } else if (string2.startsWith("XNode")) {
            Element element = xMLTemplate.expand(xNode, exprContext);
            object = string2.endsWith("*") || string2.endsWith("+") ? new XNode[]{element} : element;
        }
        return object;
    }

    private static Object parseArgument(String string, String string2, String string3, XNode xNode, Script script) {
        Object object = null;
        if ("String".equals(string2)) {
            object = string3;
        } else if (string2.endsWith("Name")) {
            boolean bl = "Name".equals(string2);
            object = Name.parse(string3, bl, script);
        } else if ("Boolean".equals(string2)) {
            if ("false".equals(string3)) {
                object = Boolean.FALSE;
            } else if ("true".equals(string3)) {
                object = Boolean.TRUE;
            }
        } else if ("Double".equals(string2)) {
            try {
                object = Double.valueOf(string3);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (string2.endsWith("Integer")) {
            Integer n = null;
            try {
                n = Integer.valueOf(string3);
                int n2 = n;
                if ("PositiveInteger".equals(string2)) {
                    if (n2 < 1) {
                        n = null;
                    }
                } else if ("NonNegativeInteger".equals(string2)) {
                    if (n2 < 0) {
                        n = null;
                    }
                } else if ("NonPositiveInteger".equals(string2)) {
                    if (n2 > 0) {
                        n = null;
                    }
                } else if ("NegativeInteger".equals(string2) && n2 > -1) {
                    n = null;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            object = n;
        } else if ((string2.startsWith("Element") || string2.startsWith("Node") || string2.startsWith("XNode")) && string3 == CONTEXT_NODE) {
            if (string2.startsWith("Element")) {
                if (xNode.type() == XNode.Type.ELEMENT) {
                    object = string2.endsWith("*") || string2.endsWith("+") ? new Element[]{(Element)xNode} : xNode;
                }
            } else if (string2.startsWith("Node")) {
                if (xNode.type() != XNode.Type.ATTRIBUTE) {
                    object = string2.endsWith("*") || string2.endsWith("+") ? new Node[]{(Node)xNode} : xNode;
                }
            } else {
                object = string2.endsWith("*") || string2.endsWith("+") ? new XNode[]{xNode} : xNode;
            }
        }
        return object;
    }

    protected void illegalArgument(String string, String string2, String string3) throws IllegalArgumentException {
        throw new IllegalArgumentException(Msg.msg("illegalArgument", string, string2, string3));
    }
}

