/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.validate;

import com.xmlmind.util.IdentityLinearHashtable;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.validate.AttributeType;
import com.xmlmind.xml.validate.CommentItem;
import com.xmlmind.xml.validate.ContentType;
import com.xmlmind.xml.validate.Data;
import com.xmlmind.xml.validate.DataType;
import com.xmlmind.xml.validate.DocumentTypeUtil;
import com.xmlmind.xml.validate.ElementType;
import com.xmlmind.xml.validate.Field;
import com.xmlmind.xml.validate.IDDataType;
import com.xmlmind.xml.validate.Item;
import com.xmlmind.xml.validate.ProcessingInstructionItem;
import com.xmlmind.xml.validate.SchemaKind;
import com.xmlmind.xml.validate.Structure;
import com.xmlmind.xml.validate.TextItem;
import com.xmlmind.xml.wxs.datatype.AnyURIType;
import com.xmlmind.xml.wxs.datatype.BooleanType;
import com.xmlmind.xml.wxs.datatype.ListType;
import com.xmlmind.xml.wxs.datatype.QNameType;
import com.xmlmind.xml.wxs.validate.AllParticle;
import com.xmlmind.xml.wxs.validate.AttributeDeclaration;
import com.xmlmind.xml.wxs.validate.AttributeUse;
import com.xmlmind.xml.wxs.validate.ChoiceParticle;
import com.xmlmind.xml.wxs.validate.ComplexType;
import com.xmlmind.xml.wxs.validate.ElementDeclaration;
import com.xmlmind.xml.wxs.validate.ElementParticle;
import com.xmlmind.xml.wxs.validate.FieldImpl;
import com.xmlmind.xml.wxs.validate.NameList;
import com.xmlmind.xml.wxs.validate.NameWildcard;
import com.xmlmind.xml.wxs.validate.Particle;
import com.xmlmind.xml.wxs.validate.Schema;
import com.xmlmind.xml.wxs.validate.SequenceParticle;
import com.xmlmind.xml.wxs.validate.SimpleList;
import com.xmlmind.xml.wxs.validate.SimpleType;
import com.xmlmind.xml.wxs.validate.Type;
import com.xmlmind.xml.wxs.validate.Wildcard;
import com.xmlmind.xml.wxs.validate.WildcardParticle;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

final class ElementTypeImpl
implements ElementType {
    private static final FieldImpl[] NO_FIELDS;
    private static IdentityLinearHashtable<Name, FieldImpl> NO_FIELD_MAP;
    private static final FieldImpl[] XSI_FIELDS1;
    private static IdentityLinearHashtable<Name, FieldImpl> XSI_FIELD_MAP1;
    private static final FieldImpl[] XSI_FIELDS2;
    private static IdentityLinearHashtable<Name, FieldImpl> XSI_FIELD_MAP2;
    private static final XSIAttributeType XSI_NIL_ATTRIBUTE;
    private static final XSIAttributeType XSI_TYPE_ATTRIBUTE;
    private static final XSIAttributeType XSI_SCHEMA_LOCATION_ATTRIBUTE;
    private static final XSIAttributeType XSI_NO_NAMESPACE_SCHEMA_LOCATION_ATTRIBUTE;
    private static ParticleWeightCompare particleWeightCompare;
    private static final Name TYPE_PROPERTY;
    public final Schema schema;
    public final ElementDeclaration decl;
    public final Type type;
    private ContentType contentType = ContentType.OTHER;
    private FieldImpl[] attributeFields;
    private IdentityLinearHashtable<Name, FieldImpl> nameToAttributeField;
    private int firstAttributeWildcard = -1;
    private int requiredAttributeCount = -1;
    private FieldImpl[] childElementFields;
    private IdentityLinearHashtable<Name, FieldImpl> nameToChildElementField;
    private int firstChildElementWildcard = -1;
    private SimpleList nameOrItemList = new SimpleList();
    private NameList nameList = new NameList();
    private static final CompareWildcardFieldBySpecificity compareWildcardFieldBySpecificity;
    private static final SpaceItem SPACE_ITEM;

    public ElementTypeImpl(Schema schema, ElementDeclaration elementDeclaration, Type type) {
        this.schema = schema;
        this.decl = elementDeclaration;
        if (type == null) {
            type = elementDeclaration.type;
        }
        this.type = type;
    }

    @Override
    public ContentType getElementContentType() {
        if (this.contentType == ContentType.OTHER) {
            this.initContentType();
        }
        return this.contentType;
    }

    private void initContentType() {
        if (this.type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)this.type;
            switch (complexType.getContentType()) {
                case EMPTY: {
                    this.contentType = ContentType.EMPTY;
                    break;
                }
                case DATA: {
                    this.contentType = ContentType.DATA;
                    break;
                }
                case ELEMENT_ONLY: {
                    this.contentType = ContentType.ELEMENT_ONLY;
                    break;
                }
                case MIXED: {
                    this.contentType = ContentType.MIXED1;
                }
            }
            if (this.contentType == ContentType.MIXED1 && ElementTypeImpl.isMixed2(complexType.getParticle())) {
                this.contentType = ContentType.MIXED2;
            }
        } else {
            this.contentType = ContentType.DATA;
        }
    }

    private static final boolean isMixed2(Particle particle) {
        if (particle == null) {
            return true;
        }
        switch (particle.getType()) {
            case CHOICE: {
                Particle[] particleArray = ((ChoiceParticle)particle).getParticles();
                if (particleArray.length != 0) break;
                return true;
            }
            case SEQUENCE: {
                Particle[] particleArray = ((SequenceParticle)particle).getParticles();
                if (particleArray.length != 0) break;
                return true;
            }
            case ALL: {
                Particle[] particleArray = ((AllParticle)particle).getParticles();
                if (particleArray.length != 0) break;
                return true;
            }
        }
        return ElementTypeImpl.isUnconstrainedChoice(particle);
    }

    private static final boolean isUnconstrainedChoice(Particle particle) {
        int n = particle.getMinOccurs();
        int n2 = particle.getMaxOccurs();
        switch (particle.getType()) {
            case CHOICE: {
                Particle[] particleArray = ((ChoiceParticle)particle).getParticles();
                if (n == 1 && n2 == 1) {
                    return particleArray.length == 1 && ElementTypeImpl.isUnconstrainedChoice(particleArray[0]);
                }
                if (n == 0 && n2 == -1) {
                    boolean bl = true;
                    for (int i = 0; i < particleArray.length; ++i) {
                        Particle particle2 = particleArray[i];
                        if (ElementTypeImpl.isUnconstrainedChoice2(particle2)) continue;
                        bl = false;
                        break;
                    }
                    return bl;
                }
                return false;
            }
            case SEQUENCE: {
                Particle[] particleArray = ((SequenceParticle)particle).getParticles();
                if (particleArray.length != 1) {
                    return false;
                }
                if (n == 1 && n2 == 1) {
                    return ElementTypeImpl.isUnconstrainedChoice(particleArray[0]);
                }
                if (n == 0 && n2 == -1) {
                    return ElementTypeImpl.isUnconstrainedChoice2(particleArray[0]);
                }
                return false;
            }
            case ALL: {
                Particle[] particleArray = ((AllParticle)particle).getParticles();
                if (particleArray.length != 1) {
                    return false;
                }
                if (n == 1 && n2 == 1) {
                    return ElementTypeImpl.isUnconstrainedChoice(particleArray[0]);
                }
                if (n == 0 && n2 == -1) {
                    return ElementTypeImpl.isUnconstrainedChoice2(particleArray[0]);
                }
                return false;
            }
        }
        return n == 0 && n2 == -1;
    }

    private static final boolean isUnconstrainedChoice2(Particle particle) {
        int n = particle.getMinOccurs();
        int n2 = particle.getMaxOccurs();
        if (n != 0 && n != 1 || n2 != 1 && n2 != -1) {
            return false;
        }
        switch (particle.getType()) {
            case CHOICE: {
                Particle[] particleArray = ((ChoiceParticle)particle).getParticles();
                boolean bl = true;
                for (int i = 0; i < particleArray.length; ++i) {
                    Particle particle2 = particleArray[i];
                    if (ElementTypeImpl.isUnconstrainedChoice2(particle2)) continue;
                    bl = false;
                    break;
                }
                return bl;
            }
            case SEQUENCE: {
                Particle[] particleArray = ((SequenceParticle)particle).getParticles();
                if (particleArray.length == 1) {
                    return ElementTypeImpl.isUnconstrainedChoice2(particleArray[0]);
                }
                return false;
            }
            case ALL: {
                Particle[] particleArray = ((AllParticle)particle).getParticles();
                if (particleArray.length == 1) {
                    return ElementTypeImpl.isUnconstrainedChoice2(particleArray[0]);
                }
                return false;
            }
        }
        return true;
    }

    @Override
    public DataType getElementDataType() {
        return this.type.getDataType();
    }

    @Override
    public Object getElementDefaultValue() {
        return this.decl.defaultValue;
    }

    @Override
    public Object getElementFixedValue() {
        return this.decl.isFixedValue ? this.decl.defaultValue : null;
    }

    @Override
    public Field[] getAttributeFields() {
        if (this.attributeFields == null) {
            this.initAttributeFields();
        }
        return this.attributeFields;
    }

    private void initAttributeFields() {
        boolean bl;
        boolean bl2 = bl = this.schema.getSchemaKind() == SchemaKind.DTD;
        if (this.type instanceof ComplexType) {
            Object object;
            ComplexType complexType = (ComplexType)this.type;
            AttributeUse[] attributeUseArray = complexType.getAttributeUses();
            Wildcard wildcard = complexType.getAttributeWildcard();
            int n = attributeUseArray.length;
            boolean bl3 = false;
            if (!bl) {
                bl3 = this.decl.isNillable;
                n = bl3 ? (n += XSI_FIELDS2.length) : (n += XSI_FIELDS1.length);
            }
            this.firstAttributeWildcard = n++;
            if (wildcard != null) {
                // empty if block
            }
            this.attributeFields = new FieldImpl[n];
            this.nameToAttributeField = new IdentityLinearHashtable();
            this.requiredAttributeCount = 0;
            int n2 = attributeUseArray.length;
            for (int i = 0; i < n2; ++i) {
                FieldImpl fieldImpl;
                AttributeUse attributeUse = attributeUseArray[i];
                object = attributeUse.name;
                boolean bl4 = attributeUse.isRequired;
                this.attributeFields[i] = fieldImpl = new FieldImpl((Name)object, bl4);
                this.nameToAttributeField.put((Name)object, fieldImpl);
                if (!bl4) continue;
                ++this.requiredAttributeCount;
            }
            if (!bl) {
                FieldImpl[] fieldImplArray = bl3 ? XSI_FIELDS2 : XSI_FIELDS1;
                System.arraycopy(fieldImplArray, 0, this.attributeFields, n2, fieldImplArray.length);
                n2 += fieldImplArray.length;
                for (int i = 0; i < fieldImplArray.length; ++i) {
                    object = fieldImplArray[i];
                    this.nameToAttributeField.put(((FieldImpl)object).name, (FieldImpl)object);
                }
            }
            if (wildcard != null) {
                this.attributeFields[n2] = new FieldImpl(wildcard.nameWildcard, false);
            }
        } else {
            if (bl) {
                this.attributeFields = NO_FIELDS;
                this.nameToAttributeField = NO_FIELD_MAP;
            } else if (this.decl.isNillable) {
                this.attributeFields = XSI_FIELDS2;
                this.nameToAttributeField = XSI_FIELD_MAP2;
            } else {
                this.attributeFields = XSI_FIELDS1;
                this.nameToAttributeField = XSI_FIELD_MAP1;
            }
            this.requiredAttributeCount = 0;
            this.firstAttributeWildcard = this.attributeFields.length;
        }
    }

    @Override
    public void getAttributeFields(Name name, List<Field> list) {
        FieldImpl fieldImpl;
        list.clear();
        if (this.attributeFields == null) {
            this.initAttributeFields();
        }
        if ((fieldImpl = this.nameToAttributeField.get(name)) != null) {
            list.add(fieldImpl);
        }
        if (this.firstAttributeWildcard < this.attributeFields.length && this.attributeFields[this.firstAttributeWildcard].nameWildcard.match(name)) {
            list.add(this.attributeFields[this.firstAttributeWildcard]);
        }
    }

    @Override
    public boolean isRequiredAttribute(Field field) {
        return ((FieldImpl)field).isRequired;
    }

    @Override
    public Data getAttributeDefaultValue(Name name) {
        FieldImpl fieldImpl;
        if (this.attributeFields == null) {
            this.initAttributeFields();
        }
        if ((fieldImpl = this.nameToAttributeField.get(name)) == null) {
            return null;
        }
        if (this.type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)this.type;
            AttributeDeclaration attributeDeclaration = complexType.getAttributeDeclaration(name);
            if (attributeDeclaration == null) {
                attributeDeclaration = this.schema.getAttributeDeclaration(name);
            }
            if (attributeDeclaration == null) {
                return null;
            }
            return attributeDeclaration.defaultValue;
        }
        return null;
    }

    @Override
    public Field[] getChildElementFields() {
        if (this.childElementFields == null) {
            this.initChildElementFields();
        }
        return this.childElementFields;
    }

    private void initChildElementFields() {
        if (this.type instanceof ComplexType) {
            int n;
            ComplexType complexType = (ComplexType)this.type;
            Name[] nameArray = complexType.getElementFields();
            Wildcard[] wildcardArray = complexType.getElementWildcards();
            int n2 = nameArray.length;
            this.childElementFields = new FieldImpl[n2 + wildcardArray.length];
            this.nameToChildElementField = new IdentityLinearHashtable();
            this.firstChildElementWildcard = n2;
            for (n = 0; n < n2; ++n) {
                FieldImpl fieldImpl;
                Name name = nameArray[n];
                this.childElementFields[n] = fieldImpl = new FieldImpl(name);
                this.nameToChildElementField.put(name, fieldImpl);
            }
            for (n = 0; n < wildcardArray.length; ++n) {
                this.childElementFields[n2++] = new FieldImpl(wildcardArray[n].nameWildcard);
            }
            if (wildcardArray.length > 1) {
                Arrays.sort(this.childElementFields, nameArray.length, nameArray.length + wildcardArray.length, compareWildcardFieldBySpecificity);
            }
        } else {
            this.childElementFields = NO_FIELDS;
            this.nameToChildElementField = NO_FIELD_MAP;
            this.firstChildElementWildcard = NO_FIELDS.length;
        }
    }

    @Override
    public void getChildElementFields(Name name, List<Field> list) {
        FieldImpl fieldImpl;
        list.clear();
        if (this.childElementFields == null) {
            this.initChildElementFields();
        }
        if ((fieldImpl = this.nameToChildElementField.get(name)) != null) {
            list.add(fieldImpl);
        }
        for (int i = this.firstChildElementWildcard; i < this.childElementFields.length; ++i) {
            if (!this.childElementFields[i].nameWildcard.match(name)) continue;
            list.add(this.childElementFields[i]);
        }
    }

    @Override
    public boolean canCheckAttributeStructure() {
        return true;
    }

    @Override
    public boolean checkStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
        return this.checkAttributeStructure(fieldArray, n, itemArray, n2) && this.checkElementStructure(fieldArray, n, itemArray, n2);
    }

    @Override
    public boolean checkAttributeStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
        this.fieldsToNames(fieldArray, n, this.nameOrItemList);
        return this.checkAttributes(this.nameOrItemList, null);
    }

    @Override
    public boolean checkElementStructure(Field[] fieldArray, int n, Item[] itemArray, int n2) {
        this.fieldsToNames(itemArray, n2, this.nameOrItemList);
        return this.checkChildNodes(this.nameOrItemList, false, null);
    }

    private void fieldsToNames(Item[] itemArray, int n, SimpleList simpleList) {
        simpleList.clear();
        for (int i = 0; i < n; ++i) {
            Item item = itemArray[i];
            if (item instanceof Field) {
                FieldImpl fieldImpl = (FieldImpl)item;
                if (fieldImpl.name != null) {
                    simpleList.add(fieldImpl.name);
                    continue;
                }
                simpleList.add(fieldImpl.nameWildcard.getSampleName());
                continue;
            }
            simpleList.add(item);
        }
    }

    private boolean checkAttributes(SimpleList simpleList, Structure structure) {
        if (this.attributeFields == null) {
            this.initAttributeFields();
        }
        int n = 0;
        for (int i = 0; i < simpleList.size; ++i) {
            Name name = (Name)simpleList.list[i];
            FieldImpl fieldImpl = this.nameToAttributeField.get(name);
            if (fieldImpl == null && this.firstAttributeWildcard < this.attributeFields.length && this.attributeFields[this.firstAttributeWildcard].nameWildcard.match(name)) {
                fieldImpl = this.attributeFields[this.firstAttributeWildcard];
            }
            if (fieldImpl == null) {
                return false;
            }
            if (fieldImpl.isRequired) {
                ++n;
            }
            if (structure == null) continue;
            structure.addAttributeField(name, fieldImpl);
        }
        return n == this.requiredAttributeCount;
    }

    private boolean checkChildNodes(SimpleList simpleList, boolean bl, Structure structure) {
        if (this.childElementFields == null) {
            this.initChildElementFields();
        }
        boolean bl2 = false;
        this.nameList.clear();
        for (int i = 0; i < simpleList.size; ++i) {
            Object object;
            Object object2 = simpleList.list[i];
            if (object2 instanceof Name) {
                object = (Name)object2;
                FieldImpl fieldImpl = this.nameToChildElementField.get((Name)object);
                if (fieldImpl == null) {
                    for (int j = this.firstChildElementWildcard; j < this.childElementFields.length; ++j) {
                        if (!this.childElementFields[j].nameWildcard.match((Name)object)) continue;
                        fieldImpl = this.childElementFields[j];
                        break;
                    }
                }
                if (fieldImpl == null) {
                    return false;
                }
                this.nameList.add((Name)object);
                if (structure == null) continue;
                structure.addChildNodeItem(fieldImpl);
                continue;
            }
            object = (Item)object2;
            if (object == TextItem.INSTANCE) {
                bl2 = true;
            } else if (object == SPACE_ITEM) {
                if (!bl) {
                    bl2 = true;
                }
                object = TextItem.INSTANCE;
            }
            if (structure == null) continue;
            structure.addChildNodeItem((Item)object);
        }
        if (this.type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)this.type;
            switch (complexType.getContentType()) {
                case DATA: 
                case MIXED: {
                    break;
                }
                default: {
                    if (!bl2) break;
                    return false;
                }
            }
            if (complexType.getParticle() == null) {
                return this.nameList.size == 0;
            }
            return complexType.checkNameSequence(this.nameList.list, this.nameList.size);
        }
        return this.nameList.size == 0;
    }

    @Override
    public boolean getStructure(Element element, boolean bl, Structure structure) {
        structure.clear();
        return this.doGetAttributeStructure(element, structure) && this.doGetElementStructure(element, bl, structure);
    }

    @Override
    public boolean getAttributeStructure(Element element, boolean bl, Structure structure) {
        structure.clear();
        return this.doGetAttributeStructure(element, structure);
    }

    @Override
    public boolean getElementStructure(Element element, boolean bl, Structure structure) {
        structure.clear();
        return this.doGetElementStructure(element, bl, structure);
    }

    private boolean doGetAttributeStructure(Element element, Structure structure) {
        this.nameOrItemList.clear();
        if (element.getAttributeCount() > 0) {
            Iterator<Attribute> iterator = element.getAttributes();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                this.nameOrItemList.add(attribute.name);
            }
        }
        return this.checkAttributes(this.nameOrItemList, structure);
    }

    private boolean doGetElementStructure(Element element, boolean bl, Structure structure) {
        this.nameOrItemList.clear();
        block5: for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getType()) {
                case COMMENT: {
                    this.nameOrItemList.add(CommentItem.INSTANCE);
                    continue block5;
                }
                case PROCESSING_INSTRUCTION: {
                    this.nameOrItemList.add(ProcessingInstructionItem.INSTANCE);
                    continue block5;
                }
                case TEXT: {
                    if (((Text)node).isXMLSpace()) {
                        this.nameOrItemList.add(SPACE_ITEM);
                        continue block5;
                    }
                    this.nameOrItemList.add(TextItem.INSTANCE);
                    continue block5;
                }
                default: {
                    this.nameOrItemList.add(((Element)node).getName());
                }
            }
        }
        return this.checkChildNodes(this.nameOrItemList, bl, structure);
    }

    @Override
    public boolean getStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        structure.clear();
        return this.doGetAttributeStructure(attributeArray, n, nodeArray, n2, structure) && this.doGetElementStructure(attributeArray, n, nodeArray, n2, bl, structure);
    }

    @Override
    public boolean getAttributeStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        structure.clear();
        return this.doGetAttributeStructure(attributeArray, n, nodeArray, n2, structure);
    }

    @Override
    public boolean getElementStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        structure.clear();
        return this.doGetElementStructure(attributeArray, n, nodeArray, n2, bl, structure);
    }

    private boolean doGetAttributeStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, Structure structure) {
        this.nameOrItemList.clear();
        for (int i = 0; i < n; ++i) {
            this.nameOrItemList.add(attributeArray[i].name);
        }
        return this.checkAttributes(this.nameOrItemList, structure);
    }

    private boolean doGetElementStructure(Attribute[] attributeArray, int n, Node[] nodeArray, int n2, boolean bl, Structure structure) {
        this.nameOrItemList.clear();
        block5: for (int i = 0; i < n2; ++i) {
            Node node = nodeArray[i];
            switch (node.getType()) {
                case COMMENT: {
                    this.nameOrItemList.add(CommentItem.INSTANCE);
                    continue block5;
                }
                case PROCESSING_INSTRUCTION: {
                    this.nameOrItemList.add(ProcessingInstructionItem.INSTANCE);
                    continue block5;
                }
                case TEXT: {
                    if (((Text)node).isXMLSpace()) {
                        this.nameOrItemList.add(SPACE_ITEM);
                        continue block5;
                    }
                    this.nameOrItemList.add(TextItem.INSTANCE);
                    continue block5;
                }
                default: {
                    this.nameOrItemList.add(((Element)node).getName());
                }
            }
        }
        return this.checkChildNodes(this.nameOrItemList, bl, structure);
    }

    @Override
    public AttributeType getAttributeType(Field field, Name name) {
        ComplexType complexType;
        AttributeType attributeType = null;
        if (this.type instanceof ComplexType && (attributeType = (complexType = (ComplexType)this.type).getAttributeDeclaration(name)) == null) {
            attributeType = this.schema.getAttributeDeclaration(name);
        }
        if (attributeType == null) {
            if (name == Name.XSI_NIL) {
                attributeType = XSI_NIL_ATTRIBUTE;
            } else if (name == Name.XSI_TYPE) {
                attributeType = XSI_TYPE_ATTRIBUTE;
            } else if (name == Name.XSI_SCHEMA_LOCATION) {
                attributeType = XSI_SCHEMA_LOCATION_ATTRIBUTE;
            } else if (name == Name.XSI_NO_NAMESPACE_SCHEMA_LOCATION) {
                attributeType = XSI_NO_NAMESPACE_SCHEMA_LOCATION_ATTRIBUTE;
            }
        }
        return attributeType;
    }

    @Override
    public ElementType getChildElementType(Field field, Name name) {
        return this.doGetChildElementType(field, name, null);
    }

    @Override
    public ElementType getChildElementType(Field field, Element element) {
        return this.doGetChildElementType(field, element.getName(), element);
    }

    private ElementType doGetChildElementType(Field field, Name name, Element element) {
        if (this.type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)this.type;
            ElementDeclaration elementDeclaration = complexType.getElementDeclaration(name);
            if (elementDeclaration == null) {
                elementDeclaration = this.schema.getElementDeclaration(name);
            }
            if (elementDeclaration == null) {
                return null;
            }
            return new ElementTypeImpl(this.schema, elementDeclaration, element == null ? null : this.schema.getElementLocalType(element));
        }
        return null;
    }

    @Override
    public Element createInstance(Name name, int n) {
        Element element = new Element(name);
        if ((n & 4) != 0) {
            this.addChildren(element, this.type, n);
            element.removeProperties(Node.ALL_PROPERTIES, true);
        } else {
            this.addChildText(element, this.type);
        }
        if ((n & 1) != 0) {
            this.addRequiredAttributes(element, this.type, n);
        }
        return element;
    }

    private void addChildText(Element element, Type type) {
        if (type == null) {
            return;
        }
        if (type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)type;
            switch (complexType.getContentType()) {
                case DATA: 
                case MIXED: {
                    element.appendChild(new Text());
                }
            }
        } else {
            element.appendChild(new Text());
        }
    }

    private boolean addChildren(Element element, Type type, int n) {
        if (type == null) {
            return true;
        }
        element.putProperty(TYPE_PROPERTY, type);
        if (type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)type;
            ComplexType.ContentType contentType = complexType.getContentType();
            switch (contentType) {
                case EMPTY: {
                    return true;
                }
                case DATA: {
                    element.appendChild(new Text());
                    return true;
                }
            }
            boolean bl = this.addChildren(element, complexType, complexType.getParticle(), n);
            if (bl && element.hasNoContent()) {
                if (contentType == ComplexType.ContentType.MIXED) {
                    element.appendChild(new Text());
                } else if ((n & 0x40) != 0 && (n & 0x10) != 0 && (n & 8) != 0 && (n & 4) != 0) {
                    Particle particle = complexType.getParticle().copy();
                    this.makeNonEmptiable(particle, complexType);
                    bl = this.addChildren(element, complexType, particle, n);
                }
            }
            return bl;
        }
        element.appendChild(new Text());
        return true;
    }

    private void makeNonEmptiable(Particle particle, ComplexType complexType) {
        int n;
        if (particle.getMinOccurs() == 0 && ((n = particle.getMaxOccurs()) > 0 || n == -1)) {
            particle.setOccurs(1, n);
        }
        Particle.Type type = particle.getType();
        switch (type) {
            case ELEMENT: 
            case WILDCARD: {
                break;
            }
            case CHOICE: {
                Particle[] particleArray = ((ChoiceParticle)particle).getParticles();
                for (int i = 0; i < particleArray.length; ++i) {
                    this.makeNonEmptiable(particleArray[i], complexType);
                }
                break;
            }
            case SEQUENCE: 
            case ALL: {
                Particle[] particleArray = type == Particle.Type.SEQUENCE ? ((SequenceParticle)particle).getParticles() : ((AllParticle)particle).getParticles();
                if (particleArray.length == 1) {
                    this.makeNonEmptiable(particleArray[0], complexType);
                    break;
                }
                if (particleArray.length <= 1) break;
                ParticleWeight[] particleWeightArray = new ParticleWeight[particleArray.length];
                for (int i = 0; i < particleArray.length; ++i) {
                    Particle particle2 = particleArray[i];
                    int n2 = particle2.getMinOccurs();
                    int n3 = particle2.getMaxOccurs();
                    int n4 = n3 > 0 || n3 == -1 ? n3 : 1;
                    particle2.setOccurs(1, n4);
                    ParticleWeight particleWeight = new ParticleWeight();
                    particleWeight.particle = particle2;
                    particleWeight.weight = this.particleWeight(complexType, particle2);
                    particleWeightArray[i] = particleWeight;
                    particle2.setOccurs(n2, n3);
                }
                Arrays.sort(particleWeightArray, particleWeightCompare);
                this.makeNonEmptiable(particleWeightArray[0].particle, complexType);
            }
        }
    }

    private boolean addChildren(Element element, ComplexType complexType, Particle particle, int n) {
        boolean bl = true;
        int n2 = particle.getMinOccurs();
        if (n2 > 0) {
            int n3;
            int n4;
            int n5 = element.getChildCount();
            Particle.Type type = particle.getType();
            block0 : switch (type) {
                case ELEMENT: {
                    Object object = this.getElementNameAndType(complexType, (ElementParticle)particle);
                    bl = this.addChild(element, object.name, object.type, n);
                    break;
                }
                case WILDCARD: {
                    Object object = this.getElementNameAndType(complexType, (WildcardParticle)particle);
                    bl = this.addChild(element, object.name, object.type, n);
                    break;
                }
                case CHOICE: {
                    Object object = ((ChoiceParticle)particle).getParticles();
                    if (((Particle[])object).length == 0) {
                        bl = true;
                        break;
                    }
                    if (((Particle[])object).length == 1 || (n & 8) != 0) {
                        bl = false;
                        if ((n & 0x10) != 0) {
                            Object object2;
                            int n6;
                            ParticleWeight[] particleWeightArray = new ParticleWeight[((Particle[])object).length];
                            for (n6 = 0; n6 < ((Particle[])object).length; ++n6) {
                                object2 = object[n6];
                                ParticleWeight particleWeight = new ParticleWeight();
                                particleWeight.particle = object2;
                                particleWeight.weight = this.particleWeight(complexType, (Particle)object2);
                                if (particleWeight.weight == 0.0) {
                                    bl = true;
                                    break;
                                }
                                particleWeightArray[n6] = particleWeight;
                            }
                            if (!bl) {
                                if (((Particle[])object).length > 1) {
                                    Arrays.sort(particleWeightArray, particleWeightCompare);
                                }
                                for (n6 = 0; n6 < ((Particle[])object).length; ++n6) {
                                    object2 = particleWeightArray[n6];
                                    if (!this.addChildren(element, complexType, ((ParticleWeight)object2).particle, n)) continue;
                                    bl = true;
                                    break;
                                }
                            }
                        }
                        if (bl) break;
                        for (int i = 0; i < ((Particle[])object).length; ++i) {
                            if (!this.addChildren(element, complexType, object[i], n)) continue;
                            bl = true;
                            break block0;
                        }
                        break;
                    }
                    bl = true;
                    break;
                }
                case SEQUENCE: 
                case ALL: {
                    Object object = type == Particle.Type.SEQUENCE ? ((SequenceParticle)particle).getParticles() : ((AllParticle)particle).getParticles();
                    bl = true;
                    for (int i = 0; i < ((Particle[])object).length; ++i) {
                        if (this.addChildren(element, complexType, object[i], n)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) break;
                    ElementTypeImpl.restoreChildren(element, n5);
                }
            }
            if (bl && n2 > 1 && (n4 = (n3 = element.getChildCount()) - n5) > 0) {
                int n7;
                Node[] nodeArray = new Node[n4];
                n4 = 0;
                for (n7 = n5; n7 < n3; ++n7) {
                    nodeArray[n4++] = element.getChild(n7);
                }
                while (n2 > 1) {
                    for (n7 = 0; n7 < n4; ++n7) {
                        element.appendChild(nodeArray[n7].copy());
                    }
                    --n2;
                }
            }
        }
        return bl;
    }

    private NameAndType getElementNameAndType(ComplexType complexType, ElementParticle elementParticle) {
        Name name = elementParticle.elementName;
        ElementDeclaration elementDeclaration = complexType.getElementDeclaration(name);
        if (elementDeclaration == null) {
            elementDeclaration = this.schema.getElementDeclaration(name);
        }
        Type type = elementDeclaration == null ? null : elementDeclaration.type;
        return new NameAndType(name, type);
    }

    private NameAndType getElementNameAndType(ComplexType complexType, WildcardParticle wildcardParticle) {
        ElementDeclaration elementDeclaration;
        Wildcard wildcard = wildcardParticle.wildcard;
        NameWildcard nameWildcard = wildcard.nameWildcard;
        Name name = null;
        Type type = null;
        Iterator<ElementDeclaration> iterator = complexType.getElementDeclarations();
        while (iterator.hasNext()) {
            elementDeclaration = iterator.next();
            if (!nameWildcard.match(elementDeclaration.name)) continue;
            name = elementDeclaration.name;
            type = elementDeclaration.type;
            break;
        }
        if (name == null) {
            iterator = this.schema.getElementDeclarations();
            while (iterator.hasNext()) {
                elementDeclaration = iterator.next();
                if (!nameWildcard.match(elementDeclaration.name)) continue;
                name = elementDeclaration.name;
                type = elementDeclaration.type;
                break;
            }
        }
        if (name == null) {
            name = nameWildcard.getSampleName();
        }
        return new NameAndType(name, type);
    }

    private double particleWeight(ComplexType complexType, Particle particle) {
        if (particle.getMinOccurs() == 0) {
            return 0.0;
        }
        double d = 0.0;
        Particle.Type type = particle.getType();
        switch (type) {
            case ELEMENT: {
                NameAndType nameAndType = this.getElementNameAndType(complexType, (ElementParticle)particle);
                d = ElementTypeImpl.typeWeight(nameAndType.type, nameAndType.name);
                break;
            }
            case WILDCARD: {
                NameAndType nameAndType = this.getElementNameAndType(complexType, (WildcardParticle)particle);
                d = ElementTypeImpl.typeWeight(nameAndType.type, nameAndType.name);
                break;
            }
            case CHOICE: {
                Particle[] particleArray = ((ChoiceParticle)particle).getParticles();
                if (particleArray.length == 0) {
                    d = 0.0;
                    break;
                }
                double d2 = -1.0;
                for (int i = 0; i < particleArray.length; ++i) {
                    Particle particle2 = particleArray[i];
                    double d3 = this.particleWeight(complexType, particle2);
                    if (!(d2 < 0.0) && !(d3 < d2)) continue;
                    d2 = d3;
                }
                if (!(d2 >= 0.0)) break;
                d = d2;
                break;
            }
            case SEQUENCE: 
            case ALL: {
                Particle[] particleArray = type == Particle.Type.SEQUENCE ? ((SequenceParticle)particle).getParticles() : ((AllParticle)particle).getParticles();
                if (particleArray.length == 0) {
                    d = 0.0;
                    break;
                }
                for (int i = 0; i < particleArray.length; ++i) {
                    Particle particle3 = particleArray[i];
                    d += this.particleWeight(complexType, particle3);
                }
                break;
            }
        }
        return d;
    }

    private static int typeWeight(Type type, Name name) {
        int n;
        int n2 = 0;
        if (type == null) {
            n = 8;
        } else if (type instanceof SimpleType) {
            n = 2;
        } else {
            ComplexType complexType = (ComplexType)type;
            switch (complexType.getContentType()) {
                case MIXED: {
                    n = complexType.getParticle().isEmptiable() ? 1 : 6;
                    break;
                }
                case ELEMENT_ONLY: {
                    n = complexType.getParticle().isEmptiable() ? 5 : 7;
                    break;
                }
                case DATA: {
                    n = 4;
                    break;
                }
                default: {
                    n = 3;
                }
            }
            AttributeUse[] attributeUseArray = complexType.getAttributeUses();
            for (int i = 0; i < attributeUseArray.length; ++i) {
                if (!attributeUseArray[i].isRequired) continue;
                ++n2;
            }
            if (n2 > 9) {
                n2 = 9;
            }
        }
        int n3 = name.localPart.length();
        if (n3 > 99) {
            n3 = 99;
        }
        return 10000 * n + 100 * n2 + n3;
    }

    private boolean addChild(Element element, Name name, Type type, int n) {
        if (type != null && ElementTypeImpl.isRecursiveStructure(element, type)) {
            return false;
        }
        Element element2 = new Element(name);
        element.appendChild(element2);
        if (!this.addChildren(element2, type, n)) {
            element.removeChild(element2);
            return false;
        }
        if ((n & 1) != 0) {
            this.addRequiredAttributes(element2, type, n);
        }
        return true;
    }

    private static final boolean isRecursiveStructure(Element element, Type type) {
        Object object;
        boolean bl = false;
        for (Element element2 = element; element2 != null && (object = element2.getProperty(TYPE_PROPERTY)) != null; element2 = element2.getParentElement()) {
            if (object != type) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static final void restoreChildren(Element element, int n) {
        for (int i = element.getChildCount(); i > n; --i) {
            element.removeChild(element.getLastChild());
        }
    }

    private void addRequiredAttributes(Element element, Type type, int n) {
        if (type == null) {
            return;
        }
        if (type instanceof ComplexType) {
            ComplexType complexType = (ComplexType)type;
            AttributeUse[] attributeUseArray = complexType.getAttributeUses();
            boolean bl = (n & 2) != 0;
            boolean bl2 = (n & 0x20) != 0;
            for (int i = 0; i < attributeUseArray.length; ++i) {
                String string;
                AttributeUse attributeUse = attributeUseArray[i];
                if (!attributeUse.isRequired) continue;
                Name name = attributeUse.name;
                String string2 = string = bl2 ? "" : "???";
                if (bl) {
                    AttributeDeclaration attributeDeclaration = complexType.getAttributeDeclaration(name);
                    if (attributeDeclaration == null) {
                        attributeDeclaration = this.schema.getAttributeDeclaration(name);
                    }
                    if (attributeDeclaration != null && attributeDeclaration.dataType instanceof IDDataType) {
                        string = DocumentTypeUtil.generateUniqueId();
                    }
                }
                element.putAttribute(name, string);
            }
        }
    }

    static {
        FieldImpl fieldImpl;
        int n;
        NO_FIELDS = new FieldImpl[0];
        NO_FIELD_MAP = new IdentityLinearHashtable();
        XSI_FIELDS1 = new FieldImpl[]{new FieldImpl(Name.XSI_TYPE, false), new FieldImpl(Name.XSI_SCHEMA_LOCATION, false), new FieldImpl(Name.XSI_NO_NAMESPACE_SCHEMA_LOCATION, false)};
        XSI_FIELD_MAP1 = new IdentityLinearHashtable();
        XSI_FIELDS2 = new FieldImpl[]{XSI_FIELDS1[0], XSI_FIELDS1[1], XSI_FIELDS1[2], new FieldImpl(Name.XSI_NIL, false)};
        XSI_FIELD_MAP2 = new IdentityLinearHashtable();
        for (n = 0; n < NO_FIELDS.length; ++n) {
            fieldImpl = NO_FIELDS[n];
            NO_FIELD_MAP.put(fieldImpl.name, fieldImpl);
        }
        for (n = 0; n < XSI_FIELDS1.length; ++n) {
            fieldImpl = XSI_FIELDS1[n];
            XSI_FIELD_MAP1.put(fieldImpl.name, fieldImpl);
        }
        for (n = 0; n < XSI_FIELDS2.length; ++n) {
            fieldImpl = XSI_FIELDS2[n];
            XSI_FIELD_MAP2.put(fieldImpl.name, fieldImpl);
        }
        XSI_NIL_ATTRIBUTE = new XSIAttributeType(BooleanType.BASE);
        XSI_TYPE_ATTRIBUTE = new XSIAttributeType(QNameType.BASE);
        XSI_SCHEMA_LOCATION_ATTRIBUTE = new XSIAttributeType(new ListType(AnyURIType.BASE));
        XSI_NO_NAMESPACE_SCHEMA_LOCATION_ATTRIBUTE = new XSIAttributeType(AnyURIType.BASE);
        particleWeightCompare = new ParticleWeightCompare();
        TYPE_PROPERTY = Name.get(Namespace.get("http://www.xmlmind.com/xmleditor/namespace/private"), "type");
        compareWildcardFieldBySpecificity = new CompareWildcardFieldBySpecificity();
        SPACE_ITEM = new SpaceItem();
    }

    private static final class SpaceItem
    implements Item {
        private SpaceItem() {
        }
    }

    private static final class CompareWildcardFieldBySpecificity
    implements Comparator<FieldImpl> {
        private CompareWildcardFieldBySpecificity() {
        }

        @Override
        public int compare(FieldImpl fieldImpl, FieldImpl fieldImpl2) {
            return fieldImpl2.nameWildcard.getSpecificity() - fieldImpl.nameWildcard.getSpecificity();
        }
    }

    private static final class ParticleWeightCompare
    implements Comparator<ParticleWeight> {
        private ParticleWeightCompare() {
        }

        @Override
        public int compare(ParticleWeight particleWeight, ParticleWeight particleWeight2) {
            double d = particleWeight.weight;
            double d2 = particleWeight2.weight;
            return d < d2 ? -1 : (d > d2 ? 1 : 0);
        }
    }

    private static final class ParticleWeight {
        public Particle particle;
        public double weight;

        private ParticleWeight() {
        }
    }

    private static final class NameAndType {
        public Name name;
        public Type type;

        public NameAndType(Name name, Type type) {
            this.name = name;
            this.type = type;
        }
    }

    private static final class XSIAttributeType
    implements AttributeType {
        private DataType dataType;

        public XSIAttributeType(DataType dataType) {
            this.dataType = dataType;
        }

        @Override
        public DataType getAttributeDataType() {
            return this.dataType;
        }

        @Override
        public Data getAttributeDefaultValue() {
            return null;
        }

        @Override
        public Data getAttributeFixedValue() {
            return null;
        }
    }
}

