/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.validate;

import com.xmlmind.xml.wxs.validate.Particle;
import java.util.ArrayList;

public final class ChoiceParticle
extends Particle {
    private Particle[] particles;

    public ChoiceParticle(Particle[] particleArray, int n, int n2) {
        super(n, n2);
        this.particles = particleArray;
    }

    @Override
    public Particle.Type getType() {
        return Particle.Type.CHOICE;
    }

    public Particle[] getParticles() {
        return this.particles;
    }

    @Override
    public int rangeMin() {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.particles.length; ++i) {
            int n2;
            Particle particle = this.particles[i];
            switch (particle.getType()) {
                case ELEMENT: 
                case WILDCARD: {
                    n2 = particle.minOccurs;
                    break;
                }
                default: {
                    n2 = particle.rangeMin();
                }
            }
            if (n2 >= n) continue;
            n = n2;
        }
        return n == Integer.MAX_VALUE ? 0 : this.minOccurs * n;
    }

    @Override
    public int rangeMax() {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < this.particles.length; ++i) {
            int n2;
            Particle particle = this.particles[i];
            switch (particle.getType()) {
                case ELEMENT: 
                case WILDCARD: {
                    n2 = particle.maxOccurs;
                    break;
                }
                default: {
                    n2 = particle.rangeMax();
                }
            }
            if (n2 == -1 || n2 > 0 && this.maxOccurs == -1) {
                return -1;
            }
            if (n2 <= n) continue;
            n = n2;
        }
        return n == Integer.MIN_VALUE ? 0 : this.maxOccurs * n;
    }

    @Override
    public Particle simplify() {
        Particle[] particleArray;
        int n;
        if (this.minOccurs == 0 && this.maxOccurs == 0 || this.particles.length == 0) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (n = 0; n < this.particles.length; ++n) {
            particleArray = this.particles[n].simplify();
            if (particleArray == null) continue;
            if (particleArray instanceof ChoiceParticle && particleArray.minOccurs == 1 && particleArray.maxOccurs == 1) {
                Particle[] particleArray2 = ((ChoiceParticle)particleArray).particles;
                for (int i = 0; i < particleArray2.length; ++i) {
                    arrayList.add(particleArray2[i]);
                }
                continue;
            }
            arrayList.add(particleArray);
        }
        n = arrayList.size();
        if (n == 0) {
            return null;
        }
        if (n == 1 && this.minOccurs == 1 && this.maxOccurs == 1) {
            return (Particle)arrayList.get(0);
        }
        particleArray = new Particle[n];
        arrayList.toArray(particleArray);
        return new ChoiceParticle(particleArray, this.minOccurs, this.maxOccurs);
    }

    @Override
    protected void toString(StringBuilder stringBuilder) {
        stringBuilder.append('(');
        for (int i = 0; i < this.particles.length; ++i) {
            if (i > 0) {
                stringBuilder.append('|');
            }
            stringBuilder.append(this.particles[i]);
        }
        stringBuilder.append(')');
    }

    @Override
    public Particle copy() {
        ChoiceParticle choiceParticle;
        try {
            choiceParticle = (ChoiceParticle)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            return null;
        }
        choiceParticle.particles = (Particle[])this.particles.clone();
        for (int i = 0; i < this.particles.length; ++i) {
            choiceParticle.particles[i] = this.particles[i].copy();
        }
        return choiceParticle;
    }
}

