/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.wxs.datatype.DataType;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.InvalidTypeException;
import com.xmlmind.xml.wxs.datatype.ListType;
import com.xmlmind.xml.wxs.datatype.NOTATIONType;
import com.xmlmind.xml.wxs.datatype.Restriction;
import com.xmlmind.xml.wxs.datatype.UnionType;
import com.xmlmind.xml.wxs.load.FacetInfo;
import com.xmlmind.xml.wxs.load.Info;
import com.xmlmind.xml.wxs.load.ListInfo;
import com.xmlmind.xml.wxs.load.LoadContext;
import com.xmlmind.xml.wxs.load.LoadState;
import com.xmlmind.xml.wxs.load.RestrictionInfo;
import com.xmlmind.xml.wxs.load.SchemaErrors;
import com.xmlmind.xml.wxs.load.SchemaInfo;
import com.xmlmind.xml.wxs.load.TypeInfo;
import com.xmlmind.xml.wxs.load.UnionInfo;
import com.xmlmind.xml.wxs.validate.SimpleType;
import com.xmlmind.xml.wxs.validate.Type;
import java.lang.reflect.Field;

final class SimpleTypeInfo
extends TypeInfo {
    public int final_ = 0;
    public int derivation = 2;
    public Name base = null;
    public SimpleTypeInfo baseTypeInfo = null;
    public FacetInfo[] facetInfo = null;
    public Name itemType = null;
    public SimpleTypeInfo itemTypeInfo = null;
    public Name[] memberTypes = null;
    public SimpleTypeInfo[] memberTypeInfo = null;
    private SimpleType created = null;
    private static final Name DATA_TYPE_ATTR = Name.get(Namespace.get("http://www.xmlmind.com/xmleditor/namespace/extension"), "DataType");

    public SimpleTypeInfo(Info info) {
        super(info);
    }

    public void add(FacetInfo facetInfo) {
        if (this.facetInfo == null) {
            this.facetInfo = new FacetInfo[]{facetInfo};
        } else {
            FacetInfo[] facetInfoArray = new FacetInfo[this.facetInfo.length + 1];
            System.arraycopy(this.facetInfo, 0, facetInfoArray, 0, this.facetInfo.length);
            facetInfoArray[this.facetInfo.length] = facetInfo;
            this.facetInfo = facetInfoArray;
        }
    }

    public void add(SimpleTypeInfo simpleTypeInfo) {
        if (this.memberTypeInfo == null) {
            this.memberTypeInfo = new SimpleTypeInfo[]{simpleTypeInfo};
        } else {
            SimpleTypeInfo[] simpleTypeInfoArray = new SimpleTypeInfo[this.memberTypeInfo.length + 1];
            System.arraycopy(this.memberTypeInfo, 0, simpleTypeInfoArray, 0, this.memberTypeInfo.length);
            simpleTypeInfoArray[this.memberTypeInfo.length] = simpleTypeInfo;
            this.memberTypeInfo = simpleTypeInfoArray;
        }
    }

    @Override
    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.name = SimpleTypeInfo.getNCNameAttribute(element, _NAME, schemaInfo.targetNamespace, null);
        this.final_ = SimpleTypeInfo.getFinalAttribute(element, _FINAL, schemaInfo.finalDefault);
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            if (name == XSD_RESTRICTION) {
                this.derivation = 2;
                this.initRestriction(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                break;
            }
            if (name == XSD_LIST) {
                this.derivation = 8;
                this.initList(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                break;
            }
            if (name != XSD_UNION) continue;
            this.derivation = 16;
            this.initUnion(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
            break;
        }
        switch (this.derivation) {
            case 2: {
                if (this.base == null && this.baseTypeInfo == null) {
                    schemaErrors2.append(this, "src-simple-type.2", "missingBase");
                    break;
                }
                if (this.base == null || this.baseTypeInfo == null) break;
                schemaErrors2.append(this, "src-simple-type.2", "inconsistentBase");
                break;
            }
            case 8: {
                if (this.itemType == null && this.itemTypeInfo == null) {
                    schemaErrors2.append(this, "src-simple-type.3", "missingItemType");
                    break;
                }
                if (this.itemType == null || this.itemTypeInfo == null) break;
                schemaErrors2.append(this, "src-simple-type.3", "inconsistentItemType");
                break;
            }
            case 16: {
                if (this.memberTypes != null || this.memberTypeInfo != null) break;
                schemaErrors2.append(this, "x-src-simple-type", "missingMemberTypes");
            }
        }
    }

    private void initRestriction(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        RestrictionInfo restrictionInfo = new RestrictionInfo(this);
        restrictionInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.base = this.getQNameAttribute(element, _BASE, null);
        if (this.base != null) {
            this.checkImportedNamespaces(this.base, schemaInfo, schemaErrors2);
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            String string;
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            if (name == XSD_SIMPLE_TYPE) {
                this.baseTypeInfo = new SimpleTypeInfo(restrictionInfo);
                this.baseTypeInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                continue;
            }
            Info.NameToFacetEntry nameToFacetEntry = (Info.NameToFacetEntry)nameToFacet.get(name);
            if (nameToFacetEntry == null || (string = element2.getAttribute(_VALUE)) == null) continue;
            boolean bl = SimpleTypeInfo.getBooleanAttribute(element2, _FIXED, false);
            FacetInfo facetInfo = new FacetInfo(restrictionInfo, nameToFacetEntry.facet, string, bl);
            facetInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
            this.add(facetInfo);
        }
    }

    private void initList(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        Element element2;
        ListInfo listInfo = new ListInfo(this);
        listInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.itemType = this.getQNameAttribute(element, _ITEM_TYPE, null);
        if (this.itemType != null) {
            this.checkImportedNamespaces(this.itemType, schemaInfo, schemaErrors2);
        }
        if ((element2 = SimpleTypeInfo.getChild(element, XSD_SIMPLE_TYPE)) != null) {
            this.itemTypeInfo = new SimpleTypeInfo(listInfo);
            this.itemTypeInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        }
    }

    private void initUnion(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        UnionInfo unionInfo = new UnionInfo(this);
        unionInfo.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.memberTypes = this.getQNamesAttribute(element, _MEMBER_TYPES, null);
        if (this.memberTypes != null) {
            this.checkImportedNamespaces(this.memberTypes, schemaInfo, schemaErrors2);
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element element2;
            if (node.getType() != Node.Type.ELEMENT || (element2 = (Element)node).getName() != XSD_SIMPLE_TYPE) continue;
            SimpleTypeInfo simpleTypeInfo = new SimpleTypeInfo(unionInfo);
            simpleTypeInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
            this.add(simpleTypeInfo);
        }
    }

    @Override
    public Type toType(LoadState loadState) {
        if (this.created == null) {
            this.created = this.toSimpleType(loadState);
        }
        return this.created;
    }

    private SimpleType toSimpleType(LoadState loadState) {
        Object object;
        Object object2;
        int n;
        SimpleType simpleType = this.derivation == 2 ? (this.base != null ? loadState.getSimpleType(this.base, this, "st-props-correct.1") : (this.baseTypeInfo != null ? (SimpleType)this.baseTypeInfo.toType(loadState) : SimpleType.ANY)) : SimpleType.ANY;
        if (simpleType == null) {
            return null;
        }
        switch (this.derivation) {
            case 8: {
                n = 4;
                break;
            }
            case 16: {
                n = 8;
                break;
            }
            default: {
                n = 2;
            }
        }
        int n2 = 0;
        if ((this.final_ & 1) != 0) {
            n2 |= 1;
        }
        if ((this.final_ & 2) != 0) {
            n2 |= 2;
        }
        if ((this.final_ & 8) != 0) {
            n2 |= 4;
        }
        if ((this.final_ & 0x10) != 0) {
            n2 |= 8;
        }
        SimpleType simpleType2 = new SimpleType(this.name, simpleType, n, false, n2, 0);
        switch (this.derivation) {
            case 8: {
                object2 = this.deriveByList(simpleType2, loadState);
                break;
            }
            case 16: {
                object2 = this.deriveByUnion(simpleType2, loadState);
                break;
            }
            default: {
                object2 = this.deriveByRestriction(simpleType.getDataType(), simpleType2, loadState);
                if (object2 == null || !(object2 instanceof NOTATIONType) || SimpleTypeInfo.checkNotations((DataType)object2, this, "st-props-correct.1", loadState)) break;
                object2 = null;
            }
        }
        if (object2 == null) {
            return null;
        }
        if ((simpleType.prohibitedDerivations & 2) != 0) {
            loadState.errors.append(this, "st-props-correct.3", "prohibitedRestriction");
            return null;
        }
        if (object2 instanceof ListType) {
            object = (DataType[])((ListType)object2).getItemType().getProperties();
            if ((object.prohibitedDerivations & 4) != 0) {
                loadState.errors.append(this, "st-props-correct.4.2.1", "prohibitedDerivationByList");
                return null;
            }
        } else if (object2 instanceof UnionType) {
            object = ((UnionType)object2).getMemberTypes();
            for (int i = 0; i < ((DataType[])object).length; ++i) {
                SimpleType simpleType3 = (SimpleType)object[i].getProperties();
                if ((simpleType3.prohibitedDerivations & 8) == 0) continue;
                loadState.errors.append(this, "st-props-correct.4.2.2", "prohibitedDerivationByUnion");
                return null;
            }
        }
        if ((object = this.createCustomDataType(simpleType2)) != null) {
            object2 = object;
        }
        simpleType2.setDataType((DataType)object2);
        return simpleType2;
    }

    private DataType deriveByRestriction(DataType dataType, SimpleType simpleType, LoadState loadState) {
        Restriction restriction = new Restriction(dataType);
        DataType dataType2 = null;
        try {
            if (this.facetInfo != null) {
                SimpleTypeInfo.applyFacets(restriction, this.facetInfo);
            }
            dataType2 = restriction.derive(simpleType);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            loadState.errors.append(this, "st-props-correct.1", "cannotDeriveByRestriction", illegalArgumentException.getMessage());
            return null;
        }
        catch (InvalidDataException invalidDataException) {
            loadState.errors.append(this, "st-props-correct.1", "cannotDeriveByRestriction2", invalidDataException.getMessage(), invalidDataException.getConstraint());
            return null;
        }
        catch (InvalidTypeException invalidTypeException) {
            loadState.errors.append(this, "st-props-correct.1", "cannotDeriveByRestriction2", invalidTypeException.getMessage(), invalidTypeException.getConstraint());
            return null;
        }
        return dataType2;
    }

    private DataType deriveByList(SimpleType simpleType, LoadState loadState) {
        SimpleType simpleType2 = this.itemType != null ? loadState.getSimpleType(this.itemType, this, "st-props-correct.1") : (SimpleType)this.itemTypeInfo.toType(loadState);
        if (simpleType2 == null) {
            return null;
        }
        ListType listType = new ListType(simpleType2.getDataType());
        Restriction restriction = new Restriction(listType);
        DataType dataType = null;
        try {
            dataType = restriction.derive(simpleType);
        }
        catch (InvalidTypeException invalidTypeException) {
            loadState.errors.append(this, "st-props-correct.1", "cannotDeriveByList", invalidTypeException.getMessage(), invalidTypeException.getConstraint());
            return null;
        }
        return dataType;
    }

    private DataType deriveByUnion(SimpleType simpleType, LoadState loadState) {
        Object object;
        Object object2;
        int n;
        int n2 = 0;
        if (this.memberTypes != null) {
            n2 += this.memberTypes.length;
        }
        if (this.memberTypeInfo != null) {
            n2 += this.memberTypeInfo.length;
        }
        SimpleType[] simpleTypeArray = new SimpleType[n2];
        n2 = 0;
        if (this.memberTypes != null) {
            for (n = 0; n < this.memberTypes.length; ++n) {
                object2 = this.memberTypes[n];
                object = loadState.getSimpleType((Name)object2, this, "st-props-correct.1");
                if (object == null) continue;
                simpleTypeArray[n2++] = object;
            }
        }
        if (this.memberTypeInfo != null) {
            for (n = 0; n < this.memberTypeInfo.length; ++n) {
                object2 = this.memberTypeInfo[n];
                object = (SimpleType)((SimpleTypeInfo)object2).toType(loadState);
                if (object == null) continue;
                simpleTypeArray[n2++] = object;
            }
        }
        if (n2 != simpleTypeArray.length) {
            return null;
        }
        DataType[] dataTypeArray = new DataType[n2];
        for (int i = 0; i < n2; ++i) {
            dataTypeArray[i] = simpleTypeArray[i].getDataType();
        }
        UnionType unionType = new UnionType(dataTypeArray);
        object = new Restriction(unionType);
        DataType dataType = null;
        try {
            dataType = ((Restriction)object).derive(simpleType);
        }
        catch (InvalidTypeException invalidTypeException) {
            loadState.errors.append(this, "st-props-correct.1", "cannotDeriveByUnion", invalidTypeException.getMessage(), invalidTypeException.getConstraint());
            return null;
        }
        return dataType;
    }

    private DataType createCustomDataType(SimpleType simpleType) {
        Element element = this.peerElement.getChildElement(0);
        if (element != null && element.getName() == XSD_ANNOTATION) {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                String string;
                Element element2;
                if (node.getType() != Node.Type.ELEMENT || (element2 = (Element)node).getName() != XSD_APPINFO || (string = element2.getAttribute(DATA_TYPE_ATTR)) == null) continue;
                DataType dataType = null;
                try {
                    Class<?> clazz = Class.forName(string);
                    Field field = clazz.getDeclaredField("BASE");
                    DataType dataType2 = (DataType)field.get(null);
                    Restriction restriction = new Restriction(dataType2);
                    dataType = restriction.derive(simpleType);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return dataType;
            }
        }
        return null;
    }
}

