/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.util.LinearHashtable;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.load.DocumentLoader;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.wxs.load.Info;
import com.xmlmind.xml.wxs.load.LoadContext;
import com.xmlmind.xml.wxs.load.SchemaErrors;
import com.xmlmind.xml.wxs.load.SchemaInfo;
import java.net.URL;
import org.xml.sax.SAXParseException;

final class ImportInfo
extends Info {
    public Namespace namespace = Namespace.NONE;
    public URL schemaLocation;

    public ImportInfo(Info info) {
        super(info);
    }

    @Override
    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        String string = ImportInfo.getNamespaceURIAttribute(element, _NAMESPACE, null);
        if (string != null) {
            this.namespace = Namespace.get(string);
        }
        this.schemaLocation = ImportInfo.getResolvedURLAttribute(element, _SCHEMA_LOCATION, this.getLocation(), null);
        if (this.namespace == schemaInfo.targetNamespace) {
            schemaErrors2.append(this, "src-import.1", "invalidImport", this.namespace, schemaInfo.targetNamespace);
        } else {
            schemaInfo.addImportedNamespace(this.namespace);
            SchemaInfo schemaInfo2 = null;
            boolean bl = false;
            LinearHashtable<URL, SchemaInfo> linearHashtable = loadContext.getImportedSchemas(this.namespace);
            if (linearHashtable != null) {
                if (this.schemaLocation == null) {
                    if (linearHashtable.size() == 1) {
                        schemaInfo2 = linearHashtable.elements().next();
                    }
                } else {
                    schemaInfo2 = linearHashtable.get(this.schemaLocation);
                }
            }
            if (schemaInfo2 == null) {
                if (this.schemaLocation == null) {
                    if (this.namespace == Namespace.XML) {
                        this.schemaLocation = ImportInfo.class.getResource("xml.xsd");
                    }
                    if (this.schemaLocation == null) {
                        schemaErrors.append(this, "x-src-import", "cannotImport");
                        return;
                    }
                }
                if (loadContext.isSchemaBeingLoaded(this.schemaLocation)) {
                    return;
                }
                try {
                    schemaInfo2 = ImportInfo.loadSchema(this.schemaLocation, null, loadContext, schemaErrors, schemaErrors2);
                }
                catch (Exception exception) {
                    String string2 = exception instanceof SAXParseException ? DocumentLoader.format((SAXParseException)exception) : ThrowableUtil.reason(exception);
                    schemaErrors2.append(this, "x-src-import.1", "cannotLoadSchema", this.schemaLocation, string2);
                    return;
                }
                bl = true;
            }
            if (schemaInfo2 != null) {
                if (this.namespace != schemaInfo2.targetNamespace) {
                    schemaErrors2.append(this, "src-import.3", "unexpectedTargetNamespace", this.namespace, this.schemaLocation, schemaInfo2.targetNamespace);
                } else {
                    if (bl) {
                        loadContext.registerImportedSchema(this.namespace, this.schemaLocation, schemaInfo2);
                    }
                    ImportInfo.moveInfo(schemaInfo2, schemaInfo, schemaErrors2);
                }
            }
        }
    }
}

