/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.wxs.load.AllInfo;
import com.xmlmind.xml.wxs.load.ChoiceInfo;
import com.xmlmind.xml.wxs.load.Info;
import com.xmlmind.xml.wxs.load.LoadContext;
import com.xmlmind.xml.wxs.load.LoadState;
import com.xmlmind.xml.wxs.load.ModelGroupInfo;
import com.xmlmind.xml.wxs.load.NamedComponent;
import com.xmlmind.xml.wxs.load.SchemaErrors;
import com.xmlmind.xml.wxs.load.SchemaInfo;
import com.xmlmind.xml.wxs.load.SequenceInfo;
import com.xmlmind.xml.wxs.validate.ElementDeclaration;
import com.xmlmind.xml.wxs.validate.Particle;
import java.util.IdentityHashMap;

final class GroupInfo
extends Info {
    public ModelGroupInfo modelGroupInfo = null;
    public Name ref = null;
    public int minOccurs = 1;
    public int maxOccurs = 1;

    public GroupInfo(Info info) {
        super(info);
    }

    @Override
    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        this.name = GroupInfo.getNCNameAttribute(element, _NAME, schemaInfo.targetNamespace, null);
        if (this.name == null) {
            this.ref = this.getQNameAttribute(element, _REF, null);
            if (this.ref != null) {
                this.checkImportedNamespaces(this.ref, schemaInfo, schemaErrors2);
            }
            this.minOccurs = GroupInfo.getNonNegativeIntAttribute(element, _MIN_OCCURS, 1);
            this.maxOccurs = GroupInfo.getMaxOccursAttribute(element, _MAX_OCCURS, 1);
        } else {
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getType() != Node.Type.ELEMENT) continue;
                Element element2 = (Element)node;
                Name name = element2.getName();
                if (name == XSD_SEQUENCE) {
                    this.modelGroupInfo = new SequenceInfo(this);
                    this.modelGroupInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    break;
                }
                if (name == XSD_CHOICE) {
                    this.modelGroupInfo = new ChoiceInfo(this);
                    this.modelGroupInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                    break;
                }
                if (name != XSD_ALL) continue;
                this.modelGroupInfo = new AllInfo(this);
                this.modelGroupInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                break;
            }
        }
    }

    @Override
    public boolean toParticle(Particle[] particleArray, int n, LoadState loadState) {
        if (!this.checkOccurs(this.minOccurs, this.maxOccurs, loadState)) {
            return false;
        }
        if (this.minOccurs == 0 && this.maxOccurs == 0) {
            particleArray[n] = null;
            return true;
        }
        GroupInfo groupInfo = loadState.getGroupInfo(this.ref, this, "p-props-correct.1");
        if (groupInfo == null) {
            return false;
        }
        if (loadState.detectCircularComponent(NamedComponent.Type.GROUP, this.ref, this, "p-props-correct.1")) {
            return false;
        }
        boolean bl = groupInfo.modelGroupInfo.toParticle(particleArray, n, loadState);
        loadState.undetectCircularComponent(NamedComponent.Type.GROUP, this.ref);
        if (bl && particleArray[n] != null) {
            particleArray[n].setOccurs(this.minOccurs, this.maxOccurs);
        }
        return bl;
    }

    @Override
    public boolean toParticle2(IdentityHashMap<Name, ElementDeclaration> identityHashMap, LoadState loadState) {
        if (this.minOccurs == 0 && this.maxOccurs == 0) {
            return true;
        }
        GroupInfo groupInfo = loadState.getGroupInfo(this.ref, this, "p-props-correct.1");
        if (groupInfo == null) {
            return false;
        }
        return groupInfo.modelGroupInfo.toParticle2(identityHashMap, loadState);
    }
}

