/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.wxs.datatype.DataType;
import com.xmlmind.xml.wxs.datatype.IDType;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.load.ComplexTypeInfo;
import com.xmlmind.xml.wxs.load.IdentityConstraintInfo;
import com.xmlmind.xml.wxs.load.Info;
import com.xmlmind.xml.wxs.load.KeyInfo;
import com.xmlmind.xml.wxs.load.KeyrefInfo;
import com.xmlmind.xml.wxs.load.LoadContext;
import com.xmlmind.xml.wxs.load.LoadState;
import com.xmlmind.xml.wxs.load.RedefineInfo;
import com.xmlmind.xml.wxs.load.SchemaErrors;
import com.xmlmind.xml.wxs.load.SchemaInfo;
import com.xmlmind.xml.wxs.load.SimpleTypeInfo;
import com.xmlmind.xml.wxs.load.SubstitutionGroup;
import com.xmlmind.xml.wxs.load.TypeInfo;
import com.xmlmind.xml.wxs.load.UniqueInfo;
import com.xmlmind.xml.wxs.validate.ComplexType;
import com.xmlmind.xml.wxs.validate.ElementDeclaration;
import com.xmlmind.xml.wxs.validate.ElementParticle;
import com.xmlmind.xml.wxs.validate.IdentityConstraint;
import com.xmlmind.xml.wxs.validate.Particle;
import com.xmlmind.xml.wxs.validate.Type;
import java.io.Serializable;
import java.util.IdentityHashMap;

final class ElementInfo
extends Info {
    public boolean abstract_;
    public int block;
    public int final_;
    public String default_;
    public String fixed;
    public int minOccurs = 1;
    public int maxOccurs = 1;
    public boolean nillable;
    public Name ref;
    public Name substitutionGroup;
    public Name type;
    public TypeInfo typeInfo;
    public IdentityConstraintInfo[] identityConstraintInfo;
    private ElementDeclaration elementDecl;

    public ElementInfo(Info info) {
        super(info);
    }

    public void add(IdentityConstraintInfo identityConstraintInfo) {
        if (this.identityConstraintInfo == null) {
            this.identityConstraintInfo = new IdentityConstraintInfo[]{identityConstraintInfo};
        } else {
            IdentityConstraintInfo[] identityConstraintInfoArray = new IdentityConstraintInfo[this.identityConstraintInfo.length + 1];
            System.arraycopy(this.identityConstraintInfo, 0, identityConstraintInfoArray, 0, this.identityConstraintInfo.length);
            identityConstraintInfoArray[this.identityConstraintInfo.length] = identityConstraintInfo;
            this.identityConstraintInfo = identityConstraintInfoArray;
        }
    }

    @Override
    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        Namespace namespace = this.getTargetNamespace(element, false, schemaInfo);
        this.name = ElementInfo.getNCNameAttribute(element, _NAME, namespace, null);
        this.abstract_ = ElementInfo.getBooleanAttribute(element, _ABSTRACT, false);
        this.block = ElementInfo.getBlockAttribute(element, _BLOCK, schemaInfo.blockDefault);
        this.final_ = ElementInfo.getFinalAttribute(element, _FINAL, schemaInfo.finalDefault);
        this.default_ = element.getAttribute(_DEFAULT);
        this.fixed = element.getAttribute(_FIXED);
        this.minOccurs = ElementInfo.getNonNegativeIntAttribute(element, _MIN_OCCURS, 1);
        this.maxOccurs = ElementInfo.getMaxOccursAttribute(element, _MAX_OCCURS, 1);
        this.nillable = ElementInfo.getBooleanAttribute(element, _NILLABLE, false);
        this.ref = this.getQNameAttribute(element, _REF, null);
        if (this.ref != null) {
            this.checkImportedNamespaces(this.ref, schemaInfo, schemaErrors2);
        }
        this.substitutionGroup = this.getQNameAttribute(element, _SUBSTITUTION_GROUP, null);
        if (this.substitutionGroup == this.name) {
            this.substitutionGroup = null;
        }
        if (this.substitutionGroup != null) {
            this.checkImportedNamespaces(this.substitutionGroup, schemaInfo, schemaErrors2);
        }
        this.type = this.getQNameAttribute(element, _TYPE, null);
        if (this.type != null) {
            this.checkImportedNamespaces(this.type, schemaInfo, schemaErrors2);
        }
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            IdentityConstraintInfo identityConstraintInfo;
            if (node.getType() != Node.Type.ELEMENT) continue;
            Element element2 = (Element)node;
            Name name = element2.getName();
            if (name == XSD_COMPLEX_TYPE) {
                this.typeInfo = new ComplexTypeInfo(this);
                this.typeInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                continue;
            }
            if (name == XSD_SIMPLE_TYPE) {
                this.typeInfo = new SimpleTypeInfo(this);
                this.typeInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                continue;
            }
            if (name == XSD_UNIQUE) {
                identityConstraintInfo = new UniqueInfo(this);
                identityConstraintInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                this.add(identityConstraintInfo);
                continue;
            }
            if (name == XSD_KEY) {
                identityConstraintInfo = new KeyInfo(this);
                identityConstraintInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
                this.add(identityConstraintInfo);
                continue;
            }
            if (name != XSD_KEYREF) continue;
            identityConstraintInfo = new KeyrefInfo(this);
            ((KeyrefInfo)identityConstraintInfo).init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
            this.add(identityConstraintInfo);
        }
        if (this.default_ != null && this.fixed != null) {
            schemaErrors2.append(this, "src-element.1", "inconsistentFixed");
        }
        if (!(this.parent instanceof SchemaInfo) && !(this.parent instanceof RedefineInfo)) {
            if (this.name == null && this.ref == null) {
                schemaErrors2.append(this, "src-element.2.1", "missingName");
            } else if (this.name != null && this.ref != null) {
                schemaErrors2.append(this, "src-element.2.1", "inconsistentName");
            }
            if (this.ref != null && (this.typeInfo != null || this.identityConstraintInfo != null || element.hasAttribute(_NILLABLE) || this.default_ != null || this.fixed != null || element.hasAttribute(_FORM) || element.hasAttribute(_BLOCK) || element.hasAttribute(_FINAL) || this.type != null)) {
                schemaErrors2.append(this, "src-element.2.2", "inconsistentForm2");
            }
        }
        if (this.type != null && this.typeInfo != null) {
            schemaErrors2.append(this, "src-element.3", "inconsistentType2");
        }
    }

    public ElementDeclaration toElementDeclaration(LoadState loadState) {
        Serializable serializable;
        Object object;
        Object object2;
        if (this.elementDecl != null) {
            return this.elementDecl;
        }
        this.elementDecl = new ElementDeclaration(this.name, ComplexType.ANY, null, false, false, 0, false);
        Type type = null;
        if (this.typeInfo != null) {
            type = this.typeInfo.toType(loadState);
        } else if (this.type != null) {
            type = loadState.getType(this.type, this, "e-props-correct.1");
        } else {
            type = ComplexType.ANY;
            if (this.substitutionGroup != null) {
                object2 = this.substitutionGroup;
                while (object2 != null) {
                    ElementInfo elementInfo = loadState.getElementInfo((Name)object2, this, "e-props-correct.1");
                    if (elementInfo == null) {
                        type = null;
                        break;
                    }
                    if (elementInfo == this) break;
                    if (elementInfo.typeInfo != null || elementInfo.type != null) {
                        object = loadState.getElementDeclaration((Name)object2, this, "e-props-correct.1");
                        if (object == null) {
                            type = null;
                            break;
                        }
                        type = ((ElementDeclaration)object).type;
                        break;
                    }
                    object2 = elementInfo.substitutionGroup;
                }
            }
        }
        if (type == null) {
            this.elementDecl = null;
            return null;
        }
        object2 = null;
        boolean bl = false;
        if (this.default_ != null || this.fixed != null) {
            if (this.fixed != null) {
                object = this.fixed;
                bl = true;
            } else {
                object = this.default_;
            }
            DataType dataType = type.getDataType();
            if (dataType == null) {
                serializable = (ComplexType)type;
                if (serializable.getContentType() != ComplexType.ContentType.MIXED) {
                    loadState.errors.append(this, "cos-valid-default.2.1", "cannotHaveAValueConstraint");
                    this.elementDecl = null;
                    return null;
                }
                if (!serializable.getParticle().isEmptiable()) {
                    loadState.errors.append(this, "cos-valid-default.2.2.2", "mixedNotEmptiable");
                    this.elementDecl = null;
                    return null;
                }
                object2 = object;
            } else {
                try {
                    object2 = dataType.valueOf((String)object, this);
                }
                catch (InvalidDataException invalidDataException) {
                    loadState.errors.append(this, "e-props-correct.2", "invalidValueConstraint", object, invalidDataException.getMessage(), invalidDataException.getConstraint());
                    this.elementDecl = null;
                    return null;
                }
                if (dataType instanceof IDType) {
                    loadState.errors.append(this, "e-props-correct.4", "idWithDefault", "element");
                    this.elementDecl = null;
                    return null;
                }
            }
        }
        int n = 0;
        if ((this.block & 1) != 0) {
            n |= 1;
        }
        if ((this.block & 2) != 0) {
            n |= 2;
        }
        this.elementDecl.type = type;
        this.elementDecl.defaultValue = object2;
        this.elementDecl.isFixedValue = bl;
        this.elementDecl.isNillable = this.nillable;
        this.elementDecl.disallowedSubstitutions = n;
        this.elementDecl.isAbstract = this.abstract_;
        if (this.identityConstraintInfo != null) {
            for (int i = 0; i < this.identityConstraintInfo.length; ++i) {
                serializable = this.identityConstraintInfo[i].toIdentityConstraint(loadState);
                if (serializable == null) {
                    this.elementDecl = null;
                    return null;
                }
                this.elementDecl.addIdentityConstraint((IdentityConstraint)serializable);
            }
        }
        return this.elementDecl;
    }

    public boolean toElementDeclaration2(ElementDeclaration elementDeclaration, LoadState loadState) {
        if (this.substitutionGroup != null) {
            ElementDeclaration elementDeclaration2 = loadState.getElementDeclaration(this.substitutionGroup, this, "e-props-correct.1");
            if (elementDeclaration2 == null) {
                return false;
            }
            ElementInfo elementInfo = loadState.schemaInfo.elementInfo.get(this.substitutionGroup);
            int n = 0;
            if ((elementInfo.final_ & 1) != 0) {
                n |= 1;
            }
            if ((elementInfo.final_ & 2) != 0) {
                n |= 2;
            }
            if (!elementDeclaration.type.isValidDerivation(elementDeclaration2.type, n)) {
                loadState.errors.append(this, "e-props-correct.3", "excludedFromSubstitutionGroup", this.substitutionGroup.format(false, this));
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean toParticle(Particle[] particleArray, int n, LoadState loadState) {
        if (!this.checkOccurs(this.minOccurs, this.maxOccurs, loadState)) {
            return false;
        }
        if (this.minOccurs == 0 && this.maxOccurs == 0) {
            particleArray[n] = null;
            return true;
        }
        if (this.ref == null) {
            particleArray[n] = new ElementParticle(this.name, this.minOccurs, this.maxOccurs);
        } else {
            ElementInfo elementInfo = loadState.getElementInfo(this.ref, this, "p-props-correct.1");
            if (elementInfo == null) {
                return false;
            }
            SubstitutionGroup substitutionGroup = loadState.getSubstitutionGroup(elementInfo);
            if (substitutionGroup != null) {
                particleArray[n] = substitutionGroup.toParticle(this.minOccurs, this.maxOccurs);
            } else if (!elementInfo.abstract_) {
                particleArray[n] = new ElementParticle(this.ref, this.minOccurs, this.maxOccurs);
            }
            if (particleArray[n] == null) {
                // empty if block
            }
        }
        return true;
    }

    @Override
    public boolean toParticle2(IdentityHashMap<Name, ElementDeclaration> identityHashMap, LoadState loadState) {
        if (this.minOccurs == 0 && this.maxOccurs == 0) {
            return true;
        }
        if (this.ref == null) {
            ElementDeclaration elementDeclaration = this.toElementDeclaration(loadState);
            if (elementDeclaration == null) {
                return false;
            }
            ElementDeclaration elementDeclaration2 = identityHashMap.get(this.name);
            if (elementDeclaration2 != null && !ElementInfo.checkConsistent(this, elementDeclaration2, elementDeclaration, loadState)) {
                return false;
            }
            identityHashMap.put(this.name, elementDeclaration);
        } else {
            ElementDeclaration elementDeclaration = new ElementDeclaration(this.ref, null, null, false, false, 0, false);
            ElementDeclaration elementDeclaration3 = identityHashMap.get(this.ref);
            if (elementDeclaration3 != null && !ElementInfo.checkConsistent(this, elementDeclaration3, elementDeclaration, loadState)) {
                return false;
            }
            identityHashMap.put(this.ref, elementDeclaration);
        }
        return true;
    }

    public static boolean checkConsistent(Info info, ElementDeclaration elementDeclaration, ElementDeclaration elementDeclaration2, LoadState loadState) {
        boolean bl;
        boolean bl2 = ElementInfo.inconsistent(elementDeclaration, elementDeclaration2);
        boolean bl3 = bl = !elementDeclaration.equals(elementDeclaration2);
        if (bl2 || bl) {
            if (bl2) {
                loadState.errors.append(info, "cos-element-consistent", "elementDeclarationInconsistent", elementDeclaration2.name.format(false, info));
            } else {
                loadState.errors.append(info, "x-cos-element-consistent", "elementDeclarationInconsistent2", elementDeclaration2.name.format(false, info));
            }
            return false;
        }
        return true;
    }

    private static final boolean inconsistent(ElementDeclaration elementDeclaration, ElementDeclaration elementDeclaration2) {
        if (elementDeclaration.name != elementDeclaration2.name) {
            return true;
        }
        Type type = elementDeclaration.type;
        Type type2 = elementDeclaration2.type;
        if (type == type2) {
            return false;
        }
        return type != null && type2 != null;
    }
}

