/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.load;

import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.wxs.datatype.DataType;
import com.xmlmind.xml.wxs.datatype.IDType;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.Value;
import com.xmlmind.xml.wxs.load.Info;
import com.xmlmind.xml.wxs.load.LoadContext;
import com.xmlmind.xml.wxs.load.LoadState;
import com.xmlmind.xml.wxs.load.RedefineInfo;
import com.xmlmind.xml.wxs.load.SchemaErrors;
import com.xmlmind.xml.wxs.load.SchemaInfo;
import com.xmlmind.xml.wxs.load.SimpleTypeInfo;
import com.xmlmind.xml.wxs.load.Use;
import com.xmlmind.xml.wxs.validate.AttributeDeclaration;
import com.xmlmind.xml.wxs.validate.AttributeUse;
import com.xmlmind.xml.wxs.validate.ComplexType;
import com.xmlmind.xml.wxs.validate.SimpleType;
import java.util.ArrayList;

final class AttributeInfo
extends Info {
    public Name ref = null;
    public String default_ = null;
    public String fixed = null;
    public Use use = Use.OPTIONAL;
    public Name type = null;
    public SimpleTypeInfo typeInfo = null;

    public AttributeInfo(Info info) {
        super(info);
    }

    @Override
    public void init(Element element, SchemaInfo schemaInfo, LoadContext loadContext, SchemaErrors schemaErrors, SchemaErrors schemaErrors2) {
        Element element2;
        super.init(element, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        Namespace namespace = this.getTargetNamespace(element, true, schemaInfo);
        this.name = AttributeInfo.getNCNameAttribute(element, _NAME, namespace, null);
        this.ref = this.getQNameAttribute(element, _REF, null);
        if (this.ref != null) {
            this.checkImportedNamespaces(this.ref, schemaInfo, schemaErrors2);
        }
        this.default_ = element.getAttribute(_DEFAULT);
        this.fixed = element.getAttribute(_FIXED);
        this.use = AttributeInfo.getUseAttribute(element, _USE, Use.OPTIONAL);
        this.type = this.getQNameAttribute(element, _TYPE, null);
        if (this.type != null) {
            this.checkImportedNamespaces(this.type, schemaInfo, schemaErrors2);
        }
        if ((element2 = AttributeInfo.getChild(element, XSD_SIMPLE_TYPE)) != null) {
            this.typeInfo = new SimpleTypeInfo(this);
            this.typeInfo.init(element2, schemaInfo, loadContext, schemaErrors, schemaErrors2);
        }
        if (this.default_ != null && this.fixed != null) {
            schemaErrors2.append(this, "src-attribute.1", "inconsistentFixed");
        }
        if (this.default_ != null && this.use != Use.OPTIONAL) {
            schemaErrors2.append(this, "src-attribute.2", "inconsistentUse");
        }
        if (!(this.parent instanceof SchemaInfo) && !(this.parent instanceof RedefineInfo)) {
            if (this.name == null && this.ref == null) {
                schemaErrors2.append(this, "src-attribute.3.1", "missingName");
            } else if (this.name != null && this.ref != null) {
                schemaErrors2.append(this, "src-attribute.3.1", "inconsistentName");
            }
            if (this.ref != null && (this.typeInfo != null || element.hasAttribute(_FORM) || this.type != null)) {
                schemaErrors2.append(this, "src-attribute.3.2", "inconsistentForm");
            }
        }
        if (this.type != null && this.typeInfo != null) {
            schemaErrors2.append(this, "src-attribute.4", "inconsistentType");
        }
    }

    public AttributeDeclaration toAttributeDeclaration(LoadState loadState) {
        if (this.name.namespace == Namespace.XSI) {
            loadState.errors.append(this, "no-xsi", "xsiAttributeDeclaration");
            return null;
        }
        SimpleType simpleType = this.typeInfo != null ? (SimpleType)this.typeInfo.toType(loadState) : (this.type != null ? loadState.getSimpleType(this.type, this, "a-props-correct.1") : SimpleType.ANY);
        if (simpleType == null) {
            return null;
        }
        DataType dataType = simpleType.getDataType();
        Value value = null;
        boolean bl = false;
        if (this.default_ != null || this.fixed != null) {
            String string;
            if (this.fixed != null) {
                string = this.fixed;
                bl = true;
            } else {
                string = this.default_;
            }
            try {
                value = dataType.valueOf(string, this);
            }
            catch (InvalidDataException invalidDataException) {
                loadState.errors.append(this, "a-props-correct.2", "invalidValueConstraint", string, invalidDataException.getMessage(), invalidDataException.getConstraint());
                return null;
            }
            if (dataType instanceof IDType) {
                loadState.errors.append(this, "a-props-correct.3", "idWithDefault", "attribute");
                return null;
            }
        }
        return new AttributeDeclaration(this.name, dataType, value, bl);
    }

    public boolean toAttributeUse(ArrayList<AttributeUse> arrayList, ArrayList<Name> arrayList2, ComplexType complexType, LoadState loadState) {
        if (this.use == Use.PROHIBITED) {
            arrayList2.add(this.ref == null ? this.name : this.ref);
            return true;
        }
        if (this.ref == null) {
            AttributeDeclaration attributeDeclaration = this.toAttributeDeclaration(loadState);
            if (attributeDeclaration == null) {
                return false;
            }
            complexType.addAttributeDeclaration(attributeDeclaration);
            arrayList.add(new AttributeUse(this.name, this.use == Use.REQUIRED));
        } else {
            AttributeDeclaration attributeDeclaration = loadState.getAttributeDeclaration(this.ref, this, "au-props-correct.1");
            if (attributeDeclaration == null) {
                return false;
            }
            DataType dataType = attributeDeclaration.dataType;
            Value value = null;
            boolean bl = false;
            if (this.default_ != null || this.fixed != null) {
                String string;
                if (this.fixed != null) {
                    string = this.fixed;
                    bl = true;
                } else {
                    string = this.default_;
                }
                try {
                    value = dataType.valueOf(string, this);
                }
                catch (InvalidDataException invalidDataException) {
                    loadState.errors.append(this, "au-props-correct.1", "invalidValueConstraint", string, invalidDataException.getMessage(), invalidDataException.getConstraint());
                    return false;
                }
                Value value2 = attributeDeclaration.defaultValue;
                boolean bl2 = attributeDeclaration.isFixedValue;
                if (bl2 && bl && !value2.equals(value)) {
                    loadState.errors.append(this, "au-props-correct.2", "inconsistentFixedValue", string, this.ref.format(false, this));
                    return false;
                }
                if (bl2 != bl || value2 == null || !value2.equals(value)) {
                    complexType.addAttributeDeclaration(new AttributeDeclaration(this.ref, dataType, value, bl));
                }
            }
            arrayList.add(new AttributeUse(this.ref, this.use == Use.REQUIRED));
        }
        return true;
    }
}

