/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype;

import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.Msg;
import com.xmlmind.xml.wxs.datatype.NumericValue;
import com.xmlmind.xml.wxs.datatype.Value;
import java.math.BigDecimal;

public class DecimalValue
extends NumericValue {
    private final BigDecimal decimal;

    public static DecimalValue parseDecimal(String string) throws InvalidDataException {
        BigDecimal bigDecimal = null;
        try {
            if (DecimalValue.checkString(string)) {
                bigDecimal = new BigDecimal(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (bigDecimal == null) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("decimalSyntax", string));
        }
        return new DecimalValue(bigDecimal);
    }

    private static final boolean checkString(String string) {
        int n = string.length();
        if (n == 0) {
            return false;
        }
        int n2 = 0;
        switch (string.charAt(n2)) {
            case '+': 
            case '-': {
                if (++n2 != n) break;
                return false;
            }
        }
        boolean bl = false;
        if (string.charAt(n2) == '.') {
            bl = true;
            if (++n2 == n) {
                return false;
            }
        }
        do {
            switch (string.charAt(n2)) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    break;
                }
                case '.': {
                    if (bl) {
                        return false;
                    }
                    bl = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        } while (++n2 < n);
        return true;
    }

    public DecimalValue(BigDecimal bigDecimal) {
        this.decimal = bigDecimal;
    }

    public BigDecimal getBigDecimal() {
        return this.decimal;
    }

    @Override
    public BigDecimal toBigDecimal() {
        return this.decimal;
    }

    @Override
    public String toString() {
        int n;
        String string = this.decimal.toString();
        int n2 = string.length();
        int n3 = 0;
        int n4 = 0;
        for (n = n2 - 1; n >= 0 && string.charAt(n) == '0'; --n) {
            ++n3;
            ++n4;
        }
        boolean bl = false;
        while (n >= 0) {
            if (string.charAt(n) == '.') {
                bl = true;
                break;
            }
            ++n4;
            --n;
        }
        if (!bl) {
            return string + ".0";
        }
        if (n3 == n4) {
            --n3;
        }
        if (n3 > 0) {
            return string.substring(0, n2 - n3);
        }
        return string;
    }

    @Override
    public int hashCode() {
        return this.decimal.intValue();
    }

    @Override
    public int compareTo(Value value) {
        if (value == null || !(value instanceof NumericValue)) {
            return -2;
        }
        return this.decimal.compareTo(((NumericValue)value).toBigDecimal());
    }

    @Override
    public int totalDigits() {
        String string = this.toString();
        int n = string.length();
        if (string.charAt(0) == '-') {
            --n;
        }
        n = string.endsWith(".0") ? (n -= 2) : --n;
        return n;
    }

    @Override
    public int fractionDigits() {
        String string = this.toString();
        if (string.endsWith(".0")) {
            return 0;
        }
        int n = 0;
        for (int i = string.length() - 1; i >= 0 && string.charAt(i) != '.'; --i) {
            ++n;
        }
        return n;
    }
}

