/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype;

import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.Msg;
import com.xmlmind.xml.wxs.datatype.Value;

public class BooleanValue
extends Value {
    public static final BooleanValue FALSE = new BooleanValue(false);
    public static final BooleanValue TRUE = new BooleanValue(true);
    private boolean bool;

    public static BooleanValue parseBoolean(String string) throws InvalidDataException {
        if (string.equals("1") || string.equals("true")) {
            return TRUE;
        }
        if (string.equals("0") || string.equals("false")) {
            return FALSE;
        }
        throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("booleanSyntax", string));
    }

    public BooleanValue(boolean bl) {
        this.bool = bl;
    }

    public boolean getBoolean() {
        return this.bool;
    }

    @Override
    public String toString() {
        return this.bool ? "true" : "false";
    }

    @Override
    public int hashCode() {
        return this.bool ? 1 : 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof BooleanValue)) {
            return false;
        }
        BooleanValue booleanValue = (BooleanValue)object;
        return this.bool == booleanValue.bool;
    }
}

