/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.wxs.datatype;

import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.xml.wxs.datatype.InvalidDataException;
import com.xmlmind.xml.wxs.datatype.Msg;
import com.xmlmind.xml.wxs.datatype.Value;
import java.net.URI;
import java.net.URISyntaxException;

public class AnyURIValue
extends Value {
    private URI uri;

    public static AnyURIValue parseAnyURI(String string) throws InvalidDataException {
        URI uRI;
        try {
            uRI = new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new InvalidDataException("cvc-datatype-valid.1.2.1", Msg.msg("anyURISyntax", string, ThrowableUtil.reason(uRISyntaxException)));
        }
        return new AnyURIValue(uRI);
    }

    public AnyURIValue(URI uRI) {
        this.uri = uRI;
    }

    public URI getURI() {
        return this.uri;
    }

    @Override
    public String toString() {
        return this.uri.toASCIIString();
    }

    @Override
    public int hashCode() {
        return this.uri.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof AnyURIValue)) {
            return false;
        }
        AnyURIValue anyURIValue = (AnyURIValue)object;
        return this.uri.equals(anyURIValue.uri);
    }

    @Override
    public int length() {
        return this.uri.toASCIIString().length();
    }
}

