/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.validate;

import com.xmlmind.util.SystemUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.name.PrefixPreferences;
import com.xmlmind.xml.validate.ElementType;
import com.xmlmind.xml.validate.Msg;
import com.xmlmind.xml.validate.SubDocumentType;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;

public abstract class DocumentationGeneratorBase
implements NamespaceToPrefixes {
    public static final String INDEX_PAGE_NAME = "index.html";
    public static final String NAMESPACES_PAGE_NAME = "namespaces.html";
    public static final byte TOP_NAVIGATION_BAR = 1;
    public static final byte BOTTOM_NAVIGATION_BAR = 2;
    public static final byte BOTH_NAVIGATION_BARS = 3;
    protected String css = null;
    protected boolean addContentMeta = true;
    protected String charset = null;
    protected PrefixPreferences userPrefixPreferences = null;
    protected PrefixPreferences prefixPreferences = new PrefixPreferences();
    protected byte navigationBars = (byte)3;
    protected static final String indexPageTitle = Msg.msg("DG.indexPageTitle");
    protected static final String namespacesPageTitle = Msg.msg("DG.namespacesPageTitle");
    protected static final String namespacePrefixLabel = Msg.msg("DG.namespacePrefix");
    protected static final String namespaceURILabel = Msg.msg("DG.namespaceURI");
    protected static final String defaultNamespaceLabel = Msg.msg("DG.defaultNamespace");

    public void setCSS(String string) {
        this.css = string;
    }

    public String getCSS() {
        return this.css;
    }

    public void setContentMetaAdded(boolean bl) {
        this.addContentMeta = bl;
    }

    public boolean isContentMetaAdded() {
        return this.addContentMeta;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setPrefixPreferences(PrefixPreferences prefixPreferences) {
        this.userPrefixPreferences = prefixPreferences;
    }

    public PrefixPreferences getPrefixPreferences() {
        return this.userPrefixPreferences;
    }

    public void setNavigationBars(int n) {
        this.navigationBars = (byte)n;
    }

    public int getNavigationBars() {
        return this.navigationBars;
    }

    public abstract void initSubDocumentType(SubDocumentType var1);

    public abstract SubDocumentType getSubDocumentType();

    public abstract void generateAll(File var1) throws IOException;

    public abstract void generateIndexPage(PageInfo var1);

    public abstract void generateNamespacesPage(PageInfo var1);

    public abstract ElementType getElementType(String var1);

    public abstract boolean generateElementPage(ElementType var1, PageInfo var2);

    protected void generateNamespacesPage(PrefixEntry[] prefixEntryArray, PageInfo pageInfo) {
        Object object;
        int n;
        PrefixPreferences prefixPreferences = this.userPrefixPreferences == null ? this.prefixPreferences : this.userPrefixPreferences;
        Namespace namespace = prefixPreferences.getDefaultNamespace();
        Object[] objectArray = prefixPreferences.getAll();
        if (objectArray.length > 1) {
            Arrays.sort(objectArray);
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.appendPageStart(stringBuilder);
        stringBuilder.append("<title>");
        String string = namespacesPageTitle;
        XMLText.escapeXML(string, stringBuilder);
        stringBuilder.append("</title>\n");
        this.appendPageMiddle(true, false, stringBuilder);
        stringBuilder.append("<h1>");
        XMLText.escapeXML(string, stringBuilder);
        stringBuilder.append("</h1>\n");
        stringBuilder.append("<table border='1'>\n");
        stringBuilder.append("<tr><th>");
        XMLText.escapeXML(namespacePrefixLabel, stringBuilder);
        stringBuilder.append("</th><th>");
        XMLText.escapeXML(namespaceURILabel, stringBuilder);
        stringBuilder.append("</th></tr>\n");
        if (namespace != null) {
            stringBuilder.append("<tr><td>&#160;</td><td><b>");
            XMLText.escapeXML(namespace.toString(), stringBuilder);
            stringBuilder.append("</b> (");
            XMLText.escapeXML(defaultNamespaceLabel, stringBuilder);
            stringBuilder.append(")</td></tr>\n");
        }
        for (n = 0; n < objectArray.length; ++n) {
            object = objectArray[n];
            stringBuilder.append("<tr><td>");
            XMLText.escapeXML(((PrefixEntry)object).prefix, stringBuilder);
            stringBuilder.append("</td><td>");
            XMLText.escapeXML(((PrefixEntry)object).namespace.toString(), stringBuilder);
            stringBuilder.append("</td></tr>\n");
        }
        if (prefixEntryArray != null) {
            for (n = 0; n < prefixEntryArray.length; ++n) {
                object = prefixEntryArray[n];
                String string2 = prefixPreferences.get(((PrefixEntry)object).namespace);
                if (string2 != null && ((PrefixEntry)object).prefix.equals(string2)) continue;
                stringBuilder.append("<tr><td>");
                XMLText.escapeXML(((PrefixEntry)object).prefix, stringBuilder);
                stringBuilder.append("</td><td>");
                XMLText.escapeXML(((PrefixEntry)object).namespace.toString(), stringBuilder);
                stringBuilder.append("</td></tr>\n");
            }
        }
        stringBuilder.append("</table>\n");
        this.appendPageEnd(true, false, stringBuilder);
        pageInfo.html = stringBuilder.toString();
        pageInfo.name = NAMESPACES_PAGE_NAME;
        pageInfo.title = string;
    }

    protected void appendPageStart(StringBuilder stringBuilder) {
        stringBuilder.append("<html>\n<head>\n");
        if (this.addContentMeta) {
            stringBuilder.append("<meta http-equiv='Content-Type'");
            stringBuilder.append(" content='text/html; charset=");
            stringBuilder.append(this.charset == null ? SystemUtil.defaultEncoding() : this.charset);
            stringBuilder.append("'>\n");
        }
        if (this.css != null) {
            stringBuilder.append("<link href='");
            stringBuilder.append(this.css);
            stringBuilder.append("' rel='stylesheet' type='text/css'>\n");
        }
    }

    protected void appendPageMiddle(boolean bl, boolean bl2, StringBuilder stringBuilder) {
        stringBuilder.append("</head>\n<body text='black' bgcolor='white'>\n");
        this.appendNavigationBar(bl, bl2, false, stringBuilder);
    }

    protected void appendPageEnd(boolean bl, boolean bl2, StringBuilder stringBuilder) {
        this.appendNavigationBar(bl, bl2, true, stringBuilder);
        stringBuilder.append("</body>\n</html>\n");
    }

    protected void appendNavigationBar(boolean bl, boolean bl2, boolean bl3, StringBuilder stringBuilder) {
        if (bl3 && (this.navigationBars & 2) == 0 || !bl3 && (this.navigationBars & 1) == 0) {
            return;
        }
        if (bl || bl2) {
            if (bl3) {
                stringBuilder.append("<p></p>\n");
                stringBuilder.append("<hr>\n");
            }
            stringBuilder.append("<table border='0' cellpadding='0' cellspacing='0'>\n");
            stringBuilder.append("<tr>\n");
        }
        if (bl) {
            stringBuilder.append("<td><small>");
            stringBuilder.append("<a href='index.html'>");
            XMLText.escapeXML(indexPageTitle, stringBuilder);
            stringBuilder.append("</a>");
            stringBuilder.append("</small></td>\n");
        }
        if (bl && bl2) {
            stringBuilder.append("<td><small>&#160;&#160;&#160;&#160;</small></td>\n");
        }
        if (bl2) {
            stringBuilder.append("<td><small>");
            stringBuilder.append("<a href='namespaces.html'>");
            XMLText.escapeXML(namespacesPageTitle, stringBuilder);
            stringBuilder.append("</a>");
            stringBuilder.append("</small></td>\n");
        }
        if (bl || bl2) {
            stringBuilder.append("</tr>\n");
            stringBuilder.append("</table>\n");
            if (!bl3) {
                stringBuilder.append("<hr>\n");
                stringBuilder.append("<p></p>\n");
            }
        }
    }

    @Override
    public String[] namespaceToPrefixes(Namespace namespace) {
        if (this.userPrefixPreferences == null) {
            if (this.prefixPreferences.size() == 0) {
                Namespace[] namespaceArray;
                SubDocumentType subDocumentType = this.getSubDocumentType();
                PrefixEntry[] prefixEntryArray = subDocumentType.getSchemaDeclaredPrefixes();
                if (prefixEntryArray != null) {
                    this.prefixPreferences.add(prefixEntryArray, true);
                }
                if ((namespaceArray = subDocumentType.getTargetNamespaces()) != null) {
                    for (int i = 0; i < namespaceArray.length; ++i) {
                        Namespace namespace2 = namespaceArray[i];
                        if (this.prefixPreferences.add(namespace2, null) == null) continue;
                        this.prefixPreferences.setDefaultNamespace(namespace2);
                        break;
                    }
                }
            }
            if (this.prefixPreferences.get(namespace) == null) {
                this.prefixPreferences.add(namespace, null);
            }
            return this.prefixPreferences.namespaceToPrefixes(namespace);
        }
        return this.userPrefixPreferences.namespaceToPrefixes(namespace);
    }

    public static final class PageInfo {
        public String html;
        public String name;
        public String title;
    }
}

