/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.sxpath;

import com.xmlmind.util.StringUtil;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.sxpath.Path;
import java.io.Serializable;

public final class XPath
implements Serializable {
    private Path[] paths;

    private XPath() {
    }

    public static XPath fromString(String string, PrefixToNamespace prefixToNamespace) {
        return XPath.fromString(string, prefixToNamespace, false);
    }

    public static XPath fromString(String string, PrefixToNamespace prefixToNamespace, boolean bl) {
        String[] stringArray = StringUtil.split(string, '|');
        Path[] pathArray = new Path[stringArray.length];
        int n = 0;
        for (String string2 : stringArray) {
            if ((string2 = string2.trim()).length() == 0) continue;
            pathArray[n] = Path.fromString(string2, prefixToNamespace, bl);
            if (pathArray[n] == null) {
                return null;
            }
            ++n;
        }
        if (n == 0) {
            return null;
        }
        XPath xPath = new XPath();
        if (n != pathArray.length) {
            xPath.paths = new Path[n];
            System.arraycopy(pathArray, 0, xPath.paths, 0, n);
        } else {
            xPath.paths = pathArray;
        }
        return xPath;
    }

    public Path[] getPaths() {
        return this.paths;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof XPath)) {
            return false;
        }
        XPath xPath = (XPath)object;
        if (this.paths == null || xPath.paths == null) {
            return this.paths == xPath.paths;
        }
        int n = this.paths.length;
        if (n != xPath.paths.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.paths[i].equals(xPath.paths[i])) continue;
            return false;
        }
        return true;
    }

    public boolean sameAs(XPath xPath) {
        if (xPath == null) {
            return false;
        }
        if (this.paths == null || xPath.paths == null) {
            return this.paths == xPath.paths;
        }
        int n = this.paths.length;
        if (n != xPath.paths.length) {
            return false;
        }
        if (n == 1) {
            return this.paths[0].equals(xPath.paths[0]);
        }
        Path[] pathArray = (Path[])xPath.paths.clone();
        for (int i = 0; i < n; ++i) {
            Path path = this.paths[i];
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                if (pathArray[j] == null || !path.equals(pathArray[j])) continue;
                bl = true;
                pathArray[j] = null;
                break;
            }
            if (bl) continue;
            return false;
        }
        return true;
    }

    public String toString(NamespaceToPrefixes namespaceToPrefixes) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.paths.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append('|');
            }
            this.paths[i].toString(stringBuilder, namespaceToPrefixes);
        }
        return stringBuilder.toString();
    }

    public XNode[] select(Tree tree) {
        return this.select(tree, false);
    }

    public XNode[] select(Tree tree, boolean bl) {
        XNode[] xNodeArray = Path.NO_XNODES;
        for (Path path : this.paths) {
            XNode[] xNodeArray2 = path.select(tree, bl);
            if (xNodeArray2 == null || xNodeArray2.length == 0) continue;
            xNodeArray = xNodeArray == Path.NO_XNODES ? xNodeArray2 : XPath.union(xNodeArray, xNodeArray2);
        }
        return xNodeArray;
    }

    public static XNode[] union(XNode[] xNodeArray, XNode[] xNodeArray2) {
        int n = xNodeArray.length;
        int n2 = xNodeArray2.length;
        XNode[] xNodeArray3 = new XNode[n + n2];
        System.arraycopy(xNodeArray, 0, xNodeArray3, 0, n);
        int n3 = n;
        for (int i = 0; i < n2; ++i) {
            XNode xNode = xNodeArray2[i];
            boolean bl = false;
            for (int j = 0; j < n; ++j) {
                if (!xNode.equals(xNodeArray3[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            xNodeArray3[n3++] = xNode;
        }
        if (n3 != xNodeArray3.length) {
            XNode[] xNodeArray4 = new XNode[n3];
            System.arraycopy(xNodeArray3, 0, xNodeArray4, 0, n3);
            xNodeArray3 = xNodeArray4;
        }
        return xNodeArray3;
    }

    public boolean match(XNode xNode) {
        for (Path path : this.paths) {
            if (!path.match(xNode)) continue;
            return true;
        }
        return false;
    }
}

