/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.sxpath;

import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.name.PrefixToNamespace;
import java.io.Serializable;

public final class Step
implements Serializable {
    Axis axis;
    Test test;
    Name name;
    Namespace namespace;

    Step() {
    }

    public static Step fromString(String string, PrefixToNamespace prefixToNamespace) {
        return Step.fromString(string, prefixToNamespace, false);
    }

    public static Step fromString(String string, PrefixToNamespace prefixToNamespace, boolean bl) {
        Step step = new Step();
        int n = string.length();
        int n2 = string.indexOf("::");
        if (n2 > 0 && n2 + 2 < n) {
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 2);
            if ("child".equals(string2)) {
                step.axis = Axis.CHILD;
            } else if ("attribute".equals(string2)) {
                step.axis = Axis.ATTRIBUTE;
            } else if ("descendant-or-self".equals(string2)) {
                step.axis = Axis.DESCENDANT_OR_SELF;
            } else if ("self".equals(string2)) {
                step.axis = Axis.SELF;
            } else {
                return null;
            }
            if ("*".equals(string3)) {
                step.test = Test.ALL;
            } else if ("node()".equals(string3)) {
                step.test = Test.NODE;
            } else if (!Step.parseName(string3, prefixToNamespace, step.axis == Axis.ATTRIBUTE ? false : bl, step)) {
                return null;
            }
        } else if (".".equals(string)) {
            step.axis = Axis.SELF;
            step.test = Test.NODE;
        } else if ("*".equals(string)) {
            step.axis = Axis.CHILD;
            step.test = Test.ALL;
        } else if (string.indexOf(64) == 0 && n > 1) {
            step.axis = Axis.ATTRIBUTE;
            if (!Step.parseName(string.substring(1), prefixToNamespace, false, step)) {
                return null;
            }
        } else {
            step.axis = Axis.CHILD;
            if (!Step.parseName(string, prefixToNamespace, bl, step)) {
                return null;
            }
        }
        return step;
    }

    private static boolean parseName(String string, PrefixToNamespace prefixToNamespace, boolean bl, Step step) {
        if (string.endsWith(":*")) {
            String string2 = string.substring(0, string.length() - 2) + ":x";
            Name name = Name.parse(string2, !bl, prefixToNamespace);
            if (name == null) {
                return false;
            }
            step.test = Test.NAMESPACE;
            step.namespace = name.namespace;
        } else {
            step.test = Test.NAME;
            step.name = Name.parse(string, !bl, prefixToNamespace);
            if (step.name == null) {
                return false;
            }
        }
        return true;
    }

    public Axis getAxis() {
        return this.axis;
    }

    public Test getTest() {
        return this.test;
    }

    public Name getTestedName() {
        return this.name;
    }

    public Namespace getTestedNamespace() {
        return this.namespace;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Step)) {
            return false;
        }
        Step step = (Step)object;
        return this.axis == step.axis && this.test == step.test && this.name == step.name && this.namespace == step.namespace;
    }

    public String toString(NamespaceToPrefixes namespaceToPrefixes) {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, namespaceToPrefixes);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder, NamespaceToPrefixes namespaceToPrefixes) {
        switch (this.axis) {
            case SELF: {
                stringBuilder.append("self");
                break;
            }
            case DESCENDANT_OR_SELF: {
                stringBuilder.append("descendant-or-self");
                break;
            }
            case CHILD: {
                stringBuilder.append("child");
                break;
            }
            case ATTRIBUTE: {
                stringBuilder.append("attribute");
                break;
            }
            default: {
                stringBuilder.append("(unknown axis " + String.valueOf((Object)this.axis) + ")");
            }
        }
        stringBuilder.append("::");
        switch (this.test) {
            case NODE: {
                stringBuilder.append("node()");
                break;
            }
            case ALL: {
                stringBuilder.append('*');
                break;
            }
            case NAME: {
                stringBuilder.append(this.name.format(true, namespaceToPrefixes));
                break;
            }
            case NAMESPACE: {
                Object object;
                if (this.namespace == Namespace.XML) {
                    object = "xml";
                } else {
                    String[] stringArray = namespaceToPrefixes == null ? null : namespaceToPrefixes.namespaceToPrefixes(this.namespace);
                    object = null;
                    if (stringArray != null) {
                        for (String string : stringArray) {
                            if (string.length() <= 0) continue;
                            object = string;
                            break;
                        }
                    }
                    if (object == null) {
                        object = "{" + String.valueOf(this.namespace) + "}";
                    }
                }
                stringBuilder.append((String)object);
                stringBuilder.append(":*");
                break;
            }
            default: {
                stringBuilder.append("(unknown test " + String.valueOf((Object)this.test) + ")");
            }
        }
    }

    public static enum Test {
        NODE,
        ALL,
        NAME,
        NAMESPACE;

    }

    public static enum Axis {
        SELF,
        DESCENDANT_OR_SELF,
        CHILD,
        ATTRIBUTE;

    }
}

