/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.sxpath;

import com.xmlmind.util.StringUtil;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.name.PrefixToNamespace;
import com.xmlmind.xml.sxpath.Step;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;

public final class Path
implements Serializable {
    private Step[] steps;
    private boolean isAbsolute;
    private static final Path DOCUMENT_PATH = new Path();
    static final XNode[] NO_XNODES;

    private Path() {
    }

    public static Path fromString(String string, PrefixToNamespace prefixToNamespace) {
        return Path.fromString(string, prefixToNamespace, false);
    }

    public static Path fromString(String string, PrefixToNamespace prefixToNamespace, boolean bl) {
        Step step;
        Object object;
        int n;
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        String[] stringArray = StringUtil.split(string, '/');
        boolean bl2 = false;
        Step[] stepArray = new Step[stringArray.length];
        int n2 = 0;
        int n3 = 0;
        if (stringArray[n3].length() == 0) {
            bl2 = true;
            ++n3;
        }
        if ((n = stringArray.length - 1) >= 0 && stringArray[n].length() == 0) {
            --n;
        }
        while (n3 <= n) {
            object = stringArray[n3];
            if (((String)object).length() == 0) {
                step = new Step();
                step.axis = Step.Axis.DESCENDANT_OR_SELF;
                step.test = Step.Test.NODE;
            } else {
                step = Step.fromString((String)object, prefixToNamespace, bl);
                if (step == null) {
                    return null;
                }
            }
            stepArray[n2++] = step;
            ++n3;
        }
        if (n2 == 0) {
            if (bl2) {
                return DOCUMENT_PATH;
            }
            return null;
        }
        object = new Path();
        ((Path)object).isAbsolute = bl2;
        if (n2 != stepArray.length) {
            ((Path)object).steps = new Step[n2];
            System.arraycopy(stepArray, 0, ((Path)object).steps, 0, n2);
        } else {
            ((Path)object).steps = stepArray;
        }
        n = n2 - 1;
        for (n3 = 0; n3 <= n; ++n3) {
            step = ((Path)object).steps[n3];
            if (step.axis != Step.Axis.ATTRIBUTE || n3 == n) continue;
            return null;
        }
        return object;
    }

    public Step[] getSteps() {
        return this.steps;
    }

    public boolean isAbsolute() {
        return this.isAbsolute;
    }

    public boolean isSelectingAttributes() {
        return this.steps.length > 0 && this.steps[this.steps.length - 1].axis == Step.Axis.ATTRIBUTE;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof Path)) {
            return false;
        }
        Path path = (Path)object;
        if (this.steps == null || path.steps == null) {
            return this.steps == path.steps && this.isAbsolute == path.isAbsolute;
        }
        int n = this.steps.length;
        if (n != path.steps.length || this.isAbsolute != path.isAbsolute) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (this.steps[i].equals(path.steps[i])) continue;
            return false;
        }
        return true;
    }

    public String toString(NamespaceToPrefixes namespaceToPrefixes) {
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, namespaceToPrefixes);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder, NamespaceToPrefixes namespaceToPrefixes) {
        if (this.isAbsolute) {
            stringBuilder.append('/');
        }
        int n = this.steps.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append('/');
            }
            this.steps[i].toString(stringBuilder, namespaceToPrefixes);
        }
    }

    public XNode[] select(Tree tree) {
        return this.select(tree, false);
    }

    public XNode[] select(Tree tree, boolean bl) {
        if (this.isAbsolute && tree.getType() != Node.Type.DOCUMENT) {
            return NO_XNODES;
        }
        ArrayList<XNode> arrayList = new ArrayList<XNode>();
        Path.select(tree, this.steps, 0, bl, arrayList);
        return Path.toXNodeArray(arrayList);
    }

    private static void select(Tree tree, Step[] stepArray, int n, boolean bl, ArrayList<XNode> arrayList) {
        Step step = stepArray[n];
        boolean bl2 = n == stepArray.length - 1;
        switch (step.axis) {
            case SELF: 
            case DESCENDANT_OR_SELF: {
                Node node;
                boolean bl3 = false;
                if (tree.getType() == Node.Type.ELEMENT) {
                    node = (Element)tree;
                    switch (step.test) {
                        case NODE: 
                        case ALL: {
                            bl3 = true;
                            break;
                        }
                        case NAME: {
                            bl3 = ((Element)node).getName() == step.name;
                            break;
                        }
                        case NAMESPACE: {
                            bl3 = ((Element)node).getName().namespace == step.namespace;
                        }
                    }
                } else {
                    boolean bl4 = bl3 = step.test == Step.Test.NODE;
                }
                if (bl3) {
                    if (bl2) {
                        arrayList.add(tree);
                    } else {
                        Path.select(tree, stepArray, n + 1, bl, arrayList);
                    }
                }
                if (step.axis != Step.Axis.DESCENDANT_OR_SELF) break;
                for (node = tree.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getType() != Node.Type.ELEMENT) continue;
                    Path.select((Element)node, stepArray, n, bl, arrayList);
                }
                break;
            }
            case CHILD: {
                for (Node node = tree.getFirstChild(); node != null; node = node.getNextSibling()) {
                    if (node.getType() != Node.Type.ELEMENT) continue;
                    Element element = (Element)node;
                    boolean bl5 = false;
                    switch (step.test) {
                        case NODE: 
                        case ALL: {
                            bl5 = true;
                            break;
                        }
                        case NAME: {
                            bl5 = element.getName() == step.name;
                            break;
                        }
                        case NAMESPACE: {
                            boolean bl6 = bl5 = element.getName().namespace == step.namespace;
                        }
                    }
                    if (!bl5) continue;
                    if (bl2) {
                        arrayList.add(element);
                        continue;
                    }
                    Path.select(element, stepArray, n + 1, bl, arrayList);
                }
                break;
            }
            case ATTRIBUTE: {
                if (tree.getType() != Node.Type.ELEMENT) {
                    return;
                }
                boolean bl7 = false;
                Iterator<Attribute> iterator = ((Element)tree).getAttributes();
                while (iterator.hasNext()) {
                    Attribute attribute = iterator.next();
                    switch (step.test) {
                        case NODE: 
                        case ALL: {
                            arrayList.add(attribute.copy());
                            break;
                        }
                        case NAME: {
                            if (attribute.name != step.name) break;
                            arrayList.add(attribute.copy());
                            bl7 = true;
                            break;
                        }
                        case NAMESPACE: {
                            if (attribute.name.namespace != step.namespace) break;
                            arrayList.add(attribute.copy());
                        }
                    }
                }
                if (!bl || bl7 || step.test != Step.Test.NAME) break;
                arrayList.add(new Attribute((Element)tree, step.name, null));
            }
        }
    }

    private static XNode[] toXNodeArray(ArrayList<XNode> arrayList) {
        int n = arrayList.size();
        XNode[] xNodeArray = new XNode[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            XNode xNode = arrayList.get(i);
            boolean bl = false;
            for (int j = 0; j < n2; ++j) {
                if (!xNode.equals(xNodeArray[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            xNodeArray[n2++] = xNode;
        }
        if (n2 != n) {
            XNode[] xNodeArray2 = new XNode[n2];
            System.arraycopy(xNodeArray, 0, xNodeArray2, 0, n2);
            xNodeArray = xNodeArray2;
        }
        return xNodeArray;
    }

    public boolean match(XNode xNode) {
        int n = this.steps.length;
        if (n > 0) {
            Step step = this.steps[n - 1];
            if (step.axis == Step.Axis.ATTRIBUTE) {
                if (xNode.type() != XNode.Type.ATTRIBUTE) {
                    return false;
                }
                Attribute attribute = (Attribute)xNode;
                switch (step.test) {
                    case NODE: 
                    case ALL: {
                        break;
                    }
                    case NAME: {
                        if (attribute.name == step.name) break;
                        return false;
                    }
                    case NAMESPACE: {
                        if (attribute.name.namespace == step.namespace) break;
                        return false;
                    }
                    default: {
                        throw new RuntimeException("unknown Step test " + String.valueOf((Object)step.test));
                    }
                }
                xNode = attribute.element;
                --n;
            }
        }
        if (xNode == null || !(xNode instanceof Node)) {
            return false;
        }
        return Path.match(this.steps, n, this.isAbsolute, (Node)xNode);
    }

    private static final boolean match(Step[] stepArray, int n, boolean bl, Node node) {
        block6: for (int i = n - 1; i >= 0; --i) {
            Step step = stepArray[i];
            switch (step.axis) {
                case SELF: {
                    if (node != null && Path.match(step, node)) continue block6;
                    return false;
                }
                case DESCENDANT_OR_SELF: {
                    if (node == null || !Path.match(step, node)) {
                        return false;
                    }
                    while (node != null && !Path.match(stepArray, i, bl, node)) {
                        node = node.getParent();
                    }
                    return node != null;
                }
                case CHILD: {
                    if (node == null || !Path.match(step, node)) {
                        return false;
                    }
                    node = node.getParent();
                    continue block6;
                }
                case ATTRIBUTE: {
                    return false;
                }
                default: {
                    throw new RuntimeException("unknown Step axis " + String.valueOf((Object)step.axis));
                }
            }
        }
        return !bl || node != null && node.getType() == Node.Type.DOCUMENT;
    }

    private static final boolean match(Step step, Node node) {
        switch (step.test) {
            case NODE: 
            case ALL: {
                break;
            }
            case NAME: {
                if (node instanceof Element) {
                    if (((Element)node).getName() == step.name) break;
                    return false;
                }
                return false;
            }
            case NAMESPACE: {
                if (node instanceof Element) {
                    if (((Element)node).getNamespace() == step.namespace) break;
                    return false;
                }
                return false;
            }
            default: {
                throw new RuntimeException("unknown Step test " + String.valueOf((Object)step.test));
            }
        }
        return true;
    }

    static {
        Path.DOCUMENT_PATH.isAbsolute = true;
        Path.DOCUMENT_PATH.steps = new Step[]{Step.fromString(".", null, false)};
        NO_XNODES = new XNode[0];
    }
}

