/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.schematron;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.schematron.Assertion;
import com.xmlmind.xml.schematron.KeySpec;
import com.xmlmind.xml.schematron.LetVariable;
import com.xmlmind.xml.schematron.ValidateExprContext;
import com.xmlmind.xml.validate.Diagnostic;
import com.xmlmind.xml.validate.DiagnosticImpl;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.Pattern;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

final class Rule {
    public final Pattern contextPattern;
    public final String contextString;
    public final LetVariable[] letVariables;
    public final Assertion[] assertions;

    public Rule(Pattern pattern, String string, LetVariable[] letVariableArray, Assertion[] assertionArray) {
        this.contextPattern = pattern;
        this.contextString = string;
        this.letVariables = letVariableArray;
        this.assertions = assertionArray;
    }

    public boolean apply(XNode xNode, ValidateExprContext validateExprContext, ArrayList<Diagnostic> arrayList) throws EvalException {
        if (!this.contextPattern.matches(xNode, validateExprContext)) {
            return false;
        }
        if (this.letVariables.length > 0) {
            validateExprContext.pushVariables(this.letVariables, xNode);
        }
        for (Assertion assertion : this.assertions) {
            XNode xNode2;
            if (assertion.check(xNode, validateExprContext)) continue;
            switch (xNode.type()) {
                case TEXT: 
                case COMMENT: 
                case PROCESSING_INSTRUCTION: 
                case ATTRIBUTE: {
                    xNode2 = xNode.parent();
                    break;
                }
                case ELEMENT: {
                    xNode2 = xNode;
                    break;
                }
                default: {
                    xNode2 = xNode.document();
                }
            }
            Element element = xNode2 instanceof Document ? ((Document)xNode2).getRootElement() : (Element)xNode2;
            String string = assertion.message.format(xNode, validateExprContext);
            arrayList.add(new DiagnosticImpl(element, string, Diagnostic.Severity.SEMANTIC_ERROR));
        }
        if (this.letVariables.length > 0) {
            validateExprContext.popVariables();
        }
        return true;
    }

    public void writeXML(Writer writer, int n) throws IOException {
        KeySpec.writeIndent(writer, n);
        writer.write("<sch:rule context=");
        writer.write(XMLText.quoteXML(this.contextString));
        writer.write(">\n");
        if (this.letVariables.length > 0) {
            for (LetVariable object : this.letVariables) {
                object.writeXML(writer, n + 2);
            }
            writer.write(10);
        }
        for (Assertion assertion : this.assertions) {
            assertion.writeXML(writer, n + 2);
        }
        KeySpec.writeIndent(writer, n);
        writer.write("</sch:rule>\n");
    }
}

