/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.schematron;

import com.xmlmind.util.LinearHashtable;
import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.schematron.KeySpec;
import com.xmlmind.xml.schematron.LetVariable;
import com.xmlmind.xml.schematron.Pattern;
import com.xmlmind.xml.schematron.Rule;
import com.xmlmind.xml.schematron.ValidateExprContext;
import com.xmlmind.xml.validate.Diagnostic;
import com.xmlmind.xml.xpath.EvalException;
import com.xmlmind.xml.xpath.Variant;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;

final class Phase {
    public final String id;
    public final LetVariable[] letVariables;
    public final Pattern[] patterns;

    public Phase(String string, LetVariable[] letVariableArray, Pattern[] patternArray) {
        this.id = string;
        this.letVariables = letVariableArray;
        this.patterns = patternArray;
    }

    public void validate(Document document, ValidateExprContext validateExprContext, ArrayList<Diagnostic> arrayList) throws EvalException {
        LinearHashtable<String, Variant> linearHashtable;
        Rule[] ruleArray;
        int n;
        if (this.letVariables.length > 0) {
            validateExprContext.pushVariables(this.letVariables, document);
        }
        LinearHashtable[] linearHashtableArray = new LinearHashtable[this.patterns.length];
        int n2 = this.patterns.length;
        for (n = 0; n < n2; ++n) {
            ruleArray = this.patterns[n];
            linearHashtable = null;
            if (ruleArray.letVariables.length > 0) {
                linearHashtable = validateExprContext.pushVariables(ruleArray.letVariables, document);
                validateExprContext.popVariables();
            }
            linearHashtableArray[n] = linearHashtable;
        }
        for (n = 0; n < n2; ++n) {
            ruleArray = this.patterns[n].rules;
            linearHashtable = linearHashtableArray[n];
            if (linearHashtable != null) {
                validateExprContext.pushVariables(linearHashtable);
            }
            for (Rule ruleArray2 : ruleArray) {
                if (ruleArray2.apply(document, validateExprContext, arrayList)) break;
            }
            if (linearHashtable == null) continue;
            validateExprContext.popVariables();
        }
        for (Node node = document.getFirstChild(); node != null; node = node.getNextSibling()) {
            boolean bl = false;
            boolean bl2 = false;
            switch (node.getType()) {
                case ELEMENT: {
                    bl2 = true;
                }
                case COMMENT: 
                case PROCESSING_INSTRUCTION: {
                    bl = true;
                }
            }
            if (!bl) continue;
            for (int i = 0; i < n2; ++i) {
                Rule[] ruleArray3 = this.patterns[i].rules;
                LinearHashtable linearHashtable2 = linearHashtableArray[i];
                if (linearHashtable2 != null) {
                    validateExprContext.pushVariables(linearHashtable2);
                }
                for (Rule rule : ruleArray3) {
                    if (rule.apply(node, validateExprContext, arrayList)) break;
                }
                if (linearHashtable2 == null) continue;
                validateExprContext.popVariables();
            }
            if (!bl2) continue;
            this.validate((Element)node, validateExprContext, linearHashtableArray, arrayList);
        }
        if (this.letVariables.length > 0) {
            validateExprContext.popVariables();
        }
    }

    private void validate(Element element, ValidateExprContext validateExprContext, LinearHashtable<String, Variant>[] linearHashtableArray, ArrayList<Diagnostic> arrayList) throws EvalException {
        int n;
        XNode xNode;
        int n2 = this.patterns.length;
        Iterator<Attribute> iterator = element.getAttributes();
        while (iterator.hasNext()) {
            xNode = iterator.next();
            for (n = 0; n < n2; ++n) {
                Rule[] ruleArray = this.patterns[n].rules;
                LinearHashtable<String, Variant> linearHashtable = linearHashtableArray[n];
                if (linearHashtable != null) {
                    validateExprContext.pushVariables(linearHashtable);
                }
                for (Rule rule : ruleArray) {
                    if (rule.apply(xNode, validateExprContext, arrayList)) break;
                }
                if (linearHashtable == null) continue;
                validateExprContext.popVariables();
            }
        }
        for (xNode = element.getFirstChild(); xNode != null; xNode = ((Node)xNode).getNextSibling()) {
            n = 0;
            boolean bl = false;
            switch (((Node)xNode).getType()) {
                case ELEMENT: {
                    bl = true;
                }
                case COMMENT: 
                case PROCESSING_INSTRUCTION: {
                    n = 1;
                }
            }
            if (n == 0) continue;
            for (int i = 0; i < n2; ++i) {
                Rule[] ruleArray = this.patterns[i].rules;
                LinearHashtable<String, Variant> linearHashtable = linearHashtableArray[i];
                if (linearHashtable != null) {
                    validateExprContext.pushVariables(linearHashtable);
                }
                for (Rule rule : ruleArray) {
                    if (rule.apply(xNode, validateExprContext, arrayList)) break;
                }
                if (linearHashtable == null) continue;
                validateExprContext.popVariables();
            }
            if (!bl) continue;
            this.validate((Element)xNode, validateExprContext, linearHashtableArray, arrayList);
        }
    }

    public void writeXML(Writer writer, int n) throws IOException {
        KeySpec.writeIndent(writer, n);
        writer.write("<sch:phase id=");
        writer.write(XMLText.quoteXML(this.id));
        writer.write(">\n");
        if (this.letVariables.length > 0) {
            for (LetVariable object : this.letVariables) {
                object.writeXML(writer, n + 2);
            }
            writer.write(10);
        }
        for (Pattern pattern : this.patterns) {
            this.writeActive(pattern.id, writer, n + 2);
        }
        KeySpec.writeIndent(writer, n);
        writer.write("</sch:phase>\n");
    }

    private void writeActive(String string, Writer writer, int n) throws IOException {
        KeySpec.writeIndent(writer, n);
        writer.write("<sch:active pattern=");
        writer.write(XMLText.quoteXML(string));
        writer.write("/>\n");
    }
}

