/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.schematron;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.schematron.KeySpec;
import com.xmlmind.xml.schematron.Message;
import com.xmlmind.xml.schematron.Msg;
import com.xmlmind.xml.schematron.ValidateExprContext;
import com.xmlmind.xml.xpath.BooleanExpr;
import com.xmlmind.xml.xpath.EvalException;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;

final class Assertion {
    public final BooleanExpr testExpr;
    public final String testString;
    public final boolean isNegative;
    public final Message message;
    public final URL assertURL;

    public Assertion(BooleanExpr booleanExpr, String string, boolean bl, Message message, URL uRL) {
        this.testExpr = booleanExpr;
        this.testString = string;
        this.isNegative = bl;
        this.assertURL = uRL;
        if (message == null || message.parts.length == 0) {
            String string2 = bl ? Msg.msg("reportSucceeded", string) : Msg.msg("assertFailed", string);
            message = new Message(new Message.Part[]{new Message.Text(string2)}, uRL);
        }
        this.message = message;
    }

    public boolean check(XNode xNode, ValidateExprContext validateExprContext) throws EvalException {
        validateExprContext.defaultBaseURL = this.assertURL;
        boolean bl = this.testExpr.eval(xNode, validateExprContext);
        if (this.isNegative) {
            bl = !bl;
        }
        return bl;
    }

    public void writeXML(Writer writer, int n) throws IOException {
        String string = this.isNegative ? "report" : "assert";
        KeySpec.writeIndent(writer, n);
        writer.write("<sch:");
        writer.write(string);
        writer.write(" test=");
        writer.write(XMLText.quoteXML(this.testString));
        writer.write(">\n");
        KeySpec.writeIndent(writer, n + 2);
        this.message.writeXML(writer);
        writer.write(10);
        KeySpec.writeIndent(writer, n);
        writer.write("</sch:");
        writer.write(string);
        writer.write(">\n");
    }
}

