/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.save;

import com.xmlmind.xml.doc.Attribute;
import com.xmlmind.xml.doc.Comment;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Inclusion;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.load.EntityRef;
import com.xmlmind.xml.load.XInclusion;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.save.DocumentWriter;
import com.xmlmind.xml.save.LineWriter;
import com.xmlmind.xml.save.Msg;
import com.xmlmind.xml.save.SaveOptions;
import com.xmlmind.xml.save.WrappedLine;
import com.xmlmind.xml.validate.AnyDocumentType;
import com.xmlmind.xml.validate.AnyElementType;
import com.xmlmind.xml.validate.AttributeDefaultValue;
import com.xmlmind.xml.validate.AttributeUtil;
import com.xmlmind.xml.validate.ContentType;
import com.xmlmind.xml.validate.ContentTypeUtil;
import com.xmlmind.xml.validate.Data;
import com.xmlmind.xml.validate.DocumentType;
import com.xmlmind.xml.validate.ElementType;
import com.xmlmind.xml.validate.Field;
import com.xmlmind.xml.validate.Item;
import com.xmlmind.xml.validate.LaxElementType;
import com.xmlmind.xml.validate.PreserveSpaceDefaultValue;
import com.xmlmind.xml.validate.Structure;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;

public class DocumentIndenter
extends DocumentWriter {
    public static final int MAX_INDENT = 16;
    public static final int MIN_LINE_LENGTH = 40;
    protected boolean guessContentType;
    protected int indent;
    protected int maxLineLength;
    protected boolean addOpenLines;
    protected State[] stateStack;
    protected int stateStackSize;
    protected Structure structure = new Structure();
    protected boolean[] guessed = new boolean[1];

    public DocumentIndenter(Writer writer) {
        super(writer instanceof LineWriter ? writer : new LineWriter(writer));
        this.setDocumentType(null);
        SaveOptions saveOptions = SaveOptions.INSTANCE;
        this.indent = saveOptions.indent;
        if (this.indent < -1) {
            this.indent = -2 - this.indent;
        } else if (this.indent == -1) {
            this.indent = 0;
        }
        this.maxLineLength = saveOptions.maxLineLength;
        this.addOpenLines = saveOptions.addOpenLines;
        this.stateStack = new State[10];
        this.stateStackSize = 0;
    }

    @Override
    public void setDocumentType(DocumentType documentType) {
        if (documentType == null) {
            documentType = AnyDocumentType.INSTANCE;
        }
        super.setDocumentType(documentType);
        this.guessContentType = documentType instanceof AnyDocumentType;
    }

    public void setIndent(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > 16) {
            n = 16;
        }
        this.indent = n;
    }

    public int getIndent() {
        return this.indent;
    }

    public void setMaxLineLength(int n) {
        if (n <= 0) {
            n = Integer.MAX_VALUE;
        } else if (n < 40) {
            n = 40;
        }
        this.maxLineLength = n;
    }

    public int getMaxLineLength() {
        return this.maxLineLength;
    }

    public void setAddOpenLines(boolean bl) {
        this.addOpenLines = bl;
    }

    public boolean getAddOpenLines() {
        return this.addOpenLines;
    }

    @Override
    public void write(Document document) throws IOException {
        this.pushState(this.createInitialState());
        super.write(document);
        this.popState();
    }

    @Override
    public void write(Element element) throws IOException {
        this.pushState(this.createInitialState());
        super.write(element);
        this.popState();
    }

    @Override
    protected void writeComment(Comment comment) throws IOException {
        DocumentIndenter.checkComment(comment);
        State state = this.topState();
        if (state.wrappedLine != null) {
            state.wrappedLine.add("<!--");
            state.wrappedLine.flush();
        } else {
            this.out.write("<!--");
        }
        this.out.write(comment.getText());
        this.out.write("-->");
    }

    @Override
    protected void writeProcessingInstruction(ProcessingInstruction processingInstruction) throws IOException {
        DocumentIndenter.checkProcessingInstruction(processingInstruction);
        State state = this.topState();
        if (state.wrappedLine != null) {
            state.wrappedLine.add("<?");
            state.wrappedLine.add(processingInstruction.getTarget());
            state.wrappedLine.add(' ');
            state.wrappedLine.flush();
        } else {
            this.out.write("<?");
            this.out.write(processingInstruction.getTarget());
            this.out.write(32);
        }
        this.out.write(processingInstruction.getText());
        this.out.write("?>");
    }

    @Override
    protected void writeInclusion(Inclusion inclusion, Node node, Node node2) throws IOException {
        if (inclusion instanceof EntityRef) {
            State state = this.topState();
            if (state.wrappedLine != null) {
                WrappedLine wrappedLine = state.wrappedLine;
                wrappedLine.addInclusion(inclusion);
                wrappedLine.add('&');
                wrappedLine.add(((EntityRef)inclusion).name);
                wrappedLine.add(';');
            } else {
                if (state.layout == Layout.VERTICAL) {
                    ((LineWriter)this.out).writeIndent(state.lineFirst + this.indent);
                }
                ((LineWriter)this.out).writingInclusion(inclusion);
                this.out.write(38);
                this.out.write(((EntityRef)inclusion).name);
                this.out.write(59);
                if (state.layout == Layout.VERTICAL && this.addOpenLines && node2.getNextSibling() != null) {
                    this.out.write(10);
                }
            }
        } else if (inclusion instanceof XInclusion) {
            Node[] nodeArray = ((XInclusion)inclusion).uninclude(node, node2);
            this.pushInclusion(inclusion, node, node2, nodeArray);
            State state = this.topState();
            if (state.wrappedLine != null) {
                state.wrappedLine.addInclusion(inclusion);
            } else {
                ((LineWriter)this.out).writingInclusion(inclusion);
            }
            for (Node node3 : nodeArray) {
                if (state.layout == Layout.VERTICAL) {
                    ((LineWriter)this.out).writeIndent(state.lineFirst + this.indent);
                }
                switch (node3.getType()) {
                    case TEXT: {
                        this.writeText((Text)node3);
                        break;
                    }
                    case COMMENT: {
                        this.writeComment((Comment)node3);
                        break;
                    }
                    case PROCESSING_INSTRUCTION: {
                        this.writeProcessingInstruction((ProcessingInstruction)node3);
                        break;
                    }
                    case ELEMENT: {
                        this.writeElement((Element)node3);
                    }
                }
                if (state.layout != Layout.VERTICAL || !this.addOpenLines || node2.getNextSibling() == null) continue;
                this.out.write(10);
            }
            this.popInclusion();
        } else {
            throw new IOException(Msg.msg("unsupportedInclusion", inclusion.getClass().getName()));
        }
    }

    @Override
    protected void writeElement(Element element) throws IOException {
        State state = this.topState();
        this.pushElement(element);
        State state2 = this.topState();
        Name name = element.getName();
        String string = this.qNameHelper.toQName(name, false);
        this.writeStartTag(string, element);
        this.writeAttributes(element);
        this.writeFrame();
        if (this.isEmptyElement(element)) {
            this.writeEmptyEndTag(string, element);
        } else {
            if (state2.wrappedLine != null) {
                state2.wrappedLine.add('>');
                if (state2.layout == Layout.VERBATIM) {
                    state2.wrappedLine.flush();
                    state2.wrappedLine = null;
                }
            } else {
                this.out.write(62);
            }
            this.writeElementProperties(element);
            Node node = element.getFirstChild();
            while (node != null) {
                Node node2;
                Inclusion inclusion;
                if (this.preserveInclusions && (inclusion = node.getInclusion()) != null) {
                    Inclusion inclusion2;
                    Node node3 = node;
                    for (node2 = node.getNextSibling(); node2 != null && (inclusion2 = node2.getInclusion()) == inclusion; node2 = node2.getNextSibling()) {
                        node3 = node2;
                    }
                    this.writeInclusion(inclusion, node, node3);
                } else {
                    if (state2.layout == Layout.VERTICAL) {
                        ((LineWriter)this.out).writeIndent(state2.lineFirst + this.indent);
                    }
                    switch (node.getType()) {
                        case TEXT: {
                            if (this.cdataSections != null && this.cdataSections.match(element)) {
                                this.writeCDATA((Text)node, element);
                                break;
                            }
                            this.writeText((Text)node);
                            break;
                        }
                        case COMMENT: {
                            this.writeComment((Comment)node);
                            break;
                        }
                        case PROCESSING_INSTRUCTION: {
                            this.writeProcessingInstruction((ProcessingInstruction)node);
                            break;
                        }
                        case ELEMENT: {
                            this.writeElement((Element)node);
                        }
                    }
                    if (state2.layout == Layout.VERTICAL && this.addOpenLines && node2 != null) {
                        this.out.write(10);
                    }
                }
                node = node2;
            }
            this.writeEndTag(string, element);
        }
        this.popElement();
        if (state2.wrappedLine != null && state2.wrappedLine != state.wrappedLine) {
            state2.wrappedLine.flush();
        }
    }

    @Override
    protected void writeStartTag(String string, Element element) throws IOException {
        State state = this.topState();
        state.elementTag = string;
        if (state.wrappedLine != null) {
            WrappedLine wrappedLine = state.wrappedLine;
            wrappedLine.addElement(element);
            wrappedLine.add('<');
            wrappedLine.add(string);
            if (state.layout == Layout.VERTICAL) {
                wrappedLine.flush();
                state.wrappedLine = null;
            }
        } else {
            ((LineWriter)this.out).writingElement(element);
            this.out.write(60);
            this.out.write(string);
        }
    }

    @Override
    protected void writeAttribute(String string, String string2) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append("=\"");
        char[] cArray = string2.toCharArray();
        this.textHelper.escapeXML(true, cArray, 0, cArray.length, stringBuilder);
        stringBuilder.append('\"');
        State state = this.topState();
        if (state.wrappedLine != null) {
            state.wrappedLine.addSpace();
            state.wrappedLine.add(stringBuilder.toString());
        } else {
            int n = state.parentIsVertical ? state.lineFirst + 1 + state.elementTag.length() + 1 : state.lineFirst + this.indent;
            int n2 = ((LineWriter)this.out).getColumnNumber();
            if (n2 <= n || n2 + 1 + stringBuilder.length() <= state.lineEnd) {
                this.out.write(32);
            } else {
                ((LineWriter)this.out).writeIndent(n);
            }
            this.out.write(stringBuilder.toString());
        }
    }

    @Override
    protected void writeEmptyEndTag(String string, Element element) throws IOException {
        State state = this.topState();
        assert (element == state.element);
        if (this.favorInteroperability) {
            if (this.hasEmptyContentType(element)) {
                if (state.wrappedLine != null) {
                    state.wrappedLine.add(" />");
                } else {
                    this.out.write(" />");
                }
            } else if (state.wrappedLine != null) {
                state.wrappedLine.add("></");
                state.wrappedLine.add(string);
                state.wrappedLine.add('>');
            } else {
                this.out.write("></");
                this.out.write(string);
                this.out.write(62);
            }
        } else if (state.wrappedLine != null) {
            state.wrappedLine.add("/>");
        } else {
            this.out.write("/>");
        }
    }

    @Override
    protected boolean hasEmptyContentType(Element element) {
        if (element.getNamespace() == Namespace.XHTML) {
            return super.hasEmptyContentType(element);
        }
        State state = this.topState();
        assert (element == state.element);
        return state.getElementContentType() == ContentType.EMPTY;
    }

    @Override
    protected void writeEndTag(String string, Element element) throws IOException {
        State state = this.topState();
        assert (element == state.element);
        if (state.wrappedLine != null) {
            state.wrappedLine.add("</");
            state.wrappedLine.add(string);
            state.wrappedLine.add('>');
        } else {
            if (state.layout == Layout.VERTICAL) {
                ((LineWriter)this.out).writeIndent(state.lineFirst);
            }
            this.out.write("</");
            this.out.write(string);
            this.out.write(62);
        }
    }

    @Override
    protected void writeCDATA(Text text, Element element) throws IOException {
        String string;
        String string2;
        Name name = element.getName();
        if (this.favorInteroperability && (name == Name.SCRIPT || name == Name.STYLE)) {
            string2 = "/*<![CDATA[*/";
            string = "/*]]>*/";
        } else {
            string2 = "<![CDATA[";
            string = "]]>";
        }
        String string3 = text.getText();
        if (string3.indexOf("]]>") < 0) {
            State state = this.topState();
            if (state.wrappedLine != null) {
                state.wrappedLine.add(string2);
                state.wrappedLine.flush();
            } else {
                this.out.write(string2);
            }
            this.out.write(string3);
            this.out.write(string);
        } else {
            this.writeText(text);
        }
    }

    @Override
    protected void writeText(Text text) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        this.textHelper.escapeXML(false, text.getTextChars(), 0, text.getTextLength(), stringBuilder);
        State state = this.topState();
        if (state.wrappedLine != null) {
            state.wrappedLine.addAll(stringBuilder.toString());
        } else {
            this.out.write(stringBuilder.toString());
        }
    }

    protected State createInitialState() {
        State state = new State();
        state.element = null;
        state.elementType = null;
        state.childElements = null;
        state.childElementTypes = null;
        state.hasPreserveSpace = false;
        state.parentIsVertical = true;
        state.layout = Layout.VERTICAL;
        state.lineFirst = -this.indent;
        state.lineEnd = this.maxLineLength;
        state.wrappedLine = null;
        state.elementTag = null;
        return state;
    }

    @Override
    protected void pushElement(Element element) {
        Object object;
        int n;
        int n2;
        Object[] objectArray;
        super.pushElement(element);
        State state = this.topState();
        State state2 = new State();
        state2.element = element;
        ElementType elementType = null;
        if (state.element == null) {
            elementType = this.documentType.getElementType(element);
        } else {
            objectArray = state.childElements;
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                if (objectArray[n2] != element) continue;
                elementType = state.childElementTypes[n2];
                break;
            }
        }
        ElementType elementType2 = state2.elementType = elementType == null ? AnyElementType.INSTANCE : elementType;
        if (!state2.elementType.getStructure(element, false, this.structure)) {
            state2.elementType = new LaxElementType(state2.elementType);
            state2.elementType.getStructure(element, false, this.structure);
        }
        objectArray = this.structure.childNodeItems;
        n2 = this.structure.childNodeItemCount;
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (!(objectArray[n] instanceof Field)) continue;
            ++n3;
        }
        state2.childElements = new Element[n3];
        state2.childElementTypes = new ElementType[n3];
        n3 = 0;
        for (n = 0; n < n2; ++n) {
            if (!(objectArray[n] instanceof Field)) continue;
            object = (Element)element.getChild(n);
            ElementType elementType3 = state2.elementType.getChildElementType((Field)objectArray[n], (Element)object);
            if (elementType3 == null) {
                elementType3 = AnyElementType.INSTANCE;
            }
            state2.childElements[n3] = object;
            state2.childElementTypes[n3] = elementType3;
            ++n3;
        }
        String string = DocumentIndenter.getElementAttribute(element, elementType, Name.XML_SPACE, PreserveSpaceDefaultValue.INSTANCE);
        state2.hasPreserveSpace = string == null ? state.hasPreserveSpace : string.trim().equals("preserve");
        state2.parentIsVertical = state.layout == Layout.VERTICAL;
        object = state2.getElementContentType(this.guessed);
        boolean bl = this.guessed[0];
        switch (1.$SwitchMap$com$xmlmind$xml$validate$ContentType[((Enum)object).ordinal()]) {
            case 1: 
            case 2: {
                state2.layout = Layout.VERBATIM;
                break;
            }
            case 3: {
                if (bl && state2.hasPreserveSpace) {
                    state2.layout = Layout.VERBATIM;
                    break;
                }
                state2.layout = Layout.VERTICAL;
                break;
            }
            default: {
                state2.layout = state2.hasPreserveSpace ? Layout.VERBATIM : Layout.HORIZONTAL;
            }
        }
        if (state.layout == Layout.HORIZONTAL) {
            if (this.isEmptyElement(element)) {
                state2.layout = Layout.HORIZONTAL;
            }
            if (state2.layout == Layout.HORIZONTAL) {
                state2.lineFirst = state.lineFirst;
                state2.lineEnd = state.lineEnd;
            } else {
                state2.lineFirst = state.lineFirst + this.indent;
                state2.lineEnd = this.computeLineEnd(state2.lineFirst);
            }
            state2.wrappedLine = state.wrappedLine;
        } else {
            state2.lineFirst = state.lineFirst + this.indent;
            state2.lineEnd = this.computeLineEnd(state2.lineFirst);
            state2.wrappedLine = state2.layout == Layout.HORIZONTAL ? new WrappedLine((LineWriter)this.out, state2.lineFirst, state2.lineEnd) : null;
        }
        this.pushState(state2);
    }

    protected static String getElementAttribute(Element element, ElementType elementType, Name name, AttributeDefaultValue attributeDefaultValue) {
        Data data;
        String string = AttributeUtil.getAttribute(element, name, attributeDefaultValue);
        if (string == null && elementType != null && (data = elementType.getAttributeDefaultValue(name)) != null) {
            string = data.formatData(element);
        }
        return string;
    }

    protected int computeLineEnd(int n) {
        int n2 = Math.max(40, 2 * this.maxLineLength / 3);
        if (this.maxLineLength - n < n2) {
            return n + n2;
        }
        return this.maxLineLength;
    }

    @Override
    protected void popElement() {
        this.popState();
        super.popElement();
    }

    protected void pushInclusion(Inclusion inclusion, Node node, Node node2, Node[] nodeArray) {
        State state = this.topState();
        State state2 = new State();
        state2.element = state.element;
        state2.elementType = state.elementType;
        if (state2.elementType == null) {
            state2.elementType = AnyElementType.INSTANCE;
        }
        if (state2.element == null) {
            Node node3;
            int n;
            int n2 = 0;
            for (n = 0; n < nodeArray.length; ++n) {
                node3 = nodeArray[n];
                if (node3.getType() != Node.Type.ELEMENT) continue;
                ++n2;
            }
            state2.childElements = new Element[n2];
            state2.childElementTypes = new ElementType[n2];
            n2 = 0;
            for (n = 0; n < nodeArray.length; ++n) {
                node3 = nodeArray[n];
                if (node3.getType() != Node.Type.ELEMENT) continue;
                Element element = (Element)node3;
                ElementType elementType = this.documentType.getElementType(element);
                if (elementType == null) {
                    elementType = AnyElementType.INSTANCE;
                }
                state2.childElements[n2] = element;
                state2.childElementTypes[n2] = elementType;
                ++n2;
            }
        } else {
            Node node4;
            ArrayList<Node> arrayList = new ArrayList<Node>();
            for (node4 = state2.element.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                if (node4 == node) {
                    for (int i = 0; i < nodeArray.length; ++i) {
                        arrayList.add(nodeArray[i]);
                    }
                    node4 = node2;
                    continue;
                }
                arrayList.add(node4);
            }
            Node[] nodeArray2 = new Node[arrayList.size()];
            arrayList.toArray(nodeArray2);
            int n = 0;
            for (int i = 0; i < nodeArray2.length; ++i) {
                node4 = nodeArray2[i];
                if (node4.getType() != Node.Type.ELEMENT) continue;
                ++n;
            }
            state2.childElements = new Element[n];
            state2.childElementTypes = new ElementType[n];
            n = 0;
            Item[] itemArray = null;
            Attribute[] attributeArray = state2.element.getAllAttributes();
            if (state2.elementType.getStructure(attributeArray, attributeArray.length, nodeArray2, nodeArray2.length, false, this.structure)) {
                itemArray = this.structure.childNodeItems;
            }
            for (int i = 0; i < nodeArray2.length; ++i) {
                node4 = nodeArray2[i];
                if (node4.getType() != Node.Type.ELEMENT) continue;
                Element element = (Element)node4;
                ElementType elementType = null;
                if (itemArray != null) {
                    elementType = state2.elementType.getChildElementType((Field)itemArray[i], element.getName());
                }
                if (elementType == null) {
                    elementType = AnyElementType.INSTANCE;
                }
                state2.childElements[n] = element;
                state2.childElementTypes[n] = elementType;
                ++n;
            }
        }
        state2.hasPreserveSpace = state.hasPreserveSpace;
        state2.parentIsVertical = state.parentIsVertical;
        state2.layout = state.layout;
        state2.lineFirst = state.lineFirst;
        state2.lineEnd = state.lineEnd;
        state2.wrappedLine = state.wrappedLine;
        state2.elementTag = state.elementTag;
        this.pushState(state2);
    }

    protected void popInclusion() {
        this.popState();
    }

    protected void pushState(State state) {
        if (this.stateStackSize >= this.stateStack.length) {
            State[] stateArray = new State[Math.max(10, 2 * this.stateStack.length)];
            System.arraycopy(this.stateStack, 0, stateArray, 0, this.stateStack.length);
            this.stateStack = stateArray;
        }
        this.stateStack[this.stateStackSize++] = state;
    }

    protected void popState() {
        this.stateStack[--this.stateStackSize] = null;
    }

    protected State topState() {
        return this.stateStack[this.stateStackSize - 1];
    }

    protected final class State {
        public Element element;
        public ElementType elementType;
        public Element[] childElements;
        public ElementType[] childElementTypes;
        public boolean hasPreserveSpace;
        public boolean parentIsVertical;
        public Layout layout;
        public int lineFirst;
        public int lineEnd;
        public WrappedLine wrappedLine;
        public String elementTag;

        protected State() {
        }

        public ContentType getElementContentType() {
            return this.getElementContentType(null);
        }

        public ContentType getElementContentType(boolean[] blArray) {
            if (DocumentIndenter.this.guessContentType || this.elementType == null || this.elementType instanceof AnyElementType) {
                if (blArray != null) {
                    blArray[0] = true;
                }
                return ContentTypeUtil.guessContentType(this.element);
            }
            if (blArray != null) {
                blArray[0] = false;
            }
            return this.elementType.getElementContentType();
        }
    }

    protected static enum Layout {
        VERTICAL,
        HORIZONTAL,
        VERBATIM;

    }
}

