/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.xml.rng.validate.AttributeField;
import com.xmlmind.xml.rng.validate.ChoicePattern;
import com.xmlmind.xml.rng.validate.DataExceptPattern;
import com.xmlmind.xml.rng.validate.DataPattern;
import com.xmlmind.xml.rng.validate.ElementField;
import com.xmlmind.xml.rng.validate.EmptyPattern;
import com.xmlmind.xml.rng.validate.GroupPattern;
import com.xmlmind.xml.rng.validate.InterleavePattern;
import com.xmlmind.xml.rng.validate.ListPattern;
import com.xmlmind.xml.rng.validate.NotAllowedPattern;
import com.xmlmind.xml.rng.validate.OneOrMorePattern;
import com.xmlmind.xml.rng.validate.Pattern;
import com.xmlmind.xml.rng.validate.TextPattern;
import com.xmlmind.xml.rng.validate.ValuePattern;
import java.util.IdentityHashMap;

final class PatternTraversal {
    public static final Object LEAVE_PATTERN = new Object();

    PatternTraversal() {
    }

    public static Object traverse(Pattern pattern, Handler handler) {
        IdentityHashMap<Pattern, Pattern> identityHashMap = new IdentityHashMap<Pattern, Pattern>();
        return PatternTraversal.doTraverse(pattern, handler, identityHashMap);
    }

    private static Object doTraverse(Pattern pattern, Handler handler, IdentityHashMap<Pattern, Pattern> identityHashMap) {
        Object object;
        if (pattern instanceof ChoicePattern) {
            ChoicePattern choicePattern = (ChoicePattern)pattern;
            Object object2 = handler.choicePattern(choicePattern);
            if (object2 != null) {
                return object2;
            }
            if (object2 != LEAVE_PATTERN) {
                object2 = PatternTraversal.doTraverse(choicePattern.pattern1, handler, identityHashMap);
                if (object2 != null) {
                    return object2;
                }
                return PatternTraversal.doTraverse(choicePattern.pattern2, handler, identityHashMap);
            }
        } else if (pattern instanceof GroupPattern) {
            GroupPattern groupPattern = (GroupPattern)pattern;
            Object object3 = handler.groupPattern(groupPattern);
            if (object3 != null) {
                return object3;
            }
            if (object3 != LEAVE_PATTERN) {
                object3 = PatternTraversal.doTraverse(groupPattern.pattern1, handler, identityHashMap);
                if (object3 != null) {
                    return object3;
                }
                return PatternTraversal.doTraverse(groupPattern.pattern2, handler, identityHashMap);
            }
        } else if (pattern instanceof InterleavePattern) {
            InterleavePattern interleavePattern = (InterleavePattern)pattern;
            Object object4 = handler.interleavePattern(interleavePattern);
            if (object4 != null) {
                return object4;
            }
            if (object4 != LEAVE_PATTERN) {
                object4 = PatternTraversal.doTraverse(interleavePattern.pattern1, handler, identityHashMap);
                if (object4 != null) {
                    return object4;
                }
                return PatternTraversal.doTraverse(interleavePattern.pattern2, handler, identityHashMap);
            }
        } else if (pattern instanceof OneOrMorePattern) {
            OneOrMorePattern oneOrMorePattern = (OneOrMorePattern)pattern;
            Object object5 = handler.oneOrMorePattern(oneOrMorePattern);
            if (object5 != null) {
                return object5;
            }
            if (object5 != LEAVE_PATTERN) {
                return PatternTraversal.doTraverse(oneOrMorePattern.pattern, handler, identityHashMap);
            }
        } else if (pattern instanceof ElementField) {
            if (identityHashMap.containsKey(pattern)) {
                return null;
            }
            identityHashMap.put(pattern, pattern);
            ElementField elementField = (ElementField)pattern;
            Object object6 = handler.elementField(elementField);
            if (object6 != null) {
                return object6;
            }
            if (object6 != LEAVE_PATTERN) {
                return PatternTraversal.doTraverse(elementField.pattern, handler, identityHashMap);
            }
        } else if (pattern instanceof AttributeField) {
            AttributeField attributeField = (AttributeField)pattern;
            Object object7 = handler.attributeField(attributeField);
            if (object7 != null) {
                return object7;
            }
            if (object7 != LEAVE_PATTERN) {
                return PatternTraversal.doTraverse(attributeField.pattern, handler, identityHashMap);
            }
        } else if (pattern instanceof TextPattern) {
            Object object8 = handler.textPattern((TextPattern)pattern);
            if (object8 != null) {
                return object8;
            }
        } else if (pattern instanceof EmptyPattern) {
            Object object9 = handler.emptyPattern((EmptyPattern)pattern);
            if (object9 != null) {
                return object9;
            }
        } else if (pattern instanceof DataPattern) {
            Object object10 = handler.dataPattern((DataPattern)pattern);
            if (object10 != null) {
                return object10;
            }
        } else if (pattern instanceof ValuePattern) {
            Object object11 = handler.valuePattern((ValuePattern)pattern);
            if (object11 != null) {
                return object11;
            }
        } else if (pattern instanceof ListPattern) {
            ListPattern listPattern = (ListPattern)pattern;
            Object object12 = handler.listPattern(listPattern);
            if (object12 != null) {
                return object12;
            }
            if (object12 != LEAVE_PATTERN) {
                return PatternTraversal.doTraverse(listPattern.pattern, handler, identityHashMap);
            }
        } else if (pattern instanceof DataExceptPattern) {
            DataExceptPattern dataExceptPattern = (DataExceptPattern)pattern;
            Object object13 = handler.dataExceptPattern(dataExceptPattern);
            if (object13 != null) {
                return object13;
            }
            if (object13 != LEAVE_PATTERN) {
                return PatternTraversal.doTraverse(dataExceptPattern.pattern, handler, identityHashMap);
            }
        } else if (pattern instanceof NotAllowedPattern && (object = handler.notAllowedPattern((NotAllowedPattern)pattern)) != null) {
            return object;
        }
        return null;
    }

    public static class HandlerBase
    implements Handler {
        @Override
        public Object choicePattern(ChoicePattern choicePattern) {
            return null;
        }

        @Override
        public Object groupPattern(GroupPattern groupPattern) {
            return null;
        }

        @Override
        public Object interleavePattern(InterleavePattern interleavePattern) {
            return null;
        }

        @Override
        public Object oneOrMorePattern(OneOrMorePattern oneOrMorePattern) {
            return null;
        }

        @Override
        public Object elementField(ElementField elementField) {
            return null;
        }

        @Override
        public Object attributeField(AttributeField attributeField) {
            return null;
        }

        @Override
        public Object textPattern(TextPattern textPattern) {
            return null;
        }

        @Override
        public Object emptyPattern(EmptyPattern emptyPattern) {
            return null;
        }

        @Override
        public Object dataPattern(DataPattern dataPattern) {
            return null;
        }

        @Override
        public Object valuePattern(ValuePattern valuePattern) {
            return null;
        }

        @Override
        public Object listPattern(ListPattern listPattern) {
            return null;
        }

        @Override
        public Object dataExceptPattern(DataExceptPattern dataExceptPattern) {
            return null;
        }

        @Override
        public Object notAllowedPattern(NotAllowedPattern notAllowedPattern) {
            return null;
        }
    }

    public static interface Handler {
        public Object choicePattern(ChoicePattern var1);

        public Object groupPattern(GroupPattern var1);

        public Object interleavePattern(InterleavePattern var1);

        public Object oneOrMorePattern(OneOrMorePattern var1);

        public Object elementField(ElementField var1);

        public Object attributeField(AttributeField var1);

        public Object textPattern(TextPattern var1);

        public Object emptyPattern(EmptyPattern var1);

        public Object dataPattern(DataPattern var1);

        public Object valuePattern(ValuePattern var1);

        public Object listPattern(ListPattern var1);

        public Object dataExceptPattern(DataExceptPattern var1);

        public Object notAllowedPattern(NotAllowedPattern var1);
    }
}

