/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.rng.validate.NameClassBase;
import com.xmlmind.xml.rng.validate.NameClassVisitor;

final class NsNameClass
extends NameClassBase {
    public final Namespace namespace;

    public NsNameClass(Namespace namespace) {
        this.namespace = namespace;
    }

    public int hashCode() {
        return System.identityHashCode(this.namespace);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof NsNameClass)) {
            return false;
        }
        return this.namespace == ((NsNameClass)object).namespace;
    }

    @Override
    public void toLabel(boolean bl, NamespaceToPrefixes namespaceToPrefixes, StringBuilder stringBuilder) {
        NsNameClass.toLabel(this.namespace, bl, namespaceToPrefixes, stringBuilder);
    }

    static void toLabel(Namespace namespace, boolean bl, NamespaceToPrefixes namespaceToPrefixes, StringBuilder stringBuilder) {
        String[] stringArray;
        boolean bl2 = false;
        if (namespaceToPrefixes != null && (stringArray = namespaceToPrefixes.namespaceToPrefixes(namespace)) != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() <= 0) continue;
                stringBuilder.append(stringArray[i]);
                bl2 = true;
                break;
            }
        }
        if (bl2) {
            stringBuilder.append(":*");
        } else if (namespace == Namespace.NONE) {
            stringBuilder.append(":*");
        } else if (namespace == Namespace.XML) {
            stringBuilder.append("xml:*");
        } else {
            stringBuilder.append('{');
            stringBuilder.append(namespace.uri);
            stringBuilder.append("}*");
        }
    }

    @Override
    public void accept(NameClassVisitor nameClassVisitor) {
        nameClassVisitor.visitNsName(this.namespace);
    }

    @Override
    public Name getInstance() {
        return Name.get(this.namespace, PRIVATE_LOCAL_PART);
    }

    @Override
    public boolean containsName(Name name) {
        return this.namespace == name.namespace;
    }
}

