/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.XMLText;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.rng.validate.AnyDataPattern;
import com.xmlmind.xml.rng.validate.AttributeField;
import com.xmlmind.xml.rng.validate.ChoicePattern;
import com.xmlmind.xml.rng.validate.DocGenUtil;
import com.xmlmind.xml.rng.validate.ElementField;
import com.xmlmind.xml.rng.validate.EmptyPattern;
import com.xmlmind.xml.rng.validate.FieldBase;
import com.xmlmind.xml.rng.validate.GroupPattern;
import com.xmlmind.xml.rng.validate.InterleavePattern;
import com.xmlmind.xml.rng.validate.Msg;
import com.xmlmind.xml.rng.validate.NotAllowedPattern;
import com.xmlmind.xml.rng.validate.Occurrence;
import com.xmlmind.xml.rng.validate.Pattern;
import com.xmlmind.xml.rng.validate.SubDocumentTypeImpl;
import com.xmlmind.xml.rng.validate.TextPattern;
import com.xmlmind.xml.validate.ContentType;
import com.xmlmind.xml.validate.Data;
import com.xmlmind.xml.validate.DataType;
import com.xmlmind.xml.validate.DocumentationGeneratorBase;
import com.xmlmind.xml.validate.ElementType;
import com.xmlmind.xml.validate.SubDocumentType;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;

public final class DocumentationGenerator
extends DocumentationGeneratorBase {
    private static final FieldInfoComparator compareFieldInfo = new FieldInfoComparator();
    private SubDocumentTypeImpl subDocType;
    private boolean annotate = false;
    private IdentityHashMap<ElementField, ElementFieldInfo> elementFieldToInfo;
    private HashMap<String, ElementField> pageNameToElementField;

    @Override
    public void initSubDocumentType(SubDocumentType subDocumentType) {
        this.subDocType = (SubDocumentTypeImpl)subDocumentType;
        ElementField elementField = this.subDocType.getStartField();
        ElementField[] elementFieldArray = elementField.childElementFields;
        this.elementFieldToInfo = new IdentityHashMap();
        this.collectInfo(elementField);
        for (int i = 0; i < elementFieldArray.length; ++i) {
            Iterator<ElementFieldInfo> iterator = elementFieldArray[i];
            ElementFieldInfo object2 = this.elementFieldToInfo.get(iterator);
            object2.markAsStart(elementField);
        }
        HashMap<String, ElementFieldInfo[]> hashMap = new HashMap<String, ElementFieldInfo[]>();
        for (ElementFieldInfo elementFieldInfo : this.elementFieldToInfo.values()) {
            String string = elementFieldInfo.field.getFieldLabel(false, this);
            ElementFieldInfo[] elementFieldInfoArray = (ElementFieldInfo[])hashMap.get(string);
            if (elementFieldInfoArray == null) {
                elementFieldInfoArray = new ElementFieldInfo[]{elementFieldInfo};
            } else {
                ElementFieldInfo[] elementFieldInfoArray2 = new ElementFieldInfo[elementFieldInfoArray.length + 1];
                System.arraycopy(elementFieldInfoArray, 0, elementFieldInfoArray2, 0, elementFieldInfoArray.length);
                elementFieldInfoArray2[elementFieldInfoArray.length] = elementFieldInfo;
                elementFieldInfoArray = elementFieldInfoArray2;
            }
            hashMap.put(string, elementFieldInfoArray);
        }
        Comparator<ElementFieldInfo> comparator = new Comparator<ElementFieldInfo>(){

            @Override
            public int compare(ElementFieldInfo elementFieldInfo, ElementFieldInfo elementFieldInfo2) {
                return elementFieldInfo2.parents.length - elementFieldInfo.parents.length;
            }
        };
        int n = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            String string = (String)entry.getKey();
            ElementFieldInfo[] elementFieldInfoArray = (ElementFieldInfo[])entry.getValue();
            if (elementFieldInfoArray.length > 1) {
                Arrays.sort(elementFieldInfoArray, comparator);
            }
            for (int i = 0; i < elementFieldInfoArray.length; ++i) {
                StringBuilder stringBuilder;
                ElementFieldInfo elementFieldInfo = elementFieldInfoArray[i];
                if (i == 0) {
                    elementFieldInfo.label = string;
                } else {
                    stringBuilder = new StringBuilder();
                    stringBuilder.append(string);
                    stringBuilder.append('#');
                    stringBuilder.append(Integer.toString(1 + i));
                    elementFieldInfo.label = stringBuilder.toString();
                }
                stringBuilder = new StringBuilder();
                if (elementFieldInfo.field.getFieldNameClass() != null) {
                    stringBuilder.append("__wc__");
                } else {
                    String string2 = elementFieldInfo.label;
                    int n2 = string2.length();
                    for (int j = 0; j < n2; ++j) {
                        char c = string2.charAt(j);
                        if (Character.isLetterOrDigit(c)) {
                            stringBuilder.append(c);
                            continue;
                        }
                        stringBuilder.append('_');
                    }
                }
                stringBuilder.append('_');
                stringBuilder.append(Integer.toString(n, 36));
                ++n;
                stringBuilder.append(".html");
                elementFieldInfo.pageName = stringBuilder.toString();
            }
        }
        this.pageNameToElementField = new HashMap();
        for (ElementFieldInfo elementFieldInfo : this.elementFieldToInfo.values()) {
            this.pageNameToElementField.put(elementFieldInfo.pageName, (ElementField)elementFieldInfo.field);
        }
    }

    private void collectInfo(ElementField elementField) {
        ElementField[] elementFieldArray = elementField.childElementFields;
        for (int i = 0; i < elementFieldArray.length; ++i) {
            ElementField elementField2 = elementFieldArray[i];
            ElementFieldInfo elementFieldInfo = this.elementFieldToInfo.get(elementField2);
            if (elementFieldInfo == null) {
                elementFieldInfo = new ElementFieldInfo(elementField2, elementField);
                this.elementFieldToInfo.put(elementField2, elementFieldInfo);
                this.collectInfo(elementField2);
                continue;
            }
            elementFieldInfo.addParent(elementField);
        }
    }

    @Override
    public SubDocumentType getSubDocumentType() {
        return this.subDocType;
    }

    public void setAnnotated(boolean bl) {
        this.annotate = bl;
    }

    public boolean isAnnotated() {
        return this.annotate;
    }

    @Override
    public void generateAll(File file) throws IOException {
        DocumentationGeneratorBase.PageInfo pageInfo = new DocumentationGeneratorBase.PageInfo();
        for (ElementFieldInfo elementFieldInfo : this.elementFieldToInfo.values()) {
            this.generateElementPage(elementFieldInfo, pageInfo);
            FileUtil.saveString(pageInfo.html, new File(file, pageInfo.name), this.charset);
        }
        this.generateIndexPage(pageInfo);
        FileUtil.saveString(pageInfo.html, new File(file, pageInfo.name), this.charset);
        this.generateNamespacesPage(pageInfo);
        FileUtil.saveString(pageInfo.html, new File(file, pageInfo.name), this.charset);
    }

    @Override
    public void generateIndexPage(DocumentationGeneratorBase.PageInfo pageInfo) {
        ElementFieldInfo[] elementFieldInfoArray = new ElementFieldInfo[this.elementFieldToInfo.size()];
        this.elementFieldToInfo.values().toArray(elementFieldInfoArray);
        Arrays.sort(elementFieldInfoArray, compareFieldInfo);
        StringBuilder stringBuilder = new StringBuilder();
        this.appendPageStart(stringBuilder);
        stringBuilder.append("<title>");
        String string = indexPageTitle;
        XMLText.escapeXML(string, stringBuilder);
        stringBuilder.append("</title>\n");
        this.appendPageMiddle(false, true, stringBuilder);
        stringBuilder.append("<h1>");
        XMLText.escapeXML(string, stringBuilder);
        stringBuilder.append("</h1>\n");
        boolean bl = true;
        Namespace namespace = Namespace.XML;
        String string2 = "\u0000";
        for (int i = 0; i < elementFieldInfoArray.length; ++i) {
            ElementFieldInfo elementFieldInfo = elementFieldInfoArray[i];
            Name name = elementFieldInfo.field.getFieldName();
            if (name == null) {
                if (!bl) {
                    stringBuilder.append("<h2>");
                    XMLText.escapeXML(Msg.msg("DG.wildcardsHead"), stringBuilder);
                    stringBuilder.append("</h2>\n");
                }
            } else {
                Namespace namespace2 = name.namespace;
                if (namespace2 != namespace) {
                    stringBuilder.append("<h2>");
                    if (namespace2 == Namespace.NONE) {
                        XMLText.escapeXML(Msg.msg("DG.noNamespaceHead"), stringBuilder);
                    } else {
                        XMLText.escapeXML(Msg.msg("DG.namespaceHead", namespace2), stringBuilder);
                    }
                    stringBuilder.append("</h2>\n");
                }
                char c = Character.toUpperCase(name.localPart.charAt(0));
                char c2 = Character.toUpperCase(string2.charAt(0));
                if (!Character.isLetter(c)) {
                    c = '_';
                }
                if (c != c2) {
                    stringBuilder.append("<h3>");
                    if (Character.isLetter(c)) {
                        XMLText.escapeXML(Character.toString(c), stringBuilder);
                    } else {
                        stringBuilder.append("&#160;");
                    }
                    stringBuilder.append("</h3>\n");
                }
            }
            DocumentationGenerator.appendLink(elementFieldInfo, stringBuilder);
            if (elementFieldInfo.isStart) {
                stringBuilder.append("&#160;&#160;&#160;&#160;<small");
                if (this.css != null) {
                    stringBuilder.append(" class=\"startElement\"");
                } else {
                    stringBuilder.append(" style=\"background-color: #98FB98;\"");
                }
                stringBuilder.append(">(");
                XMLText.escapeXML(Msg.msg("DG.startAnnotation"), stringBuilder);
                stringBuilder.append(")</small>");
            }
            stringBuilder.append("<br>\n");
            bl = name == null;
            namespace = name == null ? Namespace.XML : name.namespace;
            string2 = name == null ? "\u0000" : name.localPart;
        }
        this.appendPageEnd(false, true, stringBuilder);
        pageInfo.html = stringBuilder.toString();
        pageInfo.name = "index.html";
        pageInfo.title = string;
    }

    private static final void appendLink(ElementFieldInfo elementFieldInfo, StringBuilder stringBuilder) {
        stringBuilder.append("<a href='");
        XMLText.escapeXML(elementFieldInfo.pageName, stringBuilder);
        stringBuilder.append("'>");
        XMLText.escapeXML(elementFieldInfo.label, stringBuilder);
        stringBuilder.append("</a>");
    }

    @Override
    public void generateNamespacesPage(DocumentationGeneratorBase.PageInfo pageInfo) {
        this.generateNamespacesPage(null, pageInfo);
    }

    @Override
    public ElementType getElementType(String string) {
        return this.pageNameToElementField.get(string);
    }

    @Override
    public boolean generateElementPage(ElementType elementType, DocumentationGeneratorBase.PageInfo pageInfo) {
        ElementFieldInfo elementFieldInfo = this.elementFieldToInfo.get(elementType);
        if (elementFieldInfo == null) {
            return false;
        }
        this.generateElementPage(elementFieldInfo, pageInfo);
        return true;
    }

    private void generateElementPage(ElementFieldInfo elementFieldInfo, DocumentationGeneratorBase.PageInfo pageInfo) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendPageStart(stringBuilder);
        stringBuilder.append("<title>");
        String string = Msg.msg("DG.elementPageTitle", elementFieldInfo.label);
        XMLText.escapeXML(string, stringBuilder);
        stringBuilder.append("</title>\n");
        this.appendPageMiddle(true, true, stringBuilder);
        stringBuilder.append("<h1>");
        XMLText.escapeXML(string, stringBuilder);
        stringBuilder.append("</h1>\n");
        ElementField elementField = (ElementField)elementFieldInfo.field;
        AttributeField[] attributeFieldArray = elementField.attributeFields;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        IdentityHashMap<AttributeField, AttributeFieldInfo> identityHashMap = new IdentityHashMap<AttributeField, AttributeFieldInfo>();
        for (int i = 0; i < attributeFieldArray.length; ++i) {
            AttributeField attributeField = attributeFieldArray[i];
            Object object = attributeField.getFieldLabel(true, this);
            Integer n = (Integer)hashMap.get(object);
            n = n == null ? Integer.valueOf(0) : Integer.valueOf(n + 1);
            hashMap.put((String)object, n);
            if (n > 0) {
                object = (String)object + "#" + Integer.toString(1 + n);
            }
            String string2 = "__a__" + Integer.toString(System.identityHashCode(attributeField), 36);
            identityHashMap.put(attributeField, new AttributeFieldInfo(attributeField, (String)object, string2));
        }
        this.appendContentModelSection(elementField, identityHashMap, stringBuilder);
        this.appendAttributesSection(elementField, identityHashMap, stringBuilder);
        this.appendParentsSection(elementFieldInfo, stringBuilder);
        this.appendChildrenSection(elementFieldInfo, stringBuilder);
        this.appendPageEnd(true, true, stringBuilder);
        pageInfo.html = stringBuilder.toString();
        pageInfo.name = elementFieldInfo.pageName;
        pageInfo.title = string;
    }

    private void appendChildrenSection(ElementFieldInfo elementFieldInfo, StringBuilder stringBuilder) {
        ElementField elementField = (ElementField)elementFieldInfo.field;
        ElementField[] elementFieldArray = elementField.childElementFields;
        if (elementFieldArray.length == 0) {
            return;
        }
        stringBuilder.append("<h2>");
        XMLText.escapeXML(Msg.msg("DG.childrenHead"), stringBuilder);
        stringBuilder.append("</h2>\n");
        stringBuilder.append("<p>");
        XMLText.escapeXML(Msg.msg("DG.childrenBlurb", elementFieldInfo.label), stringBuilder);
        stringBuilder.append(": ");
        ElementFieldInfo[] elementFieldInfoArray = this.sortElementFieldInfo(elementFieldArray);
        for (int i = 0; i < elementFieldInfoArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(",\n");
            }
            DocumentationGenerator.appendLink(elementFieldInfoArray[i], stringBuilder);
        }
        stringBuilder.append(".</p>\n");
    }

    private ElementFieldInfo[] sortElementFieldInfo(ElementField[] elementFieldArray) {
        ElementFieldInfo[] elementFieldInfoArray = new ElementFieldInfo[elementFieldArray.length];
        for (int i = 0; i < elementFieldArray.length; ++i) {
            elementFieldInfoArray[i] = this.elementFieldToInfo.get(elementFieldArray[i]);
        }
        if (elementFieldInfoArray.length > 1) {
            Arrays.sort(elementFieldInfoArray, compareFieldInfo);
        }
        return elementFieldInfoArray;
    }

    private void appendParentsSection(ElementFieldInfo elementFieldInfo, StringBuilder stringBuilder) {
        ElementField[] elementFieldArray = elementFieldInfo.parents;
        if (elementFieldArray.length == 0) {
            return;
        }
        stringBuilder.append("<h2>");
        XMLText.escapeXML(Msg.msg("DG.parentsHead"), stringBuilder);
        stringBuilder.append("</h2>\n");
        stringBuilder.append("<p>");
        XMLText.escapeXML(Msg.msg("DG.parentsBlurb", elementFieldInfo.label), stringBuilder);
        stringBuilder.append(": ");
        ElementFieldInfo[] elementFieldInfoArray = this.sortElementFieldInfo(elementFieldArray);
        for (int i = 0; i < elementFieldInfoArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(",\n");
            }
            DocumentationGenerator.appendLink(elementFieldInfoArray[i], stringBuilder);
        }
        stringBuilder.append(".</p>\n");
    }

    private void appendAttributesSection(ElementField elementField, IdentityHashMap<AttributeField, AttributeFieldInfo> identityHashMap, StringBuilder stringBuilder) {
        if (identityHashMap.size() == 0) {
            return;
        }
        stringBuilder.append("<h2>");
        XMLText.escapeXML(Msg.msg("DG.attributesHead"), stringBuilder);
        stringBuilder.append("</h2>\n");
        stringBuilder.append("<table border='1'>\n");
        stringBuilder.append("<tr align='center'>\n");
        stringBuilder.append("<th>");
        XMLText.escapeXML(Msg.msg("DG.attributeName"), stringBuilder);
        stringBuilder.append("</th>\n");
        stringBuilder.append("<th>");
        XMLText.escapeXML(Msg.msg("DG.attributeDataType"), stringBuilder);
        stringBuilder.append("</th>\n");
        stringBuilder.append("<th>");
        XMLText.escapeXML(Msg.msg("DG.attributeValue"), stringBuilder);
        stringBuilder.append("</th>\n");
        stringBuilder.append("</tr>\n");
        AttributeFieldInfo[] attributeFieldInfoArray = new AttributeFieldInfo[identityHashMap.size()];
        identityHashMap.values().toArray(attributeFieldInfoArray);
        if (attributeFieldInfoArray.length > 1) {
            Arrays.sort(attributeFieldInfoArray, compareFieldInfo);
        }
        for (int i = 0; i < attributeFieldInfoArray.length; ++i) {
            AttributeFieldInfo attributeFieldInfo = attributeFieldInfoArray[i];
            AttributeField attributeField = (AttributeField)attributeFieldInfo.field;
            DataType dataType = attributeField.getAttributeDataType();
            Data data = attributeField.getAttributeFixedValue();
            Data data2 = attributeField.getAttributeDefaultValue();
            boolean bl = elementField.isRequiredAttribute(attributeField);
            stringBuilder.append("<tr valign='top'>\n");
            stringBuilder.append("<td>");
            if (bl) {
                if (data != null) {
                    stringBuilder.append("<b><i>");
                } else {
                    stringBuilder.append("<b>");
                }
            } else if (data != null) {
                stringBuilder.append("<i>");
            }
            stringBuilder.append("<a name='");
            XMLText.escapeXML(attributeFieldInfo.id, stringBuilder);
            stringBuilder.append("' id='");
            XMLText.escapeXML(attributeFieldInfo.id, stringBuilder);
            stringBuilder.append("'>");
            this.appendFieldLabel(attributeFieldInfo, elementField, stringBuilder);
            stringBuilder.append("</a>");
            if (bl) {
                if (data != null) {
                    stringBuilder.append("</i></b>");
                } else {
                    stringBuilder.append("</b>");
                }
            } else if (data != null) {
                stringBuilder.append("</i>");
            }
            stringBuilder.append("</td>\n");
            stringBuilder.append("<td>");
            this.appendDataType(dataType, stringBuilder);
            stringBuilder.append("</td>\n");
            stringBuilder.append("<td>");
            this.appendValue(data == null ? data2 : data, data != null, data2 != null, bl, stringBuilder);
            stringBuilder.append("</td>\n");
            stringBuilder.append("</tr>\n");
        }
        stringBuilder.append("</table>\n");
    }

    private void appendDataType(DataType dataType, StringBuilder stringBuilder) {
        if (dataType instanceof com.xmlmind.xml.wxs.datatype.DataType) {
            DocGenUtil.appendDataType((com.xmlmind.xml.wxs.datatype.DataType)dataType, this, stringBuilder);
        } else {
            String string = dataType.getDataTypeLabel(this);
            XMLText.escapeXML(string, stringBuilder);
        }
    }

    private void appendValue(Data data, boolean bl, boolean bl2, boolean bl3, StringBuilder stringBuilder) {
        int n = stringBuilder.length();
        if (bl3) {
            XMLText.escapeXML(Msg.msg("DG.requiredValue"), stringBuilder);
        }
        if (bl) {
            if (stringBuilder.length() > n) {
                stringBuilder.append(' ');
            }
            XMLText.escapeXML(Msg.msg("DG.fixedValue"), stringBuilder);
        }
        if (bl2) {
            if (stringBuilder.length() > n) {
                stringBuilder.append(' ');
            }
            XMLText.escapeXML(Msg.msg("DG.defaultValue"), stringBuilder);
        }
        if (data != null) {
            if (stringBuilder.length() > n) {
                stringBuilder.append(' ');
            }
            stringBuilder.append('\"');
            DocGenUtil.appendLongLine(data.formatData(this), stringBuilder);
            stringBuilder.append('\"');
        } else {
            stringBuilder.append("&#160;");
        }
    }

    private void appendFieldLabel(FieldInfo fieldInfo, ElementField elementField, StringBuilder stringBuilder) {
        if (!this.annotate) {
            XMLText.escapeXML(fieldInfo.label, stringBuilder);
            return;
        }
        boolean bl = elementField.isAmbiguousField(fieldInfo.field);
        if (bl) {
            stringBuilder.append("<span");
            this.appendMayBeAmbiguousAttribute(stringBuilder);
            stringBuilder.append('>');
        }
        XMLText.escapeXML(fieldInfo.label, stringBuilder);
        if (bl) {
            stringBuilder.append("</span>");
        }
    }

    private void appendMayBeAmbiguousAttribute(StringBuilder stringBuilder) {
        if (this.css != null) {
            stringBuilder.append(" class=\"mayBeAmbiguousField\"");
        } else {
            stringBuilder.append(" style=\"background-color: #FFFF00;\"");
        }
    }

    private void appendContentModelSection(ElementField elementField, IdentityHashMap<AttributeField, AttributeFieldInfo> identityHashMap, StringBuilder stringBuilder) {
        stringBuilder.append("<h2>");
        XMLText.escapeXML(Msg.msg("DG.contentModelHead"), stringBuilder);
        stringBuilder.append("</h2>\n");
        ContentType contentType = elementField.getElementContentType();
        if (contentType != ContentType.OTHER) {
            stringBuilder.append("<p><small>");
            switch (contentType) {
                case EMPTY: {
                    XMLText.escapeXML(Msg.msg("DG.emptyContentBlurb"), stringBuilder);
                    break;
                }
                case DATA: {
                    XMLText.escapeXML(Msg.msg("DG.dataContentBlurb"), stringBuilder);
                    break;
                }
                case ELEMENT_ONLY: {
                    XMLText.escapeXML(Msg.msg("DG.elementOnlyContentBlurb"), stringBuilder);
                    break;
                }
                case MIXED1: {
                    XMLText.escapeXML(Msg.msg("DG.mixed1ContentBlurb"), stringBuilder);
                    break;
                }
                case MIXED2: {
                    XMLText.escapeXML(Msg.msg("DG.mixed2ContentBlurb"), stringBuilder);
                }
            }
            stringBuilder.append("</small></p>\n");
        }
        Particle particle = this.translatePattern(elementField.pattern);
        stringBuilder.append("<pre>");
        particle.append(0, identityHashMap, elementField, stringBuilder);
        stringBuilder.append("</pre>\n");
        if (this.annotate && elementField.hasAmbiguousFields()) {
            stringBuilder.append("<p>&#160;</p>\n<hr align='left' width='10%'>\n");
            stringBuilder.append("<table border='0' cellspacing='0' width='80%'>\n");
            stringBuilder.append("<tr>\n");
            stringBuilder.append("<th valign='top'><small");
            this.appendMayBeAmbiguousAttribute(stringBuilder);
            stringBuilder.append(">&#160;&#160;&#160;&#160;</small></th>\n");
            stringBuilder.append("<td><small>\n");
            XMLText.escapeXML(Msg.msg("DG.mayBeAmbiguousBlurb"), stringBuilder);
            stringBuilder.append("</small></td>\n");
            stringBuilder.append("</tr>\n");
            stringBuilder.append("</table>\n");
        }
    }

    private Particle translatePattern(Pattern pattern) {
        Particle particle;
        Occurrence occurrence = Occurrence.which(pattern);
        Occurrence.Op op = occurrence.occurrence;
        pattern = occurrence.pattern;
        if (pattern instanceof GroupPattern) {
            GroupPattern groupPattern = (GroupPattern)pattern;
            Particle particle2 = this.translatePattern(groupPattern.pattern1);
            Particle particle3 = this.translatePattern(groupPattern.pattern2);
            particle = new GroupParticle(particle2, particle3);
        } else if (pattern instanceof ChoicePattern) {
            ChoicePattern choicePattern = (ChoicePattern)pattern;
            Particle particle4 = this.translatePattern(choicePattern.pattern1);
            Particle particle5 = this.translatePattern(choicePattern.pattern2);
            particle = new ChoiceParticle(particle4, particle5);
        } else if (pattern instanceof InterleavePattern) {
            InterleavePattern interleavePattern = (InterleavePattern)pattern;
            Particle particle6 = this.translatePattern(interleavePattern.pattern1);
            Particle particle7 = this.translatePattern(interleavePattern.pattern2);
            particle = new InterleaveParticle(particle6, particle7);
        } else if (pattern instanceof ElementField) {
            particle = new ElementParticle((ElementField)pattern);
        } else if (pattern instanceof AttributeField) {
            particle = new AttributeParticle((AttributeField)pattern);
        } else if (pattern instanceof AnyDataPattern) {
            particle = new AnyDataParticle((AnyDataPattern)pattern);
        } else if (pattern == TextPattern.INSTANCE) {
            particle = new TextParticle();
        } else if (pattern == EmptyPattern.INSTANCE) {
            particle = new EmptyParticle();
        } else if (pattern == NotAllowedPattern.INSTANCE) {
            particle = new NotAllowedParticle();
        } else {
            throw new RuntimeException("unexpected pattern " + pattern.getClass().getName());
        }
        particle.occurrence = op;
        return particle;
    }

    private final class NotAllowedParticle
    extends Particle {
        private NotAllowedParticle() {
        }

        @Override
        public void append(int n, IdentityHashMap<AttributeField, AttributeFieldInfo> identityHashMap, ElementField elementField, StringBuilder stringBuilder) {
            stringBuilder.append("<b>notAllowed</b>");
            stringBuilder.append(this.occurrence.toString());
        }
    }

    private final class EmptyParticle
    extends Particle {
        private EmptyParticle() {
        }

        @Override
        public void append(int n, IdentityHashMap<AttributeField, AttributeFieldInfo> identityHashMap, ElementField elementField, StringBuilder stringBuilder) {
            stringBuilder.append("<b>empty</b>");
            stringBuilder.append(this.occurrence.toString());
        }
    }

    private final class TextParticle
    extends Particle {
        private TextParticle() {
        }

        @Override
        public void append(int n, IdentityHashMap<AttributeField, AttributeFieldInfo> identityHashMap, ElementField elementField, StringBuilder stringBuilder) {
            stringBuilder.append("<b><i>text</i></b>");
            stringBuilder.append(this.occurrence.toString());
        }
    }

    private final class AnyDataParticle
    extends Particle {
        public AnyDataPattern pattern;

        public AnyDataParticle(AnyDataPattern anyDataPattern) {
            this.pattern = anyDataPattern;
        }

        @Override
        public void append(int n, IdentityHashMap<AttributeField, AttributeFieldInfo> identityHashMap, ElementField elementField, StringBuilder stringBuilder) {
            boolean bl;
            String string;
            StringBuilder stringBuilder2 = new StringBuilder();
            if (elementField.dataType != null) {
                DocumentationGenerator.this.appendDataType(elementField.dataType, stringBuilder2);
                if (elementField.fixedValue != null) {
                    stringBuilder2.append(' ');
                    DocumentationGenerator.this.appendValue(elementField.fixedValue, true, false, false, stringBuilder2);
                }
                string = stringBuilder2.toString();
            } else {
                this.pattern.toString(-1, DocumentationGenerator.this, stringBuilder2);
                string = XMLText.escapeXML(stringBuilder2.toString());
            }
            string = StringUtil.replaceAll(string, "<br>", " ");
            string = XMLText.collapseWhiteSpace(string);
            stringBuilder.append("<b><i>");
            boolean bl2 = bl = !string.startsWith("(") && !string.endsWith(")");
            if (bl) {
                stringBuilder.append('(');
            }
            stringBuilder.append(string);
            if (bl) {
                stringBuilder.append(')');
            }
            stringBuilder.append("</i></b>");
            stringBuilder.append(this.occurrence.toString());
        }
    }

    private final class AttributeParticle
    extends Particle {
        public AttributeField field;

        public AttributeParticle(AttributeField attributeField) {
            this.field = attributeField;
        }

        @Override
        public void append(int n, IdentityHashMap<AttributeField, AttributeFieldInfo> identityHashMap, ElementField elementField, StringBuilder stringBuilder) {
            AttributeFieldInfo attributeFieldInfo = identityHashMap.get(this.field);
            stringBuilder.append("@");
            stringBuilder.append("<a href='#");
            XMLText.escapeXML(attributeFieldInfo.id, stringBuilder);
            stringBuilder.append("'>");
            DocumentationGenerator.this.appendFieldLabel(attributeFieldInfo, elementField, stringBuilder);
            stringBuilder.append("</a>");
            stringBuilder.append(this.occurrence.toString());
        }
    }

    private final class ElementParticle
    extends Particle {
        public ElementField field;

        public ElementParticle(ElementField elementField) {
            this.field = elementField;
        }

        @Override
        public void append(int n, IdentityHashMap<AttributeField, AttributeFieldInfo> identityHashMap, ElementField elementField, StringBuilder stringBuilder) {
            ElementFieldInfo elementFieldInfo = DocumentationGenerator.this.elementFieldToInfo.get(this.field);
            stringBuilder.append("<a href='");
            XMLText.escapeXML(elementFieldInfo.pageName, stringBuilder);
            stringBuilder.append("'>");
            DocumentationGenerator.this.appendFieldLabel(elementFieldInfo, elementField, stringBuilder);
            stringBuilder.append("</a>");
            stringBuilder.append(this.occurrence.toString());
        }
    }

    private final class InterleaveParticle
    extends BinaryParticle {
        public InterleaveParticle(Particle particle, Particle particle2) {
            super('&', particle, particle2);
        }
    }

    private final class ChoiceParticle
    extends BinaryParticle {
        public ChoiceParticle(Particle particle, Particle particle2) {
            super('|', particle, particle2);
        }

        @Override
        public void append(int n, IdentityHashMap<AttributeField, AttributeFieldInfo> identityHashMap, ElementField elementField, StringBuilder stringBuilder) {
            if (elementField.dataType != null) {
                boolean bl = true;
                for (int i = 0; i < this.particles.length; ++i) {
                    if (this.particles[i] instanceof AnyDataParticle) continue;
                    bl = false;
                    break;
                }
                if (bl) {
                    AnyDataParticle anyDataParticle = new AnyDataParticle(null);
                    anyDataParticle.occurrence = this.occurrence;
                    anyDataParticle.append(n, identityHashMap, elementField, stringBuilder);
                    return;
                }
            }
            super.append(n, identityHashMap, elementField, stringBuilder);
        }
    }

    private final class GroupParticle
    extends BinaryParticle {
        public GroupParticle(Particle particle, Particle particle2) {
            super(',', particle, particle2);
        }
    }

    private abstract class BinaryParticle
    extends Particle {
        public char op;
        public Particle[] particles;

        protected BinaryParticle(char c, Particle particle, Particle particle2) {
            BinaryParticle binaryParticle;
            this.op = c;
            boolean bl = particle.getClass() == this.getClass() && particle.occurrence == Occurrence.Op.ONE;
            boolean bl2 = particle2.getClass() == this.getClass() && particle2.occurrence == Occurrence.Op.ONE;
            this.particles = new Particle[(bl ? ((BinaryParticle)particle).particles.length : 1) + (bl2 ? ((BinaryParticle)particle2).particles.length : 1)];
            int n = 0;
            if (bl) {
                binaryParticle = (BinaryParticle)particle;
                System.arraycopy(binaryParticle.particles, 0, this.particles, n, binaryParticle.particles.length);
                n += binaryParticle.particles.length;
            } else {
                this.particles[n++] = particle;
            }
            if (bl2) {
                binaryParticle = (BinaryParticle)particle2;
                System.arraycopy(binaryParticle.particles, 0, this.particles, n, binaryParticle.particles.length);
                n += binaryParticle.particles.length;
            } else {
                this.particles[n++] = particle2;
            }
        }

        @Override
        public void append(int n, IdentityHashMap<AttributeField, AttributeFieldInfo> identityHashMap, ElementField elementField, StringBuilder stringBuilder) {
            int n2;
            boolean bl = true;
            for (n2 = 0; n2 < this.particles.length; ++n2) {
                if (!(this.particles[n2] instanceof BinaryParticle)) continue;
                bl = false;
                break;
            }
            stringBuilder.append('(');
            for (n2 = 0; n2 < this.particles.length; ++n2) {
                if (n2 > 0) {
                    stringBuilder.append(' ');
                    stringBuilder.append(this.op);
                    stringBuilder.append(' ');
                    if (bl && n2 % 5 == 0 || !bl) {
                        stringBuilder.append('\n');
                        this.appendIndent(n + 1, stringBuilder);
                    }
                }
                this.particles[n2].append(n + 1, identityHashMap, elementField, stringBuilder);
            }
            stringBuilder.append(')');
            stringBuilder.append(this.occurrence.toString());
        }

        protected void appendIndent(int n, StringBuilder stringBuilder) {
            while (n > 0) {
                stringBuilder.append(' ');
                --n;
            }
        }
    }

    private abstract class Particle {
        public Occurrence.Op occurrence;

        private Particle() {
        }

        public abstract void append(int var1, IdentityHashMap<AttributeField, AttributeFieldInfo> var2, ElementField var3, StringBuilder var4);
    }

    private static final class FieldInfoComparator
    implements Comparator<FieldInfo> {
        private FieldInfoComparator() {
        }

        @Override
        public int compare(FieldInfo fieldInfo, FieldInfo fieldInfo2) {
            Name name = fieldInfo.field.getFieldName();
            Name name2 = fieldInfo2.field.getFieldName();
            if (name != null) {
                if (name2 != null) {
                    Namespace namespace = name.namespace;
                    Namespace namespace2 = name2.namespace;
                    if (namespace == namespace2) {
                        String string;
                        String string2 = name.localPart.toUpperCase();
                        int n = string2.compareTo(string = name2.localPart.toUpperCase());
                        if (n == 0 && fieldInfo instanceof ElementFieldInfo && fieldInfo2 instanceof ElementFieldInfo) {
                            n = ((ElementFieldInfo)fieldInfo2).parents.length - ((ElementFieldInfo)fieldInfo).parents.length;
                        }
                        return n;
                    }
                    return namespace.compareTo(namespace2);
                }
                return Integer.MIN_VALUE;
            }
            if (name2 != null) {
                return Integer.MAX_VALUE;
            }
            return fieldInfo.label.compareTo(fieldInfo2.label);
        }
    }

    private static final class AttributeFieldInfo
    extends FieldInfo {
        public String id;

        public AttributeFieldInfo(AttributeField attributeField, String string, String string2) {
            super(attributeField, string);
            this.id = string2;
        }
    }

    private static final class ElementFieldInfo
    extends FieldInfo {
        public ElementField[] parents;
        public boolean isStart;
        public String pageName;

        public ElementFieldInfo(ElementField elementField, ElementField elementField2) {
            super(elementField, null);
            this.parents = new ElementField[]{elementField2};
        }

        public void addParent(ElementField elementField) {
            int n = this.parents.length;
            for (int i = 0; i < n; ++i) {
                if (this.parents[i] != elementField) continue;
                return;
            }
            ElementField[] elementFieldArray = new ElementField[n + 1];
            System.arraycopy(this.parents, 0, elementFieldArray, 0, n);
            elementFieldArray[n] = elementField;
            this.parents = elementFieldArray;
        }

        public void markAsStart(ElementField elementField) {
            this.isStart = true;
            ElementField[] elementFieldArray = new ElementField[this.parents.length - 1];
            int n = 0;
            for (int i = 0; i < this.parents.length; ++i) {
                if (this.parents[i] == elementField) continue;
                elementFieldArray[n++] = this.parents[i];
            }
            this.parents = elementFieldArray;
        }
    }

    private static class FieldInfo {
        public FieldBase field;
        public String label;

        protected FieldInfo(FieldBase fieldBase, String string) {
            this.field = fieldBase;
            this.label = string;
        }
    }
}

