/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.rng.validate;

import com.xmlmind.xml.rng.validate.AttributeField;
import com.xmlmind.xml.rng.validate.ElementField;
import com.xmlmind.xml.rng.validate.ItemList;
import com.xmlmind.xml.rng.validate.Pattern;
import com.xmlmind.xml.rng.validate.PatternStack;
import com.xmlmind.xml.validate.ContentType;
import java.util.IdentityHashMap;

abstract class BinaryPattern
extends Pattern {
    public Pattern pattern1;
    public Pattern pattern2;

    protected BinaryPattern(Pattern pattern, Pattern pattern2, boolean bl) {
        super(bl);
        this.pattern1 = pattern;
        this.pattern2 = pattern2;
    }

    protected BinaryPattern() {
    }

    public int hashCode() {
        return System.identityHashCode(this.pattern1) ^ System.identityHashCode(this.pattern2);
    }

    @Override
    protected ContentType scan(PatternStack patternStack, IdentityHashMap<AttributeField, Boolean> identityHashMap, IdentityHashMap<ElementField, Boolean> identityHashMap2) {
        patternStack.push(this);
        ContentType contentType = this.pattern1.scan(patternStack, identityHashMap, identityHashMap2);
        ContentType contentType2 = this.pattern2.scan(patternStack, identityHashMap, identityHashMap2);
        patternStack.pop();
        if (contentType == ContentType.DATA) {
            if (contentType2.ordinal() <= ContentType.DATA.ordinal()) {
                return ContentType.DATA;
            }
            return ContentType.OTHER;
        }
        if (contentType2 == ContentType.DATA) {
            if (contentType.ordinal() <= ContentType.DATA.ordinal()) {
                return ContentType.DATA;
            }
            return ContentType.OTHER;
        }
        if (contentType.ordinal() >= contentType2.ordinal()) {
            return contentType;
        }
        return contentType2;
    }

    @Override
    protected int attributesSeparatedFromElements() {
        int n = this.pattern1.attributesSeparatedFromElements();
        int n2 = this.pattern2.attributesSeparatedFromElements();
        return Math.max(n, n2);
    }

    @Override
    protected Pattern findDataPattern() {
        Pattern pattern = this.pattern1.findDataPattern();
        if (pattern == null) {
            pattern = this.pattern2.findDataPattern();
        }
        return pattern;
    }

    @Override
    protected int getComplexity(boolean bl) {
        return this.pattern1.getComplexity(bl) + this.pattern2.getComplexity(bl);
    }

    @Override
    protected boolean expand(int n, ItemList itemList) {
        int n2 = itemList.size;
        if (!this.pattern1.expand(n, itemList)) {
            return false;
        }
        if (!this.pattern2.expand(n, itemList)) {
            itemList.setSize(n2);
            return false;
        }
        return true;
    }
}

