/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.name;

import com.xmlmind.util.XMLText;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.NamespacePrefixMap;
import com.xmlmind.xml.name.PrefixEntry;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;

public final class PrefixPreferences
implements NamespacePrefixMap {
    public static final PrefixPreferences INSTANCE = new PrefixPreferences();
    private HashMap<String, Namespace> prefixTONS = new HashMap();
    private IdentityHashMap<Namespace, String> nsToPrefix = new IdentityHashMap();
    private Namespace defaultNamespace = null;

    public PrefixPreferences() {
        this(null, false);
    }

    public PrefixPreferences(PrefixEntry[] prefixEntryArray, boolean bl) {
        if (prefixEntryArray != null) {
            this.add(prefixEntryArray, bl);
        }
    }

    public PrefixPreferences copy() {
        PrefixPreferences prefixPreferences = new PrefixPreferences();
        prefixPreferences.prefixTONS = (HashMap)this.prefixTONS.clone();
        prefixPreferences.nsToPrefix = (IdentityHashMap)this.nsToPrefix.clone();
        prefixPreferences.defaultNamespace = this.defaultNamespace;
        return prefixPreferences;
    }

    public void add(PrefixEntry[] prefixEntryArray, boolean bl) {
        for (PrefixEntry prefixEntry : prefixEntryArray) {
            if (prefixEntry.prefix.length() <= 0) continue;
            this.add(prefixEntry.namespace, prefixEntry.prefix);
        }
        for (PrefixEntry prefixEntry : prefixEntryArray) {
            if (prefixEntry.prefix.length() != 0 || this.add(prefixEntry.namespace, null) == null || !bl || this.defaultNamespace != null) continue;
            this.defaultNamespace = prefixEntry.namespace;
        }
    }

    public String add(Namespace namespace, String string) {
        Object object;
        Namespace namespace2;
        String string2 = this.nsToPrefix.get(namespace);
        if (string2 != null) {
            return string2;
        }
        if (namespace == Namespace.NONE || namespace == Namespace.XML || namespace == Namespace.ANY_NAMESPACE) {
            return null;
        }
        if (string == null) {
            string = namespace.getUsualPrefix();
            if (string == null) {
                string = "ns";
            }
        } else if (!XMLText.isNCName(string) || string.regionMatches(true, 0, "xml", 0, 3)) {
            return null;
        }
        if ((namespace2 = this.prefixTONS.get(string)) == null) {
            object = string;
        } else {
            int n = string.length();
            int n2 = -1;
            for (String string3 : this.nsToPrefix.values()) {
                if (string3.indexOf(string) != 0 || string3.length() == n) continue;
                int n3 = -1;
                try {
                    n3 = Integer.parseInt(string3.substring(n));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n3 <= n2) continue;
                n2 = n3;
            }
            if (n2 < 1) {
                n2 = 1;
            }
            object = string + Integer.toString(n2 + 1);
        }
        this.nsToPrefix.put(namespace, (String)object);
        this.prefixTONS.put((String)object, namespace);
        return object;
    }

    public Namespace remove(String string) {
        Namespace namespace = this.prefixTONS.remove(string);
        if (namespace != null) {
            this.nsToPrefix.remove(namespace);
            if (namespace == this.defaultNamespace) {
                this.defaultNamespace = null;
            }
        }
        return namespace;
    }

    public String remove(Namespace namespace) {
        String string = this.nsToPrefix.remove(namespace);
        if (string != null) {
            this.prefixTONS.remove(string);
            if (namespace == this.defaultNamespace) {
                this.defaultNamespace = null;
            }
        }
        return string;
    }

    public void clear() {
        this.prefixTONS.clear();
        this.nsToPrefix.clear();
        this.defaultNamespace = null;
    }

    public Namespace get(String string) {
        return this.prefixTONS.get(string);
    }

    public String get(Namespace namespace) {
        return this.nsToPrefix.get(namespace);
    }

    public int size() {
        return this.nsToPrefix.size();
    }

    public PrefixEntry[] getAll() {
        PrefixEntry[] prefixEntryArray = new PrefixEntry[this.nsToPrefix.size()];
        int n = 0;
        for (Map.Entry<Namespace, String> entry : this.nsToPrefix.entrySet()) {
            prefixEntryArray[n++] = new PrefixEntry(entry.getValue(), entry.getKey());
        }
        return prefixEntryArray;
    }

    public boolean setDefaultNamespace(Namespace namespace) {
        if (namespace == null || this.nsToPrefix.get(namespace) != null) {
            this.defaultNamespace = namespace;
            return true;
        }
        return false;
    }

    public Namespace getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public String toString() {
        Object[] objectArray;
        StringBuilder stringBuilder = new StringBuilder();
        Namespace namespace = this.getDefaultNamespace();
        if (namespace != null) {
            stringBuilder.append("xmlns=");
            XMLText.quoteXML(namespace.uri, stringBuilder);
            stringBuilder.append('\n');
        }
        if ((objectArray = this.getAll()).length > 1) {
            Arrays.sort(objectArray);
        }
        for (Object object : objectArray) {
            stringBuilder.append("xmlns:");
            stringBuilder.append(((PrefixEntry)object).prefix);
            stringBuilder.append('=');
            XMLText.quoteXML(((PrefixEntry)object).namespace.uri, stringBuilder);
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public Namespace prefixToNamespace(String string) {
        if (string.length() == 0 && this.defaultNamespace != null) {
            return this.defaultNamespace;
        }
        Namespace namespace = this.prefixTONS.get(string);
        if (namespace == null && "xml".equals(string)) {
            return Namespace.XML;
        }
        return namespace;
    }

    @Override
    public String[] namespaceToPrefixes(Namespace namespace) {
        String string = this.nsToPrefix.get(namespace);
        if (string == null) {
            return namespace == Namespace.XML ? XML_PREFIXES : null;
        }
        if (namespace == this.defaultNamespace) {
            return new String[]{"", string};
        }
        return new String[]{string};
    }

    public static PrefixEntry[] merge(PrefixEntry[] prefixEntryArray, PrefixEntry[] prefixEntryArray2) {
        if (prefixEntryArray == null || prefixEntryArray.length == 0) {
            return prefixEntryArray2;
        }
        if (prefixEntryArray2 == null || prefixEntryArray2.length == 0) {
            return prefixEntryArray;
        }
        PrefixPreferences prefixPreferences = new PrefixPreferences();
        for (PrefixEntry prefixEntry : prefixEntryArray) {
            prefixPreferences.add(prefixEntry.namespace, prefixEntry.prefix);
        }
        for (PrefixEntry prefixEntry : prefixEntryArray2) {
            prefixPreferences.add(prefixEntry.namespace, prefixEntry.prefix);
        }
        return prefixPreferences.getAll();
    }
}

