/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.name;

import com.xmlmind.util.StringList;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.NamespacePrefixMap;
import com.xmlmind.xml.name.PrefixEntry;

public final class PrefixEntries
implements NamespacePrefixMap {
    public final PrefixEntry[] entries;

    public PrefixEntries(String string, Namespace namespace) {
        this(new PrefixEntry[]{new PrefixEntry(string, namespace)});
    }

    public PrefixEntries(PrefixEntry[] prefixEntryArray) {
        this.entries = prefixEntryArray;
    }

    @Override
    public Namespace prefixToNamespace(String string) {
        for (PrefixEntry prefixEntry : this.entries) {
            if (!prefixEntry.prefix.equals(string)) continue;
            return prefixEntry.namespace;
        }
        if ("xml".equals(string)) {
            return Namespace.XML;
        }
        if ("".equals(string)) {
            return Namespace.NONE;
        }
        return null;
    }

    @Override
    public String[] namespaceToPrefixes(Namespace namespace) {
        String[] stringArray = null;
        for (PrefixEntry prefixEntry : this.entries) {
            if (namespace != prefixEntry.namespace) continue;
            stringArray = stringArray == null ? new String[]{prefixEntry.prefix} : StringList.append(stringArray, prefixEntry.prefix);
        }
        if (stringArray != null) {
            return stringArray;
        }
        if (namespace == Namespace.XML) {
            return XML_PREFIXES;
        }
        if (namespace == Namespace.NONE) {
            return EMPTY_PREFIXES;
        }
        return null;
    }

    public String toString() {
        return PrefixEntry.toString(this.entries);
    }
}

