/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.load;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.ThrowableUtil;
import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.doc.Comment;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.DocumentTypeDeclaration;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.load.AttributeDecl;
import com.xmlmind.xml.load.DTDSpec;
import com.xmlmind.xml.load.Decl;
import com.xmlmind.xml.load.ElementDecl;
import com.xmlmind.xml.load.Entities;
import com.xmlmind.xml.load.EntityDecl;
import com.xmlmind.xml.load.EntityRef;
import com.xmlmind.xml.load.ExternalEntityDecl;
import com.xmlmind.xml.load.InternalEntityDecl;
import com.xmlmind.xml.load.LoadOptions;
import com.xmlmind.xml.load.Msg;
import com.xmlmind.xml.load.NotationDecl;
import com.xmlmind.xml.load.UnparsedEntityDecl;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.name.PrefixPreferences;
import com.xmlmind.xml.resolve.XMLCatalogs;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.EntityResolver2;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;

public class DocumentLoader
implements LexicalHandler,
DeclHandler,
DTDHandler,
ContentHandler,
EntityResolver2,
ErrorHandler,
LoadOptions {
    protected int options;
    protected XMLReader parser;
    protected StackItem[] stack;
    protected int stackSize;
    protected Locator2 locator;
    protected boolean insideDTD;
    protected DTDSpec dtdSpec;
    protected StringBuilder internalSubset;
    protected int dtdEntityNesting;
    protected boolean insideExternalSubset;
    protected Entities entities;
    protected String internalSubsetOrigin;
    protected String externalSubsetOrigin;
    protected boolean firstElement;
    protected PrefixPreferences nsPrefixMap;
    protected PrefixEntry[] declaredPrefixes;
    protected boolean isCharEntity;
    protected char[] chars;
    protected int charCount;
    protected boolean wasCDATA;
    protected static final char[] cdataMark = new char[]{'\ue123'};
    protected String version;
    protected String encoding;
    protected String standalone;

    public void setOptions(int n) {
        this.options = n;
    }

    public int getOptions() {
        return this.options;
    }

    public Document load(File file) throws SAXException, IOException {
        return this.load(FileUtil.fileToURL(file));
    }

    public Document load(URL uRL) throws SAXException, IOException {
        return this.load(uRL, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document load(URL uRL, boolean bl) throws SAXException, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(bl ? URLUtil.openStreamUseCache(uRL) : URLUtil.openStreamNoCache(uRL), 65535);
        InputSource inputSource = new InputSource(bufferedInputStream);
        inputSource.setSystemId(uRL.toExternalForm());
        try {
            Document document = this.load(inputSource);
            return document;
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    public Document load(InputSource inputSource) throws SAXException, IOException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            sAXParserFactory.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
            sAXParserFactory.setValidating(false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", true);
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", true);
            sAXParserFactory.setFeature("http://xml.org/sax/features/lexical-handler/parameter-entities", true);
            sAXParserFactory.setFeature("http://xml.org/sax/features/resolve-dtd-uris", false);
            sAXParserFactory.setXIncludeAware(false);
            try {
                sAXParserFactory.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!sAXParserFactory.getFeature("http://xml.org/sax/features/use-entity-resolver2")) {
                throw new SAXNotSupportedException("use-entity-resolver2");
            }
            if (!sAXParserFactory.getFeature("http://xml.org/sax/features/use-attributes2")) {
                throw new SAXNotSupportedException("use-attributes2");
            }
            this.parser = sAXParserFactory.newSAXParser().getXMLReader();
            this.parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.parser.setProperty("http://xml.org/sax/properties/declaration-handler", this);
            this.parser.setDTDHandler(this);
            this.parser.setContentHandler(this);
            this.parser.setEntityResolver(this);
            this.parser.setErrorHandler(this);
        }
        catch (Exception exception) {
            throw new SAXException(Msg.msg("cannotCreateSAXParser", ThrowableUtil.reason(exception)));
        }
        this.stack = new StackItem[10];
        for (int i = 0; i < this.stack.length; ++i) {
            this.stack[i] = new StackItem();
        }
        this.stackSize = 0;
        this.locator = null;
        this.insideDTD = false;
        this.dtdSpec = null;
        this.internalSubset = null;
        this.dtdEntityNesting = 0;
        this.insideExternalSubset = false;
        this.entities = null;
        this.externalSubsetOrigin = null;
        this.internalSubsetOrigin = null;
        this.firstElement = true;
        this.nsPrefixMap = null;
        this.declaredPrefixes = null;
        this.isCharEntity = false;
        this.chars = new char[1024];
        this.charCount = 0;
        this.wasCDATA = false;
        this.version = null;
        this.encoding = null;
        this.standalone = null;
        Document document = new Document();
        if ((this.options & 1) == 0) {
            this.nsPrefixMap = new PrefixPreferences();
            document.putProperty(Constants.NAMESPACE_PREFIX_MAP_PROPERTY, this.nsPrefixMap);
        }
        URL uRL = null;
        String string = inputSource.getSystemId();
        if (string != null) {
            try {
                uRL = URLUtil.createURL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL != null) {
            document.putProperty(Constants.SOURCE_URL_PROPERTY, uRL);
        }
        this.push(document, 0, null, null);
        this.parser.parse(inputSource);
        if ((this.options & 4) == 0 && (this.version != null || this.encoding != null || this.standalone != null)) {
            document.putProperty(Constants.XML_DECLARATION_PROPERTY, new String[]{this.version, this.encoding, this.standalone});
        }
        return document;
    }

    public String getVersion() {
        return this.version;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getStandalone() {
        return this.standalone;
    }

    public DTDSpec getDTDSpec() {
        return this.dtdSpec;
    }

    public static String format(SAXParseException sAXParseException) {
        StringBuilder stringBuilder = new StringBuilder();
        if (sAXParseException.getSystemId() != null) {
            stringBuilder.append(sAXParseException.getSystemId());
        }
        stringBuilder.append(':');
        if (sAXParseException.getLineNumber() > 0) {
            stringBuilder.append(sAXParseException.getLineNumber());
        }
        stringBuilder.append(':');
        if (sAXParseException.getColumnNumber() > 0) {
            stringBuilder.append(sAXParseException.getColumnNumber());
        }
        stringBuilder.append(':');
        stringBuilder.append(Msg.msg("parseError"));
        stringBuilder.append(": ");
        stringBuilder.append(sAXParseException.getMessage());
        return stringBuilder.toString();
    }

    protected void push(Tree tree, int n, EntityRef entityRef, URL uRL) {
        Object object;
        if (this.stackSize == this.stack.length) {
            object = new StackItem[2 * this.stackSize];
            System.arraycopy(this.stack, 0, object, 0, this.stackSize);
            for (int i = this.stackSize; i < ((StackItem[])object).length; ++i) {
                object[i] = new StackItem();
            }
            this.stack = object;
        }
        object = this.stack[this.stackSize++];
        object.tree = tree;
        object.entityNesting = n;
        object.entityRef = entityRef;
        object.entityURL = uRL;
    }

    protected void pop() {
        StackItem stackItem = this.stack[--this.stackSize];
        stackItem.tree = null;
        stackItem.entityNesting = -1;
        stackItem.entityRef = null;
        stackItem.entityURL = null;
    }

    protected StackItem top() {
        return this.stack[this.stackSize - 1];
    }

    protected URL getDocumentURL() {
        return (URL)this.stack[0].tree.getProperty(Constants.SOURCE_URL_PROPERTY);
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.insideDTD = true;
        this.dtdSpec = new DTDSpec(string, string2, string3, this.baseURL());
        this.dtdSpec.setInternalSubsetFlag(0);
        this.internalSubset = new StringBuilder();
        this.entities = new Entities();
        Document document = (Document)this.top().tree;
        document.putProperty(Constants.ENTITIES_PROPERTY, this.entities);
    }

    protected URL baseURL() {
        String string;
        URL uRL = null;
        if (this.locator != null && (string = this.locator.getSystemId()) != null) {
            try {
                uRL = URLUtil.createURL(string);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return uRL;
    }

    @Override
    public void endDTD() throws SAXException {
        this.insideDTD = false;
        this.insideExternalSubset = false;
        DocumentTypeDeclaration documentTypeDeclaration = this.createDocumentTypeDeclaration();
        if (documentTypeDeclaration != null) {
            Document document = (Document)this.top().tree;
            document.appendChild(documentTypeDeclaration);
        }
    }

    protected DocumentTypeDeclaration createDocumentTypeDeclaration() {
        String string = null;
        if (this.internalSubset.length() > 0) {
            string = this.internalSubset.toString();
        }
        return new DocumentTypeDeclaration(this.dtdSpec.documentTypeName, this.dtdSpec.publicId, this.dtdSpec.systemId, string);
    }

    @Override
    public void startEntity(String string) throws SAXException {
        if ("lt".equals(string) || "amp".equals(string) || "gt".equals(string) || "quot".equals(string) || "apos".equals(string)) {
            this.isCharEntity = true;
            return;
        }
        if (this.insideDTD) {
            boolean bl = "[dtd]".equals(string);
            if (this.dtdEntityNesting == 0 && !bl) {
                this.internalSubset.append(string);
                this.internalSubset.append(";\n");
                this.dtdSpec.setInternalSubsetFlag(1);
            }
            ++this.dtdEntityNesting;
            if (bl) {
                this.insideExternalSubset = true;
            }
        } else {
            assert (this.entities != null);
            EntityDecl entityDecl = this.entities.get(string);
            assert (entityDecl != null);
            this.isCharEntity = entityDecl.isCharEntity();
            if (this.isCharEntity) {
                return;
            }
            URL uRL = entityDecl.getURL();
            StackItem stackItem = this.top();
            this.checkChars(stackItem);
            if (stackItem.entityRef != null) {
                this.push(stackItem.tree, stackItem.entityNesting, stackItem.entityRef, uRL);
            } else {
                EntityRef entityRef = new EntityRef(string, entityDecl.origin);
                this.push(stackItem.tree, stackItem.entityNesting + 1, entityRef, uRL);
            }
        }
    }

    @Override
    public void endEntity(String string) throws SAXException {
        if (this.isCharEntity) {
            this.isCharEntity = false;
            return;
        }
        if (this.insideDTD) {
            --this.dtdEntityNesting;
        } else {
            this.checkChars(this.top());
            this.pop();
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        Name name;
        StackItem stackItem = this.top();
        if (stackItem.tree.getType() == Node.Type.ELEMENT && ((name = ((Element)stackItem.tree).getName()) == Name.SCRIPT || name == Name.STYLE)) {
            this.characters(cdataMark, 0, 1);
            this.wasCDATA = true;
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.wasCDATA) {
            this.characters(cdataMark, 0, 1);
        }
    }

    @Override
    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (this.insideDTD) {
            if (this.dtdEntityNesting == 0) {
                this.internalSubset.append("<!--");
                this.internalSubset.append(cArray, n, n2);
                this.internalSubset.append("-->\n");
            }
        } else {
            StackItem stackItem = this.top();
            this.checkChars(stackItem);
            Comment comment = new Comment(cArray, n, n2);
            this.checkEntityRef(stackItem, comment);
            stackItem.tree.appendChild(comment);
        }
    }

    protected void checkChars(StackItem stackItem) {
        if (this.charCount > 0) {
            Text text;
            if (this.wasCDATA) {
                this.wasCDATA = false;
                char c = cdataMark[0];
                char[] cArray = new char[this.charCount];
                int n = 0;
                for (int i = 0; i < this.charCount; ++i) {
                    char c2 = this.chars[i];
                    if (c2 == c) {
                        if (i < 2 || this.chars[i - 1] != '*' || this.chars[i - 2] != '/' || i + 2 >= this.charCount || this.chars[i + 1] != '*' || this.chars[i + 2] != '/') continue;
                        n -= 2;
                        i += 2;
                        continue;
                    }
                    cArray[n++] = c2;
                }
                text = new Text(cArray, 0, n);
            } else {
                text = new Text(this.chars, 0, this.charCount);
            }
            this.charCount = 0;
            this.checkEntityRef(stackItem, text);
            stackItem.tree.appendChild(text);
        }
    }

    protected void checkEntityRef(StackItem stackItem, Node node) {
        if (stackItem.entityRef != null) {
            if (stackItem.entityNesting == 1) {
                node.putProperty(Constants.INCLUSION_PROPERTY, stackItem.entityRef);
                node.putProperty(Constants.READ_ONLY_PROPERTY, Boolean.TRUE);
            }
            if (stackItem.entityURL != null) {
                node.putProperty(Constants.SOURCE_URL_PROPERTY, stackItem.entityURL);
            }
        }
    }

    @Override
    public void elementDecl(String string, String string2) throws SAXException {
        ElementDecl elementDecl = this.dtdSpec.elementDecl(string, string2, this.insideExternalSubset);
        if (this.dtdEntityNesting == 0) {
            ((Decl)elementDecl).toString(this.internalSubset);
            this.internalSubset.append('\n');
            this.dtdSpec.setInternalSubsetFlag(1);
        }
    }

    @Override
    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
        AttributeDecl attributeDecl = this.dtdSpec.attributeDecl(string, string2, string3, string4, string5, this.insideExternalSubset);
        if (this.dtdEntityNesting == 0) {
            ((Decl)attributeDecl).toString(this.internalSubset);
            this.internalSubset.append('\n');
            this.dtdSpec.setInternalSubsetFlag(1);
        }
    }

    @Override
    public void internalEntityDecl(String string, String string2) throws SAXException {
        InternalEntityDecl internalEntityDecl = this.entities.internalEntityDecl(string, string2, this.entityOrigin());
        if (this.dtdEntityNesting == 0) {
            ((Decl)internalEntityDecl).toString(this.internalSubset);
            this.internalSubset.append('\n');
            this.dtdSpec.setInternalSubsetFlag(1);
        }
    }

    protected String entityOrigin() {
        if (this.insideExternalSubset) {
            if (this.externalSubsetOrigin == null) {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.dtdSpec.publicId != null) {
                    stringBuilder.append("<!DOCTYPE PUBLIC \"");
                    stringBuilder.append(this.dtdSpec.publicId);
                    stringBuilder.append("\">");
                } else {
                    String string = this.dtdSpec.systemId;
                    try {
                        String string2 = XMLCatalogs.getResolvedEntity(this.dtdSpec.publicId, string);
                        URL uRL = string2 != null ? URLUtil.createURL(string2) : URLUtil.createURL(this.dtdSpec.baseURL, string);
                        string = uRL.toExternalForm();
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    stringBuilder.append("<!DOCTYPE SYSTEM \"");
                    stringBuilder.append(string);
                    stringBuilder.append("\">");
                }
                this.externalSubsetOrigin = stringBuilder.toString();
            }
            return this.externalSubsetOrigin;
        }
        if (this.internalSubsetOrigin == null) {
            StringBuilder stringBuilder = new StringBuilder("<!DOCTYPE []> ");
            stringBuilder.append(this.getDocumentURL());
            this.internalSubsetOrigin = stringBuilder.toString();
        }
        return this.internalSubsetOrigin;
    }

    @Override
    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
        ExternalEntityDecl externalEntityDecl = this.entities.externalEntityDecl(string, string2, string3, this.baseURL(), this.entityOrigin());
        if (this.dtdEntityNesting == 0) {
            ((Decl)externalEntityDecl).toString(this.internalSubset);
            this.internalSubset.append('\n');
            this.dtdSpec.setInternalSubsetFlag(1);
        }
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        NotationDecl notationDecl = this.dtdSpec.notationDecl(string, string2, string3, this.baseURL(), this.insideExternalSubset);
        if (this.dtdEntityNesting == 0) {
            ((Decl)notationDecl).toString(this.internalSubset);
            this.internalSubset.append('\n');
            this.dtdSpec.setInternalSubsetFlag(1);
        }
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        UnparsedEntityDecl unparsedEntityDecl = this.entities.unparsedEntityDecl(string, string2, string3, this.baseURL(), string4, this.entityOrigin());
        if (this.dtdEntityNesting == 0) {
            ((Decl)unparsedEntityDecl).toString(this.internalSubset);
            this.internalSubset.append('\n');
            this.dtdSpec.setInternalSubsetFlag(1);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = (Locator2)locator;
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        int n = string.length();
        int n2 = string2.length();
        if (n > 0 && n2 == 0) {
            return;
        }
        PrefixEntry prefixEntry = new PrefixEntry(string, Namespace.get(string2));
        this.declaredPrefixes = this.declaredPrefixes == null ? new PrefixEntry[]{prefixEntry} : ArrayUtil.append(this.declaredPrefixes, prefixEntry);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        StackItem stackItem = this.top();
        this.checkChars(stackItem);
        Element element = new Element(Name.get(Namespace.get(string), string2));
        this.checkEntityRef(stackItem, element);
        if (this.declaredPrefixes != null) {
            this.declarePrefixes(element, this.declaredPrefixes);
            this.declaredPrefixes = null;
        }
        if ((this.options & 2) != 0 && this.locator != null) {
            element.putProperty(Constants.LINE_COLUMN_PROPERTY, new int[]{this.locator.getLineNumber(), this.locator.getColumnNumber()});
        }
        Attributes2 attributes2 = (Attributes2)attributes;
        int n = attributes.getLength();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (!attributes2.isSpecified(i)) continue;
                Name name = Name.get(Namespace.get(attributes2.getURI(i)), attributes2.getLocalName(i));
                element.putAttribute(name, attributes2.getValue(i));
            }
        }
        stackItem.tree.appendChild(element);
        if (this.firstElement) {
            this.firstElement = false;
            if (this.locator != null) {
                this.version = this.locator.getXMLVersion();
                this.encoding = this.locator.getEncoding();
            }
            try {
                this.standalone = this.parser.getFeature("http://xml.org/sax/features/is-standalone") ? "yes" : "false";
            }
            catch (SAXException sAXException) {
                // empty catch block
            }
            this.rootElement(element);
        }
        this.push(element, stackItem.entityNesting, null, null);
    }

    private void declarePrefixes(Element element, PrefixEntry[] prefixEntryArray) {
        if ((this.options & 1) != 0) {
            element.putProperty(Constants.DECLARED_PREFIXES_PROPERTY, prefixEntryArray);
        } else {
            Namespace namespace = null;
            for (PrefixEntry prefixEntry : prefixEntryArray) {
                if (prefixEntry.prefix.length() == 0) {
                    namespace = prefixEntry.namespace;
                    continue;
                }
                this.nsPrefixMap.add(prefixEntry.namespace, prefixEntry.prefix);
            }
            if (namespace != null && this.nsPrefixMap.add(namespace, null) != null && this.nsPrefixMap.getDefaultNamespace() == null) {
                this.nsPrefixMap.setDefaultNamespace(namespace);
            }
        }
    }

    protected void rootElement(Element element) {
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.charCount + n2 > this.chars.length) {
            int n3 = Math.max(this.charCount + n2, 2 * this.chars.length);
            char[] cArray2 = new char[n3];
            if (this.charCount > 0) {
                System.arraycopy(this.chars, 0, cArray2, 0, this.charCount);
            }
            this.chars = cArray2;
        }
        System.arraycopy(cArray, n, this.chars, this.charCount, n2);
        this.charCount += n2;
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.insideDTD) {
            if (this.dtdEntityNesting == 0) {
                this.internalSubset.append("<?");
                this.internalSubset.append(string);
                this.internalSubset.append(' ');
                this.internalSubset.append(string2);
                this.internalSubset.append("?>\n");
            }
        } else {
            StackItem stackItem = this.top();
            this.checkChars(stackItem);
            ProcessingInstruction processingInstruction = new ProcessingInstruction(string, string2);
            this.checkEntityRef(stackItem, processingInstruction);
            stackItem.tree.appendChild(processingInstruction);
        }
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        throw new SAXParseException(Msg.msg("undefinedEntity", string), this.locator);
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.checkChars(this.top());
        this.pop();
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public InputSource getExternalSubset(String string, String string2) throws SAXException, IOException {
        return null;
    }

    @Override
    public InputSource resolveEntity(String string, String string2, String string3, String string4) throws SAXException, IOException {
        EntityResolver entityResolver = XMLCatalogs.getEntityResolver();
        return entityResolver.resolveEntity(string2, string4);
    }

    @Override
    public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
        EntityResolver entityResolver = XMLCatalogs.getEntityResolver();
        return entityResolver.resolveEntity(string, string2);
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
    }

    protected static final class StackItem {
        public Tree tree;
        public int entityNesting = -1;
        public EntityRef entityRef;
        public URL entityURL;

        protected StackItem() {
        }
    }
}

