/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.doc;

import com.xmlmind.xml.doc.Comment;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.Text;
import com.xmlmind.xml.name.Name;

public final class Traversal {
    public static final Object LEAVE_ELEMENT = new Object();
    public static final TextFinder textFinder = new TextFinder();
    public static final TextNodeFinder textNodeFinder = new TextNodeFinder();
    public static final NodeFinder nodeFinder = new NodeFinder();

    private Traversal() {
    }

    public static final Object traverse(Node node, Handler handler) {
        switch (node.getType()) {
            case TEXT: {
                return handler.processText((Text)node);
            }
            case PROCESSING_INSTRUCTION: {
                return handler.processPI((ProcessingInstruction)node);
            }
            case COMMENT: {
                return handler.processComment((Comment)node);
            }
            case ELEMENT: {
                Element element = (Element)node;
                Object object = handler.enterElement(element);
                if (object != null) {
                    return object == LEAVE_ELEMENT ? null : object;
                }
                for (Node node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    object = Traversal.traverse(node2, handler);
                    if (object == null) continue;
                    return object;
                }
                object = handler.leaveElement(element);
                if (object != null) {
                    return object;
                }
                return null;
            }
        }
        return null;
    }

    public static final Object traverseBackwards(Node node, Handler handler) {
        switch (node.getType()) {
            case TEXT: {
                return handler.processText((Text)node);
            }
            case PROCESSING_INSTRUCTION: {
                return handler.processPI((ProcessingInstruction)node);
            }
            case COMMENT: {
                return handler.processComment((Comment)node);
            }
            case ELEMENT: {
                Element element = (Element)node;
                Object object = handler.enterElement(element);
                if (object != null) {
                    return object == LEAVE_ELEMENT ? null : object;
                }
                for (Node node2 = element.getLastChild(); node2 != null; node2 = node2.getPreviousSibling()) {
                    object = Traversal.traverseBackwards(node2, handler);
                    if (object == null) continue;
                    return object;
                }
                object = handler.leaveElement(element);
                if (object != null) {
                    return object;
                }
                return null;
            }
        }
        return null;
    }

    public static final Object traverseFrom(Node node, Handler handler) {
        Object object = Traversal.traverse(node, handler);
        if (object != null) {
            return object;
        }
        return Traversal.traverseAfter(node, handler);
    }

    public static final Object traverseAfter(Node node, Handler handler) {
        Object object;
        Object object2 = node.getParentElement();
        if (object2 == null) {
            return null;
        }
        for (Node node2 = node.getNextSibling(); node2 != null; node2 = node2.getNextSibling()) {
            object = Traversal.traverse(node2, handler);
            if (object == null) continue;
            return object;
        }
        while ((object = ((Node)object2).getParentElement()) != null) {
            Node node3 = ((Node)object2).getNextSibling();
            if (node3 != null) {
                return Traversal.traverseFrom(node3, handler);
            }
            object2 = object;
        }
        return null;
    }

    public static final Object traverseBackwardsFrom(Node node, Handler handler) {
        Object object = Traversal.traverseBackwards(node, handler);
        if (object != null) {
            return object;
        }
        return Traversal.traverseBefore(node, handler);
    }

    public static final Object traverseBefore(Node node, Handler handler) {
        Object object;
        Object object2 = node.getParentElement();
        if (object2 == null) {
            return null;
        }
        for (Node node2 = node.getPreviousSibling(); node2 != null; node2 = node2.getPreviousSibling()) {
            object = Traversal.traverseBackwards(node2, handler);
            if (object == null) continue;
            return object;
        }
        while ((object = ((Node)object2).getParentElement()) != null) {
            Node node3 = ((Node)object2).getPreviousSibling();
            if (node3 != null) {
                return Traversal.traverseBackwardsFrom(node3, handler);
            }
            object2 = object;
        }
        return null;
    }

    public static final Object traverseBackwardsFromEx(Node node, Handler handler) {
        Object object = Traversal.traverseBackwards(node, handler);
        if (object != null) {
            return object;
        }
        return Traversal.traverseBeforeEx(node, handler);
    }

    public static final Object traverseBeforeEx(Node node, Handler handler) {
        Object object;
        Element element = node.getParentElement();
        if (element == null) {
            return null;
        }
        for (Node node2 = node.getPreviousSibling(); node2 != null; node2 = node2.getPreviousSibling()) {
            object = Traversal.traverseBackwards(node2, handler);
            if (object == null) continue;
            return object;
        }
        while ((object = handler.leaveElement(element)) == null) {
            Element element2 = element.getParentElement();
            if (element2 == null) {
                return null;
            }
            Node node3 = element.getPreviousSibling();
            if (node3 != null) {
                return Traversal.traverseBackwardsFromEx(node3, handler);
            }
            element = element2;
        }
        return object;
    }

    public static class ElementFinder
    extends HandlerBase {
        public Name searchedName;

        @Override
        public Object enterElement(Element element) {
            if (element.getName() == this.searchedName) {
                return element;
            }
            return null;
        }
    }

    public static class TextNodeGrabber
    extends TextGrabber {
        @Override
        public Object processPI(ProcessingInstruction processingInstruction) {
            this.grabbed.append(processingInstruction.getText());
            return null;
        }

        @Override
        public Object processComment(Comment comment) {
            this.grabbed.append(comment.getText());
            return null;
        }
    }

    public static class TextGrabber
    extends HandlerBase {
        public StringBuilder grabbed = new StringBuilder();

        @Override
        public Object processText(Text text) {
            this.grabbed.append(text.getText());
            return null;
        }
    }

    public static class NodeMatcher
    extends TextNodeMatcher {
        @Override
        public Object enterElement(Element element) {
            if (element == this.searchedNode) {
                return element;
            }
            return null;
        }
    }

    public static class TextNodeMatcher
    extends TextMatcher {
        @Override
        public Object processPI(ProcessingInstruction processingInstruction) {
            if (processingInstruction == this.searchedNode) {
                return processingInstruction;
            }
            return null;
        }

        @Override
        public Object processComment(Comment comment) {
            if (comment == this.searchedNode) {
                return comment;
            }
            return null;
        }
    }

    public static class TextMatcher
    extends HandlerBase {
        public Node searchedNode;

        @Override
        public Object processText(Text text) {
            if (text == this.searchedNode) {
                return text;
            }
            return null;
        }
    }

    public static class NodeFinder
    extends TextNodeFinder {
        @Override
        public Object enterElement(Element element) {
            return element;
        }
    }

    public static class TextNodeFinder
    extends TextFinder {
        @Override
        public Object processPI(ProcessingInstruction processingInstruction) {
            return processingInstruction;
        }

        @Override
        public Object processComment(Comment comment) {
            return comment;
        }
    }

    public static class TextFinder
    extends HandlerBase {
        @Override
        public Object processText(Text text) {
            return text;
        }
    }

    public static class HandlerBase
    implements Handler {
        @Override
        public Object processText(Text text) {
            return null;
        }

        @Override
        public Object processPI(ProcessingInstruction processingInstruction) {
            return null;
        }

        @Override
        public Object processComment(Comment comment) {
            return null;
        }

        @Override
        public Object enterElement(Element element) {
            return null;
        }

        @Override
        public Object leaveElement(Element element) {
            return null;
        }
    }

    public static interface Handler {
        public Object processText(Text var1);

        public Object processPI(ProcessingInstruction var1);

        public Object processComment(Comment var1);

        public Object enterElement(Element var1);

        public Object leaveElement(Element var1);
    }
}

