/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.doc;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.IdentityLinearHashtable;
import com.xmlmind.util.KeyValuePair;
import com.xmlmind.util.URLUtil;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Inclusion;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.NamespacePrefixMap;
import com.xmlmind.xml.name.NamespaceToPrefixes;
import com.xmlmind.xml.resolve.XMLCatalogs;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class Node
implements XNode,
Serializable {
    public static final Name[] ALL_PROPERTIES = new Name[0];
    protected Tree parent;
    protected Node previous;
    protected Node next;
    protected transient byte readOnly = (byte)-1;
    protected transient IdentityLinearHashtable<Name, Object> properties;
    protected transient Object[] listenerData;
    protected static final byte UNSET = -1;
    protected static final byte FALSE = 0;
    protected static final byte TRUE = 1;
    public static final Node[] EMPTY_LIST = new Node[0];
    protected static final PropertyIterator NO_PROPERTY_ITERATOR = new PropertyIterator();

    protected Node() {
    }

    public abstract Node copy();

    public final void copyProperties(Node node) {
        node.readOnly = this.readOnly;
        if (this.properties == null) {
            node.properties = null;
        } else {
            IdentityLinearHashtable<Name, Object> identityLinearHashtable = null;
            Object[] objectArray = this.properties.getKeyValueTable();
            int n = objectArray.length;
            for (int i = 0; i < n; i += 2) {
                Name name = (Name)objectArray[i];
                if (name == null || name.localPart.startsWith("__")) continue;
                if (identityLinearHashtable == null) {
                    identityLinearHashtable = new IdentityLinearHashtable<Name, Object>(1);
                }
                identityLinearHashtable.put(name, objectArray[i + 1]);
            }
            node.properties = identityLinearHashtable;
        }
    }

    public abstract Type getType();

    public Document getDocument() {
        return this.parent == null ? null : this.parent.getDocument();
    }

    public final Tree getParent() {
        return this.parent;
    }

    public final Node getPreviousSibling() {
        return this.previous;
    }

    public final Node getNextSibling() {
        return this.next;
    }

    public final void setDocumentListenerData(int n, Object object) {
        this.listenerData[n] = object;
    }

    public final Object getDocumentListenerData(int n) {
        return this.listenerData[n];
    }

    public final int indexOfDocumentListenerData(Object object) {
        int n = this.listenerData.length;
        for (int i = 0; i < n; ++i) {
            if (this.listenerData[i] != object) continue;
            return i;
        }
        return -1;
    }

    public final Object putProperty(Name name, Object object) {
        Object object2;
        if (name == Constants.READ_ONLY_PROPERTY) {
            switch (this.readOnly) {
                case 0: {
                    object2 = Boolean.FALSE;
                    break;
                }
                case 1: {
                    object2 = Boolean.TRUE;
                    break;
                }
                default: {
                    object2 = null;
                }
            }
            this.readOnly = ((Boolean)object).booleanValue() ? (byte)1 : 0;
        } else {
            if (this.properties == null) {
                this.properties = new IdentityLinearHashtable(1);
            }
            object2 = this.properties.put(name, object);
        }
        Document document = this.getDocument();
        if (document != null) {
            document.firePropertyChanged(this, name, object2, object);
        }
        return object2;
    }

    public final Object removeProperty(Name name) {
        Document document;
        Object object = null;
        if (name == Constants.READ_ONLY_PROPERTY) {
            switch (this.readOnly) {
                case 0: {
                    object = Boolean.FALSE;
                    this.readOnly = (byte)-1;
                    break;
                }
                case 1: {
                    object = Boolean.TRUE;
                    this.readOnly = (byte)-1;
                }
            }
        } else if (this.properties != null && (object = this.properties.remove(name)) != null && this.properties.size() == 0) {
            this.properties = null;
        }
        if (object != null && (document = this.getDocument()) != null) {
            document.firePropertyChanged(this, name, object, null);
        }
        return object;
    }

    public void removeProperties(Name[] nameArray, boolean bl) {
        if (nameArray == ALL_PROPERTIES) {
            nameArray = this.getPropertyNames();
        }
        for (Name name : nameArray) {
            this.removeProperty(name);
        }
    }

    public final boolean hasProperty(Name name) {
        if (name == Constants.READ_ONLY_PROPERTY) {
            return this.readOnly != -1;
        }
        return this.properties == null ? false : this.properties.containsKey(name);
    }

    public final Object getProperty(Name name) {
        if (name == Constants.READ_ONLY_PROPERTY) {
            switch (this.readOnly) {
                case 0: {
                    return Boolean.FALSE;
                }
                case 1: {
                    return Boolean.TRUE;
                }
            }
            return null;
        }
        return this.properties == null ? null : this.properties.get(name);
    }

    public final int getPropertyCount() {
        int n = 0;
        if (this.readOnly != -1) {
            ++n;
        }
        if (this.properties != null) {
            n += this.properties.size();
        }
        return n;
    }

    public final Name[] getPropertyNames() {
        int n = 0;
        if (this.properties != null) {
            n += this.properties.size();
        }
        if (this.readOnly != -1) {
            ++n;
        }
        if (n == 0) {
            return Name.EMPTY_LIST;
        }
        Name[] nameArray = new Name[n];
        if (this.properties != null) {
            this.properties.copyKeysInto((Name[])nameArray);
        }
        if (this.readOnly != -1) {
            nameArray[n - 1] = Constants.READ_ONLY_PROPERTY;
        }
        return nameArray;
    }

    public final Iterator<KeyValuePair<Name, Object>> getProperties() {
        if (this.readOnly == -1 && this.properties == null) {
            return NO_PROPERTY_ITERATOR;
        }
        PropertyIterator propertyIterator = new PropertyIterator();
        if (this.readOnly != -1) {
            propertyIterator.add(Constants.READ_ONLY_PROPERTY, this.readOnly == 1 ? Boolean.TRUE : Boolean.FALSE);
        }
        if (this.properties != null) {
            propertyIterator.add(this.properties.entries());
        }
        return propertyIterator;
    }

    public final Object lookupProperty(Name name) {
        if (name == Constants.READ_ONLY_PROPERTY) {
            Node node = this;
            while (node != null) {
                switch (node.readOnly) {
                    case 0: {
                        return Boolean.FALSE;
                    }
                    case 1: {
                        return Boolean.TRUE;
                    }
                }
                node = node.parent;
            }
        } else {
            Node node = this;
            while (node != null) {
                Object object;
                if (node.properties != null && (object = node.properties.get(name)) != null) {
                    return object;
                }
                node = node.parent;
            }
        }
        return null;
    }

    public final boolean isEditable() {
        Node node = this;
        while (node != null) {
            switch (node.readOnly) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            node = node.parent;
        }
        return true;
    }

    public final boolean isReadOnly() {
        return this.readOnly == 1;
    }

    public final Inclusion getInclusion() {
        return this.properties == null ? null : (Inclusion)this.properties.get(Constants.INCLUSION_PROPERTY);
    }

    public final Inclusion lookupInclusion() {
        return this.lookupInclusion(null);
    }

    public final Inclusion lookupInclusion(Node[] nodeArray) {
        Node node = this;
        while (node != null) {
            Inclusion inclusion;
            if (node.properties != null && (inclusion = (Inclusion)node.properties.get(Constants.INCLUSION_PROPERTY)) != null) {
                if (nodeArray != null) {
                    nodeArray[0] = node;
                }
                return inclusion;
            }
            node = node.parent;
        }
        return null;
    }

    public static final boolean sameInclusion(Node node, Node node2) {
        if (node == null || node2 == null) {
            return false;
        }
        Inclusion inclusion = (Inclusion)node.getProperty(Constants.INCLUSION_PROPERTY);
        if (inclusion == null) {
            return false;
        }
        Inclusion inclusion2 = (Inclusion)node2.getProperty(Constants.INCLUSION_PROPERTY);
        if (inclusion2 == null) {
            return false;
        }
        return inclusion == inclusion2;
    }

    public static final boolean canReplace(Node node, Node node2) {
        Node node3;
        Tree tree = node.getParent();
        if (tree == null || node2.getParent() != tree) {
            return false;
        }
        boolean bl = true;
        for (node3 = node; node3 != null; node3 = node3.getNextSibling()) {
            if (node3 != node2) continue;
            bl = false;
            break;
        }
        if (bl) {
            node3 = node;
            node = node2;
            node2 = node3;
        }
        Node node4 = node.getPreviousSibling();
        Node node5 = node2.getNextSibling();
        return !Node.sameInclusion(node, node4) && !Node.sameInclusion(node2, node5);
    }

    public static final boolean canInsertBefore(Node node) {
        if (node == null) {
            return true;
        }
        Node node2 = node.getPreviousSibling();
        return !Node.sameInclusion(node, node2);
    }

    @Override
    public final URL getSourceURL() {
        return (URL)this.lookupProperty(Constants.SOURCE_URL_PROPERTY);
    }

    @Override
    public final URL getBaseURL() {
        return this.doGetBaseURL(null);
    }

    public final URL doGetBaseURL(URL uRL) {
        URL uRL2 = null;
        Node node = this;
        while (node != null) {
            Tree tree = node.parent;
            switch (node.getType()) {
                case ELEMENT: {
                    URL uRL3;
                    String string = ((Element)node).getAttribute(Name.XML_BASE);
                    if (string == null) break;
                    String string2 = XMLCatalogs.resolveURI(string);
                    if (string2 != null) {
                        try {
                            uRL2 = URLUtil.createURL(string2);
                        }
                        catch (MalformedURLException malformedURLException) {}
                        break;
                    }
                    URL uRL4 = (URL)node.getProperty(Constants.SOURCE_URL_PROPERTY);
                    try {
                        uRL2 = URLUtil.createURL(uRL4, string);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (uRL2 != null || tree == null || (uRL3 = tree.doGetBaseURL(uRL)) == null) break;
                    try {
                        uRL2 = URLUtil.createURL(uRL3, string);
                    }
                    catch (MalformedURLException malformedURLException) {}
                    break;
                }
                case DOCUMENT: {
                    uRL2 = uRL == null ? Node.getDocumentBaseURL((Document)node) : uRL;
                }
            }
            if (uRL2 == null) {
                uRL2 = (URL)node.getProperty(Constants.SOURCE_URL_PROPERTY);
            }
            if (uRL2 != null) break;
            node = tree;
        }
        return uRL2;
    }

    private static final URL getDocumentBaseURL(Document document) {
        Element element;
        URL uRL = null;
        URL uRL2 = (URL)document.getProperty(Constants.SOURCE_URL_PROPERTY);
        Element element2 = document.getRootElement();
        if (element2 != null && element2.getName() == Name.HTML && (element = element2.getChildElement(0)) != null && element.getName() == Name.get(Namespace.XHTML, "head")) {
            String string;
            Element element3 = null;
            Name name = Name.get(Namespace.XHTML, "base");
            for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getType() != Type.ELEMENT || ((Element)node).getName() != name) continue;
                element3 = (Element)node;
                break;
            }
            if (element3 != null && (string = element3.getAttribute(Name.get("href"))) != null && (string = string.trim()).length() > 0) {
                try {
                    uRL = URLUtil.createURL(uRL2, string);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (uRL == null) {
            uRL = uRL2;
        }
        return uRL;
    }

    public final Element getParentElement() {
        return this.parent != null && this.parent.getType() == Type.ELEMENT ? (Element)this.parent : null;
    }

    public final Element getPreviousElement() {
        Node node = this.previous;
        while (node != null) {
            if (node.getType() == Type.ELEMENT) {
                return (Element)node;
            }
            node = node.previous;
        }
        return null;
    }

    public final Element getNextElement() {
        Node node = this.next;
        while (node != null) {
            if (node.getType() == Type.ELEMENT) {
                return (Element)node;
            }
            node = node.next;
        }
        return null;
    }

    public final boolean isAncestorOf(Node node) {
        while (node != null) {
            if (node == this) {
                return true;
            }
            node = node.parent;
        }
        return false;
    }

    public final boolean isDescendantOf(Node node) {
        Node node2 = this;
        while (node2 != null) {
            if (node2 == node) {
                return true;
            }
            node2 = node2.parent;
        }
        return false;
    }

    public final Node findCommonAncestor(Node node) {
        if (this.isAncestorOf(node)) {
            return this;
        }
        Node node2 = node;
        while (node2 != null) {
            if (node2.isAncestorOf(this)) {
                return node2;
            }
            node2 = node2.parent;
        }
        return null;
    }

    public final Node getFirstSibling() {
        Node node = this.previous;
        if (node != null) {
            while (node.previous != null) {
                node = node.previous;
            }
        }
        return node;
    }

    public final Node getLastSibling() {
        Node node = this.next;
        if (node != null) {
            while (node.next != null) {
                node = node.next;
            }
        }
        return node;
    }

    public final boolean isSiblingOf(Node node) {
        return this.parent != null && this.parent == node.parent;
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public String getLabel() {
        Tree tree;
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        Type type = this.getType();
        switch (type) {
            case DOCUMENT: {
                return "/";
            }
            case ELEMENT: {
                bl = false;
                tree = (Tree)this;
                break;
            }
            default: {
                stringBuilder.append('#');
                stringBuilder.append(type.toString());
                bl = true;
                tree = this.parent;
            }
        }
        while (tree != null) {
            if (bl) {
                stringBuilder.insert(0, '/');
            } else {
                bl = true;
            }
            if (tree.getType() == Type.ELEMENT) {
                Element element = (Element)tree;
                stringBuilder.insert(0, element.getName().format(false, element));
            }
            tree = tree.parent;
        }
        return stringBuilder.toString();
    }

    public String getShortLabel() {
        Type type = this.getType();
        switch (type) {
            case DOCUMENT: {
                return "/";
            }
            case ELEMENT: {
                Element element = (Element)this;
                return element.getName().format(false, element);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('#');
        stringBuilder.append(type.toString());
        if (this.parent != null) {
            if (this.parent.getType() == Type.ELEMENT) {
                Element element = (Element)this.parent;
                stringBuilder.insert(0, element.getName().format(false, element));
            } else {
                stringBuilder.insert(0, '/');
            }
        }
        return stringBuilder.toString();
    }

    public String getXPath() {
        int n;
        Object object;
        Tree tree;
        boolean bl;
        StringBuilder stringBuilder = new StringBuilder();
        Type type = this.getType();
        switch (type) {
            case DOCUMENT: {
                return "/";
            }
            case ELEMENT: {
                bl = false;
                tree = (Tree)this;
                break;
            }
            default: {
                stringBuilder.append(type.toString());
                if (type == Type.PROCESSING_INSTRUCTION) {
                    object = ((ProcessingInstruction)this).getTarget();
                    char c = ((String)object).indexOf(34) < 0 ? (char)'\"' : '\'';
                    stringBuilder.append('(');
                    stringBuilder.append(c);
                    stringBuilder.append((String)object);
                    stringBuilder.append(c);
                    stringBuilder.append(')');
                } else {
                    stringBuilder.append("()");
                }
                n = this.getPosition();
                if (n > 0) {
                    stringBuilder.append('[');
                    stringBuilder.append(n);
                    stringBuilder.append(']');
                }
                bl = true;
                tree = this.parent;
            }
        }
        while (tree != null) {
            if (bl) {
                stringBuilder.insert(0, '/');
            } else {
                bl = true;
            }
            if (tree.getType() == Type.ELEMENT) {
                n = tree.getPosition();
                if (n > 0) {
                    stringBuilder.insert(0, ']');
                    stringBuilder.insert(0, n);
                    stringBuilder.insert(0, '[');
                }
                object = (Element)tree;
                stringBuilder.insert(0, ((Element)object).getName().format(true, (NamespaceToPrefixes)object));
            }
            tree = tree.parent;
        }
        return stringBuilder.toString();
    }

    public int getPosition() {
        if (this.parent == null) {
            return 0;
        }
        int n = 1;
        Type type = this.getType();
        Name name = type == Type.ELEMENT ? ((Element)this).getName() : null;
        String string = type == Type.PROCESSING_INSTRUCTION ? ((ProcessingInstruction)this).getTarget() : null;
        Node node = this.previous;
        while (node != null) {
            if (!(node.getType() != type || name != null && ((Element)node).getName() != name || string != null && !((ProcessingInstruction)node).getTarget().equals(string))) {
                ++n;
            }
            node = node.previous;
        }
        return n;
    }

    @Override
    public XNode.Type type() {
        switch (this.getType()) {
            case TEXT: {
                return XNode.Type.TEXT;
            }
            case COMMENT: {
                return XNode.Type.COMMENT;
            }
            case PROCESSING_INSTRUCTION: {
                return XNode.Type.PROCESSING_INSTRUCTION;
            }
            case DOCUMENT_TYPE_DECLARATION: {
                return XNode.Type.DOCUMENT_TYPE_DECLARATION;
            }
            case ELEMENT: {
                return XNode.Type.ELEMENT;
            }
        }
        return XNode.Type.DOCUMENT;
    }

    @Override
    public XNode document() {
        return this.getDocument();
    }

    @Override
    public XNode parent() {
        return this.parent;
    }

    @Override
    public XNode following() {
        return this.next;
    }

    @Override
    public XNode preceding() {
        return this.previous;
    }

    @Override
    public Name name() {
        return null;
    }

    @Override
    public String data() {
        return null;
    }

    @Override
    public NamespacePrefixMap namespacePrefixMap() {
        return this.parent == null ? null : this.parent.namespacePrefixMap();
    }

    @Override
    public XNode firstChild() {
        return null;
    }

    @Override
    public XNode lastChild() {
        return null;
    }

    @Override
    public String attributeValue(Name name) {
        return null;
    }

    @Override
    public Iterator<XNode> attributes() {
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof Node)) {
            return false;
        }
        return this == object;
    }

    @Override
    public int compareTo(XNode xNode) {
        return Node.compare(this, xNode);
    }

    static final int compare(XNode xNode, XNode xNode2) {
        XNode xNode3;
        XNode xNode4;
        switch (xNode.type()) {
            case DOCUMENT: {
                if (xNode2.type() == XNode.Type.DOCUMENT) {
                    return xNode == xNode2 ? 0 : Node.compareDocuments((Document)xNode, (Document)xNode2);
                }
                Document document = (Document)xNode2.document();
                return xNode == document ? -1 : Node.compareDocuments((Document)xNode, document);
            }
            case ATTRIBUTE: {
                switch (xNode2.type()) {
                    case DOCUMENT: {
                        Document document = (Document)xNode.document();
                        return document == xNode2 ? 1 : Node.compareDocuments(document, (Document)xNode2);
                    }
                    case ATTRIBUTE: {
                        XNode xNode5 = xNode.parent();
                        XNode xNode6 = xNode2.parent();
                        if (xNode5 == xNode6) {
                            return xNode.name().compareTo(xNode2.name());
                        }
                        return Node.compare(xNode5, xNode6);
                    }
                }
                XNode xNode7 = xNode.parent();
                if (xNode7 == xNode2) {
                    return 1;
                }
                return Node.compare(xNode7, xNode2);
            }
        }
        switch (xNode2.type()) {
            case DOCUMENT: {
                Document document = (Document)xNode.document();
                return document == xNode2 ? 1 : Node.compareDocuments(document, (Document)xNode2);
            }
            case ATTRIBUTE: {
                XNode xNode8 = xNode2.parent();
                if (xNode == xNode8) {
                    return -1;
                }
                return Node.compare(xNode, xNode8);
            }
        }
        if (xNode == xNode2) {
            return 0;
        }
        for (xNode4 = xNode2.parent(); xNode4 != null; xNode4 = xNode4.parent()) {
            if (xNode4 != xNode) continue;
            return -1;
        }
        XNode xNode9 = null;
        for (xNode4 = xNode2; xNode4 != null; xNode4 = xNode4.parent()) {
            boolean bl = false;
            xNode3 = xNode;
            for (XNode xNode10 = xNode.parent(); xNode10 != null; xNode10 = xNode10.parent()) {
                if (xNode10 == xNode4) {
                    bl = true;
                    break;
                }
                xNode3 = xNode10;
            }
            if (bl) {
                if (xNode9 == null) {
                    return 1;
                }
                for (XNode xNode11 = xNode9.following(); xNode11 != null; xNode11 = xNode11.following()) {
                    if (xNode11 != xNode3) continue;
                    return 1;
                }
                return -1;
            }
            xNode9 = xNode4;
        }
        Document document = (Document)xNode.document();
        xNode3 = (Document)xNode2.document();
        if (document == null && xNode3 == null) {
            return System.identityHashCode(xNode) - System.identityHashCode(xNode2);
        }
        return Node.compareDocuments(document, (Document)xNode3);
    }

    private static final int compareDocuments(Document document, Document document2) {
        URL uRL;
        if (document == document2) {
            return 0;
        }
        URL uRL2 = document == null ? null : document.getSourceURL();
        URL uRL3 = uRL = document2 == null ? null : document2.getSourceURL();
        if (uRL2 == null && uRL == null) {
            return System.identityHashCode(document) - System.identityHashCode(document2);
        }
        String string = uRL2 == null ? "" : uRL2.toExternalForm();
        String string2 = uRL == null ? "" : uRL.toExternalForm();
        return string.compareTo(string2);
    }

    @Override
    public XNode deepCopy() {
        return this.copy();
    }

    final boolean isDetached() {
        return this.parent == null && this.next == null && this.previous == null;
    }

    final void setAttached(Tree tree, Node node, Node node2) {
        this.parent = tree;
        this.previous = node;
        this.next = node2;
        Document document = tree.getDocument();
        if (document != null) {
            this.setDocument(document, document.isNotifyDisabled(), document.getDocumentListenerCount(true));
        }
    }

    final void setDetached() {
        this.parent = null;
        this.previous = null;
        this.next = null;
        if (this.getDocument() != null) {
            this.setDocument(null, false, -1);
        }
    }

    void setDocument(Document document, boolean bl, int n) {
        if (!bl && document != null) {
            this.listenerData = n > 0 ? new Object[n] : null;
        }
    }

    final void listenerAdded(boolean bl) {
        if (this.listenerData == null) {
            this.listenerData = new Object[1];
        } else {
            int n = this.listenerData.length;
            Object[] objectArray = new Object[n + 1];
            if (bl) {
                System.arraycopy(this.listenerData, 0, objectArray, 1, n);
            } else {
                System.arraycopy(this.listenerData, 0, objectArray, 0, n);
            }
            this.listenerData = objectArray;
        }
    }

    final void listenerRemoved(int n) {
        int n2 = this.listenerData.length;
        if (n2 <= 1) {
            this.listenerData = null;
        } else {
            int n3;
            int n4;
            Object[] objectArray = new Object[n2 - 1];
            if (n > 0) {
                System.arraycopy(this.listenerData, 0, objectArray, 0, n);
            }
            if ((n4 = n2 - (n3 = n + 1)) > 0) {
                System.arraycopy(this.listenerData, n3, objectArray, n, n4);
            }
            this.listenerData = objectArray;
        }
    }

    protected static final class PropertyIterator
    implements Iterator<KeyValuePair<Name, Object>> {
        private Object[] delegates = new Object[0];
        private int current = 0;

        protected PropertyIterator() {
        }

        public void add(Name name, Object object) {
            this.delegates = ArrayUtil.append(this.delegates, new KeyValuePair<Name, Object>(name, object));
        }

        public void add(Iterator<KeyValuePair<Name, Object>> iterator) {
            this.delegates = ArrayUtil.append(this.delegates, iterator);
        }

        @Override
        public boolean hasNext() {
            if (this.current >= this.delegates.length) {
                return false;
            }
            Object object = this.delegates[this.current];
            if (object instanceof Iterator) {
                return ((Iterator)object).hasNext();
            }
            return true;
        }

        @Override
        public KeyValuePair<Name, Object> next() {
            KeyValuePair keyValuePair;
            if (this.current >= this.delegates.length) {
                throw new NoSuchElementException();
            }
            Object object = this.delegates[this.current];
            if (object instanceof Iterator) {
                Iterator iterator = (Iterator)object;
                keyValuePair = (KeyValuePair)iterator.next();
                if (!iterator.hasNext()) {
                    ++this.current;
                }
            } else {
                keyValuePair = (KeyValuePair)object;
                ++this.current;
            }
            return keyValuePair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static enum Type {
        TEXT,
        COMMENT,
        PROCESSING_INSTRUCTION,
        DOCUMENT_TYPE_DECLARATION,
        ELEMENT,
        DOCUMENT;


        public String toString() {
            switch (this) {
                case TEXT: {
                    return "text";
                }
                case COMMENT: {
                    return "comment";
                }
                case PROCESSING_INSTRUCTION: {
                    return "processing-instruction";
                }
                case DOCUMENT_TYPE_DECLARATION: {
                    return "document-type-declaration";
                }
                case ELEMENT: {
                    return "element";
                }
                case DOCUMENT: {
                    return "document";
                }
            }
            return "???";
        }
    }
}

