/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.doc;

import com.xmlmind.xml.doc.Document;
import com.xmlmind.xml.doc.DocumentEvent;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Inclusion;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.Tree;

public final class InclusionUpdatedEvent
extends DocumentEvent {
    private Inclusion inclusion;
    private Node[] oldChildren;
    private Node[] newChildren;

    public InclusionUpdatedEvent() {
    }

    public InclusionUpdatedEvent(Object object, Inclusion inclusion, Node[] nodeArray, Node[] nodeArray2) {
        this.initialize(object, inclusion, nodeArray, nodeArray2);
    }

    public void initialize(Object object, Inclusion inclusion, Node[] nodeArray, Node[] nodeArray2) {
        super.initialize(object, DocumentEvent.Type.INCLUSION_UPDATED);
        this.inclusion = inclusion;
        if (nodeArray == null) {
            nodeArray = Node.EMPTY_LIST;
        }
        this.oldChildren = nodeArray;
        if (nodeArray2 == null) {
            nodeArray2 = Node.EMPTY_LIST;
        }
        this.newChildren = nodeArray2;
    }

    public Tree getTreeSource() {
        return (Tree)this.source;
    }

    public Element getElementSource() {
        return this.source instanceof Element ? (Element)this.source : null;
    }

    public Document getDocumentSource() {
        return this.source instanceof Document ? (Document)this.source : null;
    }

    public Inclusion getInclusion() {
        return this.inclusion;
    }

    public Node[] getOldChildren() {
        return this.oldChildren;
    }

    public Node[] getNewChildren() {
        return this.newChildren;
    }

    public Node getBeforeChild() {
        int n = this.newChildren.length - 1;
        return n >= 0 ? this.newChildren[n].getNextSibling() : null;
    }

    @Override
    public String toString() {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[source=");
        stringBuilder.append(this.source);
        if (this.oldChildren != null && this.oldChildren.length > 0) {
            stringBuilder.append(",oldChildren=");
            for (n = 0; n < this.oldChildren.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.oldChildren[n]);
            }
        }
        if (this.newChildren != null && this.newChildren.length > 0) {
            stringBuilder.append(",newChildren=");
            for (n = 0; n < this.newChildren.length; ++n) {
                if (n > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(this.newChildren[n]);
            }
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

