/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.doc;

import com.xmlmind.util.IdentityLinearHashtable;
import com.xmlmind.xml.doc.AttributeEvent;
import com.xmlmind.xml.doc.Constants;
import com.xmlmind.xml.doc.DocumentEvent;
import com.xmlmind.xml.doc.DocumentListener;
import com.xmlmind.xml.doc.DocumentTypeDeclaration;
import com.xmlmind.xml.doc.EditEvent;
import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.ElementNameEvent;
import com.xmlmind.xml.doc.Inclusion;
import com.xmlmind.xml.doc.InclusionUpdatedEvent;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.PITargetEvent;
import com.xmlmind.xml.doc.ProcessingInstruction;
import com.xmlmind.xml.doc.ProcessingInstructionEvent;
import com.xmlmind.xml.doc.PropertyEvent;
import com.xmlmind.xml.doc.TextEvent;
import com.xmlmind.xml.doc.Traversal;
import com.xmlmind.xml.doc.Tree;
import com.xmlmind.xml.doc.TreeEvent;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.Namespace;
import com.xmlmind.xml.name.NamespacePrefixMap;
import com.xmlmind.xml.name.PrefixEntry;
import com.xmlmind.xml.name.PrefixPreferences;
import java.util.Iterator;

public final class Document
extends Tree
implements NamespacePrefixMap {
    private boolean topChildrenUnset;
    private DocumentTypeDeclaration documentTypeDeclaration;
    private Element rootElement;
    private transient int editSequenceNesting;
    private transient Object editSequenceArgument;
    private transient DocumentListener[] listenersNoData = new DocumentListener[0];
    private transient DocumentListener[] listeners = new DocumentListener[0];
    private transient boolean notifyDisabled;
    private transient PropertyEvent propertyEvent = new PropertyEvent();
    private transient TextEvent textEvent = new TextEvent();
    private transient ElementNameEvent elementNameEvent = new ElementNameEvent();
    private transient ProcessingInstructionEvent processingInstructionEvent = new ProcessingInstructionEvent();
    private transient PITargetEvent piTargetEvent = new PITargetEvent();
    private transient InclusionUpdatedEvent inclusionUpdatedEvent = new InclusionUpdatedEvent();
    private transient TreeEvent treeEvent = new TreeEvent();
    private transient AttributeEvent attributeEvent = new AttributeEvent();
    private transient EditEvent editEvent = new EditEvent();

    @Override
    public Node copy() {
        Document document = new Document();
        this.copyProperties(document);
        Node node = this.first;
        while (node != null) {
            document.appendChild(node.copy());
            node = node.next;
        }
        return document;
    }

    @Override
    public Node.Type getType() {
        return Node.Type.DOCUMENT;
    }

    @Override
    public Document getDocument() {
        return this;
    }

    public DocumentTypeDeclaration getDocumentTypeDeclaration() {
        if (this.topChildrenUnset) {
            this.setTopChildren();
        }
        return this.documentTypeDeclaration;
    }

    public Element getRootElement() {
        if (this.topChildrenUnset) {
            this.setTopChildren();
        }
        return this.rootElement;
    }

    private void setTopChildren() {
        this.topChildrenUnset = false;
        this.documentTypeDeclaration = null;
        this.rootElement = null;
        Node node = this.first;
        while (node != null) {
            switch (node.getType()) {
                case DOCUMENT_TYPE_DECLARATION: {
                    if (this.documentTypeDeclaration == null) {
                        this.documentTypeDeclaration = (DocumentTypeDeclaration)node;
                        break;
                    }
                    throw new RuntimeException("document contains several document type declarations");
                }
                case ELEMENT: {
                    if (this.rootElement == null) {
                        this.rootElement = (Element)node;
                        break;
                    }
                    throw new RuntimeException("document contains several root elements");
                }
            }
            node = node.next;
        }
    }

    @Override
    public void insertChild(Node node, Node node2) {
        super.insertChild(node, node2);
        if (!this.topChildrenUnset) {
            this.unsetTopChildren();
        }
    }

    @Override
    public void replaceChild(Node node, Node node2) {
        super.replaceChild(node, node2);
        if (!this.topChildrenUnset) {
            this.unsetTopChildren();
        }
    }

    @Override
    public void updateInclusion(Node node, Node node2, Node[] nodeArray) {
        super.updateInclusion(node, node2, nodeArray);
        if (!this.topChildrenUnset) {
            this.unsetTopChildren();
        }
    }

    private void unsetTopChildren() {
        this.topChildrenUnset = true;
        this.documentTypeDeclaration = null;
        this.rootElement = null;
    }

    public void addDocumentListener(DocumentListener documentListener, boolean bl) {
        this.addDocumentListener(documentListener, bl, false);
    }

    public void addDocumentListener(DocumentListener documentListener, boolean bl, boolean bl2) {
        if (this.indexOfDocumentListener(documentListener, true) >= 0 || this.indexOfDocumentListener(documentListener, false) >= 0) {
            return;
        }
        if (bl) {
            int n = this.listeners.length;
            DocumentListener[] documentListenerArray = new DocumentListener[n + 1];
            if (bl2) {
                documentListenerArray[0] = documentListener;
                if (n > 0) {
                    System.arraycopy(this.listeners, 0, documentListenerArray, 1, n);
                }
            } else {
                if (n > 0) {
                    System.arraycopy(this.listeners, 0, documentListenerArray, 0, n);
                }
                documentListenerArray[n] = documentListener;
            }
            this.listeners = documentListenerArray;
            Document.listenerAdded(this, bl2);
        } else {
            int n = this.listenersNoData.length;
            DocumentListener[] documentListenerArray = new DocumentListener[n + 1];
            if (bl2) {
                documentListenerArray[0] = documentListener;
                if (n > 0) {
                    System.arraycopy(this.listenersNoData, 0, documentListenerArray, 1, n);
                }
            } else {
                if (n > 0) {
                    System.arraycopy(this.listenersNoData, 0, documentListenerArray, 0, n);
                }
                documentListenerArray[n] = documentListener;
            }
            this.listenersNoData = documentListenerArray;
        }
    }

    private static final void listenerAdded(Tree tree, boolean bl) {
        tree.listenerAdded(bl);
        Node node = tree.first;
        while (node != null) {
            if (node.getType() == Node.Type.ELEMENT) {
                Document.listenerAdded((Element)node, bl);
            } else {
                node.listenerAdded(bl);
            }
            node = node.next;
        }
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        int n = this.indexOfDocumentListener(documentListener, true);
        if (n >= 0) {
            int n2;
            int n3;
            int n4 = this.listeners.length;
            DocumentListener[] documentListenerArray = new DocumentListener[n4 - 1];
            if (n > 0) {
                System.arraycopy(this.listeners, 0, documentListenerArray, 0, n);
            }
            if ((n3 = n4 - (n2 = n + 1)) > 0) {
                System.arraycopy(this.listeners, n2, documentListenerArray, n, n3);
            }
            this.listeners = documentListenerArray;
            Document.listenerRemoved(this, n);
        } else {
            int n5 = this.indexOfDocumentListener(documentListener, false);
            if (n5 >= 0) {
                int n6;
                int n7;
                int n8 = this.listenersNoData.length;
                DocumentListener[] documentListenerArray = new DocumentListener[n8 - 1];
                if (n5 > 0) {
                    System.arraycopy(this.listenersNoData, 0, documentListenerArray, 0, n5);
                }
                if ((n7 = n8 - (n6 = n5 + 1)) > 0) {
                    System.arraycopy(this.listenersNoData, n6, documentListenerArray, n5, n7);
                }
                this.listenersNoData = documentListenerArray;
            }
        }
    }

    private static final void listenerRemoved(Tree tree, int n) {
        tree.listenerRemoved(n);
        Node node = tree.first;
        while (node != null) {
            if (node.getType() == Node.Type.ELEMENT) {
                Document.listenerRemoved((Element)node, n);
            } else {
                node.listenerRemoved(n);
            }
            node = node.next;
        }
    }

    public int indexOfDocumentListener(DocumentListener documentListener, boolean bl) {
        if (bl) {
            int n = this.listeners.length;
            for (int i = 0; i < n; ++i) {
                if (this.listeners[i] != documentListener) continue;
                return i;
            }
            return -1;
        }
        int n = this.listenersNoData.length;
        for (int i = 0; i < n; ++i) {
            if (this.listenersNoData[i] != documentListener) continue;
            return i;
        }
        return -1;
    }

    public int getDocumentListenerCount(boolean bl) {
        return bl ? this.listeners.length : this.listenersNoData.length;
    }

    public DocumentListener getDocumentListener(int n, boolean bl) {
        return bl ? this.listeners[n] : this.listenersNoData[n];
    }

    public DocumentListener[] getDocumentListeners(boolean bl) {
        return bl ? this.listeners : this.listenersNoData;
    }

    public PrefixEntry[] getPrefixPreferences(boolean bl) {
        Namespace namespace;
        Object object = this.getProperty(Constants.NAMESPACE_PREFIX_MAP_PROPERTY);
        if (object == null || !(object instanceof PrefixPreferences)) {
            return null;
        }
        PrefixPreferences prefixPreferences = (PrefixPreferences)object;
        PrefixEntry[] prefixEntryArray = prefixPreferences.getAll();
        if (bl && (namespace = prefixPreferences.getDefaultNamespace()) != null) {
            PrefixEntry[] prefixEntryArray2 = new PrefixEntry[prefixEntryArray.length + 1];
            System.arraycopy(prefixEntryArray, 0, prefixEntryArray2, 0, prefixEntryArray.length);
            prefixEntryArray2[prefixEntryArray.length] = new PrefixEntry("", namespace);
            prefixEntryArray = prefixEntryArray2;
        }
        return prefixEntryArray;
    }

    public void addPrefixPreferences(Element element, boolean bl, boolean bl2) {
        Object object = this.getProperty(Constants.NAMESPACE_PREFIX_MAP_PROPERTY);
        if (object == null || !(object instanceof PrefixPreferences)) {
            return;
        }
        Document.collectPrefixPreferences(element, bl, bl2, (PrefixPreferences)object);
    }

    public static void collectPrefixPreferences(Element element, final boolean bl, final boolean bl2, final PrefixPreferences prefixPreferences) {
        final IdentityLinearHashtable identityLinearHashtable = new IdentityLinearHashtable();
        final Namespace[] namespaceArray = new Namespace[1];
        Traversal.traverse(element, new Traversal.HandlerBase(){

            @Override
            public Object enterElement(Element element) {
                PrefixEntry[] prefixEntryArray = (PrefixEntry[])element.getProperty(Constants.DECLARED_PREFIXES_PROPERTY);
                if (prefixEntryArray != null) {
                    for (PrefixEntry prefixEntry : prefixEntryArray) {
                        Namespace namespace = prefixEntry.namespace;
                        String string = prefixEntry.prefix;
                        if (prefixPreferences.add(namespace, string) == null) {
                            identityLinearHashtable.put(namespace, namespace);
                        }
                        if (!bl || namespaceArray[0] != null || string.length() != 0 || namespace == Namespace.NONE || namespace == Namespace.XML) continue;
                        namespaceArray[0] = namespace;
                    }
                    if (bl2) {
                        element.removeProperty(Constants.DECLARED_PREFIXES_PROPERTY);
                    }
                }
                return null;
            }
        });
        if (identityLinearHashtable.size() > 0) {
            Iterator iterator = identityLinearHashtable.elements();
            while (iterator.hasNext()) {
                Namespace namespace = (Namespace)iterator.next();
                prefixPreferences.add(namespace, null);
            }
        }
        if (bl && namespaceArray[0] != null) {
            prefixPreferences.setDefaultNamespace(namespaceArray[0]);
        }
    }

    public void beginEdit() {
        this.beginEdit(null);
    }

    public void beginEdit(Object object) {
        if (this.editSequenceNesting == 0) {
            this.editSequenceArgument = object;
            this.fireEditSequence(this, DocumentEvent.Type.EDIT_STARTED, this.editSequenceArgument);
        }
        ++this.editSequenceNesting;
    }

    public void endEdit() {
        if (this.editSequenceNesting > 0) {
            --this.editSequenceNesting;
            if (this.editSequenceNesting == 0) {
                this.fireEditSequence(this, DocumentEvent.Type.EDIT_COMPLETED, this.editSequenceArgument);
                this.editSequenceArgument = null;
            }
        }
    }

    public void setNotifyDisabled(boolean bl) {
        this.notifyDisabled = bl;
    }

    public boolean isNotifyDisabled() {
        return this.notifyDisabled;
    }

    public void notifyDocumentListeners(DocumentEvent documentEvent) {
        if (this.notifyDisabled) {
            return;
        }
        DocumentListener[] documentListenerArray = this.listeners;
        int n = documentListenerArray.length;
        DocumentListener[] documentListenerArray2 = this.listenersNoData;
        int n2 = documentListenerArray2.length;
        switch (documentEvent.getType()) {
            case TEXT_INSERTED: 
            case TEXT_REPLACED: 
            case TEXT_DELETED: {
                int n3;
                for (n3 = 0; n3 < n; ++n3) {
                    documentListenerArray[n3].textChanged((TextEvent)documentEvent, n3);
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    documentListenerArray2[n3].textChanged((TextEvent)documentEvent, -1);
                }
                break;
            }
            case CHILD_ADDED: 
            case CHILD_REPLACED: 
            case CHILD_REMOVED: {
                int n4;
                for (n4 = 0; n4 < n; ++n4) {
                    documentListenerArray[n4].treeChanged((TreeEvent)documentEvent, n4);
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    documentListenerArray2[n4].treeChanged((TreeEvent)documentEvent, -1);
                }
                break;
            }
            case INCLUSION_UPDATED: {
                int n5;
                for (n5 = 0; n5 < n; ++n5) {
                    documentListenerArray[n5].inclusionUpdated((InclusionUpdatedEvent)documentEvent, n5);
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    documentListenerArray2[n5].inclusionUpdated((InclusionUpdatedEvent)documentEvent, -1);
                }
                break;
            }
            case ATTRIBUTE_ADDED: 
            case ATTRIBUTE_CHANGED: 
            case ATTRIBUTE_REMOVED: {
                int n6;
                for (n6 = 0; n6 < n; ++n6) {
                    documentListenerArray[n6].attributeChanged((AttributeEvent)documentEvent, n6);
                }
                for (n6 = 0; n6 < n2; ++n6) {
                    documentListenerArray2[n6].attributeChanged((AttributeEvent)documentEvent, -1);
                }
                break;
            }
            case TARGET_CHANGED: {
                int n7;
                for (n7 = 0; n7 < n; ++n7) {
                    documentListenerArray[n7].processingInstructionChanged((ProcessingInstructionEvent)documentEvent, n7);
                }
                for (n7 = 0; n7 < n2; ++n7) {
                    documentListenerArray2[n7].processingInstructionChanged((ProcessingInstructionEvent)documentEvent, -1);
                }
                break;
            }
            case ELEMENT_NAME_CHANGED: {
                int n8;
                for (n8 = 0; n8 < n; ++n8) {
                    documentListenerArray[n8].elementNameChanged((ElementNameEvent)documentEvent, n8);
                }
                for (n8 = 0; n8 < n2; ++n8) {
                    documentListenerArray2[n8].elementNameChanged((ElementNameEvent)documentEvent, -1);
                }
                break;
            }
            case EDIT_STARTED: {
                int n9;
                for (n9 = 0; n9 < n; ++n9) {
                    documentListenerArray[n9].editStarted((EditEvent)documentEvent, n9);
                }
                for (n9 = 0; n9 < n2; ++n9) {
                    documentListenerArray2[n9].editStarted((EditEvent)documentEvent, -1);
                }
                break;
            }
            case EDIT_COMPLETED: {
                int n10;
                for (n10 = 0; n10 < n; ++n10) {
                    documentListenerArray[n10].editCompleted((EditEvent)documentEvent, n10);
                }
                for (n10 = 0; n10 < n2; ++n10) {
                    documentListenerArray2[n10].editCompleted((EditEvent)documentEvent, -1);
                }
                break;
            }
            default: {
                int n11;
                for (n11 = 0; n11 < n; ++n11) {
                    documentListenerArray[n11].eventHappened(documentEvent, n11);
                }
                for (n11 = 0; n11 < n2; ++n11) {
                    documentListenerArray2[n11].eventHappened(documentEvent, -1);
                }
            }
        }
    }

    void firePropertyChanged(Node node, Name name, Object object, Object object2) {
        PropertyEvent propertyEvent = this.propertyEvent;
        propertyEvent.initialize(node, name, object, object2);
        this.notifyDocumentListeners(propertyEvent);
    }

    void fireTextChanged(Object object, DocumentEvent.Type type, int n, String string, String string2) {
        TextEvent textEvent = this.textEvent;
        textEvent.initialize(object, type, n, string, string2);
        this.notifyDocumentListeners(textEvent);
    }

    void fireInclusionUpdated(Object object, Inclusion inclusion, Node[] nodeArray, Node[] nodeArray2) {
        InclusionUpdatedEvent inclusionUpdatedEvent = this.inclusionUpdatedEvent;
        inclusionUpdatedEvent.initialize(object, inclusion, nodeArray, nodeArray2);
        this.notifyDocumentListeners(inclusionUpdatedEvent);
    }

    void fireTreeChanged(Object object, DocumentEvent.Type type, Node node, Node node2, Node node3) {
        TreeEvent treeEvent = this.treeEvent;
        treeEvent.initialize(object, type, node, node2, node3);
        this.notifyDocumentListeners(treeEvent);
    }

    void fireAttributeChanged(Object object, DocumentEvent.Type type, Name name, String string, String string2) {
        AttributeEvent attributeEvent = this.attributeEvent;
        attributeEvent.initialize(object, type, name, string, string2);
        this.notifyDocumentListeners(attributeEvent);
    }

    void fireProcessingInstructionChanged(Object object, DocumentEvent.Type type, String string) {
        ProcessingInstructionEvent processingInstructionEvent = this.processingInstructionEvent;
        processingInstructionEvent.initialize(object, type, string);
        this.notifyDocumentListeners(processingInstructionEvent);
    }

    void fireNameChanged(Object object, DocumentEvent.Type type, Name name) {
        ElementNameEvent elementNameEvent = this.elementNameEvent;
        elementNameEvent.initialize(object, type, name);
        this.notifyDocumentListeners(elementNameEvent);
    }

    void firePITargetDetected(ProcessingInstruction processingInstruction) {
        PITargetEvent pITargetEvent = this.piTargetEvent;
        pITargetEvent.initialize(processingInstruction);
        this.notifyDocumentListeners(pITargetEvent);
    }

    private void fireEditSequence(Object object, DocumentEvent.Type type, Object object2) {
        EditEvent editEvent = this.editEvent;
        editEvent.initialize(object, type, object2);
        this.notifyDocumentListeners(editEvent);
    }

    @Override
    public NamespacePrefixMap namespacePrefixMap() {
        return this;
    }

    @Override
    public Namespace prefixToNamespace(String string) {
        NamespacePrefixMap namespacePrefixMap = (NamespacePrefixMap)this.getProperty(Constants.NAMESPACE_PREFIX_MAP_PROPERTY);
        if (namespacePrefixMap == null) {
            namespacePrefixMap = PrefixPreferences.INSTANCE;
        }
        return namespacePrefixMap.prefixToNamespace(string);
    }

    @Override
    public String[] namespaceToPrefixes(Namespace namespace) {
        NamespacePrefixMap namespacePrefixMap = (NamespacePrefixMap)this.getProperty(Constants.NAMESPACE_PREFIX_MAP_PROPERTY);
        if (namespacePrefixMap == null) {
            namespacePrefixMap = PrefixPreferences.INSTANCE;
        }
        return namespacePrefixMap.namespaceToPrefixes(namespace);
    }
}

