/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.xml.doc;

import com.xmlmind.xml.doc.Element;
import com.xmlmind.xml.doc.Node;
import com.xmlmind.xml.doc.XNode;
import com.xmlmind.xml.name.Name;
import com.xmlmind.xml.name.NamespacePrefixMap;
import java.net.URL;
import java.util.Comparator;
import java.util.Iterator;

public final class Attribute
implements Cloneable,
XNode {
    public static final CompareByName COMPARE_BY_NAME = new CompareByName();
    public Element element;
    public Name name;
    public String value;
    public static final Attribute[] EMPTY_LIST = new Attribute[0];

    public Attribute() {
    }

    public Attribute(Element element, Name name, String string) {
        this.element = element;
        this.name = name;
        this.value = string;
    }

    public Attribute copy() {
        Attribute attribute;
        try {
            attribute = (Attribute)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            attribute = null;
        }
        return attribute;
    }

    public int hashCode() {
        return System.identityHashCode(this.element) ^ System.identityHashCode(this.name);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || !(object instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)object;
        return this.element == attribute.element && this.name == attribute.name;
    }

    public String toString() {
        return this.getLabel();
    }

    @Override
    public String getLabel() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.element.getLabel());
        stringBuilder.append("/@");
        stringBuilder.append(this.name.format(true, this.element));
        return stringBuilder.toString();
    }

    public String getShortLabel() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.element.getShortLabel());
        stringBuilder.append("/@");
        stringBuilder.append(this.name.format(true, this.element));
        return stringBuilder.toString();
    }

    public String getXPath() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.element.getXPath());
        stringBuilder.append("/@");
        stringBuilder.append(this.name.format(true, this.element));
        return stringBuilder.toString();
    }

    @Override
    public XNode.Type type() {
        return XNode.Type.ATTRIBUTE;
    }

    @Override
    public XNode document() {
        return this.element.document();
    }

    @Override
    public XNode parent() {
        return this.element;
    }

    @Override
    public XNode following() {
        return null;
    }

    @Override
    public XNode preceding() {
        return null;
    }

    @Override
    public Name name() {
        return this.name;
    }

    @Override
    public String data() {
        return this.value;
    }

    @Override
    public NamespacePrefixMap namespacePrefixMap() {
        return this.element;
    }

    @Override
    public XNode firstChild() {
        return null;
    }

    @Override
    public XNode lastChild() {
        return null;
    }

    @Override
    public String attributeValue(Name name) {
        return null;
    }

    @Override
    public Iterator<XNode> attributes() {
        return null;
    }

    @Override
    public int compareTo(XNode xNode) {
        return Node.compare(this, xNode);
    }

    @Override
    public XNode deepCopy() {
        return this.copy();
    }

    @Override
    public URL getSourceURL() {
        return this.element.getSourceURL();
    }

    @Override
    public URL getBaseURL() {
        return this.element.getBaseURL();
    }

    public static final class CompareByName
    implements Comparator<Attribute> {
        @Override
        public int compare(Attribute attribute, Attribute attribute2) {
            return attribute.name.compareTo(attribute2.name);
        }
    }
}

