/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

public final class ThrowableUtil {
    private ThrowableUtil() {
    }

    public static String reason(Throwable throwable) {
        String string = throwable.getMessage();
        if (string == null) {
            string = throwable.getClass().getName();
        }
        return string;
    }

    public static String reasonLine(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ThrowableUtil.reason(throwable));
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            stringBuilder.append(" CAUSE: ");
            stringBuilder.append(ThrowableUtil.reason(throwable2));
            throwable = throwable2;
        }
        if ((stackTraceElementArray = throwable.getStackTrace()).length > 0) {
            stringBuilder.append(" (");
            stringBuilder.append(stackTraceElementArray[0]);
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    public static String detailedReason(Throwable throwable) {
        return ThrowableUtil.detailedReason(throwable, 1);
    }

    public static String detailedReason(Throwable throwable, int n) {
        Throwable throwable2;
        StringBuilder stringBuilder = new StringBuilder();
        ThrowableUtil.detailedReason(throwable, stringBuilder);
        for (int i = 0; i < n && (throwable2 = throwable.getCause()) != null; ++i) {
            stringBuilder.append("\nCAUSE:\n");
            ThrowableUtil.detailedReason(throwable2, stringBuilder);
            throwable = throwable2;
        }
        return stringBuilder.toString();
    }

    public static void detailedReason(Throwable throwable, StringBuilder stringBuilder) {
        stringBuilder.append(throwable.getClass().getName());
        if (throwable.getMessage() != null) {
            stringBuilder.append(": ");
            stringBuilder.append(throwable.getMessage());
        }
        stringBuilder.append("\n+---------------------------------------\n");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        int n = Math.min(20, stackTraceElementArray.length);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("| ");
            stringBuilder.append(stackTraceElementArray[i]);
            stringBuilder.append('\n');
        }
        stringBuilder.append("+---------------------------------------");
    }
}

