/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import com.xmlmind.util.Console;
import com.xmlmind.util.Platform;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.VersionNumber;
import java.awt.GraphicsEnvironment;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;

public final class SystemUtil {
    public static final Platform PLATFORM = SystemUtil.platform();
    public static final boolean IS_WINDOWS = PLATFORM == Platform.WINDOWS;
    public static final boolean IS_UNIX = PLATFORM != Platform.WINDOWS;
    public static final boolean IS_MAC_OS = PLATFORM == Platform.MAC_OS;
    public static final boolean IS_GENERIC_UNIX = PLATFORM == Platform.GENERIC_UNIX;
    private static File[] customUserPreferencesDir = new File[1];
    private static String[] defaultEncoding = new String[1];
    private static Object allEncodingsLock = new Object();
    private static String[] allEncodings;
    private static VersionNumber[] javaVersion;
    public static final VersionNumber JAVA_9_0_0;
    private static final VersionNumber JAVA_1_8_0_40;
    private static final Boolean[] foundJavaFX;
    private static VersionNumber[] osVersion;

    private SystemUtil() {
    }

    private static final Platform platform() {
        if (File.pathSeparatorChar == ';') {
            return Platform.WINDOWS;
        }
        String string = System.getProperty("os.name");
        if (string != null && string.toLowerCase().indexOf("mac") >= 0) {
            return Platform.MAC_OS;
        }
        return Platform.GENERIC_UNIX;
    }

    public static File homeDir() {
        return SystemUtil.userDir("user.home");
    }

    public static File currentWorkingDir() {
        return SystemUtil.userDir("user.dir");
    }

    private static File userDir(String string) {
        File file = null;
        String string2 = System.getProperty(string);
        if (string2 != null) {
            try {
                file = new File(string2).getCanonicalFile();
                if (!file.isDirectory()) {
                    file = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUserPreferencesDir(File file) {
        if (file != null && !file.isAbsolute()) {
            file = file.getAbsoluteFile();
        }
        File[] fileArray = customUserPreferencesDir;
        synchronized (customUserPreferencesDir) {
            SystemUtil.customUserPreferencesDir[0] = file;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File userPreferencesDir() {
        File[] fileArray = customUserPreferencesDir;
        synchronized (customUserPreferencesDir) {
            if (customUserPreferencesDir[0] != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return customUserPreferencesDir[0];
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return SystemUtil.defaultUserPreferencesDir();
        }
    }

    public static File defaultUserPreferencesDir() {
        return SystemUtil.userPreferencesDir("XMLmind", "WordToXML", "w2x");
    }

    public static File userPreferencesDir(String string, String string2, String string3) {
        Object object;
        StringBuilder stringBuilder = new StringBuilder();
        if (IS_WINDOWS && (object = System.getenv("APPDATA")) != null && new File((String)object).isDirectory()) {
            stringBuilder.append((String)object);
            stringBuilder.append('\\');
            stringBuilder.append(string);
            stringBuilder.append('\\');
            stringBuilder.append(string2);
        }
        if (stringBuilder.length() == 0) {
            object = SystemUtil.homeDir();
            if (object == null) {
                return null;
            }
            stringBuilder.append(((File)object).getPath());
            if (IS_WINDOWS) {
                String string4 = System.getProperty("os.name");
                if (string4 != null && string4.indexOf("Vista") >= 0) {
                    stringBuilder.append("\\AppData\\Roaming\\");
                } else {
                    stringBuilder.append("\\Application Data\\");
                }
                stringBuilder.append(string);
                stringBuilder.append('\\');
                stringBuilder.append(string2);
            } else if (IS_MAC_OS) {
                stringBuilder.append("/Library/Application Support/");
                stringBuilder.append(string);
                stringBuilder.append('/');
                stringBuilder.append(string2);
            } else {
                stringBuilder.append("/.");
                stringBuilder.append(string3);
            }
        }
        object = null;
        try {
            object = new File(stringBuilder.toString()).getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String defaultEncoding() {
        String[] stringArray = defaultEncoding;
        synchronized (defaultEncoding) {
            if (defaultEncoding[0] == null) {
                Charset charset = Charset.defaultCharset();
                SystemUtil.defaultEncoding[0] = charset.name();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultEncoding[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] listEncodings() {
        Object object = allEncodingsLock;
        synchronized (object) {
            if (allEncodings == null) {
                SortedMap<String, Charset> sortedMap = Charset.availableCharsets();
                allEncodings = new String[sortedMap.size()];
                sortedMap.keySet().toArray(allEncodings);
                Arrays.sort(allEncodings);
            }
            return allEncodings;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionNumber javaVersionNumber() {
        VersionNumber[] versionNumberArray = javaVersion;
        synchronized (javaVersion) {
            if (javaVersion[0] == null) {
                String string = System.getProperty("java.version");
                if (string != null) {
                    SystemUtil.javaVersion[0] = VersionNumber.fromString(string, true);
                }
                if (javaVersion[0] == null) {
                    SystemUtil.javaVersion[0] = new VersionNumber(1, 8, 0);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return javaVersion[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean hasJavaFX() {
        Boolean[] booleanArray = foundJavaFX;
        synchronized (foundJavaFX) {
            if (foundJavaFX[0] == null) {
                if (SystemUtil.javaVersionNumber().compareTo(JAVA_1_8_0_40) < 0 || GraphicsEnvironment.isHeadless()) {
                    SystemUtil.foundJavaFX[0] = Boolean.FALSE;
                } else {
                    String string = System.getProperty("XXE_USE_JAVAFX");
                    SystemUtil.foundJavaFX[0] = string == null ? Boolean.TRUE : ("0".equals(string) || "no".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string) ? Boolean.FALSE : Boolean.TRUE);
                    if (foundJavaFX[0] == Boolean.TRUE) {
                        try {
                            Class.forName("javafx.application.Platform");
                        }
                        catch (Throwable throwable) {
                            SystemUtil.foundJavaFX[0] = Boolean.FALSE;
                        }
                    }
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return foundJavaFX[0] == Boolean.TRUE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VersionNumber osVersionNumber() {
        VersionNumber[] versionNumberArray = osVersion;
        synchronized (osVersion) {
            String string;
            if (osVersion[0] == null && (string = System.getProperty("os.version")) != null) {
                SystemUtil.osVersion[0] = VersionNumber.fromString(string, true);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return osVersion[0];
        }
    }

    public static Process shellStart(String string) throws IOException {
        return SystemUtil.shellStart(string, null, null);
    }

    public static Process shellStart(String string, String[] stringArray, File file) throws IOException {
        ProcessBuilder processBuilder = IS_WINDOWS ? new ProcessBuilder("cmd.exe", "/s", "/c", "\"" + string + "\"") : new ProcessBuilder("/bin/sh", "-c", string);
        if (stringArray != null) {
            Map<String, String> map = processBuilder.environment();
            int n = 2 * (stringArray.length / 2);
            for (int i = 0; i < n; i += 2) {
                map.put(stringArray[i], stringArray[i + 1]);
            }
        }
        if (file != null) {
            processBuilder.directory(file);
        }
        return processBuilder.start();
    }

    public static int shellExec(String string, String[] stringArray) throws IOException, InterruptedException {
        return SystemUtil.shellExec(string, null, null, stringArray);
    }

    public static int shellExec(String string, String[] stringArray, File file, String[] stringArray2) throws IOException, InterruptedException {
        Process process = SystemUtil.shellStart(string, stringArray, file);
        return SystemUtil.captureOutput(process, stringArray2);
    }

    public static int captureOutput(Process process, String[] stringArray) throws InterruptedException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        InputConsumer inputConsumer = new InputConsumer(process.getInputStream(), byteArrayOutputStream);
        InputConsumer inputConsumer2 = new InputConsumer(process.getErrorStream(), byteArrayOutputStream2);
        inputConsumer.start();
        inputConsumer2.start();
        int n = process.waitFor();
        inputConsumer.join();
        inputConsumer2.join();
        stringArray[0] = byteArrayOutputStream.toString();
        stringArray[1] = byteArrayOutputStream2.toString();
        return n;
    }

    public static int shellExec(String string) throws IOException, InterruptedException {
        return SystemUtil.shellExec(string, null, null, (Console)null);
    }

    public static int shellExec(String string, String[] stringArray, File file) throws IOException, InterruptedException {
        return SystemUtil.shellExec(string, stringArray, file, (Console)null);
    }

    public static int shellExec(String string, String[] stringArray, File file, Console console) throws IOException, InterruptedException {
        Process process = SystemUtil.shellStart(string, stringArray, file);
        return SystemUtil.captureOutput(process, console);
    }

    public static int captureOutput(Process process, Console console) throws InterruptedException {
        InputConsumer2 inputConsumer2 = new InputConsumer2(process.getInputStream(), console, Console.MessageType.INFO);
        InputConsumer2 inputConsumer22 = new InputConsumer2(process.getErrorStream(), console, Console.MessageType.ERROR);
        inputConsumer2.start();
        inputConsumer22.start();
        int n = process.waitFor();
        inputConsumer2.join();
        inputConsumer22.join();
        return n;
    }

    public static File findAppInPath(String string) {
        String string2 = System.getenv("PATH");
        if (string2 == null) {
            return null;
        }
        String[] stringArray = StringUtil.split(string2, File.pathSeparatorChar);
        for (int i = 0; i < stringArray.length; ++i) {
            File file;
            Object object = stringArray[i].trim();
            if (((String)object).length() == 0) continue;
            if (!((String)object).endsWith(File.separator)) {
                object = (String)object + File.separator;
            }
            if ((file = new File((String)object + string)).isFile()) {
                return file;
            }
            if (!IS_WINDOWS || string.lastIndexOf(46) >= 0) continue;
            String[] stringArray2 = new String[]{".EXE", ".COM", ".BAT", ".CMD"};
            String string3 = System.getenv("PATHEXT");
            if (string3 != null) {
                stringArray2 = StringUtil.split(string3, File.pathSeparatorChar);
            }
            for (int j = 0; j < stringArray2.length; ++j) {
                String string4 = stringArray2[j].trim();
                if (!string4.startsWith(".") || !(file = new File((String)object + string + string4)).isFile()) continue;
                return file;
            }
        }
        return null;
    }

    static {
        javaVersion = new VersionNumber[1];
        JAVA_9_0_0 = new VersionNumber(9, 0, 0);
        JAVA_1_8_0_40 = new VersionNumber(1, 8, 0, VersionNumber.LevelType.PATCH, 40);
        foundJavaFX = new Boolean[1];
        osVersion = new VersionNumber[1];
    }

    private static final class InputConsumer2
    extends Thread {
        private LineNumberReader lines;
        private Console console;
        private Console.MessageType messageType;

        public InputConsumer2(InputStream inputStream, Console console, Console.MessageType messageType) {
            this.lines = new LineNumberReader(new InputStreamReader(inputStream));
            this.console = console;
            this.messageType = messageType;
        }

        @Override
        public void run() {
            while (true) {
                String string;
                try {
                    string = this.lines.readLine();
                }
                catch (IOException iOException) {
                    string = null;
                }
                if (string == null) break;
                if (this.console == null) continue;
                this.console.showMessage(string, this.messageType);
            }
        }
    }

    private static class InputConsumer
    extends Thread {
        private InputStream in;
        private OutputStream out;
        private byte[] bytes = new byte[4096];

        public InputConsumer(InputStream inputStream) {
            this(inputStream, null);
        }

        public InputConsumer(InputStream inputStream, OutputStream outputStream) {
            super("SystemUtil.InputConsumer");
            this.in = inputStream;
            this.out = outputStream;
        }

        @Override
        public void run() {
            while (true) {
                int n;
                try {
                    n = this.in.read(this.bytes);
                }
                catch (IOException iOException) {
                    n = -1;
                }
                if (n < 0) break;
                if (n <= 0 || this.out == null) continue;
                try {
                    this.out.write(this.bytes, 0, n);
                    this.out.flush();
                }
                catch (IOException iOException) {
                    this.out = null;
                }
            }
        }
    }
}

