/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;

public final class Log {
    private static final Object lockRecorderFactory = new Object();
    private static RecorderFactory recorderFactory = new RecorderFactoryImpl();
    private static HashMap<String, Log> logs = new HashMap();
    public static final int DEFAULT_CAPACITY = 1000;
    public static final int MAX_CAPACITY = 100000;
    public final Recorder recorder;
    private int capacity;
    private ArrayList<Item> items;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setRecorderFactory(RecorderFactory recorderFactory) {
        Object object = lockRecorderFactory;
        synchronized (object) {
            if (recorderFactory == null) {
                recorderFactory = new RecorderFactoryImpl();
            }
            Log.recorderFactory = recorderFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RecorderFactory getRecorderFactory() {
        Object object = lockRecorderFactory;
        synchronized (object) {
            return recorderFactory;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Log getLog(String string) {
        if ((string = string == null ? "" : string.trim()).startsWith("{}")) {
            string = string.substring(2);
        }
        Object object = lockRecorderFactory;
        synchronized (object) {
            Log log = logs.get(string);
            if (log == null) {
                Recorder recorder = recorderFactory.createRecorder(string);
                log = new Log(recorder);
                logs.put(string, log);
            }
            return log;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getNames() {
        Object object = lockRecorderFactory;
        synchronized (object) {
            String[] stringArray = new String[logs.size()];
            logs.keySet().toArray(stringArray);
            return stringArray;
        }
    }

    private Log(Recorder recorder) {
        this.recorder = recorder;
        this.capacity = 1000;
        this.items = new ArrayList();
    }

    public void error(String string) {
        this.log(Level.ERROR, string);
    }

    public void warning(String string) {
        this.log(Level.WARNING, string);
    }

    public void info(String string) {
        this.log(Level.INFO, string);
    }

    public void verbose(String string) {
        this.log(Level.VERBOSE, string);
    }

    public void debug(String string) {
        this.log(Level.DEBUG, string);
    }

    public synchronized void log(Level level, String string) {
        this.recorder.record(level, string);
        while (this.items.size() >= this.capacity) {
            this.items.remove(0);
        }
        this.items.add(new Item(level, string));
    }

    public synchronized void setCapacity(int n) {
        if (n <= 0) {
            n = 1000;
        } else if (n > 100000) {
            n = 100000;
        }
        this.capacity = n;
        int n2 = this.items.size() - n;
        if (n2 > 0) {
            this.items.subList(0, n2).clear();
        }
    }

    public synchronized int getCapacity() {
        return this.capacity;
    }

    public Item[] get() {
        return this.get(Integer.MAX_VALUE);
    }

    public synchronized Item[] get(int n) {
        int n2 = this.items.size();
        if (n < 0) {
            n = n2;
        }
        Item[] itemArray = new Item[Math.min(n2, n)];
        int n3 = 0;
        for (int i = n2 - itemArray.length; i < n2; ++i) {
            itemArray[n3++] = this.items.get(i);
        }
        return itemArray;
    }

    public Item[] get(Level level) {
        return this.get(level, Integer.MAX_VALUE);
    }

    public synchronized Item[] get(Level level, int n) {
        int n2 = this.items.size();
        if (n < 0) {
            n = n2;
        }
        ArrayList<Item> arrayList = new ArrayList<Item>();
        int n3 = level.ordinal();
        int n4 = 0;
        for (int i = n2 - 1; i >= 0; --i) {
            Item item = this.items.get(i);
            if (item.level.ordinal() > n3) continue;
            arrayList.add(item);
            if (++n4 == n) break;
        }
        Item[] itemArray = new Item[n4];
        for (int i = 0; i < n4; ++i) {
            itemArray[i] = (Item)arrayList.get(n4 - 1 - i);
        }
        return itemArray;
    }

    public synchronized void clear() {
        this.items = new ArrayList();
    }

    public synchronized void print(boolean bl, boolean bl2, PrintStream printStream) {
        block4: {
            int n = this.items.size();
            if (n <= 0) break block4;
            if (bl) {
                for (int i = n - 1; i >= 0; --i) {
                    this.items.get(i).print(bl2, printStream);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    this.items.get(i).print(bl2, printStream);
                }
            }
        }
    }

    public static final class Item {
        public final Level level;
        public final String message;
        public final long date;

        public Item(Level level, String string) {
            this.level = level;
            this.message = string;
            this.date = System.currentTimeMillis();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(new Date(this.date));
            stringBuilder.append(": ");
            stringBuilder.append((Object)this.level);
            stringBuilder.append(": ");
            stringBuilder.append(this.message);
            return stringBuilder.toString();
        }

        public void print(boolean bl, PrintStream printStream) {
            if (bl) {
                printStream.print(new Date(this.date));
                printStream.print(": ");
            }
            printStream.print((Object)this.level);
            printStream.print(": ");
            printStream.println(this.message);
        }
    }

    public static final class RecorderFactoryImpl
    implements RecorderFactory {
        @Override
        public Recorder createRecorder(String string) {
            return new RecorderImpl();
        }
    }

    public static final class RecorderImpl
    implements Recorder {
        @Override
        public void record(Level level, String string) {
        }
    }

    public static interface RecorderFactory {
        public Recorder createRecorder(String var1);
    }

    public static interface Recorder {
        public void record(Level var1, String var2);
    }

    public static enum Level {
        ERROR,
        WARNING,
        INFO,
        VERBOSE,
        DEBUG;

    }
}

