/*
 * Decompiled with CFR 0.152.
 */
package com.xmlmind.util;

import com.xmlmind.util.ArrayUtil;
import com.xmlmind.util.FileUtil;
import com.xmlmind.util.StringUtil;
import com.xmlmind.util.URIComponent;
import com.xmlmind.util.URLUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public final class JarUtil {
    private JarUtil() {
    }

    public static URL[] getClassPath(URL uRL) throws IOException {
        String string = JarUtil.getClassPathAttribute(uRL);
        if (string == null) {
            return URLUtil.EMPTY_LIST;
        }
        String[] stringArray = StringUtil.split(string);
        URL[] uRLArray = new URL[stringArray.length];
        int n = 0;
        for (String string2 : stringArray) {
            try {
                uRLArray[n++] = URLUtil.createURL(uRL, string2);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (n != uRLArray.length) {
            uRLArray = ArrayUtil.trimToSize(uRLArray, n);
        }
        return uRLArray;
    }

    public static String getClassPathAttribute(URL uRL) throws IOException {
        Manifest manifest = null;
        try (JarInputStream jarInputStream = new JarInputStream(URLUtil.openStreamUseCache(uRL), false);){
            manifest = jarInputStream.getManifest();
        }
        if (manifest == null) {
            return null;
        }
        return manifest.getMainAttributes().getValue("Class-Path");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String[]> getServiceProviders(URL uRL) throws IOException {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        try (JarInputStream jarInputStream = new JarInputStream(URLUtil.openStreamUseCache(uRL), false);){
            JarEntry jarEntry;
            while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                String string = jarEntry.getName();
                if (!string.startsWith("META-INF/services/") || jarEntry.isDirectory()) continue;
                String string2 = FileUtil.loadString(jarInputStream, "UTF-8");
                jarInputStream.closeEntry();
                String[] stringArray = StringUtil.split(string2.trim(), '\n');
                String[] stringArray2 = new String[stringArray.length];
                int n = 0;
                for (String string3 : stringArray) {
                    if ((string3 = string3.trim()).length() <= 0 || string3.charAt(0) == '#') continue;
                    stringArray2[n++] = string3;
                }
                if (n != stringArray2.length) {
                    stringArray2 = ArrayUtil.trimToSize(stringArray2, n);
                }
                String object = URIComponent.getRawBaseName(string);
                hashMap.put(object, stringArray2);
            }
        }
        return hashMap;
    }
}

